/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.astar.comets;

import edu.duke.cs.osprey.astar.AStarNode;
import edu.duke.cs.osprey.astar.AStarTree;
import edu.duke.cs.osprey.astar.ConfTree;
import edu.duke.cs.osprey.astar.FullAStarNode;
import edu.duke.cs.osprey.astar.comets.COMETSNode;
import edu.duke.cs.osprey.astar.comets.LME;
import edu.duke.cs.osprey.astar.comets.UpdatedPruningMatrix;
import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.HigherTupleFinder;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.ematrix.epic.EPICSettings;
import edu.duke.cs.osprey.energy.ConfEnergyCalculator;
import edu.duke.cs.osprey.gmec.PrecomputedMatrices;
import edu.duke.cs.osprey.pruning.NewPruner;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import edu.duke.cs.osprey.structure.PDBIO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.PriorityQueue;

public class NewCOMETSTree
extends AStarTree<COMETSNode> {
    int numTreeLevels;
    LME objFcn;
    LME[] constraints;
    ArrayList<ArrayList<String>> AATypeOptions;
    int numMaxMut;
    String[] wtSeq;
    int numStates;
    SimpleConfSpace[] confSpaces;
    PrecomputedMatrices[] precompMats;
    ArrayList<ArrayList<Integer>> mutable2StatePosNums;
    int[] stateNumPos;
    int numSeqsReturned = 0;
    int stateGMECsForPruning = 0;
    boolean outputGMECStructs;
    ConfEnergyCalculator[] confECalc = null;

    public NewCOMETSTree(int numTreeLevels, LME objFcn, LME[] constraints, ArrayList<ArrayList<String>> AATypeOptions, int numMaxMut, String[] wtSeq, int numStates, SimpleConfSpace[] confSpaces, PrecomputedMatrices[] precompMats, ArrayList<ArrayList<Integer>> mutable2StatePosNums, boolean outputGMECStructs, ConfEnergyCalculator[] confECalc) {
        this.numTreeLevels = numTreeLevels;
        this.objFcn = objFcn;
        this.constraints = constraints;
        this.AATypeOptions = AATypeOptions;
        this.numMaxMut = numMaxMut;
        this.wtSeq = wtSeq;
        this.numStates = numStates;
        this.confSpaces = confSpaces;
        this.precompMats = precompMats;
        this.mutable2StatePosNums = mutable2StatePosNums;
        this.outputGMECStructs = outputGMECStructs;
        this.confECalc = confECalc;
        this.stateNumPos = new int[numStates];
        for (int state = 0; state < numStates; ++state) {
            this.stateNumPos[state] = confSpaces[state].getNumPos();
        }
    }

    @Override
    public ArrayList<COMETSNode> getChildren(COMETSNode seqNode) {
        ArrayList<COMETSNode> ans = new ArrayList<COMETSNode>();
        if (seqNode.isFullyDefined()) {
            seqNode.expandConfTree();
            seqNode.setScore(this.boundLME(seqNode, this.objFcn));
            ans.add(seqNode);
            return ans;
        }
        int[] curAssignments = seqNode.getNodeAssignments();
        for (int splitPos = 0; splitPos < this.numTreeLevels; ++splitPos) {
            if (curAssignments[splitPos] >= 0) continue;
            for (int aa = 0; aa < this.AATypeOptions.get(splitPos).size(); ++aa) {
                int[] childAssignments = (int[])curAssignments.clone();
                childAssignments[splitPos] = aa;
                PruningMatrix[] childPruneMat = new UpdatedPruningMatrix[this.numStates];
                for (int state = 0; state < this.numStates; ++state) {
                    childPruneMat[state] = this.doChildPruning(state, seqNode.pruneMat[state], splitPos, aa);
                }
                COMETSNode childNode = new COMETSNode(childAssignments, childPruneMat);
                if (splitPos == this.numTreeLevels - 1) {
                    this.makeSeqConfTrees(childNode);
                }
                childNode.setScore(this.boundLME(childNode, this.objFcn));
                ans.add(childNode);
            }
            return ans;
        }
        throw new RuntimeException("ERROR: No splittable position found but sequence not fully defined...");
    }

    private UpdatedPruningMatrix doChildPruning(int state, PruningMatrix parentMat, int splitPos, int aa) {
        int oldNumUpdates;
        String assignedAAType = this.AATypeOptions.get(splitPos).get(aa);
        UpdatedPruningMatrix ans = new UpdatedPruningMatrix(parentMat);
        int posAtState = this.mutable2StatePosNums.get(state).get(splitPos);
        for (int rc : parentMat.unprunedRCsAtPos(posAtState)) {
            String rcAAType = this.confSpaces[state].positions.get((int)posAtState).resConfs.get((int)rc).template.name;
            if (rcAAType.equalsIgnoreCase(assignedAAType)) continue;
            ans.markAsPruned(new RCTuple(posAtState, rc));
        }
        int numUpdates = ans.countUpdates();
        NewPruner dee = new NewPruner(this.precompMats[state], ans, true, Double.POSITIVE_INFINITY, 0.0, false, this.precompMats[state].shouldWeUseLUTE());
        dee.setVerbose(false);
        do {
            oldNumUpdates = numUpdates;
            dee.prune("GOLDSTEIN");
            dee.prune("GOLDSTEIN PAIRS FULL");
        } while ((numUpdates = ans.countUpdates()) > oldNumUpdates);
        return ans;
    }

    private void makeSeqConfTrees(COMETSNode node) {
        node.stateTrees = new ConfTree[this.numStates];
        node.stateUB = new double[this.numStates];
        for (int state = 0; state < this.numStates; ++state) {
            boolean RCsAvailable = true;
            for (int pos = 0; pos < this.stateNumPos[state]; ++pos) {
                if (!node.pruneMat[state].unprunedRCsAtPos(pos).isEmpty()) continue;
                RCsAvailable = false;
                break;
            }
            if (RCsAvailable) {
                if (this.precompMats[state].getLuteMat() == null && this.precompMats[state].getEpicMat() != null) {
                    throw new RuntimeException("ERROR: Continuous flexibility in COMETS must use LUTE");
                }
                node.stateTrees[state] = new ConfTree<FullAStarNode>(new FullAStarNode.Factory(this.stateNumPos[state]), this.precompMats[state].shouldWeUseLUTE(), this.precompMats[state].getEmat(), null, null, this.precompMats[state].getLuteMat(), node.pruneMat[state], false, new EPICSettings(), null);
                FullAStarNode rootNode = node.stateTrees[state].rootNode();
                int[] blankConf = new int[this.stateNumPos[state]];
                Arrays.fill(blankConf, -1);
                rootNode.UBConf = blankConf;
                this.updateUB(state, rootNode, node);
                node.stateUB[state] = rootNode.UB;
                node.stateTrees[state].initQueue(rootNode);
                continue;
            }
            node.stateTrees[state] = null;
            node.stateUB[state] = Double.POSITIVE_INFINITY;
        }
    }

    @Override
    public COMETSNode rootNode() {
        int[] conf = new int[this.numTreeLevels];
        Arrays.fill(conf, -1);
        PruningMatrix[] pruneMats = new PruningMatrix[this.numStates];
        for (int state = 0; state < this.numStates; ++state) {
            pruneMats[state] = this.precompMats[state].getPruneMat();
        }
        COMETSNode root = new COMETSNode(conf, pruneMats);
        root.setScore(this.boundLME(root, this.objFcn));
        return root;
    }

    @Override
    public boolean canPruneNode(COMETSNode seqNode) {
        if (this.numMaxMut != -1) {
            int mutCount = 0;
            int[] assignments = seqNode.getNodeAssignments();
            for (int level = 0; level < this.numTreeLevels; ++level) {
                if (assignments[level] < 0 || this.AATypeOptions.get(level).get(assignments[level]).equalsIgnoreCase(this.wtSeq[level])) continue;
                ++mutCount;
            }
            if (mutCount > this.numMaxMut) {
                return true;
            }
        }
        for (LME constr : this.constraints) {
            if (!(this.boundLME(seqNode, constr) > 0.0)) continue;
            this.stateGMECsForPruning += this.countStateGMECs(seqNode);
            return true;
        }
        return false;
    }

    @Override
    public boolean isFullyAssigned(COMETSNode seqNode) {
        if (!seqNode.isFullyDefined()) {
            return false;
        }
        for (int state = 0; state < this.numStates; ++state) {
            FullAStarNode bestNodeForState;
            if (seqNode.stateTrees[state] == null || (bestNodeForState = (FullAStarNode)seqNode.stateTrees[state].getQueue().peek()).isFullyDefined()) continue;
            return false;
        }
        return true;
    }

    public void incrementNumSeqsReturned() {
        ++this.numSeqsReturned;
    }

    @Override
    public ConfSearch.ScoredConf outputNode(COMETSNode node) {
        this.incrementNumSeqsReturned();
        this.printBestSeqInfo(node);
        return new ConfSearch.ScoredConf(node.getNodeAssignments(), node.getScore());
    }

    public String seqAsString(int[] seqNodeAssignments) {
        Object seq = "";
        for (int level = 0; level < this.numTreeLevels; ++level) {
            seq = (String)seq + this.AATypeOptions.get(level).get(seqNodeAssignments[level]) + "_";
        }
        return seq;
    }

    void printBestSeqInfo(COMETSNode seqNode) {
        System.out.println("SeqTree: A* returning conformation; lower bound = " + seqNode.getScore() + " nodes expanded: " + this.numExpanded);
        System.out.print("Sequence: ");
        String seq = this.seqAsString(seqNode.getNodeAssignments());
        System.out.println(seq);
        for (int state = 0; state < this.numStates; ++state) {
            System.out.print("State " + state);
            if (seqNode.stateTrees[state] == null) {
                System.out.println(" has an unavoidable clash.");
                continue;
            }
            System.out.print(" RCs: ");
            int[] conf = ((FullAStarNode)seqNode.stateTrees[state].getQueue().peek()).getNodeAssignments();
            for (int pos = 0; pos < this.stateNumPos[state]; ++pos) {
                System.out.print(conf[pos] + " ");
            }
            System.out.println("Energy: " + this.getEnergyMatrix(state).confE(conf));
            if (!this.outputGMECStructs) continue;
            PDBIO.writeFile(this.confECalc[state].calcEnergy(new RCTuple(conf)), "GMEC.state" + state + "." + seq + ".pdb");
        }
        System.out.println();
        this.printNodeExpansionData();
    }

    public void printNodeExpansionData() {
        int numSeqDefNodes = 0;
        for (FullAStarNode node : this.getQueue()) {
            if (!node.isFullyDefined()) continue;
            ++numSeqDefNodes;
        }
        System.out.println(this.numExpanded + " expanded; " + this.getQueue().size() + " nodes in tree, of which " + numSeqDefNodes + " are fully defined; " + this.numPruned + " pruned.");
        int stateGMECsRet = this.numSeqsReturned * this.numStates;
        int stateGMECsInTree = this.countGMECsInTree();
        int totGMECsCalcd = stateGMECsRet + stateGMECsInTree + this.stateGMECsForPruning;
        System.out.println(totGMECsCalcd + " state GMECs calculated: " + stateGMECsRet + " returned, " + stateGMECsInTree + " in tree, " + this.stateGMECsForPruning + " for pruned sequences.");
    }

    int countGMECsInTree() {
        int count = 0;
        for (AStarNode node : this.getQueue()) {
            count += this.countStateGMECs((COMETSNode)node);
        }
        return count;
    }

    int countStateGMECs(COMETSNode seqNode) {
        int count = 0;
        if (seqNode.stateTrees != null) {
            for (ConfTree<FullAStarNode> ct : seqNode.stateTrees) {
                FullAStarNode bestNode;
                if (ct == null || !(bestNode = (FullAStarNode)ct.getQueue().peek()).isFullyDefined()) continue;
                ++count;
            }
        }
        return count;
    }

    private double boundLME(COMETSNode seqNode, LME func) {
        if (seqNode.isFullyDefined()) {
            return this.calcLBConfTrees(seqNode, func);
        }
        return this.calcLBPartialSeq(seqNode, func);
    }

    private int[] AAOptions(int pos, int assignment) {
        if (assignment == -1) {
            int numOptions = this.AATypeOptions.get(pos).size();
            int[] ans = new int[numOptions];
            for (int option = 0; option < numOptions; ++option) {
                ans[option] = option;
            }
            return ans;
        }
        return new int[]{assignment};
    }

    private double calcLBPartialSeq(COMETSNode seqNode, LME func) {
        int[] partialSeq = seqNode.getNodeAssignments();
        double ans = func.constTerm;
        for (int i = 0; i < this.numTreeLevels; ++i) {
            double resE = Double.POSITIVE_INFINITY;
            for (int curAA : this.AAOptions(i, partialSeq[i])) {
                double AAE = 0.0;
                for (int state = 0; state < this.numStates; ++state) {
                    if (func.coeffs[state] == 0.0) continue;
                    int statePosNum = this.mutable2StatePosNums.get(state).get(i);
                    boolean minForState = func.coeffs[state] > 0.0;
                    double stateAAE = Double.POSITIVE_INFINITY;
                    PruningMatrix pruneMat = seqNode.pruneMat[state];
                    EnergyMatrix eMatrix = this.getEnergyMatrix(state);
                    ArrayList<Integer> rotList = this.unprunedRCsAtAA(state, pruneMat, i, statePosNum, curAA);
                    if (!minForState) {
                        stateAAE = Double.NEGATIVE_INFINITY;
                    }
                    for (int rot : rotList) {
                        double rotE = eMatrix.getOneBody(statePosNum, rot);
                        for (int pos2 = 0; pos2 < this.stateNumPos[state]; ++pos2) {
                            if (this.mutable2StatePosNums.get(state).contains(pos2) && pos2 >= statePosNum) continue;
                            double bestInteraction = Double.POSITIVE_INFINITY;
                            ArrayList<Integer> rotList2 = pruneMat.unprunedRCsAtPos(pos2);
                            if (!minForState) {
                                bestInteraction = Double.NEGATIVE_INFINITY;
                            }
                            for (int rot2 : rotList2) {
                                if (pruneMat.getPairwise(statePosNum, rot, pos2, rot2).booleanValue()) continue;
                                double pairwiseE = eMatrix.getPairwise(statePosNum, rot, pos2, rot2);
                                pairwiseE += this.higherOrderContrib(state, pruneMat, statePosNum, rot, pos2, rot2, minForState);
                                if (minForState) {
                                    bestInteraction = Math.min(bestInteraction, pairwiseE);
                                    continue;
                                }
                                bestInteraction = Math.max(bestInteraction, pairwiseE);
                            }
                            rotE += bestInteraction;
                        }
                        if (minForState) {
                            stateAAE = Math.min(stateAAE, rotE);
                            continue;
                        }
                        stateAAE = Math.max(stateAAE, rotE);
                    }
                    if (Double.isInfinite(stateAAE)) {
                        if (func.coeffs[state] > 0.0) {
                            AAE = Double.POSITIVE_INFINITY;
                            continue;
                        }
                        if (!(func.coeffs[state] < 0.0) || AAE == Double.POSITIVE_INFINITY) continue;
                        AAE = Double.NEGATIVE_INFINITY;
                        continue;
                    }
                    AAE += func.coeffs[state] * stateAAE;
                }
                resE = Math.min(resE, AAE);
            }
            ans += resE;
        }
        for (int state = 0; state < this.numStates; ++state) {
            if (func.coeffs[state] == 0.0) continue;
            ans += func.coeffs[state] * this.getEnergyMatrix(state).getConstTerm();
            double nonMutBound = this.boundStateNonMutE(state, seqNode, func.coeffs[state] > 0.0);
            if (Double.isInfinite(nonMutBound)) {
                if (func.coeffs[state] > 0.0) {
                    return Double.POSITIVE_INFINITY;
                }
                if (!(func.coeffs[state] < 0.0)) continue;
                ans = Double.NEGATIVE_INFINITY;
                continue;
            }
            ans += func.coeffs[state] * nonMutBound;
        }
        return ans;
    }

    double higherOrderContrib(int state, PruningMatrix pruneMat, int pos1, int rc1, int pos2, int rc2, boolean minForState) {
        EnergyMatrix emat = this.getEnergyMatrix(state);
        HigherTupleFinder<Double> htf = emat.getHigherOrderTerms(pos1, rc1, pos2, rc2);
        if (htf == null) {
            return 0.0;
        }
        RCTuple curPair = new RCTuple(pos1, rc1, pos2, rc2);
        return this.higherOrderContrib(state, pruneMat, htf, curPair, minForState);
    }

    private boolean posComesBefore(int pos1, int pos2, int state) {
        boolean isMut1 = this.mutable2StatePosNums.get(state).contains(pos1);
        boolean isMut2 = this.mutable2StatePosNums.get(state).contains(pos2);
        if (isMut1 && !isMut2) {
            return false;
        }
        if (isMut2 && !isMut1) {
            return true;
        }
        return pos1 < pos2;
    }

    double higherOrderContrib(int state, PruningMatrix pruneMat, HigherTupleFinder<Double> htf, RCTuple startingTuple, boolean minForState) {
        double contrib = 0.0;
        int startingLevel = startingTuple.pos.get(startingTuple.pos.size() - 1);
        for (int iPos : htf.getInteractingPos()) {
            if (!this.posComesBefore(iPos, startingLevel, state)) continue;
            double levelBestE = Double.POSITIVE_INFINITY;
            if (!minForState) {
                levelBestE = Double.NEGATIVE_INFINITY;
            }
            ArrayList<Integer> allowedRCs = pruneMat.unprunedRCsAtPos(iPos);
            for (int rc : allowedRCs) {
                RCTuple augTuple = startingTuple.addRC(iPos, rc);
                if (pruneMat.isPruned(augTuple)) continue;
                double interactionE = htf.getInteraction(iPos, rc);
                HigherTupleFinder<Double> htf2 = htf.getHigherInteractions(iPos, rc);
                if (htf2 != null) {
                    interactionE += this.higherOrderContrib(state, pruneMat, htf2, augTuple, minForState);
                }
                if (minForState) {
                    levelBestE = Math.min(levelBestE, interactionE);
                    continue;
                }
                levelBestE = Math.max(levelBestE, interactionE);
            }
            contrib += levelBestE;
        }
        return contrib;
    }

    private ArrayList<Integer> unprunedRCsAtAA(int state, PruningMatrix pruneMat, int mutablePos, int statePosNum, int curAA) {
        ArrayList<Integer> unprunedRCs = pruneMat.unprunedRCsAtPos(statePosNum);
        ArrayList<Integer> ans = new ArrayList<Integer>();
        String curAAType = this.AATypeOptions.get(mutablePos).get(curAA);
        for (int rc : unprunedRCs) {
            String rcAAType = this.confSpaces[state].positions.get((int)statePosNum).resConfs.get((int)rc).template.name;
            if (!rcAAType.equalsIgnoreCase(curAAType)) continue;
            ans.add(rc);
        }
        return ans;
    }

    private double calcLBConfTrees(COMETSNode seqNode, LME func) {
        double ans = func.constTerm;
        for (int state = 0; state < this.numStates; ++state) {
            if (func.coeffs[state] > 0.0) {
                if (seqNode.stateTrees[state] == null) {
                    return Double.POSITIVE_INFINITY;
                }
                ans += func.coeffs[state] * ((FullAStarNode)seqNode.stateTrees[state].getQueue().peek()).getScore();
                continue;
            }
            if (!(func.coeffs[state] < 0.0)) continue;
            ConfTree<FullAStarNode> curTree = seqNode.stateTrees[state];
            if (curTree == null) {
                ans = Double.NEGATIVE_INFINITY;
                continue;
            }
            PriorityQueue curExpansion = curTree.getQueue();
            FullAStarNode curNode = (FullAStarNode)curExpansion.peek();
            if (Double.isNaN(curNode.UB)) {
                while (!this.updateUB(state, curNode, seqNode)) {
                    curExpansion.poll();
                    if (curExpansion.isEmpty()) {
                        seqNode.stateUB[state] = Double.POSITIVE_INFINITY;
                        ans = Double.NEGATIVE_INFINITY;
                        curNode = null;
                        break;
                    }
                    curNode = (FullAStarNode)curExpansion.peek();
                    if (Double.isNaN(curNode.UB)) continue;
                }
            }
            if (curNode == null) {
                ans = Double.NEGATIVE_INFINITY;
                continue;
            }
            seqNode.stateUB[state] = Math.min(seqNode.stateUB[state], curNode.UB);
            ans += func.coeffs[state] * seqNode.stateUB[state];
        }
        return ans;
    }

    private EnergyMatrix getEnergyMatrix(int state) {
        if (this.precompMats[state].shouldWeUseLUTE()) {
            return this.precompMats[state].getLuteMat();
        }
        return this.precompMats[state].getEmat();
    }

    private double boundStateNonMutE(int state, COMETSNode seqNode, boolean minForState) {
        double ans = 0.0;
        PruningMatrix pruneMat = seqNode.pruneMat[state];
        EnergyMatrix eMatrix = this.getEnergyMatrix(state);
        for (int pos = 0; pos < this.stateNumPos[state]; ++pos) {
            if (this.mutable2StatePosNums.get(state).contains(pos)) continue;
            double resE = Double.POSITIVE_INFINITY;
            ArrayList<Integer> rotList = pruneMat.unprunedRCsAtPos(pos);
            if (!minForState) {
                resE = Double.NEGATIVE_INFINITY;
            }
            for (int rot : rotList) {
                if (pruneMat.getOneBody(pos, rot).booleanValue()) continue;
                double rotE = eMatrix.getOneBody(pos, rot);
                for (int pos2 = 0; pos2 < this.stateNumPos[state]; ++pos2) {
                    if (this.mutable2StatePosNums.get(state).contains(pos2) || pos2 >= pos) continue;
                    double bestInteraction = Double.POSITIVE_INFINITY;
                    ArrayList<Integer> rotList2 = pruneMat.unprunedRCsAtPos(pos2);
                    if (!minForState) {
                        bestInteraction = Double.NEGATIVE_INFINITY;
                    }
                    for (int rot2 : rotList2) {
                        if (pruneMat.getPairwise(pos, rot, pos2, rot2).booleanValue()) continue;
                        double pairwiseE = eMatrix.getPairwise(pos, rot, pos2, rot2);
                        pairwiseE += this.higherOrderContrib(state, pruneMat, pos, rot, pos2, rot2, minForState);
                        if (minForState) {
                            bestInteraction = Math.min(bestInteraction, pairwiseE);
                            continue;
                        }
                        bestInteraction = Math.max(bestInteraction, pairwiseE);
                    }
                    rotE += bestInteraction;
                }
                if (minForState) {
                    resE = Math.min(resE, rotE);
                    continue;
                }
                resE = Math.max(resE, rotE);
            }
            ans += resE;
        }
        return ans;
    }

    boolean updateUB(int state, FullAStarNode expNode, COMETSNode seqNode) {
        int[] assignments = expNode.getNodeAssignments();
        ArrayList<ArrayList<Object>> allowedRCs = new ArrayList<ArrayList<Object>>();
        for (int pos = 0; pos < this.stateNumPos[state]; ++pos) {
            ArrayList<Object> posOptions = new ArrayList<Integer>();
            if (assignments[pos] == -1) {
                posOptions = seqNode.pruneMat[state].unprunedRCsAtPos(pos);
                if (posOptions.isEmpty()) {
                    return false;
                }
            } else {
                posOptions.add(assignments[pos]);
            }
            allowedRCs.add(posOptions);
        }
        int[] startingConf = expNode.UBConf;
        int[] UBConf = (int[])startingConf.clone();
        for (int level = 0; level < this.stateNumPos[state]; ++level) {
            if (((ArrayList)allowedRCs.get(level)).contains(startingConf[level])) continue;
            double bestISE = Double.POSITIVE_INFINITY;
            int bestRC = (Integer)((ArrayList)allowedRCs.get(level)).get(0);
            Iterator iterator2 = ((ArrayList)allowedRCs.get(level)).iterator();
            while (iterator2.hasNext()) {
                int rc = (Integer)iterator2.next();
                double ise = this.getEnergyMatrix(state).getOneBody(level, rc);
                if (!(ise < bestISE)) continue;
                bestISE = ise;
                bestRC = rc;
            }
            UBConf[level] = bestRC;
        }
        double curE = this.getEnergyMatrix(state).confE(UBConf);
        boolean done = false;
        while (!done) {
            done = true;
            for (int level = 0; level < this.stateNumPos[state]; ++level) {
                int[] testConf = (int[])UBConf.clone();
                Iterator iterator3 = ((ArrayList)allowedRCs.get(level)).iterator();
                while (iterator3.hasNext()) {
                    int rc;
                    testConf[level] = rc = ((Integer)iterator3.next()).intValue();
                    double testE = this.getEnergyMatrix(state).confE(testConf);
                    if (!(testE < curE)) continue;
                    curE = testE;
                    UBConf[level] = rc;
                    done = false;
                }
            }
        }
        expNode.UBConf = UBConf;
        expNode.UB = this.getEnergyMatrix(state).confE(UBConf);
        return true;
    }
}

