/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.astar.conf;

import edu.duke.cs.osprey.confspace.ConfSearch;
import java.lang.ref.SoftReference;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.function.Supplier;

public class ConfSearchCache {
    public final Integer minCapacity;
    private final LinkedHashSet<Entry> recentEntries = new LinkedHashSet();

    public ConfSearchCache(Integer minCapacity) {
        this.minCapacity = minCapacity;
    }

    public Entry make(Supplier<ConfSearch> factory) {
        return new Entry(factory);
    }

    public class Entry
    implements ConfSearch {
        private final Supplier<ConfSearch> factory;
        private long numConfs = 0L;
        private boolean isExhausted = false;
        private ConfSearch strongRef = null;
        private SoftReference<ConfSearch> softRef = null;

        private Entry(Supplier<ConfSearch> factory) {
            this.factory = factory;
            this.getOrMakeTree();
        }

        private ConfSearch getOrMakeTree() {
            ConfSearch tree;
            if (this.softRef != null && (tree = this.softRef.get()) != null) {
                this.markUsed(tree);
                return tree;
            }
            tree = this.factory.get();
            int i = 0;
            while ((long)i < this.numConfs) {
                tree.nextConf();
                ++i;
            }
            this.softRef = new SoftReference<ConfSearch>(tree);
            this.markUsed(tree);
            return tree;
        }

        private void markUsed(ConfSearch tree) {
            this.strongRef = tree;
            if (ConfSearchCache.this.minCapacity != null) {
                ConfSearchCache.this.recentEntries.remove(this);
                ConfSearchCache.this.recentEntries.add(this);
                if (ConfSearchCache.this.recentEntries.size() > ConfSearchCache.this.minCapacity) {
                    Iterator iter = ConfSearchCache.this.recentEntries.iterator();
                    ((Entry)iter.next()).strongRef = null;
                    iter.remove();
                }
            }
        }

        public void clearRefs() {
            this.softRef = null;
            this.strongRef = null;
        }

        public boolean isProtected() {
            return this.strongRef != null;
        }

        @Override
        public BigInteger getNumConformations() {
            return this.getOrMakeTree().getNumConformations();
        }

        @Override
        public ConfSearch.ScoredConf nextConf() {
            if (this.isExhausted) {
                return null;
            }
            ConfSearch.ScoredConf conf = this.getOrMakeTree().nextConf();
            if (conf == null) {
                this.isExhausted = true;
                this.clearRefs();
            } else {
                ++this.numConfs;
            }
            return conf;
        }
    }
}

