/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace;

import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.SeqSpace;
import edu.duke.cs.osprey.confspace.Sequence;
import java.util.stream.IntStream;

public interface ConfSpaceIteration {
    public int countSingles();

    public int countPairs();

    public int numPos();

    public int numConf(int var1);

    default public int[] numConfsByPos() {
        return IntStream.range(0, this.numPos()).map(posi -> this.numConf(posi)).toArray();
    }

    public String name(int var1);

    public String confId(int var1, int var2);

    public String confType(int var1, int var2);

    public SeqSpace seqSpace();

    public String wildType(int var1);

    public boolean hasMutations(int var1);

    default public Sequence makeSequenceFromAssignments(int[] assignments) {
        Sequence seq = this.seqSpace().makeUnassignedSequence();
        for (int posi = 0; posi < this.numPos(); ++posi) {
            seq.set(this.name(posi), this.confType(posi, assignments[posi]));
        }
        return seq;
    }

    default public Sequence makeSequenceFromConf(ConfSearch.ScoredConf conf) {
        return this.makeSequenceFromAssignments(conf.getAssignments());
    }
}

