/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace;

import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.ConfSpaceIteration;
import edu.duke.cs.osprey.confspace.ParametricMolecule;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SeqSpace;
import edu.duke.cs.osprey.confspace.Sequence;
import edu.duke.cs.osprey.confspace.Strand;
import edu.duke.cs.osprey.confspace.StrandFlex;
import edu.duke.cs.osprey.confspace.VoxelShape;
import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.dof.DofInfo;
import edu.duke.cs.osprey.dof.FreeDihedral;
import edu.duke.cs.osprey.dof.MutAlignmentCache;
import edu.duke.cs.osprey.dof.ProlinePucker;
import edu.duke.cs.osprey.dof.ResidueTypeDOF;
import edu.duke.cs.osprey.minimization.ObjectiveFunction;
import edu.duke.cs.osprey.restypes.ResidueTemplate;
import edu.duke.cs.osprey.restypes.ResidueTemplateLibrary;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.structure.Residues;
import edu.duke.cs.osprey.tools.MathTools;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;

public class SimpleConfSpace
implements Serializable,
ConfSpaceIteration {
    public final List<Strand> strands;
    public final Map<Strand, List<StrandFlex>> strandFlex;
    public final double shellDist;
    public final List<Position> positions;
    public final List<Position> mutablePositions;
    public final List<Position> immutablePositions;
    public final SeqSpace seqSpace;
    private final Map<String, Position> positionsByResNum;
    public final Set<String> shellResNumbers;
    private final int[] numResConfsByPos;
    private final Molecule molTemplate;
    private final MutAlignmentCache mutAlignmentCache = new MutAlignmentCache();

    public SimpleConfSpace(List<Strand> strands, Map<Strand, List<StrandFlex>> strandFlex, double shellDist) {
        this.strands = strands;
        this.strandFlex = strandFlex;
        this.shellDist = shellDist;
        HashSet<String> resNums = new HashSet<String>();
        for (Strand strand : strands) {
            for (Residue res : strand.mol.residues) {
                String resNum = res.getPDBResNumber();
                boolean isUnique = resNums.add(resNum);
                if (isUnique) continue;
                throw new IllegalArgumentException("residue " + resNum + " appears more than once");
            }
        }
        this.positions = new ArrayList<Position>();
        this.mutablePositions = new ArrayList<Position>();
        this.immutablePositions = new ArrayList<Position>();
        for (Strand strand : strands) {
            for (String resNum : strand.flexibility.getFlexibleResidueNumbers()) {
                Iterator<String> res = strand.mol.getResByPDBResNumber(resNum);
                Strand.ResidueFlex resFlex = strand.flexibility.get(resNum);
                int index = this.positions.size();
                int mindex = resFlex.isMutable() ? this.mutablePositions.size() : -1;
                ArrayList<String> resTypes = new ArrayList<String>(resFlex.getAllResTypes());
                Position pos = new Position(index, mindex, strand, (Residue)((Object)res), (List<String>)resTypes);
                this.positions.add(pos);
                if (mindex >= 0) {
                    this.mutablePositions.add(pos);
                } else {
                    this.immutablePositions.add(pos);
                }
                for (String resType : resFlex.resTypes) {
                    this.makeResidueConfsFromTemplate(pos, strand.templateLib.getTemplateOrThrow(resType, true), ResidueConf.Type.Library);
                }
                if (!resFlex.addWildTypeRotamers) continue;
                this.makeResidueConfsFromTemplate(pos, strand.templateLib.getOrMakeWildTypeTemplate((Residue)((Object)res)), ResidueConf.Type.WildType);
            }
        }
        this.positionsByResNum = new HashMap<String, Position>();
        for (Position pos : this.positions) {
            this.positionsByResNum.put(Residues.normalizeResNum(pos.resNum), pos);
        }
        ArrayList<Residue> staticResidues = new ArrayList<Residue>();
        ArrayList<Residue> flexibleResidues = new ArrayList<Residue>();
        for (Strand strand : strands) {
            for (String resNum : strand.flexibility.getStaticResidueNumbers()) {
                staticResidues.add(strand.mol.getResByPDBResNumber(resNum));
            }
            for (String resNum : strand.flexibility.getFlexibleResidueNumbers()) {
                flexibleResidues.add(strand.mol.getResByPDBResNumber(resNum));
            }
        }
        assert (flexibleResidues.size() == this.positions.size());
        assert (staticResidues.size() == resNums.size() - this.positions.size());
        this.shellResNumbers = new HashSet<String>();
        for (Residue staticRes : staticResidues) {
            Residue nearbyFlexibleRes = null;
            for (Residue flexibleRes : flexibleResidues) {
                if (!(staticRes.distanceTo(flexibleRes) <= shellDist)) continue;
                nearbyFlexibleRes = staticRes;
                break;
            }
            if (nearbyFlexibleRes == null && !flexibleResidues.isEmpty()) continue;
            this.shellResNumbers.add(Residues.normalizeResNum(staticRes.getPDBResNumber()));
        }
        assert (this.shellResNumbers.size() <= staticResidues.size());
        assert (shellDist != Double.POSITIVE_INFINITY || this.shellResNumbers.size() == staticResidues.size());
        this.numResConfsByPos = new int[this.positions.size()];
        for (int i = 0; i < this.positions.size(); ++i) {
            this.numResConfsByPos[i] = this.positions.get((int)i).resConfs.size();
        }
        this.seqSpace = new SeqSpace(this);
        Iterator<Serializable> iterator2 = this.seqSpace.positions.iterator();
        while (iterator2.hasNext()) {
            SeqSpace.Position seqPos;
            this.positionsByResNum.get((Object)seqPos.resNum).seqPos = seqPos = iterator2.next();
        }
        this.molTemplate = new Molecule();
        for (Strand strand : strands) {
            for (Residue res : strand.mol.residues) {
                res = new Residue(res);
                res.molec = this.molTemplate;
                res.indexInMolecule = this.molTemplate.residues.size();
                this.molTemplate.residues.add(res);
            }
        }
    }

    private void makeResidueConfsFromTemplate(Position pos, ResidueTemplate template, ResidueConf.Type type) {
        for (HashMap<String, double[]> bbState : this.listBackboneVoxels(pos)) {
            if (template.name.equalsIgnoreCase("PRO") && type == ResidueConf.Type.Library) {
                for (ProlinePucker.Direction dir : ProlinePucker.Direction.values()) {
                    ResidueConf resConf = new ResidueConf(pos, pos.resConfs.size(), template, type, dir.ordinal(), bbState);
                    resConf.postTemplateModifier = res -> res.pucker.apply(dir);
                    pos.resConfs.add(resConf);
                }
                continue;
            }
            if (template.getNumRotamers() <= 0) {
                pos.resConfs.add(new ResidueConf(pos, pos.resConfs.size(), template, type, bbState));
                continue;
            }
            for (int rotamerIndex = 0; rotamerIndex < template.getNumRotamers(); ++rotamerIndex) {
                pos.resConfs.add(new ResidueConf(pos, pos.resConfs.size(), template, type, rotamerIndex, bbState));
            }
        }
    }

    public Position getPositionOrNull(String resNum) {
        return this.positionsByResNum.get(Residues.normalizeResNum(resNum));
    }

    public Position getPositionOrThrow(String resNum) {
        Position pos = this.getPositionOrNull(resNum);
        if (pos != null) {
            return pos;
        }
        throw new NoSuchElementException("no residue found with number " + resNum + " among " + String.valueOf(this.positions.stream().map(p -> p.resNum).collect(Collectors.toList())));
    }

    public int[] getNumResConfsByPos() {
        return this.numResConfsByPos;
    }

    public int getNumResConfs(int pos) {
        return this.positions.get((int)pos).resConfs.size();
    }

    public int getNumResConfs() {
        int count = 0;
        for (int pos = 0; pos < this.positions.size(); ++pos) {
            count += this.numResConfsByPos[pos];
        }
        return count;
    }

    public int getNumResConfPairs() {
        int count = 0;
        for (int pos1 = 1; pos1 < this.positions.size(); ++pos1) {
            for (int pos2 = 0; pos2 < pos1; ++pos2) {
                count += this.numResConfsByPos[pos1] * this.numResConfsByPos[pos2];
            }
        }
        return count;
    }

    public int getNumResConfTriples() {
        int count = 0;
        for (int pos1 = 2; pos1 < this.positions.size(); ++pos1) {
            for (int pos2 = 1; pos2 < pos1; ++pos2) {
                for (int pos3 = 0; pos3 < pos2; ++pos3) {
                    count += this.numResConfsByPos[pos1] * this.numResConfsByPos[pos2] * this.numResConfsByPos[pos3];
                }
            }
        }
        return count;
    }

    public int getNumResConfQuads() {
        int count = 0;
        for (int pos1 = 2; pos1 < this.positions.size(); ++pos1) {
            for (int pos2 = 1; pos2 < pos1; ++pos2) {
                for (int pos3 = 0; pos3 < pos2; ++pos3) {
                    for (int pos4 = 0; pos4 < pos3; ++pos4) {
                        count += this.numResConfsByPos[pos1] * this.numResConfsByPos[pos2] * this.numResConfsByPos[pos3] * this.numResConfsByPos[pos4];
                    }
                }
            }
        }
        return count;
    }

    @Override
    public int countSingles() {
        return this.getNumResConfs();
    }

    @Override
    public int countPairs() {
        return this.getNumResConfPairs();
    }

    @Override
    public int numPos() {
        return this.positions.size();
    }

    @Override
    public int numConf(int posi) {
        return this.getNumResConfs(posi);
    }

    @Override
    public String name(int posi) {
        return this.positions.get((int)posi).resNum;
    }

    @Override
    public String confId(int posi, int confi) {
        return this.positions.get((int)posi).resConfs.get(confi).getRotamerCode();
    }

    @Override
    public String confType(int posi, int confi) {
        return this.positions.get((int)posi).resConfs.get((int)confi).template.name;
    }

    @Override
    public SeqSpace seqSpace() {
        return this.seqSpace;
    }

    @Override
    public String wildType(int posi) {
        return this.positions.get((int)posi).resFlex.wildType;
    }

    @Override
    public boolean hasMutations(int posi) {
        return this.positions.get(posi).hasMutations();
    }

    public ParametricMolecule makeMolecule(ConfSearch.ScoredConf conf) {
        return this.makeMolecule(conf.getAssignments());
    }

    public ParametricMolecule makeMolecule(int[] conf) {
        return this.makeMolecule(new RCTuple(conf));
    }

    public Molecule makeDiscreteMolecule(RCTuple conf) {
        Molecule mol = new Molecule();
        for (Residue res : this.molTemplate.residues) {
            int index;
            Position pos = this.getPositionOrNull(res.getPDBResNumber());
            if (pos != null && (index = conf.pos.indexOf(pos.index)) >= 0) {
                ResidueConf rc = pos.resConfs.get(conf.RCs.get(index));
                Residue newRes = res.copyToMol(mol, false);
                rc.updateResidue(pos.strand.templateLib, newRes, this.mutAlignmentCache);
                continue;
            }
            res.copyToMol(mol, true);
        }
        mol.markInterResBonds();
        return mol;
    }

    public ParametricMolecule makeMolecule(RCTuple conf) {
        Molecule mol = this.makeDiscreteMolecule(conf);
        HashSet<String> confDOFNames = new HashSet<String>();
        for (int i = 0; i < conf.size(); ++i) {
            Position pos = this.positions.get(conf.pos.get(i));
            ResidueConf resConf = pos.resConfs.get(conf.RCs.get(i));
            confDOFNames.addAll(resConf.dofBounds.keySet());
        }
        ArrayList<DegreeOfFreedom> dofs = new ArrayList<DegreeOfFreedom>();
        for (Strand strand : this.getConfStrands(conf)) {
            for (StrandFlex flex : this.strandFlex.get(strand)) {
                for (DegreeOfFreedom degreeOfFreedom : flex.makeDofs(strand, mol)) {
                    if (!confDOFNames.contains(degreeOfFreedom.getName())) continue;
                    dofs.add(degreeOfFreedom);
                }
            }
        }
        for (int i = 0; i < conf.size(); ++i) {
            Position pos = this.positions.get(conf.pos.get(i));
            ResidueConf resConf = pos.resConfs.get(conf.RCs.get(i));
            Residue res = mol.getResByPDBResNumber(pos.resNum);
            Strand.ResidueFlex resFlex = pos.strand.flexibility.get(pos.resNum);
            List<DegreeOfFreedom> list = resFlex.voxelShape.makeDihedralDOFs(res);
            dofs.addAll(list);
            if (!list.isEmpty()) continue;
            List<DegreeOfFreedom> dihedralDofs = new VoxelShape.Rect().makeDihedralDOFs(res);
            for (int d = 0; d < resConf.template.numDihedrals; ++d) {
                dihedralDofs.get(d).apply(resConf.template.getRotamericDihedrals(resConf.rotamerIndex, d));
            }
        }
        ObjectiveFunction.DofBounds dofBounds = new ObjectiveFunction.DofBounds(dofs.size());
        HashMap<String, Integer> name2Index = DegreeOfFreedom.nameToIndexMap(dofs);
        HashSet<String> dofsAdded = new HashSet<String>();
        for (int i = 0; i < conf.size(); ++i) {
            Position pos = this.positions.get(conf.pos.get(i));
            ResidueConf residueConf = pos.resConfs.get(conf.RCs.get(i));
            HashMap<String, double[]> rcDOFBounds = residueConf.dofBounds;
            for (String DOFName : rcDOFBounds.keySet()) {
                int dofIndex = name2Index.get(DOFName);
                double[] curDOFBounds = rcDOFBounds.get(DOFName);
                if (dofsAdded.contains(DOFName)) {
                    if (!(Math.abs(dofBounds.getMax(dofIndex) - curDOFBounds[1]) > 1.0E-10) && !(Math.abs(dofBounds.getMin(dofIndex) - curDOFBounds[0]) > 1.0E-10)) continue;
                    throw new RuntimeException("ERROR: Conformation has inconsistent DOF bounds between different positions' RCs");
                }
                dofBounds.set(dofIndex, curDOFBounds[0], curDOFBounds[1]);
                ((DegreeOfFreedom)dofs.get(dofIndex)).apply(0.5 * (curDOFBounds[0] + curDOFBounds[1]));
                dofsAdded.add(DOFName);
            }
        }
        return new ParametricMolecule(mol, dofs, dofBounds);
    }

    public boolean isContinuouslyFlexible(int[] conf) {
        return this.isContinuouslyFlexible(new RCTuple(conf));
    }

    public boolean isContinuouslyFlexible(RCTuple conf) {
        for (int i = 0; i < conf.size(); ++i) {
            Position pos = this.positions.get(conf.pos.get(i));
            ResidueConf resConf = pos.resConfs.get(conf.RCs.get(i));
            for (double[] bounds : resConf.dofBounds.values()) {
                if (!(bounds[1] > bounds[0])) continue;
                return true;
            }
        }
        return false;
    }

    private Set<Strand> getConfStrands(RCTuple conf) {
        HashSet<Strand> confStrands = new HashSet<Strand>();
        for (int i = 0; i < conf.size(); ++i) {
            Position pos = this.positions.get(conf.pos.get(i));
            confStrands.add(pos.strand);
        }
        return confStrands;
    }

    public DofTypes getDofTypes() {
        DofTypes dofTypes = null;
        for (Strand strand : this.strands) {
            for (StrandFlex flex : this.strandFlex.get(strand)) {
                dofTypes = DofTypes.combine(dofTypes, flex.getDofTypes());
            }
        }
        for (Position pos : this.positions) {
            dofTypes = DofTypes.combine(dofTypes, pos.resFlex.voxelShape.getDofTypes());
        }
        return dofTypes;
    }

    public DofInfo makeDofInfo(RCTuple conf) {
        DofInfo info2 = new DofInfo(conf);
        for (Strand strand : this.getConfStrands(conf)) {
            for (StrandFlex flex : this.strandFlex.get(strand)) {
                info2.addStrand(strand, flex.countDofs(strand));
            }
        }
        for (int i = 0; i < conf.size(); ++i) {
            Position pos = this.positions.get(conf.pos.get(i));
            ResidueConf rc = pos.resConfs.get(conf.RCs.get(i));
            Strand.ResidueFlex resFlex = pos.strand.flexibility.get(pos.resNum);
            info2.addPos(pos, rc, resFlex.voxelShape.countDihedralDOFs(rc.template));
        }
        return info2;
    }

    public int getNumPos() {
        return this.positions.size();
    }

    private static HashMap<String, double[]> sidechainDOFBounds(Position pos, ResidueTemplate template, Integer rotamerIndex) {
        if (rotamerIndex == null) {
            return new HashMap<String, double[]>();
        }
        ObjectiveFunction.DofBounds bounds = pos.resFlex.voxelShape.makeDihedralBounds(template, rotamerIndex);
        Residue res = pos.strand.mol.getResByPDBResNumber(pos.resNum);
        HashMap<String, double[]> ans = new HashMap<String, double[]>();
        for (int d = 0; d < bounds.size(); ++d) {
            FreeDihedral dih = new FreeDihedral(res, d);
            ans.put(dih.getName(), new double[]{bounds.getMin(d), bounds.getMax(d)});
        }
        return ans;
    }

    private List<HashMap<String, double[]>> listBackboneVoxels(Position pos) {
        List<HashMap<String, double[]>> bbVoxels = this.strandFlex.get(pos.strand).stream().map(flex -> flex.listBackboneVoxels(pos)).filter(lst -> !lst.isEmpty()).flatMap(Collection::stream).collect(Collectors.toList());
        if (bbVoxels.isEmpty()) {
            bbVoxels.add(new HashMap());
        }
        if (bbVoxels.size() == 1) {
            return bbVoxels;
        }
        throw new RuntimeException("ERROR: Can't have multiple types of backbone flexibility for the same residue");
    }

    public SimpleConfSpace makeSubspace(Strand strand) {
        return new Builder().addStrand(strand, this.strandFlex.get(strand)).setShellDistance(this.shellDist).build();
    }

    public Map<Position, Position> mapPositionsTo(SimpleConfSpace other) {
        IdentityHashMap<Position, Position> matching = new IdentityHashMap<Position, Position>();
        for (Position pos : this.positions) {
            Position matchedPos = other.getPositionOrNull(pos.resNum);
            if (matchedPos != null) {
                if (pos.resConfs.size() != matchedPos.resConfs.size()) {
                    throw new IllegalStateException("residue conformations for residue " + pos.resNum + " don't match across conformation spaces");
                }
                assert (pos.resNum.equals(matchedPos.resNum));
            }
            matching.put(pos, matchedPos);
        }
        return matching;
    }

    public List<ResidueConf> getResidueConfs(ConfSearch.ScoredConf conf) {
        return this.getResidueConfs(conf.getAssignments());
    }

    public List<ResidueConf> getResidueConfs(int[] conf) {
        return this.positions.stream().map(pos -> pos.resConfs.get(conf[pos.index])).collect(Collectors.toList());
    }

    public String formatConf(ConfSearch.ScoredConf conf) {
        return this.formatConf(conf.getAssignments());
    }

    public String formatConf(int[] conf) {
        return String.join((CharSequence)" ", this.positions.stream().map(pos -> String.format("%-12s", pos.formatConfPos(conf))).collect(Collectors.toList()));
    }

    public static String formatConfRCs(ConfSearch.ScoredConf conf) {
        return SimpleConfSpace.formatConfRCs(conf.getAssignments());
    }

    public static String formatConfRCs(int[] conf) {
        return String.join((CharSequence)" ", Arrays.stream(conf).mapToObj(rc -> String.format("%-5d", rc)).collect(Collectors.toList()));
    }

    public String formatConfSequence(ConfSearch.ScoredConf conf) {
        return this.formatConfSequence(conf.getAssignments());
    }

    public String formatConfSequence(int[] conf) {
        return String.join((CharSequence)" ", this.getResidueConfs(conf).stream().map(resConf -> String.format("%-5s", resConf.template.name)).collect(Collectors.toList()));
    }

    public String formatConfRotamers(ConfSearch.ScoredConf conf) {
        return this.formatConfRotamers(conf.getAssignments());
    }

    public String formatConfRotamers(int[] conf) {
        return String.join((CharSequence)" ", this.getResidueConfs(conf).stream().map(resConf -> String.format("%-5s", resConf.getRotamerCode())).collect(Collectors.toList()));
    }

    public String formatConfRotamersWithResidueNumbers(int[] conf) {
        return String.join((CharSequence)",", this.positions.stream().map(pos -> {
            String rcString = pos.resNum + ":*";
            if (conf[pos.index] > -1) {
                ResidueConf rc = pos.resConfs.get(conf[pos.index]);
                rcString = pos.resNum + ":" + rc.template.name + "-" + rc.getRotamerCode();
            }
            return rcString;
        }).collect(Collectors.toList()));
    }

    public String formatResidueNumbers() {
        return String.join((CharSequence)" ", this.positions.stream().map(pos -> String.format("%-5s", pos.resNum)).collect(Collectors.toList()));
    }

    public Sequence makeUnassignedSequence() {
        return this.seqSpace.makeUnassignedSequence();
    }

    public Sequence makeWildTypeSequence() {
        return this.seqSpace.makeWildTypeSequence();
    }

    public BigInteger calcNumSequences() {
        BigInteger numSequences = BigInteger.ZERO;
        for (Position pos : this.positions) {
            BigInteger numResTypes = BigInteger.valueOf(pos.resFlex.resTypes.size());
            if (MathTools.isZero(numSequences)) {
                numSequences = numResTypes;
                continue;
            }
            numSequences = numSequences.multiply(numResTypes);
        }
        return numSequences;
    }

    public BigInteger getNumConformations() {
        return this.positions.stream().map(pos -> pos.resConfs.size()).map(BigInteger::valueOf).reduce(BigInteger::multiply).orElseThrow();
    }

    public static class Position
    implements Serializable {
        public final int index;
        public final int mindex;
        public final Strand strand;
        public final String resNum;
        public final Strand.ResidueFlex resFlex;
        public final List<ResidueConf> resConfs;
        public final List<String> resTypes;
        public SeqSpace.Position seqPos = null;

        public Position(int index, int mindex, Strand strand, Residue res, List<String> resTypes) {
            this.index = index;
            this.mindex = mindex;
            this.strand = strand;
            this.resNum = res.getPDBResNumber();
            this.resFlex = strand.flexibility.get(this.resNum);
            this.resConfs = new ArrayList<ResidueConf>();
            this.resTypes = resTypes;
        }

        public String toString() {
            return this.resNum;
        }

        public String formatConfPos(ConfSearch.ScoredConf conf) {
            return this.formatConfPos(conf.getAssignments());
        }

        public String formatConfPos(int[] conf) {
            ResidueConf rc = this.resConfs.get(conf[this.index]);
            return String.format("%s-%s-%d", rc.template.name.toUpperCase(), rc.getRotamerCode(), conf[this.index]);
        }

        public boolean hasMutations() {
            return this.mindex >= 0;
        }

        public int mutableIndexOrThrow() {
            if (this.mindex < 0) {
                throw new NonMutablePositionException(this);
            }
            return this.mindex;
        }
    }

    public static class ResidueConf
    implements Serializable {
        public final int index;
        public final ResidueTemplate template;
        public final Type type;
        public final Integer rotamerIndex;
        public PostTemplateModifier postTemplateModifier;
        public HashMap<String, double[]> dofBounds;

        public ResidueConf(Position pos, int index, ResidueTemplate template, Type type, HashMap<String, double[]> bbVoxel) {
            this(pos, index, template, type, null, bbVoxel);
        }

        public ResidueConf(Position pos, int index, ResidueTemplate template, Type type, Integer rotamerIndex, HashMap<String, double[]> bbVoxel) {
            if (template.getNumRotamers() > 0 && rotamerIndex == null) {
                throw new IllegalArgumentException("template " + template.name + " has rotamers, so rotamer index is required");
            }
            this.index = index;
            this.template = template;
            this.type = type;
            this.rotamerIndex = rotamerIndex;
            this.postTemplateModifier = null;
            this.dofBounds = SimpleConfSpace.sidechainDOFBounds(pos, template, rotamerIndex);
            this.dofBounds.putAll(bbVoxel);
        }

        public void updateResidue(ResidueTemplateLibrary templateLib, Residue res, MutAlignmentCache mutAlignmentCache) {
            boolean toProline = this.template.name.equalsIgnoreCase("PRO");
            if (toProline) {
                res.pucker = new ProlinePucker(templateLib, res);
            }
            ResidueTypeDOF.switchToTemplate(templateLib, res, this.template, false, mutAlignmentCache, false);
            if (this.postTemplateModifier != null) {
                this.postTemplateModifier.modify(res);
            }
        }

        public String getRotamerCode() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.type.letter);
            if (this.rotamerIndex != null) {
                buf.append(this.rotamerIndex);
            }
            for (String dofName : this.dofBounds.keySet()) {
                if (!dofName.contains("PERT")) continue;
                double[] bounds = this.dofBounds.get(dofName);
                buf.append("P" + this.dofBounds.get(dofName)[0]);
            }
            return buf.toString();
        }

        public String toString() {
            return this.template.name + " " + this.getRotamerCode();
        }

        public boolean isParametricallyIncompatibleWith(ResidueConf rc2) {
            double tol = 1.0E-8;
            for (String dofName1 : this.dofBounds.keySet()) {
                for (String dofName2 : rc2.dofBounds.keySet()) {
                    if (!dofName1.equalsIgnoreCase(dofName2)) continue;
                    double[] bounds1 = this.dofBounds.get(dofName1);
                    double[] bounds2 = this.dofBounds.get(dofName2);
                    for (int a = 0; a < 2; ++a) {
                        if (!(Math.abs(bounds1[a] - bounds2[a]) > 1.0E-8)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        public static enum Type {
            Library('L'),
            WildType('W');

            public final char letter;

            private Type(char letter) {
                this.letter = letter;
            }

            public static Type getFromLetter(char letter) {
                for (Type type : Type.values()) {
                    if (type.letter != letter) continue;
                    return type;
                }
                return null;
            }
        }

        public static interface PostTemplateModifier
        extends Serializable {
            public void modify(Residue var1);
        }
    }

    public static enum DofTypes {
        None,
        OnlyDihedrals,
        Any;


        public static DofTypes combine(DofTypes a, DofTypes b) {
            if (a == b) {
                return a;
            }
            if (a == null && b != null) {
                return b;
            }
            if (a != null && b == null) {
                return a;
            }
            if (a.ordinal() > b.ordinal()) {
                return a;
            }
            return b;
        }

        public static DofTypes combine(Iterable<DofTypes> types2) {
            Iterator<DofTypes> iter = types2.iterator();
            if (!iter.hasNext()) {
                return null;
            }
            DofTypes out = iter.next();
            if (iter.hasNext()) {
                out = DofTypes.combine(out, iter.next());
            }
            return out;
        }
    }

    public static class Builder {
        private SimpleConfSpace confSpace;
        private double shellDist = Double.POSITIVE_INFINITY;
        private List<Strand> strands = new ArrayList<Strand>();
        private Map<Strand, List<StrandFlex>> strandFlex = new IdentityHashMap<Strand, List<StrandFlex>>();

        public Builder addStrand(Strand strand, StrandFlex ... flexTypes) {
            this.addStrand(strand, Arrays.asList(flexTypes));
            return this;
        }

        public Builder addStrand(Strand strand, List<StrandFlex> flexTypes) {
            this.strands.add(strand);
            this.strandFlex.put(strand, flexTypes);
            return this;
        }

        public Builder addStrands(Strand ... strands) {
            for (Strand strand : strands) {
                this.addStrand(strand, new StrandFlex[0]);
            }
            return this;
        }

        public Builder addStrands(Iterable<Strand> strands) {
            for (Strand strand : strands) {
                this.addStrand(strand, new StrandFlex[0]);
            }
            return this;
        }

        public Builder setShellDistance(double val) {
            this.shellDist = val;
            return this;
        }

        public SimpleConfSpace build() {
            return new SimpleConfSpace(this.strands, this.strandFlex, this.shellDist);
        }
    }

    public static class NonMutablePositionException
    extends IllegalStateException {
        public NonMutablePositionException(Position pos) {
            super(String.format("Position %s was not mutable", pos));
        }
    }
}

