/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.control;

import edu.duke.cs.osprey.astar.comets.COMETSTree;
import edu.duke.cs.osprey.astar.comets.LME;
import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.SearchProblem;
import edu.duke.cs.osprey.confspace.Strand;
import edu.duke.cs.osprey.control.ConfigFileParser;
import edu.duke.cs.osprey.control.ParamSet;
import edu.duke.cs.osprey.gmec.GMECFinder;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.PDBIO;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.FileTools;
import edu.duke.cs.osprey.tools.StringParsing;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class COMETSDoer {
    COMETSTree tree;
    int numSeqsWanted;
    LME objFcn;
    LME[] constraints;
    int numStates;
    int numTreeLevels;
    ArrayList<ArrayList<String>> AATypeOptions = null;
    ArrayList<ArrayList<Integer>> mutable2StatePosNums = new ArrayList();
    private ConfigFileParser cfp;

    public COMETSDoer(ConfigFileParser cfp) {
        this.cfp = cfp;
        System.out.println();
        System.out.println("Performing multistate A*");
        System.out.println();
        this.numStates = cfp.params.getInt("NUMSTATES");
        this.numTreeLevels = cfp.params.getInt("NUMMUTRES");
        int numConstr = cfp.params.getInt("NUMCONSTR");
        this.objFcn = new LME(cfp.params.getValue("OBJFCN"), this.numStates);
        this.constraints = new LME[numConstr];
        for (int constr = 0; constr < numConstr; ++constr) {
            this.constraints[constr] = new LME(cfp.params.getValue("CONSTR" + constr), this.numStates);
        }
        SearchProblem[] stateSP = new SearchProblem[this.numStates];
        System.out.println();
        System.out.println("Preparing matrices and search problems for multistate A*");
        System.out.println();
        for (int state = 0; state < this.numStates; ++state) {
            this.mutable2StatePosNums.add(this.stateMutablePos(state, cfp.params, this.numTreeLevels));
            stateSP[state] = this.makeStateSearchProblem(state);
            System.out.println();
            System.out.println("State " + state + " matrices ready.");
            System.out.println();
        }
        int numMaxMut = cfp.params.getInt("NUMMAXMUT");
        String[] wtSeq = null;
        if (numMaxMut > -1) {
            wtSeq = this.parseWTSeq(cfp.params.getValue("WTSEQ"), this.numTreeLevels);
        }
        this.numSeqsWanted = cfp.params.getInt("NUMSEQS");
        boolean outputGMECStructs = cfp.params.getBool("OutputStateGMECStructs");
        this.tree = new COMETSTree(this.numTreeLevels, this.objFcn, this.constraints, this.AATypeOptions, numMaxMut, wtSeq, this.numStates, stateSP, this.mutable2StatePosNums, outputGMECStructs);
    }

    private String[] parseWTSeq(String seq, int numTreeLevels) {
        StringTokenizer st = new StringTokenizer(seq);
        if (st.countTokens() != numTreeLevels) {
            throw new RuntimeException("ERROR: wrong number of residues in WT seq: " + seq);
        }
        String[] wt = new String[numTreeLevels];
        for (int level = 0; level < numTreeLevels; ++level) {
            wt[level] = st.nextToken().toUpperCase();
        }
        return wt;
    }

    private ConfigFileParser makeStateConfig(int state) {
        ConfigFileParser stateCFGP;
        if (this.cfp.params.getValue("STATEKSFILE" + state).equalsIgnoreCase("DEFAULT")) {
            stateCFGP = new ConfigFileParser(this.cfp);
        } else {
            stateCFGP = new ConfigFileParser();
            stateCFGP.params.addParamsFromFile(this.cfp.params.getFile("STATEKSFILE" + state));
        }
        String stateConfigFiles = this.cfp.params.getValue("STATECFGFILES" + state);
        String stateSysFile = StringParsing.getToken(stateConfigFiles, 1);
        String stateDEEFile = StringParsing.getToken(stateConfigFiles, 2);
        FileTools.PathRoot root = this.cfp.params.getRoot("STATECFGFILES" + state);
        stateCFGP.params.addParams(root, stateSysFile);
        stateCFGP.params.addParams(root, stateDEEFile);
        stateCFGP.loadData();
        return stateCFGP;
    }

    private SearchProblem makeStateSearchProblem(int state) {
        ConfigFileParser stateCFGP = this.makeStateConfig(state);
        SearchProblem searchProb = stateCFGP.getSearchProblem();
        if (stateCFGP.params.getBool("doMinimize") && !searchProb.useTupExpForSearch) {
            throw new RuntimeException("ERROR: COMETS requires LUTE to do continuous flexibility");
        }
        this.precomputeMatrices(state, stateCFGP, searchProb);
        this.handleAATypeOptions(state, stateCFGP);
        return searchProb;
    }

    private void handleAATypeOptions(int state, ConfigFileParser cfgP) {
        ArrayList<ArrayList<String>> stateAAOptions = cfgP.getAllowedAAs();
        Molecule wtMolec = new Strand.Builder((Molecule)PDBIO.readFile((File)cfgP.params.getFile((String)"PDBName"))).build().mol;
        ArrayList<String> flexRes = cfgP.getFlexRes();
        if (this.AATypeOptions == null) {
            this.AATypeOptions = new ArrayList();
        }
        for (int mutPos = 0; mutPos < this.numTreeLevels; ++mutPos) {
            int flexPos = this.mutable2StatePosNums.get(state).get(mutPos);
            ArrayList<String> statePosOptions = stateAAOptions.get(flexPos);
            if (cfgP.params.getBool("AddWT")) {
                Residue res = wtMolec.getResByPDBResNumber(flexRes.get(flexPos));
                if (!StringParsing.containsIgnoreCase(statePosOptions, res.template.name)) {
                    statePosOptions.add(res.template.name);
                }
            }
            if (this.AATypeOptions.size() <= mutPos) {
                this.AATypeOptions.add(statePosOptions);
                continue;
            }
            ArrayList<String> posOptions = this.AATypeOptions.get(mutPos);
            if (posOptions.size() != statePosOptions.size()) {
                throw new RuntimeException("ERROR: Current state has " + statePosOptions.size() + " AA types allowed for position " + mutPos + " compared to " + posOptions.size() + " for previous states");
            }
            for (int a = 0; a < posOptions.size(); ++a) {
                String aa2;
                String aa1 = posOptions.get(a);
                if (aa1.equalsIgnoreCase(aa2 = statePosOptions.get(a))) continue;
                throw new RuntimeException("ERROR: Current state has AA type " + aa2 + " where previous states have AA type " + aa1 + ", at position " + mutPos);
            }
        }
    }

    private ArrayList<Integer> stateMutablePos(int state, ParamSet sParams, int numTreeLevels) {
        ArrayList<Integer> m2s = new ArrayList<Integer>();
        String stateMutRes = sParams.getValue("STATEMUTRES" + state);
        StringTokenizer st = new StringTokenizer(stateMutRes);
        while (st.hasMoreTokens()) {
            m2s.add(Integer.valueOf(st.nextToken()));
        }
        if (m2s.size() != numTreeLevels) {
            throw new RuntimeException("ERROR: SeqTree has " + numTreeLevels + " mutable positions  but " + m2s.size() + " are listed for state " + state);
        }
        return m2s;
    }

    public ArrayList<String> calcBestSequences() {
        ConfSearch.ScoredConf conf;
        System.out.println("Performing multistate A*");
        long startAStarTime = System.currentTimeMillis();
        ArrayList<String> bestSequences = new ArrayList<String>();
        for (int seqNum = 0; seqNum < this.numSeqsWanted && (conf = this.tree.nextConf()) != null; ++seqNum) {
            bestSequences.add(this.tree.seqAsString(conf.getAssignments()));
        }
        long stopTime = System.currentTimeMillis();
        System.out.println("Sequence enumeration time: " + (double)(stopTime - startAStarTime) / 60000.0);
        return bestSequences;
    }

    void precomputeMatrices(int state, ConfigFileParser cfgP, SearchProblem sp) {
        cfgP.params.setValue("TYPEDEP", "TRUE");
        GMECFinder gf = new GMECFinder();
        gf.init(cfgP, sp);
        double ival = this.chooseIVal(state, cfgP, gf, sp);
        gf.precomputeMatrices(ival);
    }

    double chooseIVal(int state, ConfigFileParser cfgP, GMECFinder gf, SearchProblem sp) {
        if (!gf.useTupExp) {
            return 0.0;
        }
        double iVal = cfgP.params.getDouble("COMETSIVAL");
        if (Double.isNaN(iVal)) {
            if (gf.EFullConfOnly) {
                iVal = Double.POSITIVE_INFINITY;
            } else {
                double maxStateGMEC = Double.POSITIVE_INFINITY;
                for (LME constr : this.constraints) {
                    double[] coeffs = constr.getCoeffs();
                    boolean isStabilityConstr = true;
                    for (int state2 = 0; state2 < this.numStates; ++state2) {
                        if (state2 == state && Math.abs(coeffs[state2] - 1.0) > 1.0E-8) {
                            isStabilityConstr = false;
                            continue;
                        }
                        if (state2 == state || !(Math.abs(coeffs[state2]) > 1.0E-8)) continue;
                        isStabilityConstr = false;
                    }
                    if (!isStabilityConstr) continue;
                    maxStateGMEC = -constr.getConstTerm();
                    break;
                }
                if (maxStateGMEC == Double.POSITIVE_INFINITY) {
                    iVal = Double.POSITIVE_INFINITY;
                } else {
                    sp.loadEnergyMatrix();
                    cfgP.setupPruning(sp, Double.POSITIVE_INFINITY, false, false);
                    double lowestBound = gf.lowestPairwiseBound(sp);
                    iVal = maxStateGMEC - lowestBound;
                }
            }
        }
        System.out.println("State " + state + " is using ival " + iVal);
        return iVal;
    }

    void exhaustiveMultistateSearch() {
        System.out.println();
        System.out.println("CHECKING COMETS RESULT BY EXHAUSTIVE SEARCH");
        System.out.println();
        ArrayList<String[]> seqList = this.listAllSeqs();
        int numSeqs = seqList.size();
        double[][] stateGMECs = new double[numSeqs][this.numStates];
        for (int state = 0; state < this.numStates; ++state) {
            for (int seqNum = 0; seqNum < numSeqs; ++seqNum) {
                stateGMECs[seqNum][state] = this.calcStateGMEC(state, seqList.get(seqNum));
            }
        }
        int topSeqNum = -1;
        double bestSeqScore = Double.POSITIVE_INFINITY;
        for (int seqNum = 0; seqNum < numSeqs; ++seqNum) {
            double seqScore;
            boolean constrSatisfied = true;
            for (LME constr : this.constraints) {
                if (!(constr.eval(stateGMECs[seqNum]) > 0.0)) continue;
                constrSatisfied = false;
            }
            if (!constrSatisfied || !((seqScore = this.objFcn.eval(stateGMECs[seqNum])) < bestSeqScore)) continue;
            bestSeqScore = seqScore;
            topSeqNum = seqNum;
        }
        System.out.println();
        if (topSeqNum == -1) {
            System.out.println("EXHAUSTIVE SEARCH FINDS NO CONSTR-SATISFYING SEQUENCES");
        } else {
            System.out.println("EXHAUSTIVE MULTISTATE BEST SCORE: " + bestSeqScore + " SEQUENCE: ");
            for (String aa : seqList.get(topSeqNum)) {
                System.out.println(aa);
            }
        }
        System.out.println();
    }

    private ArrayList<String[]> listAllSeqs() {
        return this.listAllSeqsHelper(0);
    }

    private ArrayList<String[]> listAllSeqsHelper(int mutPos) {
        ArrayList<String[]> ans = new ArrayList<String[]>();
        if (mutPos == this.numTreeLevels) {
            ans.add(new String[0]);
        } else {
            ArrayList<String[]> subList = this.listAllSeqsHelper(mutPos + 1);
            for (String AAType : this.AATypeOptions.get(mutPos)) {
                for (String[] subSeq : subList) {
                    String[] seq = new String[this.numTreeLevels - mutPos];
                    System.arraycopy(subSeq, 0, seq, 1, this.numTreeLevels - mutPos - 1);
                    seq[0] = AAType;
                    ans.add(seq);
                }
            }
        }
        return ans;
    }

    private double calcStateGMEC(int state, String[] AATypes) {
        ConfigFileParser stateCfp = this.makeStateConfig(state);
        stateCfp.params.setValue("RUNNAME", "EXHAUSTIVE_SEQ_" + System.currentTimeMillis());
        stateCfp.params.setValue("ADDWT", "false");
        String[] seq = new String[stateCfp.getFlexRes().size()];
        for (int mutPos = 0; mutPos < this.numTreeLevels; ++mutPos) {
            seq[this.mutable2StatePosNums.get((int)state).get((int)mutPos).intValue()] = AATypes[mutPos];
        }
        int posCount = 0;
        for (int str = 0; str < 10; ++str) {
            ArrayList<String> resAllowedRecords = stateCfp.params.searchParams("RESALLOWED" + str);
            int numRecordsInStrand = resAllowedRecords.size();
            for (int recNum = 0; recNum < numRecordsInStrand; ++recNum) {
                if (seq[posCount] != null) {
                    String param = "RESALLOWED" + str + "_" + recNum;
                    stateCfp.params.setValue(param, seq[posCount]);
                }
                ++posCount;
            }
        }
        GMECFinder gf = new GMECFinder();
        gf.init(stateCfp);
        return gf.calcGMEC().get(0).getEnergy();
    }
}

