/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.control;

import edu.duke.cs.osprey.confspace.PositionConfSpace;
import edu.duke.cs.osprey.kstar.KSAbstract;
import edu.duke.cs.osprey.kstar.KSAllowedSeqs;
import edu.duke.cs.osprey.kstar.KSConfigFileParser;
import edu.duke.cs.osprey.kstar.impl.KSImplKAStar;
import edu.duke.cs.osprey.kstar.impl.KSImplLinear;
import edu.duke.cs.osprey.kstar.pfunc.PFAbstract;
import edu.duke.cs.osprey.kstar.pfunc.PFFactory;
import edu.duke.cs.osprey.parallelism.ThreadParallelism;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

@Deprecated
public class KStarCalculator {
    KSConfigFileParser cfp;
    double Ew;
    double I0 = 0.0;
    boolean doIMinDEE;
    boolean useContFlex;
    HashMap<Integer, KSAllowedSeqs> strand2AllowedSeqs = new HashMap();

    public KStarCalculator(KSConfigFileParser cfgP) {
        this.cfp = cfgP;
        this.Ew = this.cfp.params.getDouble("Ew", 5.0);
        this.doIMinDEE = this.cfp.params.getBool("imindee", false);
        if (this.doIMinDEE) {
            this.I0 = this.cfp.params.getDouble("Ival", 5.0);
        }
        this.useContFlex = this.cfp.params.getBool("doMinimize", false);
        if (this.doIMinDEE && !this.useContFlex) {
            throw new RuntimeException("ERROR: iMinDEE requires continuous flexibility. Change the value of doMinimize to 'true'.");
        }
        PositionConfSpace.dihedFlexInterval = this.cfp.params.getDouble("dihedFlexInterval");
        PFAbstract.suppressOutput = this.cfp.params.getBool("kStarPFuncSuppressOutput");
        PFAbstract.targetEpsilon = this.cfp.params.getDouble("epsilon");
        PFAbstract.setPhase2Method(this.cfp.params.getValue("kStarPhase2Method"));
        PFAbstract.qCapacity = this.cfp.params.getInt("kStarPFuncQCap", ThreadParallelism.getNumThreads() * 8);
        PFAbstract.setCFGImpl(this.cfp.params.getValue("kStarPFuncMethod"));
        PFAbstract.setStabilityThresh(this.cfp.params.getDouble("kStarPFuncStabThresh"));
        PFAbstract.setConfsThreadBuffer(this.cfp.params.getInt("kStarPFuncConfsThreadBuffer", 4));
        PFAbstract.setNumThreads(this.cfp.params.getInt("kStarPFuncThreads"));
        PFAbstract.saveTopConfsAsPDB = this.cfp.params.getBool("kStarSaveTopConfsAsPDB");
        PFAbstract.setNumTopConfsToSave(this.cfp.params.getInt("kStarNumTopConfsToSave"));
        PFAbstract.useMaxKSConfs = this.cfp.params.getBool("kStarUseMaxKSConfs");
        PFAbstract.setMaxKSconfs(this.cfp.params.getInt("kStarMaxKSConfs"));
        PFAbstract.setHotMethod("kStarPFunctHotMethod", this.cfp.params.getValue("kStarPFunctHotMethod"));
        if (!PFAbstract.getHotMethod().equalsIgnoreCase("none")) {
            this.cfp.getHighOrderTuplesByPDBResNum();
        }
        PFAbstract.setHotNumRes("kStarPFuncHotNumRes", this.cfp.params.getInt("kStarPFuncHotNumRes", 3));
        PFAbstract.setHotBoundPct("kStarPFuncHotBoundPct", this.cfp.params.getDouble("kStarPFuncHotBoundPct", 0.03));
        PFAbstract.setHotTopRotsPct("KStarPFuncHotTopRotsPct", this.cfp.params.getDouble("kStarPFuncHotTopRotsPct", 0.0));
        KSAbstract.runTimeout = this.cfp.params.getInt("kStarRunTimeout");
        KSAbstract.doCheckPoint = this.cfp.params.getBool("kStarDoCheckpoint");
        KSAbstract.setCheckPointInterval(this.cfp.params.getInt("kStarCheckpointInterval"));
        KSImplKAStar.useTightBounds = this.cfp.params.getBool("kStarUseTightBounds", true);
        KSImplKAStar.nodeExpansionMethod = this.cfp.params.getValue("kStarNodeExpansion", "parallel1");
    }

    protected ArrayList<String> getWTSequence() {
        return this.cfp.getWTSequence();
    }

    protected ArrayList<ArrayList<String>> getMutationsFromFile(String path2) throws IOException {
        if (!new File(path2).exists()) {
            throw new RuntimeException("ERROR: " + path2 + " does not exist");
        }
        ArrayList<ArrayList<String>> ans = new ArrayList<ArrayList<String>>();
        try (BufferedReader br = new BufferedReader(new FileReader(path2));){
            Object line;
            while ((line = br.readLine()) != null) {
                ArrayList<String> l = new ArrayList<String>();
                line = ((String)line).trim();
                for (String s : Arrays.asList(((String)line).split(" "))) {
                    if (s.contains("-")) {
                        s = s.split("-")[0];
                    }
                    l.add(s.trim());
                }
                ans.add(l);
            }
        }
        if (ans.size() > 0) {
            KSAllowedSeqs pl = this.strand2AllowedSeqs.get(2);
            for (ArrayList<String> seq : ans) {
                if (seq.size() == pl.getSequenceLength()) continue;
                throw new RuntimeException("ERROR: sequence " + KSAbstract.list1D2String(seq, " ") + " has a the wrong length");
            }
            for (int i = 0; i < ans.size(); ++i) {
                ArrayList<String> seq;
                seq = KSAllowedSeqs.addPosToSeq(ans.get(i), pl.getFlexRes());
                if (!pl.isAllowed(seq)) {
                    throw new RuntimeException("ERROR: sequence " + KSAbstract.list1D2String(ans.get(i), " ") + " is not allowed in the design space.\n Change resAllowed.");
                }
                ans.set(i, seq);
            }
            return ans;
        }
        return null;
    }

    public ArrayList<ArrayList<String>> truncateAllowedSequences(String path2) throws IOException {
        ArrayList<ArrayList<String>> mutations = this.getMutationsFromFile(path2);
        if (mutations == null) {
            return null;
        }
        KSAllowedSeqs pl = this.strand2AllowedSeqs.get(2);
        KSAllowedSeqs p = this.strand2AllowedSeqs.get(0);
        KSAllowedSeqs l = this.strand2AllowedSeqs.get(1);
        int plLen = pl.getSequenceLength();
        int pLen = p.getSequenceLength();
        pl.getStrandSeqList().clear();
        if (pl.addWT) {
            pl.getStrandSeqList().add(pl.getWTSeq());
        }
        p.getStrandSeqList().clear();
        if (p.addWT) {
            p.getStrandSeqList().add(p.getWTSeq());
        }
        l.getStrandSeqList().clear();
        if (l.addWT) {
            l.getStrandSeqList().add(l.getWTSeq());
        }
        for (ArrayList<String> seq : mutations) {
            if (pl.getStrandSeqList().contains(seq)) continue;
            pl.getStrandSeqList().add(seq);
            ArrayList<String> pSubList = new ArrayList<String>();
            for (String s : seq.subList(0, pLen)) {
                pSubList.add(s);
            }
            p.getStrandSeqList().add(pSubList);
            ArrayList<String> lSubList = new ArrayList<String>();
            for (String s : seq.subList(pLen, plLen)) {
                lSubList.add(s);
            }
            l.getStrandSeqList().add(lSubList);
        }
        pl.truncateAllowedAAs();
        p.truncateAllowedAAs();
        l.truncateAllowedAAs();
        return mutations;
    }

    private void generateAllowedSequences() {
        KSAllowedSeqs complexSeqs = this.cfp.getAllowedSequences(2, null);
        this.strand2AllowedSeqs.put(2, complexSeqs);
        this.strand2AllowedSeqs.put(0, this.cfp.getAllowedSequences(0, complexSeqs));
        this.strand2AllowedSeqs.put(1, this.cfp.getAllowedSequences(1, complexSeqs));
    }

    private KSAbstract makeKStar() {
        switch (this.cfp.params.getValue("kStarMethod")) {
            case "kastar": {
                return new KSImplKAStar(this.cfp);
            }
            case "linear": {
                return new KSImplLinear(this.cfp);
            }
        }
        throw new UnsupportedOperationException("ERROR: currently supported implementations are 'linear' and 'kastar'");
    }

    public KSAbstract calcKStarScores() {
        PFFactory.initStrandInfoCache();
        try {
            this.cfp.verifyStrandsMutuallyExclusive();
            this.generateAllowedSequences();
            String mutFilePath = this.cfp.params.getValue("mutfile", "");
            if (mutFilePath.length() > 0) {
                this.truncateAllowedSequences(mutFilePath);
            }
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
        KSAbstract kstar = this.makeKStar();
        kstar.init(this.strand2AllowedSeqs);
        kstar.run();
        PFFactory.cleanupStrandInfoCache();
        return kstar;
    }
}

