/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.control;

import edu.duke.cs.osprey.Osprey;
import edu.duke.cs.osprey.control.COMETSDoer;
import edu.duke.cs.osprey.control.ConfInfo;
import edu.duke.cs.osprey.control.ConfigFileParser;
import edu.duke.cs.osprey.control.EnergyCalculator;
import edu.duke.cs.osprey.control.EnvironmentVars;
import edu.duke.cs.osprey.control.KStarCalculator;
import edu.duke.cs.osprey.control.MSKStarDoer;
import edu.duke.cs.osprey.energy.LigandResEnergies;
import edu.duke.cs.osprey.energy.MultiTermEnergyFunction;
import edu.duke.cs.osprey.gmec.GMECFinder;
import edu.duke.cs.osprey.gmec.SeqGMECFinder;
import edu.duke.cs.osprey.gpu.opencl.Diagnostics;
import edu.duke.cs.osprey.kstar.KSConfigFileParser;
import edu.duke.cs.osprey.minimization.CCDMinimizer;
import edu.duke.cs.osprey.parallelism.ThreadParallelism;
import edu.duke.cs.osprey.tools.Stopwatch;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class Main {
    public static final String Version = Osprey.INSTANCE.getVersion();

    public static void main(String[] args) {
        String commandName;
        try {
            commandName = args[0];
        }
        catch (Exception e) {
            System.out.println("OSPREY command needed. Try one of: " + Command.listNames());
            System.exit(1);
            return;
        }
        Command command = Command.get(commandName);
        if (command == null) {
            if (commandName.equals("-c")) {
                System.out.println("ERROR: OSPREY args are now like 'findGMEC KStar.cfg System.cfg DEE.cfg' instead of '-c KStar.cfg findGMEC System.cfg DEE.cfg'");
            } else {
                System.out.println("ERROR: OSPREY command unrecognized: " + commandName);
            }
            System.exit(1);
            return;
        }
        CommandArgs cargs = new CommandArgs();
        for (int i = 1; i < args.length; ++i) {
            cargs.args.add(args[i]);
        }
        Stopwatch stopwatch = new Stopwatch().start();
        command.run(cargs);
        System.out.println("OSPREY finished, total execution time: " + stopwatch.stop().getTime() + ".");
    }

    public static enum Command {
        Version{

            @Override
            public void run(CommandArgs args) {
                System.out.println("OSPREY version: " + Main.Version);
            }
        }
        ,
        FindGMEC{

            @Override
            public void run(CommandArgs args) {
                ConfigFileParser cfp = args.loadConfig();
                GMECFinder gf = new GMECFinder();
                gf.init(cfp);
                gf.calcGMEC();
                args.cleanupConfig(cfp);
            }
        }
        ,
        FindSequences{

            @Override
            public void run(CommandArgs args) {
                ConfigFileParser cfp = args.loadConfig();
                GMECFinder gf = new GMECFinder();
                gf.init(cfp);
                gf.calcSequences();
                args.cleanupConfig(cfp);
            }
        }
        ,
        CalcKStar{

            @Override
            public void run(CommandArgs args) {
                ConfigFileParser cfp = args.loadConfig();
                KSConfigFileParser ksCfp = new KSConfigFileParser(cfp);
                KStarCalculator ksc = new KStarCalculator(ksCfp);
                ksc.calcKStarScores();
                args.cleanupConfig(cfp);
            }
        }
        ,
        DoCOMETS{

            @Override
            public void run(CommandArgs args) {
                ConfigFileParser cfp = args.loadConfig();
                COMETSDoer cd = new COMETSDoer(cfp);
                cd.calcBestSequences();
                args.cleanupConfig(cfp);
            }
        }
        ,
        MultiStateKStar{

            @Override
            public void run(CommandArgs args) {
                ConfigFileParser cfp = args.loadConfig();
                MSKStarDoer msksd = new MSKStarDoer(cfp);
                msksd.calcBestSequences();
                args.cleanupConfig(cfp);
            }
        }
        ,
        CalcLigResE{

            @Override
            public void run(CommandArgs args) {
                ConfigFileParser cfp = args.loadConfig();
                LigandResEnergies lre = new LigandResEnergies(cfp.params);
                lre.printEnergies();
                args.cleanupConfig(cfp);
            }
        }
        ,
        CalcEnergy{

            @Override
            public void run(CommandArgs args) {
                ConfigFileParser cfp = args.loadConfig();
                new EnergyCalculator().run(cfp);
                args.cleanupConfig(cfp);
            }
        }
        ,
        ConfInfo{

            @Override
            public void run(CommandArgs args) {
                ConfigFileParser cfp = args.loadConfig();
                ConfInfo ci = new ConfInfo(cfp);
                ci.outputConfInfo();
                args.cleanupConfig(cfp);
            }
        }
        ,
        GpuInfo{

            @Override
            public void run(CommandArgs args) {
                edu.duke.cs.osprey.gpu.cuda.Diagnostics.main(null);
                Diagnostics.main(null);
            }
        }
        ,
        FindSeqGMECs{

            @Override
            public void run(CommandArgs args) {
                ConfigFileParser cfp = args.loadConfig();
                new SeqGMECFinder(cfp).calcAllSeqGMECs();
                args.cleanupConfig(cfp);
            }
        };

        private static Map<String, Command> commands;

        public abstract void run(CommandArgs var1);

        public static Command get(String name) {
            return commands.get(Command.normalizeName(name));
        }

        public static String listNames() {
            StringJoiner joiner = new StringJoiner(", ");
            for (Command command : Command.values()) {
                joiner.add(command.name());
            }
            return joiner.toString();
        }

        public static String normalizeName(String name) {
            return name.toLowerCase();
        }

        static {
            commands = new HashMap<String, Command>();
            for (Command command : Command.values()) {
                commands.put(Command.normalizeName(command.name()), command);
            }
        }
    }

    private static class CommandArgs {
        public final List<String> args = new ArrayList<String>();

        public ConfigFileParser loadConfig() {
            ArrayList<File> configFiles = new ArrayList<File>();
            boolean allExist = true;
            for (String path2 : this.args) {
                File configFile = new File(path2);
                if (!configFile.exists()) {
                    System.out.println("can't find config file: " + configFile.getAbsolutePath());
                    allExist = false;
                }
                configFiles.add(configFile);
            }
            if (!allExist) {
                System.exit(1);
            }
            ConfigFileParser cfp = ConfigFileParser.makeFromFiles(configFiles);
            cfp.loadData();
            EnvironmentVars.openSpecialWarningLogs(cfp);
            ThreadParallelism.setNumThreads(cfp.params.getInt("NumThreads"));
            MultiTermEnergyFunction.setNumThreads(ThreadParallelism.getNumThreads());
            CCDMinimizer.EConvTol = cfp.params.getDouble("CCDEConvTol");
            CCDMinimizer.numIter = cfp.params.getInt("CCDNumIter");
            return cfp;
        }

        public void cleanupConfig(ConfigFileParser cfp) {
            EnvironmentVars.closeSpecialWarningLogs();
        }
    }
}

