/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.design;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.MissingCommandException;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import edu.duke.cs.osprey.design.commands.CliCommand;
import edu.duke.cs.osprey.design.commands.CommandInvert;
import edu.duke.cs.osprey.design.commands.CommandLaunchGui;
import edu.duke.cs.osprey.design.commands.CompiledConfSpaceKStar;
import java.util.Map;

public class Main {
    @Parameter(names={"--help", "-h"}, help=true)
    private boolean help;
    public static final int Success = 0;
    public static final int Failure = 1;
    public static final String ProgramName = "osprey";

    private void printErrorMessage(String msg) {
        System.out.println(msg);
        System.out.println();
        System.out.println("Use --help or <command> --help for more info.");
        System.out.println();
    }

    public int run(String[] args) {
        Map<String, CommandInvert> commandMap = Map.of("setup-design", new CommandLaunchGui(), "kstar", new CompiledConfSpaceKStar(), "invert", new CommandInvert());
        JCommander.Builder builder = JCommander.newBuilder().programName(ProgramName).addObject((Object)this);
        commandMap.forEach((x$0, x$1) -> builder.addCommand(x$0, x$1, new String[0]));
        JCommander commander = builder.build();
        try {
            commander.parse(args);
        }
        catch (MissingCommandException ex) {
            this.printErrorMessage(String.format("Error: the command \"%s\" does not exist.", ex.getUnknownCommand()));
            commander.usage();
            return 1;
        }
        catch (ParameterException ex) {
            this.printErrorMessage(String.format("Error: %s", ex.getMessage()));
            return 1;
        }
        if (args.length == 0 || this.help) {
            commander.usage();
            return 0;
        }
        String parsedCommand = commander.getParsedCommand();
        return ((CliCommand)commandMap.get(parsedCommand)).run((JCommander)commander.getCommands().get(parsedCommand), args);
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((thread2, throwable) -> {
            if (throwable instanceof OutOfMemoryError) {
                Main.printMemoryStatistics();
            }
            throwable.printStackTrace();
            System.exit(1);
        });
        System.exit(new Main().run(args));
    }

    private static void printMemoryStatistics() {
        Runtime runtime = Runtime.getRuntime();
        System.err.printf("Current HeapSize: %d\nMax Heap Size: %d\nCurrent Free Space: %d\n%n", runtime.totalMemory(), runtime.maxMemory(), runtime.freeMemory());
    }
}

