/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.design.commands;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import edu.duke.cs.osprey.astar.conf.ConfAStarTree;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.confspace.Strand;
import edu.duke.cs.osprey.confspace.StrandFlex;
import edu.duke.cs.osprey.design.commands.DelegatingCommand;
import edu.duke.cs.osprey.design.commands.DesignFileDelegate;
import edu.duke.cs.osprey.design.models.AffinityDesign;
import edu.duke.cs.osprey.design.models.MoleculeDto;
import edu.duke.cs.osprey.design.models.Residue;
import edu.duke.cs.osprey.design.models.ResidueModifier;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.ematrix.SimpleReferenceEnergies;
import edu.duke.cs.osprey.ematrix.SimplerEnergyMatrixCalculator;
import edu.duke.cs.osprey.ematrix.UpdatingEnergyMatrix;
import edu.duke.cs.osprey.energy.ConfEnergyCalculator;
import edu.duke.cs.osprey.energy.EnergyCalculator;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldParams;
import edu.duke.cs.osprey.energy.forcefield.amber.ForcefieldFileParser;
import edu.duke.cs.osprey.kstar.KStar;
import edu.duke.cs.osprey.kstar.KStarSettings;
import edu.duke.cs.osprey.kstar.ScoredSequence;
import edu.duke.cs.osprey.kstar.pfunc.GradientDescentPfunc;
import edu.duke.cs.osprey.markstar.framework.MARKStarBoundFastQueues;
import edu.duke.cs.osprey.structure.Molecule;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

@Parameters(commandDescription="Compute an epsilon approximation to binding affinity (K*).")
public class CommandBindingAffinity
extends DelegatingCommand {
    public static final String CommandName = "affinity";
    public static final String CommandDescription = "Compute an epsilon approximation to binding affinity (K*).";
    @Parameter(names={"--do-scan"}, description="Runs a scan using the scan settings specified in the design.")
    public boolean doScan;
    @Parameter(names={"--scan-flex-distance"}, description="Distance (in angstroms) around mutable residues in which residues are flexible.")
    public double scanFlexDistance = 2.0;
    @Parameter(names={"--scan-distance"}, description="Distance (in angstroms) around a scan's target residue in which residues are made mutable.")
    public double scanDistance = 5.0;
    @Parameter(names={"--scan-output"}, description="Specifies the output directory to save the scan designs in.")
    public String scanOutput;
    @Parameter(names={"--max-num-confs"}, description="Sets an upper bound on the number of conformations evaluated.")
    private int maxNumberConfs = -1;
    @Parameter(names={"--use-markstar"}, description="Use MARK* instead of Gradient Descent for the partition function calculation.")
    public boolean useMarkstar;
    @Parameter(names={"--stability-threshold"}, description="Pruning criteria to remove sequences with unstable unbound states relative to the wild type sequence. Set to a negative number to disable.")
    public double stabilityThreshold = 5.0;
    private String[] args;
    private Map<String, String> dbSettings = new HashMap<String, String>();
    private static final String dbHostnameKey = "dbHostname";
    private static final String dbPortKey = "dbPort";
    private static final String dbNameKey = "dbName";
    private static final String dbUserNameKey = "dbUserName";
    private static final String dbPasswordKey = "dbPassword";
    private static final List<String> allMutableAaTypes = List.of("ALA", "ARG", "ASN", "ASP", "CYS", "GLU", "GLN", "GLY", "HIE", "HID", "HIP", "ILE", "LEU", "LYS", "MET", "PHE", "PRO", "SER", "THR", "TRP", "TYR", "VAL");

    @Override
    public int run(JCommander commander, String[] args) {
        this.args = args;
        return this.processHelpAndNoArgs(commander, args).orElseGet(() -> this.parseAndValidate(this.delegate.design).map(this::runAffinityDesign).orElse(1));
    }

    private int runAffinityDesign(AffinityDesign design) {
        ForceFieldParamsAndStrands paramsAndStrands = new ForceFieldParamsAndStrands(this.delegate, design);
        if (this.doScan && design.scanSettings != null) {
            return this.makeScanDesigns(design, paramsAndStrands.makeAllResidues());
        }
        if (this.delegate.verifyInput) {
            System.out.println("Design file validated.");
            return 0;
        }
        EnergyCalculator minimizingECalc = new EnergyCalculator.Builder(paramsAndStrands.complexConfSpace, paramsAndStrands.forcefieldParams).setParallelism(this.delegate.getParallelism()).build();
        EnergyCalculator rigidECalc = new EnergyCalculator.SharedBuilder(minimizingECalc).setIsMinimizing(false).build();
        double epsilon = this.delegate.epsilon > 0.0 ? this.delegate.epsilon : 0.999999;
        KStar kstar = new KStar(paramsAndStrands.proteinConfSpace, paramsAndStrands.ligandConfSpace, paramsAndStrands.complexConfSpace, this.makeKStarSettings(epsilon));
        for (KStar.ConfSpaceInfo info2 : kstar.confSpaceInfos()) {
            ConfEnergyCalculator minimizingConfECalc;
            SimpleReferenceEnergies referenceEnergies = new SimpleReferenceEnergies.Builder((SimpleConfSpace)info2.confSpace, minimizingECalc).build();
            info2.confEcalc = minimizingConfECalc = new ConfEnergyCalculator.Builder((SimpleConfSpace)info2.confSpace, minimizingECalc).setReferenceEnergies(referenceEnergies).build();
            EnergyMatrix minimizedEnergyMatrix = new SimplerEnergyMatrixCalculator.Builder(minimizingConfECalc).build().calcEnergyMatrix();
            if (this.useMarkstar) {
                ConfEnergyCalculator rigidConfECalc = new ConfEnergyCalculator(info2.confEcalc, rigidECalc);
                EnergyMatrix rigidEnergymatrix = new SimplerEnergyMatrixCalculator.Builder(rigidConfECalc).build().calcEnergyMatrix();
                info2.pfuncFactory = rcs -> {
                    MARKStarBoundFastQueues pfn = new MARKStarBoundFastQueues(minimizingConfECalc.confSpace, rigidEnergymatrix, minimizedEnergyMatrix, info2.confEcalc, rcs, minimizingECalc.parallelism);
                    pfn.setCorrections(new UpdatingEnergyMatrix(info2.confEcalc.confSpace, minimizedEnergyMatrix, info2.confEcalc));
                    return pfn;
                };
                continue;
            }
            info2.pfuncFactory = rcs -> new GradientDescentPfunc(info2.confEcalc, new ConfAStarTree.Builder(minimizedEnergyMatrix, rcs).setTraditional().build(), new ConfAStarTree.Builder(minimizedEnergyMatrix, rcs).setTraditional().build(), rcs.getNumConformations());
        }
        this.printResults(kstar.run(minimizingECalc.tasks));
        return 0;
    }

    private int makeScanDesigns(AffinityDesign design, List<edu.duke.cs.osprey.structure.Residue> allResidues) {
        String target = design.scanSettings.target;
        List<ResidueModifier> residues = design.scanSettings.residues;
        if (target.isEmpty() && residues.isEmpty() || !target.isEmpty() && !residues.isEmpty()) {
            System.err.println("Either target or residues must be specified, but not both");
            return 1;
        }
        residues.forEach(r -> {
            r.mutability = r.mutability.isEmpty() ? allMutableAaTypes : r.mutability;
        });
        List<ResidueModifier> mutableTargets = residues.isEmpty() ? this.findMutableResiduesAroundTarget(design, this.scanDistance, target, allResidues) : residues;
        return this.createScanDesigns(design, mutableTargets, this.scanFlexDistance);
    }

    @NotNull
    private List<ResidueModifier> findMutableResiduesAroundTarget(AffinityDesign design, double dist, String target, List<edu.duke.cs.osprey.structure.Residue> allResidues) {
        edu.duke.cs.osprey.structure.Residue targetRes = allResidues.stream().filter(a -> a.getPDBResNumber().equals(target)).findFirst().orElseThrow();
        List modifiers = ((StreamEx)((StreamEx)((StreamEx)StreamEx.of(allResidues).filter(x -> x != targetRes)).filter(x -> !design.scanSettings.excluding.contains(x.getPDBResNumber()))).filter(x -> x.distanceTo(targetRes) <= dist)).map(CommandBindingAffinity::makeFlexibleResidueModifier).toList();
        modifiers.forEach(a -> {
            a.mutability = allMutableAaTypes;
        });
        return modifiers;
    }

    public static Stream<edu.duke.cs.osprey.structure.Residue> nearbyResidues(edu.duke.cs.osprey.structure.Residue target, Molecule molecule, double withinDistance) {
        return molecule.residues.stream().filter(x -> x.distanceTo(target) <= withinDistance).filter(x -> target.getChainId() != x.getChainId() || !target.getPDBResNumber().equals(x.getPDBResNumber()) || !target.getType().equals(x.getType()));
    }

    public static Stream<ResidueModifier> nearbyResidueModifiers(edu.duke.cs.osprey.structure.Residue target, Molecule molecule, double withinDistance) {
        return CommandBindingAffinity.nearbyResidues(target, molecule, withinDistance).map(CommandBindingAffinity::makeFlexibleResidueModifier);
    }

    private int createScanDesigns(AffinityDesign designTemplate, List<ResidueModifier> mutableTargets, double flexDist) {
        Molecule proteinMol = designTemplate.makeProteinMolecule();
        Molecule ligandMol = designTemplate.makeLigandMolecule();
        for (int[] comboIndices : StreamEx.ofCombinations((int)mutableTargets.size(), (int)this.delegate.maxSimultaneousMutations)) {
            List mutableResidues = IntStreamEx.of((int[])comboIndices).mapToObj(mutableTargets::get).toList();
            Set mutableTargetNums = StreamEx.of((Collection)mutableResidues).map(x -> x.identity.positionIdentifier()).toSet();
            List mutableTargetRes = ((StreamEx)StreamEx.of((Collection)proteinMol.residues).append((Collection)ligandMol.residues).filter(res -> mutableTargetNums.contains(res.getPDBResNumber()))).toList();
            List proteinResMods = ((StreamEx)StreamEx.of((Collection)mutableTargetRes).flatMap(residue -> CommandBindingAffinity.nearbyResidueModifiers(residue, proteinMol, flexDist)).distinct()).toList();
            List ligandResMods = ((StreamEx)StreamEx.of((Collection)mutableTargetRes).flatMap(residue -> CommandBindingAffinity.nearbyResidueModifiers(residue, ligandMol, flexDist)).distinct()).toList();
            StreamEx.of((Collection)mutableResidues).zipWith((Stream)StreamEx.of((Collection)mutableTargetRes)).forKeyValue((residueModifier, residue) -> {
                if (proteinMol.residues.contains(residue)) {
                    proteinResMods.add(residueModifier);
                } else {
                    ligandResMods.add(residueModifier);
                }
            });
            try {
                String nameTemp = this.delegate.design.getName().substring(0, this.delegate.design.getName().lastIndexOf("."));
                String comboName = String.join((CharSequence)"-", StreamEx.of((Collection)mutableTargetRes).map(edu.duke.cs.osprey.structure.Residue::getPDBResNumber).toList());
                Path path2 = Path.of(String.format("%s.%s.yaml", nameTemp, comboName), new String[0]);
                Files.deleteIfExists(path2);
                Path outFile = Files.createFile(path2, new FileAttribute[0]);
                AffinityDesign designCopy = designTemplate.copy();
                designCopy.protein.residueModifiers = StreamEx.of(designCopy.protein.residueModifiers).append((Collection)proteinResMods).toList();
                designCopy.ligand.residueModifiers = StreamEx.of(designCopy.ligand.residueModifiers).append((Collection)ligandResMods).toList();
                designCopy.scanSettings = null;
                designCopy.write(outFile);
            }
            catch (IOException e) {
                e.printStackTrace();
                return 1;
            }
        }
        return 0;
    }

    @NotNull
    private static ResidueModifier makeFlexibleResidueModifier(edu.duke.cs.osprey.structure.Residue x) {
        Residue res = new Residue();
        res.aminoAcidType = x.getType();
        res.chain = String.valueOf(x.getChainId());
        res.residueNumber = Integer.parseInt(x.getPDBResNumber().substring(1));
        ResidueModifier modifier = new ResidueModifier();
        modifier.identity = res;
        modifier.mutability = List.of();
        return modifier;
    }

    private void printResults(List<ScoredSequence> results2) {
    }

    private KStarSettings makeKStarSettings(double epsilon) {
        KStarSettings.Builder builder = new KStarSettings.Builder();
        builder.setEpsilon(epsilon);
        builder.addScoreConsoleWriter();
        if (this.maxNumberConfs > 0) {
            builder.setMaxNumConf(this.maxNumberConfs);
        }
        builder.setMaxSimultaneousMutations(this.delegate.maxSimultaneousMutations);
        builder.setStabilityThreshold(this.stabilityThreshold < 0.0 ? null : Double.valueOf(this.stabilityThreshold));
        if (this.delegate.writeNConfs > 0) {
            // empty if block
        }
        return builder.build();
    }

    private Optional<AffinityDesign> parseAndValidate(File designSpec) {
        return CommandBindingAffinity.getAffinityDesignFromFile(designSpec);
    }

    @NotNull
    public static Optional<AffinityDesign> getAffinityDesignFromFile(File designSpec) {
        AffinityDesign design;
        try {
            design = AffinityDesign.parse(designSpec);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Optional.empty();
        }
        List<String> specErrors = design.validate();
        if (!specErrors.isEmpty()) {
            System.err.println("Invalid design specification. The following validations failed:");
            specErrors.stream().map(s -> String.format("- %s", s)).forEach(System.err::println);
            return Optional.empty();
        }
        return Optional.of(design);
    }

    @Override
    public String getCommandName() {
        return CommandName;
    }

    @Override
    public String getCommandDescription() {
        return CommandDescription;
    }

    public static class ForceFieldParamsAndStrands {
        private final SimpleConfSpace complexConfSpace;
        public ForcefieldParams forcefieldParams;
        public SimpleConfSpace proteinConfSpace;
        public SimpleConfSpace ligandConfSpace;
        public List<Strand> allStrands;

        private static void addStrandsToComplexBuilder(MoleculeDto dto, SimpleConfSpace.Builder builder, List<Strand> strands) {
            if (dto.translateRotate != null) {
                StrandFlex.TranslateRotate tr = new StrandFlex.TranslateRotate(dto.translateRotate.rotateDegrees, dto.translateRotate.translateAngstroms);
                StreamEx.of(strands).forEach(cs -> builder.addStrand((Strand)cs, tr));
            } else {
                StreamEx.of(strands).forEach(x$0 -> builder.addStrand((Strand)x$0, new StrandFlex[0]));
            }
        }

        public ForceFieldParamsAndStrands(DesignFileDelegate delegate, AffinityDesign design) {
            this.forcefieldParams = delegate.frcmodPath == null ? new ForcefieldParams() : new ForcefieldParams(ForcefieldParams.Forcefield.AMBER, new ForcefieldFileParser(this.getClass().getResourceAsStream(ForcefieldParams.Forcefield.AMBER.paramsPath), Paths.get(delegate.frcmodPath, new String[0])));
            this.proteinConfSpace = delegate.createConfSpace(design.protein, this.forcefieldParams);
            this.ligandConfSpace = delegate.createConfSpace(design.ligand, this.forcefieldParams);
            this.allStrands = StreamEx.of((Object[])new List[]{this.proteinConfSpace.strands, this.ligandConfSpace.strands}).flatMap(Collection::stream).toList();
            SimpleConfSpace.Builder builder = new SimpleConfSpace.Builder();
            ForceFieldParamsAndStrands.addStrandsToComplexBuilder(design.protein, builder, this.proteinConfSpace.strands);
            ForceFieldParamsAndStrands.addStrandsToComplexBuilder(design.ligand, builder, this.ligandConfSpace.strands);
            this.complexConfSpace = builder.build();
        }

        List<edu.duke.cs.osprey.structure.Residue> makeAllResidues() {
            return StreamEx.of(this.allStrands).flatMap(x -> x.mol.residues.stream()).toList();
        }
    }
}

