/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.design.commands;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import edu.duke.cs.osprey.design.commands.CommandBindingAffinity;
import edu.duke.cs.osprey.design.commands.DelegatingCommand;
import edu.duke.cs.osprey.design.models.AffinityDesign;
import edu.duke.cs.osprey.design.models.ResidueModifier;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.Residue;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Parameters(commandDescription="Adds a flexible shell around mutable residues")
public class CommandMakeFlexShell
extends DelegatingCommand {
    public static final String CommandName = "add-flexible-shell";
    public static final String CommandDescription = "Adds a flexible shell around mutable residues";
    @Parameter(names={"--flex-distance"}, description="Distance (in angstroms) around mutable residues in which residues are flexible.")
    public double flexDistance = 3.0;

    @Override
    public int run(JCommander commander, String[] args) {
        return this.processHelpAndNoArgs(commander, args).orElseGet(() -> this.parseAndValidate(this.delegate.design).map(this::addFlexibleShell).orElse(1));
    }

    private Stream<ResidueModifier> mutableResidues(AffinityDesign design) {
        return Stream.of(design.ligand.residueModifiers, design.protein.residueModifiers).flatMap(Collection::stream).filter(x -> !x.mutability.isEmpty());
    }

    private List<ResidueModifier> makeResidueModifiersInMolecule(AffinityDesign design, Molecule molecule) {
        Set mutableResidues = this.mutableResidues(design).collect(Collectors.toSet());
        return (List)this.mutableResidues(design).map(mod -> this.toMoleculeResidue((Collection<Molecule>)List.of(design.makeProteinMolecule(), design.makeLigandMolecule()), (ResidueModifier)mod)).flatMap(residue -> CommandBindingAffinity.nearbyResidueModifiers(residue, molecule, this.flexDistance)).reduce(ImmutableList.of(), (intermediateList, residueModifier) -> {
            List residues = Stream.concat(intermediateList.stream().map(mod -> mod.identity), this.mutableResidues(design).map(mod -> mod.identity)).collect(Collectors.toList());
            return residues.contains(residueModifier.identity) ? intermediateList : new ImmutableList.Builder().addAll((Iterable)intermediateList).add(residueModifier).build();
        }, (intermediate, toAppend) -> ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)intermediate, (Iterable)toAppend)));
    }

    private int addFlexibleShell(AffinityDesign design) {
        Molecule protein = design.makeProteinMolecule();
        Molecule ligand = design.makeLigandMolecule();
        List<ResidueModifier> proteinModifiers = this.makeResidueModifiersInMolecule(design, protein);
        List<ResidueModifier> ligandModifiers = this.makeResidueModifiersInMolecule(design, ligand);
        design.protein.residueModifiers.addAll(proteinModifiers);
        design.ligand.residueModifiers.addAll(ligandModifiers);
        try {
            String nameTemp = this.delegate.design.getName().substring(0, this.delegate.design.getName().lastIndexOf("."));
            Path path2 = Path.of(String.format("%s.flex-shell.yaml", nameTemp), new String[0]).getFileName();
            design.write(path2);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    private boolean isSamePosition(Residue residue, ResidueModifier modifier) {
        return residue.getChainId() == modifier.identity.chain.charAt(0) && modifier.identity.aminoAcidType.equals(residue.getType()) && modifier.identity.residueNumber == Integer.parseInt(residue.getPDBResNumber().substring(1));
    }

    private Residue toMoleculeResidue(Collection<Molecule> molecule, ResidueModifier mod) {
        return molecule.stream().flatMap(mol -> mol.residues.stream()).filter(residue -> this.isSamePosition((Residue)residue, mod)).findAny().orElseThrow();
    }

    private Optional<AffinityDesign> checkFlexShellRequirements(AffinityDesign design) {
        boolean hasMutableResidue = this.mutableResidues(design).anyMatch(mod -> !mod.mutability.isEmpty());
        if (!hasMutableResidue) {
            System.err.print("Making a flex shell requires at least one mutable residue to flex around%n");
            return Optional.empty();
        }
        return Optional.of(design);
    }

    private Optional<AffinityDesign> parseAndValidate(File designFile) {
        Optional<AffinityDesign> design = CommandBindingAffinity.getAffinityDesignFromFile(designFile);
        return design.flatMap(this::checkFlexShellRequirements);
    }

    @Override
    public String getCommandName() {
        return CommandName;
    }

    @Override
    public String getCommandDescription() {
        return CommandDescription;
    }
}

