/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.design.commands;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParametersDelegate;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import edu.duke.cs.osprey.design.commands.CliCommand;
import edu.duke.cs.osprey.design.commands.DesignFileDelegate;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;

public abstract class DelegatingCommand
implements CliCommand {
    @ParametersDelegate
    protected DesignFileDelegate delegate = new DesignFileDelegate();

    Optional<Integer> processHelpAndNoArgs(JCommander commander, String[] args) {
        if (args.length == 1) {
            this.printHelp(commander);
            return Optional.of(1);
        }
        if (this.delegate.help) {
            this.printHelp(commander);
            return Optional.of(0);
        }
        return Optional.empty();
    }

    void cleanupStuffFromPreviousRuns() {
        try {
            List<File> filesInPwd = Files.list(Paths.get("", new String[0])).map(Path::toFile).filter(File::isFile).filter(f -> f.toString().contains(".confdb") || f.toString().contains(".wal")).toList();
            filesInPwd.forEach(File::delete);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public <T> Optional<T> parseDesignSpec(Class<T> t) {
        try {
            ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            FileInputStream stream = new FileInputStream(this.delegate.design);
            return Optional.of(mapper.readValue((InputStream)stream, t));
        }
        catch (IOException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }
}

