/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.design.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Residue {
    public String chain;
    @JsonProperty(value="res_num")
    public int residueNumber;
    @JsonProperty(value="aa_type")
    public String aminoAcidType;

    public String positionIdentifier() {
        return String.format("%s%d", this.chain, this.residueNumber).toUpperCase();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Residue residue = (Residue)o;
        return this.residueNumber == residue.residueNumber && this.chain.equals(residue.chain) && this.aminoAcidType.equals(residue.aminoAcidType);
    }

    public int hashCode() {
        return Objects.hash(this.chain, this.residueNumber, this.aminoAcidType);
    }
}

