/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.dof.deeper;

import edu.duke.cs.osprey.dof.deeper.PertSet;
import edu.duke.cs.osprey.dof.deeper.PerturbationSelector;
import edu.duke.cs.osprey.dof.deeper.perts.Perturbation;
import edu.duke.cs.osprey.multistatekstar.ResidueTermini;
import edu.duke.cs.osprey.restypes.ResidueTemplateLibrary;
import edu.duke.cs.osprey.structure.Molecule;
import java.io.Serializable;
import java.util.ArrayList;

public class DEEPerSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    PertSet perts = null;
    boolean doPerturbations;
    String pertFileName;
    boolean selectPerturbations;
    String startingPertFile;
    boolean onlyStarting;
    double maxShearParam;
    double maxBackrubParam;
    boolean selectLCAs;
    boolean doRamaCheck;
    ArrayList<String> flexibleRes;
    String PDBFile;
    ResidueTemplateLibrary templateLib;

    public DEEPerSettings() {
        this.doPerturbations = false;
    }

    public DEEPerSettings(boolean doPerturbations, String pertFileName, boolean selectPerturbations, String startingPertFile, boolean onlyStarting, double maxShearParam, double maxBackrubParam, boolean selectLCAs, ArrayList<String> flexibleRes, String PDBFile, boolean doRamaCheck, ResidueTemplateLibrary templateLib) {
        this.doPerturbations = doPerturbations;
        this.pertFileName = pertFileName;
        this.selectPerturbations = selectPerturbations;
        this.startingPertFile = startingPertFile;
        this.onlyStarting = onlyStarting;
        this.maxShearParam = maxShearParam;
        this.maxBackrubParam = maxBackrubParam;
        this.selectLCAs = selectLCAs;
        this.flexibleRes = flexibleRes;
        this.PDBFile = PDBFile;
        this.doRamaCheck = doRamaCheck;
        this.templateLib = templateLib;
    }

    public boolean doPerturbations() {
        return this.doPerturbations;
    }

    public void loadPertFile(ResidueTermini termini) {
        if (!this.doPerturbations) {
            return;
        }
        this.perts = new PertSet();
        if (!this.perts.loadPertFile(this.pertFileName, true, termini)) {
            if (!this.selectPerturbations) {
                throw new RuntimeException("ERROR: Perturbation file not found but not supposed to select perturbations");
            }
            PerturbationSelector sele = new PerturbationSelector(this.startingPertFile, this.onlyStarting, this.maxShearParam, this.maxBackrubParam, this.selectLCAs, this.flexibleRes, this.PDBFile, termini, this.doRamaCheck, this.templateLib);
            PertSet ps = sele.selectPerturbations(termini);
            ps.writePertFile(this.pertFileName);
            this.perts.loadPertFile(this.pertFileName, true, termini);
        }
    }

    public ArrayList<Perturbation> makePerturbations(Molecule m) {
        if (this.perts == null) {
            return new ArrayList<Perturbation>();
        }
        return this.perts.makePerturbations(m);
    }

    public ArrayList<ArrayList<double[]>> getPertIntervals() {
        if (this.perts == null) {
            return null;
        }
        return this.perts.pertIntervals;
    }

    public ArrayList<ArrayList<int[]>> getPertStates(int pos) {
        if (this.perts == null || this.perts.pertStates.isEmpty()) {
            return null;
        }
        return this.perts.pertStates.get(pos);
    }

    public DEEPerSettings makeDiscreteVersion() {
        DEEPerSettings discrSettings = new DEEPerSettings(this.doPerturbations, this.pertFileName + ".DISCR", this.selectPerturbations, this.startingPertFile, this.onlyStarting, 0.0, 0.0, this.selectLCAs, this.flexibleRes, this.PDBFile, this.doRamaCheck, this.templateLib);
        discrSettings.perts = this.perts == null ? null : this.perts.makeDiscreteVersion();
        return discrSettings;
    }
}

