/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.dof.deeper.perts;

import edu.duke.cs.osprey.dof.deeper.perts.Perturbation;
import edu.duke.cs.osprey.dof.deeper.perts.PerturbationBlock;
import edu.duke.cs.osprey.dof.deeper.perts.TripeptideClosure;
import edu.duke.cs.osprey.structure.ConfProblem;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.ObjectIO;
import edu.duke.cs.osprey.tools.RigidBodyMotion;
import edu.duke.cs.osprey.tools.RotationMatrix;
import edu.duke.cs.osprey.tools.VectorAlgebra;
import java.util.ArrayList;
import java.util.HashMap;

public class LoopClosureAdjustment
extends Perturbation {
    HashMap<String, RigidBodyMotion[][]> solnCache = new HashMap();
    ArrayList<ConfProblem> problems = new ArrayList();

    public LoopClosureAdjustment(ArrayList<Residue> resDirectlyAffected) {
        super(resDirectlyAffected);
    }

    @Override
    public boolean doPerturbationMotion(double paramVal) {
        int solnNum = (int)paramVal;
        RigidBodyMotion[][] rotations = this.getRotationsForCurState();
        if (solnNum >= rotations.length) {
            if (this.problems.isEmpty()) {
                for (Residue res : this.resDirectlyAffected) {
                    this.problems.add(new ConfProblem(this, res));
                }
            }
            return false;
        }
        for (ConfProblem prob : this.problems) {
            prob.removeFromRes();
        }
        this.problems = new ArrayList();
        this.applyBackrubLikeMotion(rotations[solnNum]);
        return true;
    }

    private RigidBodyMotion[][] getRotationsForCurState() {
        String startCoordHash = this.hashStartingCoords();
        if (!this.solnCache.containsKey(startCoordHash)) {
            RigidBodyMotion[][] solns = this.calcSolns();
            this.solnCache.put(startCoordHash, solns);
        }
        return this.solnCache.get(startCoordHash);
    }

    public RigidBodyMotion[][] calcSolns() {
        TripeptideClosure tc = new TripeptideClosure(this.resDirectlyAffected);
        double[][][] r_soln_n = new double[16][3][3];
        double[][][] r_soln_a = new double[16][3][3];
        double[][][] r_soln_c = new double[16][3][3];
        double[] firstN = ((Residue)this.resDirectlyAffected.get(0)).getCoordsByAtomName("N");
        double[] firstCA = ((Residue)this.resDirectlyAffected.get(0)).getCoordsByAtomName("CA");
        double[] firstC = ((Residue)this.resDirectlyAffected.get(0)).getCoordsByAtomName("C");
        double[] midN = ((Residue)this.resDirectlyAffected.get(1)).getCoordsByAtomName("N");
        double[] midCA = ((Residue)this.resDirectlyAffected.get(1)).getCoordsByAtomName("CA");
        double[] midC = ((Residue)this.resDirectlyAffected.get(1)).getCoordsByAtomName("C");
        double[] lastN = ((Residue)this.resDirectlyAffected.get(2)).getCoordsByAtomName("N");
        double[] lastCA = ((Residue)this.resDirectlyAffected.get(2)).getCoordsByAtomName("CA");
        double[] lastC = ((Residue)this.resDirectlyAffected.get(2)).getCoordsByAtomName("C");
        int numSoln = tc.solve_3pep_poly(firstN, firstCA, lastCA, lastC, r_soln_n, r_soln_a, r_soln_c);
        RigidBodyMotion[][] solns = new RigidBodyMotion[numSoln][2];
        int unperturbed = -1;
        double lowestSum = Double.POSITIVE_INFINITY;
        for (int s = 0; s < numSoln; ++s) {
            RotationMatrix rm1 = RotationMatrix.getSuperposingRotMatrix(VectorAlgebra.subtract(midCA, firstCA), VectorAlgebra.subtract(r_soln_a[s][1], firstCA), VectorAlgebra.subtract(midN, firstCA), VectorAlgebra.subtract(r_soln_n[s][1], firstCA));
            RotationMatrix rm2 = RotationMatrix.getSuperposingRotMatrix(VectorAlgebra.subtract(midC, lastCA), VectorAlgebra.subtract(r_soln_c[s][1], lastCA), VectorAlgebra.subtract(lastN, lastCA), VectorAlgebra.subtract(r_soln_n[s][2], lastCA));
            double checkSum = VectorAlgebra.normsq(VectorAlgebra.subtract(firstC, r_soln_c[s][0])) + VectorAlgebra.normsq(VectorAlgebra.subtract(midN, r_soln_n[s][1])) + VectorAlgebra.normsq(VectorAlgebra.subtract(midCA, r_soln_a[s][1])) + VectorAlgebra.normsq(VectorAlgebra.subtract(midC, r_soln_c[s][1])) + VectorAlgebra.normsq(VectorAlgebra.subtract(lastN, r_soln_n[s][2]));
            if (checkSum < lowestSum) {
                lowestSum = checkSum;
                unperturbed = s;
            }
            solns[s][0] = new RigidBodyMotion(firstCA, rm1, firstCA);
            solns[s][1] = new RigidBodyMotion(lastCA, rm2, lastCA);
        }
        if (numSoln > 0) {
            solns[unperturbed] = solns[0];
        } else {
            solns = new RigidBodyMotion[1][2];
        }
        solns[0] = new RigidBodyMotion[2];
        solns[0][0] = new RigidBodyMotion(new double[3], RotationMatrix.identity(), new double[3]);
        solns[0][1] = new RigidBodyMotion(new double[3], RotationMatrix.identity(), new double[3]);
        return solns;
    }

    private String hashStartingCoords() {
        Object ans = "";
        for (int resNum = 0; resNum < 3; ++resNum) {
            for (String atomName : new String[]{"N", "CA", "C"}) {
                double[] coords = ((Residue)this.resDirectlyAffected.get(resNum)).getCoordsByAtomName(atomName);
                for (int dim = 0; dim < 3; ++dim) {
                    ans = (String)ans + "|" + String.valueOf(coords[dim]);
                }
            }
        }
        return ans;
    }

    @Override
    public Perturbation copyForNewMolecule(Molecule mol, PerturbationBlock block) {
        LoopClosureAdjustment lca = new LoopClosureAdjustment(Residue.equivalentInMolec(this.resDirectlyAffected, mol));
        lca.curParamVal = this.curParamVal;
        lca.indexInBlock = this.indexInBlock;
        lca.block = block;
        for (ConfProblem cp : this.problems) {
            lca.problems.add(new ConfProblem(lca, cp.getBrokenResidue().equivalentInMolec(mol)));
        }
        this.solnCache = (HashMap)ObjectIO.deepCopy(this.solnCache);
        return lca;
    }
}

