/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.dof.deeper.perts;

import edu.duke.cs.osprey.control.EnvironmentVars;
import edu.duke.cs.osprey.dof.DOFBlock;
import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.dof.deeper.GenChi1Calc;
import edu.duke.cs.osprey.dof.deeper.ResBBState;
import edu.duke.cs.osprey.dof.deeper.SidechainIdealizer;
import edu.duke.cs.osprey.dof.deeper.perts.Perturbation;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.Residue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.TreeSet;

public class PerturbationBlock
implements Serializable,
DOFBlock {
    ArrayList<Perturbation> perts;
    ArrayList<LinkedHashMap<Residue, ResBBState>> prePertBBStates;
    ArrayList<ArrayList<Perturbation>> successors;
    ArrayList<ArrayList<Residue>> dependentResidues;
    ArrayList<Residue> allResidues;

    public PerturbationBlock() {
    }

    public PerturbationBlock(ArrayList<Perturbation> perts) {
        this.perts = perts;
        this.prePertBBStates = new ArrayList();
        int pertNum = 0;
        while (pertNum < perts.size()) {
            Perturbation pert = perts.get(pertNum);
            pert.block = this;
            pert.indexInBlock = pertNum++;
            this.prePertBBStates.add(new LinkedHashMap());
        }
        this.computeSuccessors();
        this.computeDependentResidues();
        this.initPrePertStates();
        for (Residue res : this.allResidues) {
            double chi1 = GenChi1Calc.getGenChi1(res);
            SidechainIdealizer.idealizeSidechain(EnvironmentVars.resTemplates, res);
            GenChi1Calc.setGenChi1(res, chi1);
        }
    }

    void updateSuccessorPrePertStates(int indexInBlock) {
        for (Residue res : this.dependentResidues.get(indexInBlock)) {
            ResBBState state = new ResBBState(res);
            for (int index = indexInBlock + 1; index < this.perts.size(); ++index) {
                this.prePertBBStates.get(index).put(res, state);
            }
        }
    }

    private void initPrePertStates() {
        for (Residue res : this.allResidues) {
            ResBBState state = new ResBBState(res);
            for (int index = 0; index < this.perts.size(); ++index) {
                this.prePertBBStates.get(index).put(res, state);
            }
        }
    }

    private void computeSuccessors() {
        int pertNum;
        this.successors = new ArrayList();
        for (pertNum = 0; pertNum < this.perts.size(); ++pertNum) {
            this.successors.add(new ArrayList());
        }
        for (pertNum = this.perts.size() - 1; pertNum >= 0; --pertNum) {
            TreeSet<Integer> successorIndices = new TreeSet<Integer>();
            for (int pert2 = pertNum + 1; pert2 < this.perts.size(); ++pert2) {
                if (!this.perturbationsOverlap(pertNum, pert2)) continue;
                successorIndices.add(pert2);
                for (Perturbation pert2Successor : this.successors.get(pert2)) {
                    successorIndices.add(pert2Successor.indexInBlock);
                }
            }
            Iterator iterator2 = successorIndices.iterator();
            while (iterator2.hasNext()) {
                int ind = (Integer)iterator2.next();
                this.successors.get(pertNum).add(this.perts.get(ind));
            }
        }
    }

    private void computeDependentResidues() {
        this.dependentResidues = new ArrayList();
        LinkedHashSet allRes = new LinkedHashSet();
        for (int pertNum = 0; pertNum < this.perts.size(); ++pertNum) {
            Perturbation pert = this.perts.get(pertNum);
            LinkedHashSet<Residue> pertDep = new LinkedHashSet<Residue>();
            for (Residue res : pert.resDirectlyAffected) {
                pertDep.add(res);
            }
            for (Perturbation successor : this.successors.get(pertNum)) {
                for (Residue res : successor.resDirectlyAffected) {
                    pertDep.add(res);
                }
            }
            this.dependentResidues.add(new ArrayList(pertDep));
            allRes.addAll(pertDep);
        }
        this.allResidues = new ArrayList(allRes);
    }

    private boolean perturbationsOverlap(int index1, int index2) {
        for (Residue res1 : this.perts.get((int)index1).resDirectlyAffected) {
            for (Residue res2 : this.perts.get((int)index2).resDirectlyAffected) {
                if (res1 != res2) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public DOFBlock copyForNewMolecule(Molecule mol, LinkedHashMap<DegreeOfFreedom, DegreeOfFreedom> copiedDOFMap) {
        PerturbationBlock copiedBlock = new PerturbationBlock();
        copiedBlock.perts = new ArrayList();
        for (Perturbation perturbation : this.perts) {
            Perturbation copiedPert = perturbation.copyForNewMolecule(mol, copiedBlock);
            copiedDOFMap.put(perturbation, copiedPert);
            copiedBlock.perts.add(copiedPert);
        }
        copiedBlock.prePertBBStates = new ArrayList();
        for (LinkedHashMap linkedHashMap : this.prePertBBStates) {
            LinkedHashMap<Residue, ResBBState> copiedBBMap = new LinkedHashMap<Residue, ResBBState>();
            for (Residue res : linkedHashMap.keySet()) {
                Residue otherRes = res.equivalentInMolec(mol);
                copiedBBMap.put(otherRes, new ResBBState((ResBBState)linkedHashMap.get(res)));
            }
            copiedBlock.prePertBBStates.add(copiedBBMap);
        }
        copiedBlock.successors = new ArrayList();
        for (ArrayList arrayList : this.successors) {
            ArrayList<Perturbation> copiedSucc = new ArrayList<Perturbation>();
            for (Perturbation pert : arrayList) {
                copiedSucc.add((Perturbation)copiedDOFMap.get(pert));
            }
            copiedBlock.successors.add(copiedSucc);
        }
        copiedBlock.dependentResidues = new ArrayList();
        for (ArrayList arrayList : this.dependentResidues) {
            copiedBlock.dependentResidues.add(Residue.equivalentInMolec(arrayList, mol));
        }
        copiedBlock.allResidues = Residue.equivalentInMolec(this.allResidues, mol);
        return copiedBlock;
    }

    public ArrayList<Perturbation> getPerts() {
        return this.perts;
    }
}

