/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.ematrix;

import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.confspace.compiled.ConfSpace;
import edu.duke.cs.osprey.ematrix.SimplerEnergyMatrixCalculator;
import edu.duke.cs.osprey.energy.ConfEnergyCalculator;
import edu.duke.cs.osprey.energy.EnergyCalculator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SimpleReferenceEnergies
implements Serializable {
    private Map<String, Double> energies = new HashMap<String, Double>();

    public Double get(int pos, String resType) {
        return this.energies.get(this.makeKey(pos, resType));
    }

    public void set(int pos, String resType, double val) {
        this.energies.put(this.makeKey(pos, resType), val);
    }

    private String makeKey(int pos, String resType) {
        return pos + "-" + resType;
    }

    public double getOffset(SimpleConfSpace confSpace, int pos, int rc) {
        String resType = confSpace.positions.get((int)pos).resConfs.get((int)rc).template.name;
        return this.getOffset(pos, resType);
    }

    public double getOffset(int pos, String resType) {
        double energy = this.get(pos, resType);
        if (Double.isFinite(energy)) {
            return -energy;
        }
        return Double.POSITIVE_INFINITY;
    }

    public boolean equals(Object other) {
        return other instanceof SimpleReferenceEnergies && this.equals((SimpleReferenceEnergies)other);
    }

    public boolean equals(SimpleReferenceEnergies other) {
        return this.energies.equals(other.energies);
    }

    public int hashCode() {
        return this.energies.hashCode();
    }

    public String toString(ConfSpace confSpace) {
        StringBuilder buf = new StringBuilder();
        buf.append("Reference Energies:\n");
        for (ConfSpace.Pos pos : confSpace.positions) {
            List types2 = Arrays.stream(pos.confs).map(conf -> confSpace.confType(pos.index, conf.index)).collect(Collectors.toSet()).stream().sorted().collect(Collectors.toList());
            for (String type : types2) {
                buf.append(String.format("\tpos=%2d, type=%3s: %f\n", pos.index, type, this.get(pos.index, type)));
            }
        }
        return buf.toString();
    }

    public static class Builder {
        private SimpleConfSpace confSpace;
        private EnergyCalculator ecalc;
        private boolean addResEntropy = false;

        public Builder(SimpleConfSpace confSpace, EnergyCalculator ecalc) {
            this.confSpace = confSpace;
            this.ecalc = ecalc;
        }

        public Builder addResEntropy(boolean val) {
            this.addResEntropy = val;
            return this;
        }

        public SimpleReferenceEnergies build() {
            ConfEnergyCalculator confEcalc = new ConfEnergyCalculator.Builder(this.confSpace, this.ecalc).addResEntropy(this.addResEntropy).build();
            return new SimplerEnergyMatrixCalculator.Builder(confEcalc).build().calcReferenceEnergies();
        }
    }
}

