/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.ematrix.epic;

import edu.duke.cs.osprey.control.ParamSet;
import java.io.Serializable;

public class EPICSettings
implements Serializable {
    boolean useEPIC;
    double EPICThresh1 = 10.0;
    public double EPICThresh2 = 25.0;
    public double EPICGoalResid = 1.0E-4;
    boolean useSAPE = true;
    boolean usePC = true;
    public boolean quadOnly = false;
    public boolean minPartialConfs = true;
    public boolean useEPICPruning = true;

    public EPICSettings() {
        this.useEPIC = false;
    }

    public EPICSettings(ParamSet params) {
        this.useEPIC = params.getBool("USEEPIC");
        this.EPICThresh1 = params.getDouble("EPICTHRESH1");
        this.EPICThresh2 = params.getDouble("EPICTHRESH2");
        this.EPICGoalResid = params.getDouble("EPICGOALRESID");
        this.useSAPE = params.getBool("USESAPE");
        this.usePC = params.getBool("EPICUSEPC");
        this.minPartialConfs = params.getBool("MINPARTIALCONFS");
        this.quadOnly = params.getBool("EPICQUADONLY");
        this.useEPICPruning = params.getBool("USEEPICPRUNING");
        if (this.EPICThresh2 < this.EPICThresh1) {
            throw new RuntimeException("ERROR: EPICThresh2 must be at least EPICThresh1!  EPICThresh2=" + this.EPICThresh2 + " EPICThresh1=" + this.EPICThresh1);
        }
    }

    public boolean shouldWeUseEPIC() {
        return this.useEPIC;
    }

    public static EPICSettings defaultEPIC() {
        EPICSettings ans = new EPICSettings();
        ans.useEPIC = true;
        return ans;
    }
}

