/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.ematrix.epic;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.EigenvalueDecomposition;
import edu.duke.cs.osprey.ematrix.epic.EPoly;
import edu.duke.cs.osprey.ematrix.epic.SeriesFitter;

public class EPolyPC
extends EPoly {
    int fullOrder;
    int PCOrder;
    boolean[] isPC;
    DoubleMatrix2D axisCoeffs;
    DoubleMatrix2D invAxisCoeffs;

    public EPolyPC(EPoly template, int fullOrder, int PCOrder, double PCFac) {
        super(template.numDOFs, template.DOFmax, template.DOFmin, template.center, template.minE, null, fullOrder, template.DOFNames);
        int n;
        DoubleMatrix2D eigVecs;
        DoubleMatrix2D hess = SeriesFitter.getHessian(template.coeffs, this.numDOFs, false);
        EigenvalueDecomposition edec = new EigenvalueDecomposition(hess);
        DoubleMatrix1D eigVals = edec.getRealEigenvalues();
        this.invAxisCoeffs = eigVecs = edec.getV();
        this.axisCoeffs = Algebra.DEFAULT.transpose(eigVecs);
        this.fullOrder = fullOrder;
        this.PCOrder = PCOrder;
        double maxEigVal = 0.0;
        for (n = 0; n < this.numDOFs; ++n) {
            maxEigVal = Math.max(Math.abs(eigVals.get(n)), maxEigVal);
        }
        this.isPC = new boolean[this.numDOFs];
        for (n = 0; n < this.numDOFs; ++n) {
            if (!(Math.abs(eigVals.get(n)) >= maxEigVal * PCFac)) continue;
            this.isPC[n] = true;
        }
    }

    @Override
    double evalSeries(DoubleMatrix1D z) {
        DoubleMatrix1D y = this.toPCBasis(z);
        return SeriesFitter.evalSeries(this.coeffs, y, this.numDOFs, false, this.fullOrder, this.PCOrder, this.isPC);
    }

    DoubleMatrix1D toPCBasis(DoubleMatrix1D z) {
        return this.axisCoeffs.zMult(z, DoubleFactory1D.dense.make(this.numDOFs));
    }
}

