/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy;

import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.energy.EnergyFunction;
import edu.duke.cs.osprey.energy.forcefield.ResPairEnergy;
import edu.duke.cs.osprey.energy.forcefield.SingleResEnergy;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.Residue;
import java.util.ArrayList;
import java.util.List;

public class MultiTermEnergyFunction
implements EnergyFunction.DecomposableByDof {
    private static final long serialVersionUID = -3516267414126293331L;
    private static int NUM_THREADS = 1;
    ArrayList<EnergyFunction> terms = new ArrayList();
    ArrayList<Double> coeffs = new ArrayList();
    ArrayList<Double> partialE = new ArrayList();
    ArrayList<Integer> indexes = new ArrayList();
    double preCompE = 0.0;

    public void addTerm(EnergyFunction ef) {
        this.terms.add(ef);
        this.coeffs.add(1.0);
        this.partialE.add(0.0);
        this.indexes.add(this.indexes.size());
    }

    public void addTermWithCoeff(EnergyFunction ef, double coeff) {
        this.terms.add(ef);
        this.coeffs.add(coeff);
        this.partialE.add(0.0);
        this.indexes.add(this.indexes.size());
    }

    public static void setNumThreads(int threads) {
        NUM_THREADS = threads;
        if (NUM_THREADS < 1) {
            NUM_THREADS = 1;
        } else if (NUM_THREADS > Runtime.getRuntime().availableProcessors()) {
            NUM_THREADS = Runtime.getRuntime().availableProcessors();
        }
        if (NUM_THREADS > 1) {
            System.out.println("\n\nWARNING (for Osprey programmers): energy function-level parallelism probably isn't the fastest tool anymore. Try the new parallel SimpleEnergyMatrixCalculator and parallel/gpu-friendly ConfMinimizer classes instead.\n");
        }
    }

    public static int getNumThreads() {
        return NUM_THREADS;
    }

    @Override
    public double getEnergy() {
        double E = 0.0;
        if (this.terms.size() != this.coeffs.size()) {
            throw new RuntimeException("ERROR: MultiTermEnergyFunction has " + this.terms.size() + " terms but " + this.coeffs.size() + " coefficients");
        }
        if (NUM_THREADS == 1) {
            for (int termNum = 0; termNum < this.terms.size(); ++termNum) {
                double termE = this.terms.get(termNum).getEnergy();
                E += this.coeffs.get(termNum) * termE;
            }
        } else {
            this.indexes.parallelStream().forEach(term -> this.partialE.set((int)term, this.terms.get((int)term).getEnergy() * this.coeffs.get((int)term)));
            for (int term2 = 0; term2 < this.indexes.size(); ++term2) {
                E += this.partialE.get(term2).doubleValue();
            }
        }
        if (Double.isNaN(E) || Double.isInfinite(E)) {
            return Double.POSITIVE_INFINITY;
        }
        this.preCompE = E;
        return this.preCompE;
    }

    public ArrayList<EnergyFunction> getTerms() {
        return this.terms;
    }

    public ArrayList<Double> getCoeffs() {
        return this.coeffs;
    }

    @Override
    public List<EnergyFunction> decomposeByDof(Molecule m, List<DegreeOfFreedom> dofs) {
        ArrayList<EnergyFunction> dofEfuncs = new ArrayList<EnergyFunction>();
        for (DegreeOfFreedom dof : dofs) {
            if (dof.getResidue() == null) {
                dofEfuncs.add(this);
                continue;
            }
            dofEfuncs.add(this.makeResidueEfunc(dof.getResidue()));
        }
        return dofEfuncs;
    }

    private EnergyFunction makeResidueEfunc(Residue residue) {
        MultiTermEnergyFunction resEfunc = new MultiTermEnergyFunction();
        for (EnergyFunction term : this.terms) {
            if (term instanceof SingleResEnergy) {
                SingleResEnergy singleResTerm = (SingleResEnergy)term;
                if (singleResTerm.getRes() != residue) continue;
                resEfunc.addTerm(singleResTerm);
                continue;
            }
            if (term instanceof ResPairEnergy) {
                ResPairEnergy resPairTerm = (ResPairEnergy)term;
                if (resPairTerm.getRes1() != residue && resPairTerm.getRes2() != residue) continue;
                resEfunc.addTerm(resPairTerm);
                continue;
            }
            resEfunc.addTerm(term);
        }
        return resEfunc;
    }

    public double getPreCompE() {
        return this.preCompE;
    }

    public void setPreCompE(double in) {
        this.preCompE = in;
    }
}

