/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy;

import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.energy.ResidueInteractions;
import java.util.ArrayList;

public class ResInterGen {
    private final SimpleConfSpace confSpace;
    private final ResidueInteractions inters;

    public static ResInterGen of(SimpleConfSpace confSpace) {
        return new ResInterGen(confSpace);
    }

    private ResInterGen(SimpleConfSpace confSpace) {
        this.confSpace = confSpace;
        this.inters = new ResidueInteractions();
    }

    public ResidueInteractions make() {
        return this.inters;
    }

    public String getResNum(int pos) {
        return this.confSpace.positions.get((int)pos).resNum;
    }

    public ResInterGen addIntra(int pos) {
        return this.addIntra(pos, 1.0, 0.0);
    }

    public ResInterGen addIntra(int pos, double weight, double offset) {
        this.inters.addSingle(this.getResNum(pos), weight, offset);
        return this;
    }

    public ResInterGen addIntras(RCTuple frag) {
        return this.addIntras(frag, 1.0, (pos, rc) -> 0.0);
    }

    public ResInterGen addIntras(RCTuple frag, double weight, IntraOffsetter offsetter) {
        for (int i = 0; i < frag.size(); ++i) {
            int pos = frag.pos.get(i);
            int rc = frag.RCs.get(i);
            this.inters.addSingle(this.getResNum(pos), weight, offsetter.makeOffset(pos, rc));
        }
        return this;
    }

    public ResInterGen addInter(int pos1, int pos2) {
        return this.addInter(pos1, pos2, 1.0, 0.0);
    }

    public ResInterGen addInter(int pos1, int pos2, double weight, double offset) {
        this.inters.addPair(this.getResNum(pos1), this.getResNum(pos2), weight, offset);
        return this;
    }

    public ResInterGen addInters(RCTuple frag) {
        return this.addInters(frag, 1.0, (pos1, rc1, pos2, rc2) -> 0.0);
    }

    public ResInterGen addInters(RCTuple frag, double weight, InterOffsetter offsetter) {
        for (int i = 0; i < frag.size(); ++i) {
            int pos1 = frag.pos.get(i);
            int rc1 = frag.RCs.get(i);
            String resNum1 = this.getResNum(pos1);
            for (int j = 0; j < i; ++j) {
                int pos2 = frag.pos.get(j);
                int rc2 = frag.RCs.get(j);
                String resNum2 = this.getResNum(pos2);
                this.inters.addPair(resNum1, resNum2, weight, offsetter.makeOffset(pos1, rc1, pos2, rc2));
            }
        }
        return this;
    }

    public ResInterGen addShell(int pos) {
        return this.addShell(pos, 1.0, 0.0);
    }

    public ResInterGen addShell(int pos, double weight, double offset) {
        String resNum = this.getResNum(pos);
        for (String resNumShell : this.confSpace.shellResNumbers) {
            this.inters.addPair(resNum, resNumShell, weight, offset);
        }
        return this;
    }

    public ResInterGen addShell(RCTuple frag) {
        return this.addShell(frag, 1.0, (pos, rc, shellResNum) -> 0.0);
    }

    public ResInterGen addShell(RCTuple frag, double weight, ShellOffsetter offsetter) {
        for (int i = 0; i < frag.size(); ++i) {
            int pos = frag.pos.get(i);
            int rc = frag.RCs.get(i);
            String resNum = this.getResNum(pos);
            for (String shellResNum : this.confSpace.shellResNumbers) {
                this.inters.addPair(resNum, shellResNum, weight, offsetter.makeOffset(pos, rc, shellResNum));
            }
        }
        return this;
    }

    public ResInterGen addShellIntras() {
        ArrayList<String> resNumbers = new ArrayList<String>(this.confSpace.shellResNumbers);
        for (String resNumber : resNumbers) {
            this.inters.addSingle(resNumber);
        }
        return this;
    }

    public ResInterGen addShellInters() {
        ArrayList<String> resNumbers = new ArrayList<String>(this.confSpace.shellResNumbers);
        for (int i = 0; i < resNumbers.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                this.inters.addPair(resNumbers.get(i), resNumbers.get(j));
            }
        }
        return this;
    }

    public ResInterGen addAll(RCTuple frag) {
        return this.addIntras(frag).addInters(frag).addShell(frag).addShellIntras().addShellInters();
    }

    public static interface IntraOffsetter {
        public double makeOffset(int var1, int var2);
    }

    public static interface InterOffsetter {
        public double makeOffset(int var1, int var2, int var3, int var4);
    }

    public static interface ShellOffsetter {
        public double makeOffset(int var1, int var2, String var3);
    }
}

