/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy.compiled;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import edu.duke.cs.osprey.confspace.compiled.AssignedCoords;
import edu.duke.cs.osprey.confspace.compiled.ConfSpace;
import edu.duke.cs.osprey.confspace.compiled.ContinuousMotion;
import edu.duke.cs.osprey.confspace.compiled.PosInter;
import edu.duke.cs.osprey.confspace.compiled.motions.DihedralAngle;
import edu.duke.cs.osprey.confspace.compiled.motions.TranslationRotation;
import edu.duke.cs.osprey.energy.compiled.AmberEnergyCalculator;
import edu.duke.cs.osprey.energy.compiled.ConfEnergyCalculator;
import edu.duke.cs.osprey.energy.compiled.EEF1EnergyCalculator;
import edu.duke.cs.osprey.energy.compiled.EnergyCalculator;
import edu.duke.cs.osprey.gpu.MemoryBuffer;
import edu.duke.cs.osprey.gpu.Precision;
import edu.duke.cs.osprey.gpu.Structs;
import edu.duke.cs.osprey.parallelism.Parallelism;
import edu.duke.cs.osprey.tools.Log;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CudaConfEnergyCalculator
implements ConfEnergyCalculator {
    private static final SArray arrayStruct = new SArray().init();
    static final SGpuInfo gpuInfoStruct = new SGpuInfo().init();
    private static final long WidestGpuLoad = 16L;
    public final ConfSpace confSpace;
    public final Precision precision;
    public final List<GpuStreams> gpuStreams;
    public final long maxBatchSize;
    public final ForcefieldsImpl forcefieldsImpl;
    private File dumpJobsTo = null;
    private final MemoryBuffer confSpaceBuf;
    private final Map<GpuInfo, Pointer> pConfSpace = new HashMap<GpuInfo, Pointer>();
    private final MemoryBuffer confSpaceSizesMem;
    private final ByteBuffer confSpaceSizesBuf;
    private final SConfSpace confSpaceStruct = new SConfSpace();
    private static final SConfSpaceSizes confSpaceSizesStruct = new SConfSpaceSizes().init();
    private final SPos posStruct = new SPos();
    private final SConf confStruct = new SConf();
    private final SReal3 real3Struct = new SReal3();
    private final SPosInter posInterStruct = new SPosInter();
    private final SDihedral dihedralStruct = new SDihedral();
    private static final int dihedralId = 0;
    private final STranslationRotation transRotStruct = new STranslationRotation();
    private static final int transRotId = 1;
    private final List<Stream> streams = new ArrayList<Stream>();
    private final BlockingQueue<Stream> streamQueue;

    public static List<GpuInfo> getGpusInfos() {
        if (!CudaConfEnergyCalculator.isSupported()) {
            return Collections.emptyList();
        }
        Pointer pArray = NativeLib.alloc_gpu_infos();
        try {
            ArrayList<GpuInfo> arrayList;
            block11: {
                int size = (int)pArray.getLong(0L);
                ByteBuffer buf = pArray.getByteBuffer(0L, arrayStruct.bytes(size, gpuInfoStruct.bytes()));
                ArrayList<GpuInfo> infos2 = new ArrayList<GpuInfo>(size);
                MemoryBuffer mem = MemoryBuffer.ofByteBuffer(buf);
                try {
                    MemoryBuffer p = CudaConfEnergyCalculator.getArrayAddress(mem);
                    Structs.Char8.Array charsBusId = Structs.char8array();
                    Structs.Char8.Array charsName = Structs.char8array();
                    for (int device = 0; device < size; ++device) {
                        infos2.add(new GpuInfo(device, charsBusId.getNullTerminated(p.sliceFrom(CudaConfEnergyCalculator.gpuInfoStruct.bus_id.offset()), (int)CudaConfEnergyCalculator.gpuInfoStruct.bus_id.bytes), charsName.getNullTerminated(p.sliceFrom(CudaConfEnergyCalculator.gpuInfoStruct.name.offset()), (int)CudaConfEnergyCalculator.gpuInfoStruct.name.bytes), CudaConfEnergyCalculator.gpuInfoStruct.integrated.get(p) != 0, CudaConfEnergyCalculator.gpuInfoStruct.concurrent_kernels.get(p) != 0, CudaConfEnergyCalculator.gpuInfoStruct.num_processors.get(p), CudaConfEnergyCalculator.gpuInfoStruct.num_async_engines.get(p), CudaConfEnergyCalculator.gpuInfoStruct.mem_total.get(p), CudaConfEnergyCalculator.gpuInfoStruct.mem_free.get(p)));
                        p = p.sliceFrom(gpuInfoStruct.bytes());
                    }
                    arrayList = infos2;
                    if (mem == null) break block11;
                }
                catch (Throwable throwable) {
                    if (mem != null) {
                        try {
                            mem.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                mem.close();
            }
            return arrayList;
        }
        finally {
            NativeLib.free_gpu_infos(pArray);
        }
    }

    private static long padToGpuAlignment(long pos) {
        return MemoryBuffer.padToAlignment(pos, 16L);
    }

    public static boolean isSupported() {
        return NativeLib.cuda_version_driver() > 0 && NativeLib.cuda_version_runtime() > 0;
    }

    public static void checkSupported() {
        Function<Integer, String> versionString = v -> String.format("%d.%d", v / 1000, v % 1000 / 10);
        int vDriver = NativeLib.cuda_version_driver();
        int vRequired = NativeLib.cuda_version_required();
        int vRuntime = NativeLib.cuda_version_runtime();
        if (vDriver <= 0) {
            throw new RuntimeException("No CUDA driver installed");
        }
        switch (vRuntime) {
            case -1: {
                throw new RuntimeException("CUDA driver is insufficient. Driver supports CUDA " + versionString.apply(vDriver) + ", but CUDA " + versionString.apply(vRequired) + " is needed.");
            }
            case -2: {
                throw new RuntimeException("No CUDA device. Does this machine have an Nvidia GPU?");
            }
            case -3: {
                throw new RuntimeException("CUDA failed to initialize");
            }
            case -4: {
                throw new RuntimeException("This error indicates that the system was upgraded to run with forward compatibility, but the visible hardware detected by CUDA does not support this configuration. Refer to the compatibility documentation for the supported hardware matrix or ensure that only supported hardware is visible during initialization via the CUDA_VISIBLE_DEVICES environment variable.");
            }
            case -2147483648: {
                throw new RuntimeException("Unrecognized error");
            }
        }
    }

    public CudaConfEnergyCalculator dumpJobsTo(File file) {
        this.dumpJobsTo = file;
        return this;
    }

    public CudaConfEnergyCalculator(ConfSpace confSpace, Precision precision) {
        this(confSpace, precision, CudaConfEnergyCalculator.getGpusInfos());
    }

    public CudaConfEnergyCalculator(ConfSpace confSpace, Precision precision, Parallelism parallelism) {
        this(confSpace, precision, CudaConfEnergyCalculator.getGpus(parallelism.numGpus));
    }

    private static List<GpuInfo> getGpus(int num) {
        List<GpuInfo> infos2 = CudaConfEnergyCalculator.getGpusInfos();
        if (num > infos2.size()) {
            Log.log("WARN: tried to pick %d GPU(s), but only %d GPU(s) were available", num, infos2.size());
            num = infos2.size();
        }
        return infos2.subList(0, num);
    }

    public CudaConfEnergyCalculator(ConfSpace confSpace, Precision precision, List<GpuInfo> gpus) {
        this(confSpace, precision, gpus.stream().map(gpu -> new GpuStreams((GpuInfo)gpu, gpu.bestNumStreams())).collect(Collectors.toList()), gpus.stream().mapToInt(gpu -> gpu.bestBatchSize()).max().orElse(Integer.MAX_VALUE));
    }

    public CudaConfEnergyCalculator(ConfSpace confSpace, Precision precision, List<GpuStreams> gpuStreams, long maxBatchSize) {
        class StreamsLeft {
            final GpuInfo gpuInfo;
            int numStreams;

            StreamsLeft(CudaConfEnergyCalculator this$0, GpuStreams gpuStreams) {
                this.gpuInfo = gpuStreams.gpuInfo;
                this.numStreams = gpuStreams.numStreams;
            }
        }
        MemoryBuffer fragOffsetsAddr;
        int posi1;
        int fragi1;
        int posi12;
        CudaConfEnergyCalculator.checkSupported();
        if (gpuStreams == null || gpuStreams.isEmpty()) {
            throw new IllegalArgumentException("0 GPUs selected");
        }
        this.confSpace = confSpace;
        this.precision = precision;
        this.gpuStreams = gpuStreams;
        this.maxBatchSize = maxBatchSize;
        EnergyCalculator.Type[] ecalcTypes = (EnergyCalculator.Type[])Arrays.stream(confSpace.ecalcs).map(EnergyCalculator::type).toArray(EnergyCalculator.Type[]::new);
        if (ecalcTypes.length != 2 || ecalcTypes[0] != AmberEnergyCalculator.type || ecalcTypes[1] != EEF1EnergyCalculator.type) {
            throw new IllegalArgumentException("No native implementation for forcefields: " + Arrays.toString((Object[])ecalcTypes));
        }
        this.forcefieldsImpl = new AmberEef1();
        this.confSpaceStruct.init();
        this.posStruct.init();
        this.confStruct.init();
        this.real3Struct.init();
        this.posInterStruct.init();
        this.dihedralStruct.init();
        this.transRotStruct.init();
        Structs.Int64.Array posOffsets = Structs.int64array();
        Structs.Int64.Array confOffsets = Structs.int64array();
        Structs.Int64.Array posPairOffsets = Structs.int64array();
        Structs.Int64.Array fragOffsets = Structs.int64array();
        Structs.Int64.Array molMotionOffsets = Structs.int64array();
        Structs.Int64.Array confMotionOffsets = Structs.int64array();
        long motionIdBytes = 8L;
        long confSpaceSize = this.confSpaceStruct.bytes() + CudaConfEnergyCalculator.padToGpuAlignment(posOffsets.bytes(confSpace.positions.length));
        long positionsSize = Structs.sum(confSpace.positions, pos -> this.posStruct.bytes() + CudaConfEnergyCalculator.padToGpuAlignment(confOffsets.bytes(pos.confs.length)) + Structs.sum(pos.confs, conf -> this.confStruct.bytes() + arrayStruct.bytes(conf.coords.size, this.real3Struct.bytes()) + arrayStruct.bytes(conf.coords.size, 4L) + CudaConfEnergyCalculator.padToGpuAlignment(confMotionOffsets.bytes(conf.motions.length)) + Structs.sum(conf.motions, motion -> {
            if (motion instanceof DihedralAngle.Description) {
                DihedralAngle.Description dihedral = (DihedralAngle.Description)motion;
                return this.dihedralStruct.bytes(dihedral.rotated.length);
            }
            throw new UnsupportedOperationException(motion.getClass().getName());
        })));
        long staticCoordsSize = arrayStruct.bytes(confSpace.staticCoords.size, this.real3Struct.bytes()) + arrayStruct.bytes(confSpace.staticCoords.size, 4L);
        long forcefieldSize = this.forcefieldsImpl.paramsBytes();
        int numPosPairs = 1 + confSpace.numPos() + confSpace.numPos() + confSpace.numPos() * (confSpace.numPos() - 1) / 2;
        forcefieldSize += CudaConfEnergyCalculator.padToGpuAlignment(posPairOffsets.bytes(numPosPairs));
        forcefieldSize += this.forcefieldsImpl.staticStaticBytes();
        for (posi12 = 0; posi12 < confSpace.positions.length; ++posi12) {
            forcefieldSize += CudaConfEnergyCalculator.padToGpuAlignment(fragOffsets.itemBytes * (long)confSpace.numFrag(posi12));
            for (fragi1 = 0; fragi1 < confSpace.numFrag(posi12); ++fragi1) {
                forcefieldSize += this.forcefieldsImpl.staticPosBytes(posi12, fragi1);
            }
        }
        for (posi12 = 0; posi12 < confSpace.positions.length; ++posi12) {
            forcefieldSize += CudaConfEnergyCalculator.padToGpuAlignment(fragOffsets.itemBytes * (long)confSpace.numFrag(posi12));
            for (fragi1 = 0; fragi1 < confSpace.numFrag(posi12); ++fragi1) {
                forcefieldSize += this.forcefieldsImpl.posBytes(posi12, fragi1);
            }
        }
        for (posi12 = 0; posi12 < confSpace.positions.length; ++posi12) {
            for (int posi2 = 0; posi2 < posi12; ++posi2) {
                forcefieldSize += CudaConfEnergyCalculator.padToGpuAlignment(fragOffsets.itemBytes * (long)confSpace.numFrag(posi12) * (long)confSpace.numFrag(posi2));
                for (int fragi12 = 0; fragi12 < confSpace.numFrag(posi12); ++fragi12) {
                    for (int fragi2 = 0; fragi2 < confSpace.numFrag(posi2); ++fragi2) {
                        forcefieldSize += this.forcefieldsImpl.posPosBytes(posi12, fragi12, posi2, fragi2);
                    }
                }
            }
        }
        long molMotionsSize = 0L;
        int numMolMotions = 0;
        for (int moli = 0; moli < confSpace.molInfos.length; ++moli) {
            ConfSpace.MolInfo molInfo = confSpace.molInfos[moli];
            for (ContinuousMotion.MolDescription motion : molInfo.motions) {
                ++numMolMotions;
                if (motion instanceof DihedralAngle.Description) {
                    DihedralAngle.Description dihedral = (DihedralAngle.Description)motion;
                    molMotionsSize += this.dihedralStruct.bytes(dihedral.rotated.length);
                    continue;
                }
                if (motion instanceof TranslationRotation.Description) {
                    molMotionsSize += this.transRotStruct.bytes();
                    continue;
                }
                throw new UnsupportedOperationException(motion.getClass().getName());
            }
        }
        long bufSize = confSpaceSize + positionsSize + staticCoordsSize + forcefieldSize + (molMotionsSize += molMotionOffsets.bytes(numMolMotions));
        this.confSpaceBuf = new MemoryBuffer(bufSize);
        assert (this.confSpaceBuf.isAligned(16L));
        MemoryBuffer confSpaceAddr = this.confSpaceBuf.place(this.confSpaceStruct);
        this.confSpaceStruct.num_pos.set(confSpaceAddr, confSpace.positions.length);
        this.confSpaceStruct.max_num_conf_atoms.set(confSpaceAddr, confSpace.maxNumConfAtoms);
        this.confSpaceStruct.max_num_dofs.set(confSpaceAddr, confSpace.maxNumDofs);
        this.confSpaceStruct.num_molecule_motions.set(confSpaceAddr, numMolMotions);
        this.confSpaceStruct.size.set(confSpaceAddr, bufSize);
        this.confSpaceStruct.static_energy.set(confSpaceAddr, Arrays.stream(confSpace.staticEnergies).sum());
        this.confSpaceBuf.skipToAlignment(16L);
        this.confSpaceStruct.positions_offset.set(confSpaceAddr, this.confSpaceBuf.getPos());
        MemoryBuffer posOffsetsAddr = this.confSpaceBuf.place(posOffsets, confSpace.positions.length, 16L);
        assert (this.confSpaceBuf.getPos() == confSpaceSize);
        assert (this.confSpaceBuf.isAligned(16L));
        for (ConfSpace.Pos pos2 : confSpace.positions) {
            assert (this.confSpaceBuf.isAligned(16L));
            posOffsets.set(posOffsetsAddr, pos2.index, this.confSpaceBuf.getPos());
            MemoryBuffer posAddr = this.confSpaceBuf.place(this.posStruct);
            this.posStruct.num_confs.set(posAddr, pos2.confs.length);
            this.posStruct.max_num_atoms.set(posAddr, pos2.maxNumAtoms);
            this.posStruct.num_frags.set(posAddr, pos2.numFrags);
            assert (this.confSpaceBuf.isAligned(16L));
            MemoryBuffer confOffsetsAddr = this.confSpaceBuf.place(confOffsets, pos2.confs.length, 16L);
            assert (this.confSpaceBuf.isAligned(16L));
            for (ConfSpace.Conf conf : pos2.confs) {
                assert (this.confSpaceBuf.isAligned(16L));
                confOffsets.set(confOffsetsAddr, conf.index, this.confSpaceBuf.getPos());
                MemoryBuffer confAddr = this.confSpaceBuf.place(this.confStruct);
                this.confStruct.frag_index.set(confAddr, conf.fragIndex);
                this.confStruct.internal_energy.set(confAddr, Arrays.stream(conf.energies).sum());
                this.confStruct.num_motions.set(confAddr, conf.motions.length);
                this.confSpaceBuf.skipToAlignment(16L);
                this.confStruct.atom_coords_offset.set(confAddr, this.confSpaceBuf.getPos());
                MemoryBuffer atomCoordsAddr = this.confSpaceBuf.place(arrayStruct);
                CudaConfEnergyCalculator.arrayStruct.size.set(atomCoordsAddr, conf.coords.size);
                CudaConfEnergyCalculator.arrayStruct.things_ptr.set(atomCoordsAddr, 0L);
                for (int i = 0; i < conf.coords.size; ++i) {
                    MemoryBuffer addr = this.confSpaceBuf.place(this.real3Struct);
                    this.real3Struct.x.set(addr, conf.coords.x(i));
                    this.real3Struct.y.set(addr, conf.coords.y(i));
                    this.real3Struct.z.set(addr, conf.coords.z(i));
                }
                this.confSpaceBuf.skipToAlignment(16L);
                this.confStruct.atom_molis_offset.set(confAddr, this.confSpaceBuf.getPos());
                MemoryBuffer atomMolisAddr = this.confSpaceBuf.place(arrayStruct);
                CudaConfEnergyCalculator.arrayStruct.size.set(atomMolisAddr, conf.coords.size);
                CudaConfEnergyCalculator.arrayStruct.things_ptr.set(atomMolisAddr, 0L);
                for (int i = 0; i < conf.coords.size; ++i) {
                    this.confSpaceBuf.int32(conf.atomMolInfoIndices[i]);
                }
                this.confSpaceBuf.skipToAlignment(16L);
                this.confStruct.motions_offset.set(confAddr, this.confSpaceBuf.getPos());
                MemoryBuffer confMotionOffsetsAddr = this.confSpaceBuf.place(confMotionOffsets, conf.motions.length, 16L);
                for (int i = 0; i < conf.motions.length; ++i) {
                    ContinuousMotion.ConfDescription motion = conf.motions[i];
                    confMotionOffsets.set(confMotionOffsetsAddr, i, this.confSpaceBuf.getPos());
                    if (!(motion instanceof DihedralAngle.Description)) {
                        throw new UnsupportedOperationException(motion.getClass().getName());
                    }
                    this.writeDihedral((DihedralAngle.Description)motion, pos2.index, this.confSpaceBuf);
                }
                assert (this.confSpaceBuf.isAligned(16L));
            }
        }
        assert (this.confSpaceBuf.getPos() == confSpaceSize + positionsSize);
        assert (this.confSpaceBuf.isAligned(16L));
        this.confSpaceStruct.static_atom_coords_offset.set(confSpaceAddr, this.confSpaceBuf.getPos());
        MemoryBuffer atomCoordsAddr = this.confSpaceBuf.place(arrayStruct);
        CudaConfEnergyCalculator.arrayStruct.size.set(atomCoordsAddr, confSpace.staticCoords.size);
        CudaConfEnergyCalculator.arrayStruct.things_ptr.set(atomCoordsAddr, 0L);
        for (int i = 0; i < confSpace.staticCoords.size; ++i) {
            MemoryBuffer addr = this.confSpaceBuf.place(this.real3Struct);
            this.real3Struct.x.set(addr, confSpace.staticCoords.x(i));
            this.real3Struct.y.set(addr, confSpace.staticCoords.y(i));
            this.real3Struct.z.set(addr, confSpace.staticCoords.z(i));
        }
        this.confSpaceBuf.skipToAlignment(16L);
        this.confSpaceStruct.static_atom_molis_offset.set(confSpaceAddr, this.confSpaceBuf.getPos());
        MemoryBuffer atomMolisAddr = this.confSpaceBuf.place(arrayStruct);
        CudaConfEnergyCalculator.arrayStruct.size.set(atomMolisAddr, confSpace.staticCoords.size);
        CudaConfEnergyCalculator.arrayStruct.things_ptr.set(atomMolisAddr, 0L);
        for (int i = 0; i < confSpace.staticCoords.size; ++i) {
            this.confSpaceBuf.int32(confSpace.staticMolInfoIndices[i]);
        }
        this.confSpaceBuf.skipToAlignment(16L);
        assert (this.confSpaceBuf.getPos() == confSpaceSize + positionsSize + staticCoordsSize);
        assert (this.confSpaceBuf.isAligned(16L));
        this.confSpaceStruct.params_offset.set(confSpaceAddr, this.confSpaceBuf.getPos());
        this.forcefieldsImpl.writeParams(this.confSpaceBuf);
        this.confSpaceStruct.pos_pairs_offset.set(confSpaceAddr, this.confSpaceBuf.getPos());
        MemoryBuffer posPairOffsetsAddr = this.confSpaceBuf.place(posPairOffsets, numPosPairs, 16L);
        assert (this.confSpaceBuf.isAligned(16L));
        posPairOffsets.set(posPairOffsetsAddr, 0L, this.confSpaceBuf.getPos());
        this.forcefieldsImpl.writeStaticStatic(this.confSpaceBuf);
        for (posi1 = 0; posi1 < confSpace.positions.length; ++posi1) {
            posPairOffsets.set(posPairOffsetsAddr, 1 + posi1, this.confSpaceBuf.getPos());
            fragOffsetsAddr = this.confSpaceBuf.place(fragOffsets, confSpace.numFrag(posi1), 16L);
            for (int fragi13 = 0; fragi13 < confSpace.numFrag(posi1); ++fragi13) {
                fragOffsets.set(fragOffsetsAddr, fragi13, this.confSpaceBuf.getPos());
                this.forcefieldsImpl.writeStaticPos(posi1, fragi13, this.confSpaceBuf);
            }
        }
        this.confSpaceBuf.skipToAlignment(16L);
        for (posi1 = 0; posi1 < confSpace.positions.length; ++posi1) {
            posPairOffsets.set(posPairOffsetsAddr, 1 + confSpace.positions.length + posi1, this.confSpaceBuf.getPos());
            fragOffsetsAddr = this.confSpaceBuf.place(fragOffsets, confSpace.numFrag(posi1), 16L);
            for (int fragi14 = 0; fragi14 < confSpace.numFrag(posi1); ++fragi14) {
                fragOffsets.set(fragOffsetsAddr, fragi14, this.confSpaceBuf.getPos());
                this.forcefieldsImpl.writePos(posi1, fragi14, this.confSpaceBuf);
            }
        }
        this.confSpaceBuf.skipToAlignment(16L);
        for (posi1 = 0; posi1 < confSpace.positions.length; ++posi1) {
            for (int posi2 = 0; posi2 < posi1; ++posi2) {
                posPairOffsets.set(posPairOffsetsAddr, 1 + 2 * confSpace.positions.length + posi1 * (posi1 - 1) / 2 + posi2, this.confSpaceBuf.getPos());
                MemoryBuffer fragOffsetsAddr2 = this.confSpaceBuf.place(fragOffsets, confSpace.numFrag(posi1) * confSpace.numFrag(posi2), 16L);
                for (int fragi15 = 0; fragi15 < confSpace.numFrag(posi1); ++fragi15) {
                    for (int fragi2 = 0; fragi2 < confSpace.numFrag(posi2); ++fragi2) {
                        fragOffsets.set(fragOffsetsAddr2, fragi15 * confSpace.numFrag(posi2) + fragi2, this.confSpaceBuf.getPos());
                        this.forcefieldsImpl.writePosPos(posi1, fragi15, posi2, fragi2, this.confSpaceBuf);
                    }
                }
            }
        }
        assert (this.confSpaceBuf.getPos() == confSpaceSize + positionsSize + staticCoordsSize + forcefieldSize);
        this.confSpaceBuf.skipToAlignment(16L);
        this.confSpaceStruct.molecule_motions_offset.set(confSpaceAddr, this.confSpaceBuf.getPos());
        MemoryBuffer molMotionOffsetsAddr = this.confSpaceBuf.place(molMotionOffsets, numMolMotions);
        int molMotionIndex = 0;
        for (int moli = 0; moli < confSpace.molInfos.length; ++moli) {
            ConfSpace.MolInfo molInfo = confSpace.molInfos[moli];
            for (ContinuousMotion.MolDescription motion : molInfo.motions) {
                molMotionOffsets.set(molMotionOffsetsAddr, molMotionIndex++, this.confSpaceBuf.getPos());
                if (motion instanceof DihedralAngle.Description) {
                    this.writeDihedral((DihedralAngle.Description)motion, -1, this.confSpaceBuf);
                    continue;
                }
                if (motion instanceof TranslationRotation.Description) {
                    this.writeTranslationRotation((TranslationRotation.Description)motion, moli, this.confSpaceBuf);
                    continue;
                }
                throw new UnsupportedOperationException(motion.getClass().getName());
            }
        }
        assert (this.confSpaceBuf.getPos() == confSpaceSize + positionsSize + staticCoordsSize + forcefieldSize + molMotionsSize);
        assert (this.confSpaceBuf.getPos() == bufSize) : String.format("%d bytes leftover", bufSize - this.confSpaceBuf.getPos());
        ByteBuffer confSpaceBuf = this.confSpaceBuf.asByteBuffer();
        for (GpuStreams it : gpuStreams) {
            Pointer p = switch (precision) {
                default -> throw new IncompatibleClassChangeError();
                case Precision.Float32 -> NativeLib.alloc_conf_space_f32(it.gpuInfo.id, confSpaceBuf);
                case Precision.Float64 -> NativeLib.alloc_conf_space_f64(it.gpuInfo.id, confSpaceBuf);
            };
            this.pConfSpace.put(it.gpuInfo, p);
        }
        this.confSpaceSizesMem = new MemoryBuffer(confSpaceSizesStruct.bytes());
        CudaConfEnergyCalculator.confSpaceSizesStruct.num_pos.set(this.confSpaceSizesMem, confSpace.numPos());
        CudaConfEnergyCalculator.confSpaceSizesStruct.max_num_inters.set(this.confSpaceSizesMem, numPosPairs);
        CudaConfEnergyCalculator.confSpaceSizesStruct.num_atoms.set(this.confSpaceSizesMem, confSpace.maxNumConfAtoms);
        CudaConfEnergyCalculator.confSpaceSizesStruct.max_num_dofs.set(this.confSpaceSizesMem, confSpace.maxNumDofs);
        CudaConfEnergyCalculator.confSpaceSizesStruct.num_mol_motions.set(this.confSpaceSizesMem, numMolMotions);
        this.confSpaceSizesBuf = this.confSpaceSizesMem.asByteBuffer();
        List gpuStreamsLeft = gpuStreams.stream().map(x$0 -> new StreamsLeft(this, (GpuStreams)x$0)).collect(Collectors.toList());
        long hostBytes = switch (precision) {
            default -> throw new IncompatibleClassChangeError();
            case Precision.Float32 -> NativeLib.minimize_batch_bufsize_host_f32(this.confSpaceSizesMem.asByteBuffer(), maxBatchSize);
            case Precision.Float64 -> NativeLib.minimize_batch_bufsize_host_f64(this.confSpaceSizesMem.asByteBuffer(), maxBatchSize);
        };
        long deviceBytes = switch (precision) {
            default -> throw new IncompatibleClassChangeError();
            case Precision.Float32 -> NativeLib.minimize_batch_bufsize_device_f32(this.confSpaceSizesMem.asByteBuffer(), maxBatchSize);
            case Precision.Float64 -> NativeLib.minimize_batch_bufsize_device_f64(this.confSpaceSizesMem.asByteBuffer(), maxBatchSize);
        };
        int gpui = 0;
        while (true) {
            StreamsLeft hasStreams = null;
            for (int i = 0; i < gpuStreams.size() && hasStreams == null; ++i) {
                StreamsLeft it = (StreamsLeft)gpuStreamsLeft.get((gpui + i) % gpuStreams.size());
                if (it.numStreams <= 0) continue;
                hasStreams = it;
            }
            if (hasStreams == null) break;
            --hasStreams.numStreams;
            this.streams.add(new Stream(hasStreams.gpuInfo.id, this.pConfSpace.get(hasStreams.gpuInfo), hostBytes, deviceBytes));
            ++gpui;
        }
        this.streamQueue = new ArrayBlockingQueue<Stream>(this.streams.size());
        this.streamQueue.addAll(this.streams);
    }

    private void writeDihedral(DihedralAngle.Description desc, int posi, MemoryBuffer buf) {
        MemoryBuffer dihedralAddr = buf.place(this.dihedralStruct);
        this.dihedralStruct.id.set(dihedralAddr, 0L);
        this.dihedralStruct.min_radians.set(dihedralAddr, Math.toRadians(desc.minDegrees));
        this.dihedralStruct.max_radians.set(dihedralAddr, Math.toRadians(desc.maxDegrees));
        this.dihedralStruct.a_index.set(dihedralAddr, desc.getAtomIndex(this.confSpace, posi, desc.a));
        this.dihedralStruct.b_index.set(dihedralAddr, desc.getAtomIndex(this.confSpace, posi, desc.b));
        this.dihedralStruct.c_index.set(dihedralAddr, desc.getAtomIndex(this.confSpace, posi, desc.c));
        this.dihedralStruct.d_index.set(dihedralAddr, desc.getAtomIndex(this.confSpace, posi, desc.d));
        this.dihedralStruct.num_rotated.set(dihedralAddr, desc.rotated.length);
        this.dihedralStruct.modified_posi.set(dihedralAddr, posi);
        Structs.Int32.Array rotatedIndices = Structs.int32array();
        MemoryBuffer indicesAddr = buf.place(rotatedIndices, desc.rotated.length, 16L);
        for (int i = 0; i < desc.rotated.length; ++i) {
            rotatedIndices.set(indicesAddr, i, desc.getAtomIndex(this.confSpace, posi, desc.rotated[i]));
        }
        buf.skipToAlignment(16L);
    }

    private void writeTranslationRotation(TranslationRotation.Description desc, int moli, MemoryBuffer buf) {
        MemoryBuffer transrotAddr = buf.place(this.transRotStruct);
        this.transRotStruct.id.set(transrotAddr, 1L);
        this.transRotStruct.max_distance.set(transrotAddr, desc.maxDistance);
        this.transRotStruct.max_radians.set(transrotAddr, desc.maxRotationRadians);
        MemoryBuffer centroidAddr = this.transRotStruct.centroid.offsetOf(transrotAddr);
        this.real3Struct.x.set(centroidAddr, desc.centroid.x);
        this.real3Struct.y.set(centroidAddr, desc.centroid.y);
        this.real3Struct.z.set(centroidAddr, desc.centroid.z);
        this.transRotStruct.moli.set(transrotAddr, moli);
    }

    @Override
    public Precision precision() {
        return this.precision;
    }

    public String version() {
        return String.format("%d.%d", NativeLib.version_major(), NativeLib.version_minor());
    }

    @Override
    public ConfSpace confSpace() {
        return this.confSpace;
    }

    public CheckedOutStream checkoutStream() {
        Stream stream = null;
        try {
            while (stream == null) {
                stream = this.streamQueue.poll(100L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        return new CheckedOutStream(stream);
    }

    public CheckedOutStream tryCheckoutStream() {
        return new CheckedOutStream((Stream)this.streamQueue.poll());
    }

    public int numStreams() {
        return this.streams.size();
    }

    @Override
    public void close() {
        for (GpuStreams it : this.gpuStreams) {
            NativeLib.free_conf_space(it.gpuInfo.id, this.pConfSpace.get(it.gpuInfo));
        }
        this.confSpaceSizesMem.close();
        for (Stream stream : this.streams) {
            stream.close();
        }
        this.confSpaceBuf.close();
    }

    /*
     * Unable to fully structure code
     */
    public AssignedCoords assign(int[] conf) {
        confMem = this.makeConf(conf);
        try {
            block23: {
                coordsMem = CudaConfEnergyCalculator.makeArray(this.confSpace.maxNumConfAtoms, this.real3Struct.bytes());
                try {
                    co = this.checkoutStream();
                    try {
                        switch (1.$SwitchMap$edu$duke$cs$osprey$gpu$Precision[this.precision.ordinal()]) {
                            case 1: {
                                NativeLib.assign_f32(co.stream.device, co.stream.stream, co.stream.pConfSpace, confMem.asByteBuffer(), coordsMem.asByteBuffer());
                                ** break;
lbl11:
                                // 1 sources

                                break;
                            }
                            case 2: {
                                NativeLib.assign_f64(co.stream.device, co.stream.stream, co.stream.pConfSpace, confMem.asByteBuffer(), coordsMem.asByteBuffer());
                                break;
                            }
                            ** default:
lbl16:
                            // 1 sources

                            break;
                        }
                    }
                    finally {
                        if (co != null) {
                            co.close();
                        }
                    }
                    var4_5 = this.makeCoords(coordsMem, conf);
                    if (coordsMem == null) break block23;
                }
                catch (Throwable var4_6) {
                    if (coordsMem != null) {
                        try {
                            coordsMem.close();
                        }
                        catch (Throwable var5_9) {
                            var4_6.addSuppressed(var5_9);
                        }
                    }
                    throw var4_6;
                }
                coordsMem.close();
            }
            return var4_5;
        }
        finally {
            if (confMem != null) {
                confMem.close();
            }
        }
    }

    private MemoryBuffer makeConf(int[] conf) {
        MemoryBuffer mem = CudaConfEnergyCalculator.makeArray(this.confSpace.positions.length, 4L);
        Structs.Int32.Array array = Structs.int32array();
        MemoryBuffer addr = CudaConfEnergyCalculator.getArrayAddress(mem);
        for (int posi = 0; posi < this.confSpace.positions.length; ++posi) {
            array.set(addr, posi, conf[posi]);
        }
        return mem;
    }

    private AssignedCoords makeCoords(MemoryBuffer mem, int[] assignments) {
        AssignedCoords coords = new AssignedCoords(this.confSpace, assignments);
        MemoryBuffer arrayAddr = CudaConfEnergyCalculator.getArrayAddress(mem);
        for (int i = 0; i < this.confSpace.maxNumConfAtoms; ++i) {
            MemoryBuffer addr = arrayAddr.sliceFrom((long)i * this.real3Struct.bytes());
            coords.coords.set(i, this.real3Struct.x.get(addr), this.real3Struct.y.get(addr), this.real3Struct.z.get(addr));
        }
        return coords;
    }

    /*
     * Exception decompiling
     */
    @Override
    public ConfEnergyCalculator.EnergiedCoords calc(int[] conf, List<PosInter> inters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public double calcEnergy(int[] conf, List<PosInter> inters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private DoubleMatrix1D makeDofs(MemoryBuffer mem) {
        int size = (int)CudaConfEnergyCalculator.getArraySize(mem);
        DoubleMatrix1D vals = DoubleFactory1D.dense.make(size);
        Structs.Real.Array floats = Structs.realarray(this.precision);
        MemoryBuffer addr = CudaConfEnergyCalculator.getArrayAddress(mem);
        for (int i = 0; i < size; ++i) {
            vals.set(i, floats.get(addr, i));
        }
        return vals;
    }

    /*
     * Exception decompiling
     */
    @Override
    public ConfEnergyCalculator.EnergiedCoords minimize(int[] conf, List<PosInter> inters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public double minimizeEnergy(int[] conf, List<PosInter> inters) {
        ConfEnergyCalculator.MinimizationJob job = new ConfEnergyCalculator.MinimizationJob(conf, inters);
        this.minimizeEnergies(Collections.singletonList(job));
        return job.energy;
    }

    @Override
    public void minimizeEnergies(List<ConfEnergyCalculator.MinimizationJob> jobs) {
        this.minimizeEnergies(jobs, null);
    }

    public void minimizeEnergies(List<ConfEnergyCalculator.MinimizationJob> jobs, CheckedOutStream co) {
        if (jobs.size() <= 0) {
            return;
        }
        if ((long)jobs.size() > this.maxBatchSize) {
            throw new IllegalArgumentException(String.format("too many jobs for batch: %d, max allocated is %d", jobs.size(), this.maxBatchSize));
        }
        try (MemoryBuffer jobsMem = this.makeMinimizationJobsMem(jobs);){
            if (this.dumpJobsTo != null) {
                this.forcefieldsImpl.dumpJobs(this.dumpJobsTo, jobsMem.asByteBuffer());
                throw new Error("Jobs dumped to: " + this.dumpJobsTo.getAbsolutePath());
            }
            try (MemoryBuffer energiesMem = CudaConfEnergyCalculator.makeArray(jobs.size(), this.precision.bytes);){
                if (co != null) {
                    this.forcefieldsImpl.minimizeBatch(co.stream, jobsMem.asByteBuffer(), energiesMem.asByteBuffer());
                } else {
                    try (CheckedOutStream co2 = this.checkoutStream();){
                        this.forcefieldsImpl.minimizeBatch(co2.stream, jobsMem.asByteBuffer(), energiesMem.asByteBuffer());
                    }
                }
                Structs.Real.Array energies = Structs.realarray(this.precision);
                MemoryBuffer addr = CudaConfEnergyCalculator.getArrayAddress(energiesMem);
                for (int i = 0; i < jobs.size(); ++i) {
                    jobs.get((int)i).energy = energies.get(addr, i);
                }
            }
        }
    }

    @Override
    public int maxBatchSize() {
        return (int)this.maxBatchSize;
    }

    private MemoryBuffer makeMinimizationJobsMem(List<ConfEnergyCalculator.MinimizationJob> jobs) {
        long memBytes = CudaConfEnergyCalculator.getArrayBytes(jobs.size(), 8L) + jobs.stream().mapToLong(job -> CudaConfEnergyCalculator.getArrayBytes(this.confSpace.positions.length, 4L) + CudaConfEnergyCalculator.getArrayBytes(job.inters.size(), this.posInterStruct.bytes())).sum();
        MemoryBuffer buf = new MemoryBuffer(memBytes);
        MemoryBuffer addr = buf.place(arrayStruct);
        CudaConfEnergyCalculator.arrayStruct.size.set(addr, jobs.size());
        assert (buf.isAligned(16L));
        Structs.Int64.Array offsetsArray = Structs.int64array();
        MemoryBuffer offsetsAddr = buf.place(offsetsArray, jobs.size(), 16L);
        assert (buf.isAligned(16L));
        Structs.Int32.Array confArray = Structs.int32array();
        for (int j = 0; j < jobs.size(); ++j) {
            ConfEnergyCalculator.MinimizationJob job2 = jobs.get(j);
            offsetsArray.set(offsetsAddr, j, buf.getPos());
            assert (buf.isAligned(16L));
            addr = buf.place(arrayStruct);
            CudaConfEnergyCalculator.arrayStruct.size.set(addr, job2.conf.length);
            addr = buf.place(confArray, job2.conf.length, 16L);
            for (int i = 0; i < job2.conf.length; ++i) {
                confArray.set(addr, i, job2.conf[i]);
            }
            assert (buf.isAligned(16L));
            addr = buf.place(arrayStruct);
            CudaConfEnergyCalculator.arrayStruct.size.set(addr, job2.inters.size());
            for (PosInter inter : job2.inters) {
                addr = buf.place(this.posInterStruct);
                this.posInterStruct.posi1.set(addr, inter.posi1);
                this.posInterStruct.posi2.set(addr, inter.posi2);
                this.posInterStruct.weight.set(addr, inter.weight);
                this.posInterStruct.offset.set(addr, inter.offset);
            }
            buf.skipToAlignment(16L);
        }
        assert (buf.getPos() == memBytes);
        return buf;
    }

    private MemoryBuffer makeIntersMem(List<PosInter> inters) {
        MemoryBuffer buf = CudaConfEnergyCalculator.makeArray(inters.size(), this.posInterStruct.bytes());
        MemoryBuffer arrayBuf = CudaConfEnergyCalculator.getArrayAddress(buf);
        for (PosInter inter : inters) {
            MemoryBuffer addr = arrayBuf.place(this.posInterStruct);
            this.posInterStruct.posi1.set(addr, inter.posi1);
            this.posInterStruct.posi2.set(addr, inter.posi2);
            this.posInterStruct.weight.set(addr, inter.weight);
            this.posInterStruct.offset.set(addr, inter.offset);
        }
        return buf;
    }

    private static long getArrayBytes(long size, long itemBytes) {
        return CudaConfEnergyCalculator.padToGpuAlignment(16L + size * itemBytes);
    }

    private static MemoryBuffer makeArray(long size, long itemBytes) {
        MemoryBuffer buf = new MemoryBuffer(CudaConfEnergyCalculator.getArrayBytes(size, itemBytes));
        buf.int64(size);
        buf.skip(8L);
        return buf.sliceFrom(0L);
    }

    private static long getArraySize(MemoryBuffer mem) {
        return mem.getLong(0L);
    }

    private static MemoryBuffer getArrayAddress(MemoryBuffer mem) {
        return mem.sliceFrom(16L);
    }

    private static class NativeLib {
        private NativeLib() {
        }

        public static native int version_major();

        public static native int version_minor();

        public static native int cuda_version_driver();

        public static native int cuda_version_runtime();

        public static native int cuda_version_required();

        public static native Pointer alloc_gpu_infos();

        public static native void free_gpu_infos(Pointer var0);

        public static native Pointer alloc_conf_space_f32(int var0, ByteBuffer var1);

        public static native Pointer alloc_conf_space_f64(int var0, ByteBuffer var1);

        public static native void free_conf_space(int var0, Pointer var1);

        public static native long minimize_batch_bufsize_device_f32(ByteBuffer var0, long var1);

        public static native long minimize_batch_bufsize_device_f64(ByteBuffer var0, long var1);

        public static native long minimize_batch_bufsize_host_f32(ByteBuffer var0, long var1);

        public static native long minimize_batch_bufsize_host_f64(ByteBuffer var0, long var1);

        public static native Pointer alloc_stream(int var0, long var1, long var3);

        public static native void free_stream(int var0, Pointer var1);

        public static native void assign_f32(int var0, Pointer var1, Pointer var2, ByteBuffer var3, ByteBuffer var4);

        public static native void assign_f64(int var0, Pointer var1, Pointer var2, ByteBuffer var3, ByteBuffer var4);

        public static native float calc_amber_eef1_f32(int var0, Pointer var1, Pointer var2, ByteBuffer var3, ByteBuffer var4, ByteBuffer var5, long var6);

        public static native double calc_amber_eef1_f64(int var0, Pointer var1, Pointer var2, ByteBuffer var3, ByteBuffer var4, ByteBuffer var5, long var6);

        public static native float minimize_amber_eef1_f32(int var0, Pointer var1, Pointer var2, ByteBuffer var3, ByteBuffer var4, ByteBuffer var5, ByteBuffer var6);

        public static native double minimize_amber_eef1_f64(int var0, Pointer var1, Pointer var2, ByteBuffer var3, ByteBuffer var4, ByteBuffer var5, ByteBuffer var6);

        public static native void minimize_batch_amber_eef1_f32(int var0, Pointer var1, Pointer var2, ByteBuffer var3, ByteBuffer var4, ByteBuffer var5);

        public static native void minimize_batch_amber_eef1_f64(int var0, Pointer var1, Pointer var2, ByteBuffer var3, ByteBuffer var4, ByteBuffer var5);

        static {
            Native.register((String)"CudaConfEcalc");
        }
    }

    static class SArray
    extends Structs.Struct {
        Structs.Int64 size = Structs.int64();
        Structs.Int64 things_ptr = Structs.int64();

        SArray() {
        }

        SArray init() {
            this.init(16, "size", "things_ptr");
            return this;
        }

        long bytes(long numItems, long itemBytes) {
            return this.bytes() + CudaConfEnergyCalculator.padToGpuAlignment(numItems * itemBytes);
        }
    }

    static class SGpuInfo
    extends Structs.Struct {
        Structs.Pad bus_id = Structs.pad(16L);
        Structs.Pad name = Structs.pad(256L);
        Structs.Int32 integrated = Structs.int32();
        Structs.Int32 concurrent_kernels = Structs.int32();
        Structs.Int32 num_processors = Structs.int32();
        Structs.Int32 num_async_engines = Structs.int32();
        Structs.Int64 mem_total = Structs.int64();
        Structs.Int64 mem_free = Structs.int64();

        SGpuInfo() {
        }

        SGpuInfo init() {
            this.init(304, "bus_id", "name", "integrated", "concurrent_kernels", "num_processors", "num_async_engines", "mem_total", "mem_free");
            return this;
        }
    }

    public static class GpuInfo {
        public final int id;
        public final String busId;
        public final String name;
        public final boolean integrated;
        public final boolean concurrentKernels;
        public final int numProcessors;
        public final int numAsyncEngines;
        public final long memTotal;
        public final long memFree;

        public GpuInfo(int id, String busId, String name, boolean integrated, boolean concurrentKernels, int numProcessors, int numAsyncEngines, long memTotal, long memFree) {
            this.id = id;
            this.busId = busId;
            this.name = name;
            this.integrated = integrated;
            this.concurrentKernels = concurrentKernels;
            this.numProcessors = numProcessors;
            this.numAsyncEngines = numAsyncEngines;
            this.memTotal = memTotal;
            this.memFree = memFree;
        }

        public int bestNumStreams() {
            return 3;
        }

        public int bestBatchSize() {
            return this.numProcessors / 2;
        }

        public int hashCode() {
            return this.busId.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof GpuInfo && this.equals((GpuInfo)other);
        }

        public boolean equals(GpuInfo other) {
            return this.busId.equals(other.busId);
        }

        public String toString() {
            return "GPU[\n" + String.format("%20s: %s\n", "id", this.id) + String.format("%20s: %s\n", "bus id", this.busId) + String.format("%20s: %s\n", "name", this.name) + String.format("%20s: %b\n", "integrated", this.integrated) + String.format("%20s: %b\n", "concurrent kernels", this.concurrentKernels) + String.format("%20s: %d\n", "num processors", this.numProcessors) + String.format("%20s: %d\n", "async engines", this.numAsyncEngines) + String.format("%20s: %d B, %.1f GiB\n", "memory total", this.memTotal, (double)this.memTotal / 1024.0 / 1024.0 / 1024.0) + String.format("%20s: %d B, %.1f GiB\n", "memory free", this.memFree, (double)this.memFree / 1024.0 / 1024.0 / 1024.0) + "]";
        }
    }

    class SConfSpace
    extends Structs.Struct {
        Structs.Int32 num_pos = Structs.int32();
        Structs.Int32 max_num_conf_atoms = Structs.int32();
        Structs.Int32 max_num_dofs = Structs.int32();
        Structs.Int32 num_molecule_motions = Structs.int32();
        Structs.Int64 size = Structs.int64();
        Structs.Int64 positions_offset = Structs.int64();
        Structs.Int64 static_atom_coords_offset = Structs.int64();
        Structs.Int64 static_atom_molis_offset = Structs.int64();
        Structs.Int64 params_offset = Structs.int64();
        Structs.Int64 pos_pairs_offset = Structs.int64();
        Structs.Int64 molecule_motions_offset = Structs.int64();
        Structs.Real static_energy;
        Structs.Pad pad;

        SConfSpace() {
        }

        void init() {
            this.static_energy = Structs.real(CudaConfEnergyCalculator.this.precision);
            this.pad = Structs.pad(CudaConfEnergyCalculator.this.precision.map(4, 0).intValue());
            this.init(CudaConfEnergyCalculator.this.precision.map(80, 80), "num_pos", "max_num_conf_atoms", "max_num_dofs", "num_molecule_motions", "size", "positions_offset", "static_atom_coords_offset", "static_atom_molis_offset", "params_offset", "pos_pairs_offset", "molecule_motions_offset", "static_energy", "pad");
        }
    }

    static class SPos
    extends Structs.Struct {
        Structs.Int32 num_confs = Structs.int32();
        Structs.Int32 max_num_atoms = Structs.int32();
        Structs.Int32 num_frags = Structs.int32();
        Structs.Pad pad;

        SPos() {
        }

        void init() {
            this.pad = Structs.pad(4L);
            this.init(16, "num_confs", "max_num_atoms", "num_frags", "pad");
        }
    }

    class SConf
    extends Structs.Struct {
        Structs.Int64 atom_coords_offset = Structs.int64();
        Structs.Int64 atom_molis_offset = Structs.int64();
        Structs.Int32 frag_index = Structs.int32();
        Structs.Pad pad1;
        Structs.Real internal_energy;
        Structs.Int64 num_motions = Structs.int64();
        Structs.Int64 motions_offset = Structs.int64();
        Structs.Pad pad2;

        SConf() {
        }

        void init() {
            this.pad1 = Structs.pad(CudaConfEnergyCalculator.this.precision.map(0, 4).intValue());
            this.internal_energy = Structs.real(CudaConfEnergyCalculator.this.precision);
            this.pad2 = Structs.pad(CudaConfEnergyCalculator.this.precision.map(8, 0).intValue());
            this.init(CudaConfEnergyCalculator.this.precision.map(48, 48), "atom_coords_offset", "atom_molis_offset", "frag_index", "pad1", "internal_energy", "num_motions", "motions_offset", "pad2");
        }
    }

    class SReal3
    extends Structs.Struct {
        Structs.Real x;
        Structs.Real y;
        Structs.Real z;
        Structs.Pad pad;

        SReal3() {
        }

        void init() {
            this.x = Structs.real(CudaConfEnergyCalculator.this.precision);
            this.y = Structs.real(CudaConfEnergyCalculator.this.precision);
            this.z = Structs.real(CudaConfEnergyCalculator.this.precision);
            this.pad = Structs.pad(CudaConfEnergyCalculator.this.precision.map(4, 0).intValue());
            this.init(CudaConfEnergyCalculator.this.precision.map(16, 24), "x", "y", "z", "pad");
        }
    }

    class SPosInter
    extends Structs.Struct {
        Structs.Int32 posi1 = Structs.int32();
        Structs.Int32 posi2 = Structs.int32();
        Structs.Real weight;
        Structs.Real offset;

        SPosInter() {
        }

        void init() {
            this.weight = Structs.real(CudaConfEnergyCalculator.this.precision);
            this.offset = Structs.real(CudaConfEnergyCalculator.this.precision);
            this.init(CudaConfEnergyCalculator.this.precision.map(16, 24), "posi1", "posi2", "weight", "offset");
        }
    }

    class SDihedral
    extends Structs.Struct {
        Structs.Int64 id = Structs.int64();
        Structs.Real min_radians;
        Structs.Real max_radians;
        Structs.Int32 a_index = Structs.int32();
        Structs.Int32 b_index = Structs.int32();
        Structs.Int32 c_index = Structs.int32();
        Structs.Int32 d_index = Structs.int32();
        Structs.Int32 num_rotated = Structs.int32();
        Structs.Int32 modified_posi = Structs.int32();
        Structs.Pad pad;

        SDihedral() {
        }

        void init() {
            this.min_radians = Structs.real(CudaConfEnergyCalculator.this.precision);
            this.max_radians = Structs.real(CudaConfEnergyCalculator.this.precision);
            this.pad = Structs.pad(CudaConfEnergyCalculator.this.precision.map(8, 0).intValue());
            this.init(CudaConfEnergyCalculator.this.precision.map(48, 48), "id", "min_radians", "max_radians", "a_index", "b_index", "c_index", "d_index", "num_rotated", "modified_posi", "pad");
        }

        long bytes(int numRotated) {
            return this.bytes() + CudaConfEnergyCalculator.padToGpuAlignment(4L * (long)numRotated);
        }
    }

    class STranslationRotation
    extends Structs.Struct {
        Structs.Int64 id = Structs.int64();
        Structs.Real max_distance;
        Structs.Real max_radians;
        Structs.StructField<SReal3> centroid;
        Structs.Int32 moli = Structs.int32();
        Structs.Pad pad = Structs.pad(12L);

        STranslationRotation() {
        }

        void init() {
            this.max_distance = Structs.real(CudaConfEnergyCalculator.this.precision);
            this.max_radians = Structs.real(CudaConfEnergyCalculator.this.precision);
            this.centroid = Structs.struct(CudaConfEnergyCalculator.this.real3Struct);
            this.init(CudaConfEnergyCalculator.this.precision.map(48, 64), "id", "max_distance", "max_radians", "centroid", "moli", "pad");
        }
    }

    private class AmberEef1
    implements ForcefieldsImpl {
        final SParamsAmberEef1 paramsStruct = new SParamsAmberEef1(this);
        final SAtomPairs atomPairsStruct = new SAtomPairs(this);
        final SAtomPairAmberF32a amberF32aStruct = new SAtomPairAmberF32a(this);
        final SAtomPairAmberF32b amberF32bStruct = new SAtomPairAmberF32b(this);
        final SAtomPairAmberF64a amberF64aStruct = new SAtomPairAmberF64a(this);
        final SAtomPairAmberF64b amberF64bStruct = new SAtomPairAmberF64b(this);
        final SAtomPairEef1F32a eef1F32aStruct = new SAtomPairEef1F32a(this);
        final SAtomPairEef1F32b eef1F32bStruct = new SAtomPairEef1F32b(this);
        final SAtomPairEef1F64a eef1F64aStruct = new SAtomPairEef1F64a(this);
        final SAtomPairEef1F64b eef1F64bStruct = new SAtomPairEef1F64b(this);
        final SAtomPairEef1F64c eef1F64cStruct = new SAtomPairEef1F64c(this);

        AmberEef1() {
            this.paramsStruct.init();
            this.atomPairsStruct.init();
            this.amberF32aStruct.init();
            this.amberF32bStruct.init();
            this.amberF64aStruct.init();
            this.amberF64bStruct.init();
            this.eef1F32aStruct.init();
            this.eef1F32bStruct.init();
            this.eef1F64aStruct.init();
            this.eef1F64bStruct.init();
            this.eef1F64cStruct.init();
        }

        @Override
        public double calc(Stream stream, ByteBuffer confBuf, ByteBuffer intersBuf, ByteBuffer coordsBuf, long numAtoms) {
            return switch (CudaConfEnergyCalculator.this.precision) {
                default -> throw new IncompatibleClassChangeError();
                case Precision.Float32 -> NativeLib.calc_amber_eef1_f32(stream.device, stream.stream, stream.pConfSpace, confBuf, intersBuf, coordsBuf, numAtoms);
                case Precision.Float64 -> NativeLib.calc_amber_eef1_f64(stream.device, stream.stream, stream.pConfSpace, confBuf, intersBuf, coordsBuf, numAtoms);
            };
        }

        @Override
        public double minimize(Stream stream, ByteBuffer jobsBuf, ByteBuffer coordsBuf, ByteBuffer dofsBuf) {
            return switch (CudaConfEnergyCalculator.this.precision) {
                default -> throw new IncompatibleClassChangeError();
                case Precision.Float32 -> NativeLib.minimize_amber_eef1_f32(stream.device, stream.stream, stream.pConfSpace, CudaConfEnergyCalculator.this.confSpaceSizesBuf, jobsBuf, coordsBuf, dofsBuf);
                case Precision.Float64 -> NativeLib.minimize_amber_eef1_f64(stream.device, stream.stream, stream.pConfSpace, CudaConfEnergyCalculator.this.confSpaceSizesBuf, jobsBuf, coordsBuf, dofsBuf);
            };
        }

        @Override
        public void minimizeBatch(Stream stream, ByteBuffer jobsBuf, ByteBuffer energiesBuf) {
            switch (CudaConfEnergyCalculator.this.precision) {
                case Float32: {
                    NativeLib.minimize_batch_amber_eef1_f32(stream.device, stream.stream, stream.pConfSpace, CudaConfEnergyCalculator.this.confSpaceSizesBuf, jobsBuf, energiesBuf);
                    break;
                }
                case Float64: {
                    NativeLib.minimize_batch_amber_eef1_f64(stream.device, stream.stream, stream.pConfSpace, CudaConfEnergyCalculator.this.confSpaceSizesBuf, jobsBuf, energiesBuf);
                }
            }
        }

        @Override
        public void dumpJobs(File file, ByteBuffer jobsBuf) {
            try (DataOutputStream out = new DataOutputStream(new FileOutputStream(CudaConfEnergyCalculator.this.dumpJobsTo));){
                Log.log("dumping jobs ...", new Object[0]);
                out.writeInt(CudaConfEnergyCalculator.this.precision.ordinal());
                MemoryBuffer spaceMem = CudaConfEnergyCalculator.this.confSpaceBuf;
                this.writeBuf(out, spaceMem.asByteBuffer());
                MemoryBuffer sizesMem = CudaConfEnergyCalculator.this.confSpaceSizesMem;
                this.writeBuf(out, sizesMem.asByteBuffer());
                this.writeBuf(out, jobsBuf);
            }
            catch (IOException ex) {
                throw new Error("can't dump jobs", ex);
            }
        }

        private void writeBuf(DataOutputStream out, ByteBuffer buf) throws IOException {
            out.writeInt(buf.capacity());
            for (int i = 0; i < buf.capacity(); ++i) {
                out.writeByte(buf.get(i));
            }
        }

        @Override
        public long paramsBytes() {
            return this.paramsStruct.bytes();
        }

        @Override
        public void writeParams(MemoryBuffer buf) {
            MemoryBuffer addr = buf.place(this.paramsStruct);
            AmberEnergyCalculator.Settings amberSettings = ((AmberEnergyCalculator)CudaConfEnergyCalculator.this.confSpace.ecalcs[0]).settings;
            this.paramsStruct.distance_dependent_dielectric.set(addr, amberSettings.distanceDependentDielectric);
        }

        private long atomPairsBytes(int numAmber, int numEef1) {
            long l = this.atomPairsStruct.bytes();
            return l + (switch (CudaConfEnergyCalculator.this.precision) {
                default -> throw new IncompatibleClassChangeError();
                case Precision.Float32 -> CudaConfEnergyCalculator.padToGpuAlignment((long)numAmber * this.amberF32aStruct.bytes()) + (long)numAmber * this.amberF32bStruct.bytes() + CudaConfEnergyCalculator.padToGpuAlignment((long)numEef1 * this.eef1F32aStruct.bytes()) + (long)numEef1 * this.eef1F32bStruct.bytes() + (long)numEef1 * this.eef1F32bStruct.bytes();
                case Precision.Float64 -> CudaConfEnergyCalculator.padToGpuAlignment((long)numAmber * this.amberF64aStruct.bytes()) + (long)numAmber * this.amberF64bStruct.bytes() + CudaConfEnergyCalculator.padToGpuAlignment((long)numEef1 * this.eef1F64aStruct.bytes()) + (long)numEef1 * this.eef1F64bStruct.bytes() + (long)numEef1 * this.eef1F64bStruct.bytes() + (long)numEef1 * this.eef1F64cStruct.bytes();
            });
        }

        @Override
        public long staticStaticBytes() {
            return this.atomPairsBytes(CudaConfEnergyCalculator.this.confSpace.indicesStatic(0).size(), CudaConfEnergyCalculator.this.confSpace.indicesStatic(1).size());
        }

        @Override
        public long staticPosBytes(int posi1, int fragi1) {
            return this.atomPairsBytes(CudaConfEnergyCalculator.this.confSpace.indicesSinglesByFrag(0, posi1, fragi1).sizeStatics(), CudaConfEnergyCalculator.this.confSpace.indicesSinglesByFrag(1, posi1, fragi1).sizeStatics());
        }

        @Override
        public long posBytes(int posi1, int fragi1) {
            return this.atomPairsBytes(CudaConfEnergyCalculator.this.confSpace.indicesSinglesByFrag(0, posi1, fragi1).sizeInternals(), CudaConfEnergyCalculator.this.confSpace.indicesSinglesByFrag(1, posi1, fragi1).sizeInternals());
        }

        @Override
        public long posPosBytes(int posi1, int fragi1, int posi2, int fragi2) {
            return this.atomPairsBytes(CudaConfEnergyCalculator.this.confSpace.indicesPairsByFrags(0, posi1, fragi1, posi2, fragi2).size(), CudaConfEnergyCalculator.this.confSpace.indicesPairsByFrags(1, posi1, fragi1, posi2, fragi2).size());
        }

        private void writeAtomPairs(AtomPairWriter amber, AtomPairWriter eef1, MemoryBuffer buf) {
            assert (buf.isAligned(16L)) : "Not aligned!";
            long firstPos = buf.getPos();
            MemoryBuffer atomPairsAddr = buf.place(this.atomPairsStruct);
            this.atomPairsStruct.num_amber.set(atomPairsAddr, amber.size());
            this.atomPairsStruct.num_eef1.set(atomPairsAddr, eef1.size());
            switch (CudaConfEnergyCalculator.this.precision) {
                case Float32: {
                    int atomi2;
                    int atomi1;
                    MemoryBuffer addr;
                    int i;
                    assert (buf.isAligned(16L));
                    for (i = 0; i < amber.size(); ++i) {
                        addr = buf.place(this.amberF32aStruct);
                        atomi1 = amber.atomi1(i);
                        atomi2 = amber.atomi2(i);
                        assert (atomi1 != atomi2);
                        this.amberF32aStruct.atomi1.set(addr, atomi1);
                        this.amberF32aStruct.atomi2.set(addr, atomi2);
                    }
                    buf.skipToAlignment(16L);
                    for (i = 0; i < amber.size(); ++i) {
                        addr = buf.place(this.amberF32bStruct);
                        this.amberF32bStruct.setParams(addr, amber.params(i));
                    }
                    assert (buf.isAligned(16L));
                    for (i = 0; i < eef1.size(); ++i) {
                        addr = buf.place(this.eef1F32aStruct);
                        atomi1 = eef1.atomi1(i);
                        atomi2 = eef1.atomi2(i);
                        assert (atomi1 != atomi2);
                        this.eef1F32aStruct.atomi1.set(addr, atomi1);
                        this.eef1F32aStruct.atomi2.set(addr, atomi2);
                    }
                    buf.skipToAlignment(16L);
                    for (i = 0; i < eef1.size(); ++i) {
                        addr = buf.place(this.eef1F32bStruct);
                        this.eef1F32bStruct.setParams1(addr, eef1.params(i));
                    }
                    assert (buf.isAligned(16L));
                    for (i = 0; i < eef1.size(); ++i) {
                        addr = buf.place(this.eef1F32bStruct);
                        this.eef1F32bStruct.setParams2(addr, eef1.params(i));
                    }
                    assert (buf.isAligned(16L));
                    break;
                }
                case Float64: {
                    int atomi2;
                    int atomi1;
                    MemoryBuffer addr;
                    int i;
                    assert (buf.isAligned(16L));
                    for (i = 0; i < amber.size(); ++i) {
                        addr = buf.place(this.amberF64aStruct);
                        atomi1 = amber.atomi1(i);
                        atomi2 = amber.atomi2(i);
                        assert (atomi1 != atomi2);
                        this.amberF64aStruct.atomi1.set(addr, atomi1);
                        this.amberF64aStruct.atomi2.set(addr, atomi2);
                        this.amberF64aStruct.setParams(addr, amber.params(i));
                    }
                    assert (buf.isAligned(16L));
                    for (i = 0; i < amber.size(); ++i) {
                        addr = buf.place(this.amberF64bStruct);
                        this.amberF64bStruct.setParams(addr, amber.params(i));
                    }
                    assert (buf.isAligned(16L));
                    for (i = 0; i < eef1.size(); ++i) {
                        addr = buf.place(this.eef1F64aStruct);
                        atomi1 = eef1.atomi1(i);
                        atomi2 = eef1.atomi2(i);
                        assert (atomi1 != atomi2);
                        this.eef1F64aStruct.atomi1.set(addr, atomi1);
                        this.eef1F64aStruct.atomi2.set(addr, atomi2);
                    }
                    buf.skipToAlignment(16L);
                    for (i = 0; i < eef1.size(); ++i) {
                        addr = buf.place(this.eef1F64bStruct);
                        this.eef1F64bStruct.setParams1(addr, eef1.params(i));
                    }
                    assert (buf.isAligned(16L));
                    for (i = 0; i < eef1.size(); ++i) {
                        addr = buf.place(this.eef1F64bStruct);
                        this.eef1F64bStruct.setParams2(addr, eef1.params(i));
                    }
                    assert (buf.isAligned(16L));
                    for (i = 0; i < eef1.size(); ++i) {
                        addr = buf.place(this.eef1F64cStruct);
                        this.eef1F64cStruct.setParams(addr, eef1.params(i));
                    }
                    assert (buf.isAligned(16L));
                    break;
                }
            }
            assert (buf.getPos() - firstPos == this.atomPairsBytes(amber.size(), eef1.size())) : String.format("overshot by %d bytes", buf.getPos() - firstPos - this.atomPairsBytes(amber.size(), eef1.size()));
            assert (buf.isAligned(16L)) : "Not aligned!";
        }

        @Override
        public void writeStaticStatic(MemoryBuffer buf) {
            final ConfSpace.IndicesStatic amberIndices = CudaConfEnergyCalculator.this.confSpace.indicesStatic(0);
            final ConfSpace.IndicesStatic eef1Indices = CudaConfEnergyCalculator.this.confSpace.indicesStatic(1);
            this.writeAtomPairs(new AtomPairWriter(){

                @Override
                public int size() {
                    return amberIndices.size();
                }

                @Override
                public int atomi1(int i) {
                    return CudaConfEnergyCalculator.this.confSpace.getStaticAtomIndex(amberIndices.getStaticAtom1Index(i));
                }

                @Override
                public int atomi2(int i) {
                    return CudaConfEnergyCalculator.this.confSpace.getStaticAtomIndex(amberIndices.getStaticAtom2Index(i));
                }

                @Override
                public double[] params(int i) {
                    return CudaConfEnergyCalculator.this.confSpace.ffparams(0, amberIndices.getParamsIndex(i));
                }
            }, new AtomPairWriter(){

                @Override
                public int size() {
                    return eef1Indices.size();
                }

                @Override
                public int atomi1(int i) {
                    return CudaConfEnergyCalculator.this.confSpace.getStaticAtomIndex(eef1Indices.getStaticAtom1Index(i));
                }

                @Override
                public int atomi2(int i) {
                    return CudaConfEnergyCalculator.this.confSpace.getStaticAtomIndex(eef1Indices.getStaticAtom2Index(i));
                }

                @Override
                public double[] params(int i) {
                    return CudaConfEnergyCalculator.this.confSpace.ffparams(1, eef1Indices.getParamsIndex(i));
                }
            }, buf);
        }

        @Override
        public void writeStaticPos(final int posi1, int fragi1, MemoryBuffer buf) {
            final ConfSpace.IndicesSingle amberIndices = CudaConfEnergyCalculator.this.confSpace.indicesSinglesByFrag(0, posi1, fragi1);
            final ConfSpace.IndicesSingle eef1Indices = CudaConfEnergyCalculator.this.confSpace.indicesSinglesByFrag(1, posi1, fragi1);
            this.writeAtomPairs(new AtomPairWriter(){

                @Override
                public int size() {
                    return amberIndices.sizeStatics();
                }

                @Override
                public int atomi1(int i) {
                    return CudaConfEnergyCalculator.this.confSpace.getStaticAtomIndex(amberIndices.getStaticStaticAtomIndex(i));
                }

                @Override
                public int atomi2(int i) {
                    return CudaConfEnergyCalculator.this.confSpace.getConfAtomIndex(posi1, amberIndices.getStaticConfAtomIndex(i));
                }

                @Override
                public double[] params(int i) {
                    return CudaConfEnergyCalculator.this.confSpace.ffparams(0, amberIndices.getStaticParamsIndex(i));
                }
            }, new AtomPairWriter(){

                @Override
                public int size() {
                    return eef1Indices.sizeStatics();
                }

                @Override
                public int atomi1(int i) {
                    return CudaConfEnergyCalculator.this.confSpace.getStaticAtomIndex(eef1Indices.getStaticStaticAtomIndex(i));
                }

                @Override
                public int atomi2(int i) {
                    return CudaConfEnergyCalculator.this.confSpace.getConfAtomIndex(posi1, eef1Indices.getStaticConfAtomIndex(i));
                }

                @Override
                public double[] params(int i) {
                    return CudaConfEnergyCalculator.this.confSpace.ffparams(1, eef1Indices.getStaticParamsIndex(i));
                }
            }, buf);
        }

        @Override
        public void writePos(final int posi1, int fragi1, MemoryBuffer buf) {
            final ConfSpace.IndicesSingle amberIndices = CudaConfEnergyCalculator.this.confSpace.indicesSinglesByFrag(0, posi1, fragi1);
            final ConfSpace.IndicesSingle eef1Indices = CudaConfEnergyCalculator.this.confSpace.indicesSinglesByFrag(1, posi1, fragi1);
            this.writeAtomPairs(new AtomPairWriter(){

                @Override
                public int size() {
                    return amberIndices.sizeInternals();
                }

                @Override
                public int atomi1(int i) {
                    return CudaConfEnergyCalculator.this.confSpace.getConfAtomIndex(posi1, amberIndices.getInternalConfAtom1Index(i));
                }

                @Override
                public int atomi2(int i) {
                    return CudaConfEnergyCalculator.this.confSpace.getConfAtomIndex(posi1, amberIndices.getInternalConfAtom2Index(i));
                }

                @Override
                public double[] params(int i) {
                    return CudaConfEnergyCalculator.this.confSpace.ffparams(0, amberIndices.getInternalParamsIndex(i));
                }
            }, new AtomPairWriter(){

                @Override
                public int size() {
                    return eef1Indices.sizeInternals();
                }

                @Override
                public int atomi1(int i) {
                    return CudaConfEnergyCalculator.this.confSpace.getConfAtomIndex(posi1, eef1Indices.getInternalConfAtom1Index(i));
                }

                @Override
                public int atomi2(int i) {
                    return CudaConfEnergyCalculator.this.confSpace.getConfAtomIndex(posi1, eef1Indices.getInternalConfAtom2Index(i));
                }

                @Override
                public double[] params(int i) {
                    return CudaConfEnergyCalculator.this.confSpace.ffparams(1, eef1Indices.getInternalParamsIndex(i));
                }
            }, buf);
        }

        @Override
        public void writePosPos(final int posi1, int fragi1, final int posi2, int fragi2, MemoryBuffer buf) {
            final ConfSpace.IndicesPair amberIndices = CudaConfEnergyCalculator.this.confSpace.indicesPairsByFrags(0, posi1, fragi1, posi2, fragi2);
            final ConfSpace.IndicesPair eef1Indices = CudaConfEnergyCalculator.this.confSpace.indicesPairsByFrags(1, posi1, fragi1, posi2, fragi2);
            this.writeAtomPairs(new AtomPairWriter(){

                @Override
                public int size() {
                    return amberIndices.size();
                }

                @Override
                public int atomi1(int i) {
                    return CudaConfEnergyCalculator.this.confSpace.getConfAtomIndex(posi1, amberIndices.getConfAtom1Index(i));
                }

                @Override
                public int atomi2(int i) {
                    return CudaConfEnergyCalculator.this.confSpace.getConfAtomIndex(posi2, amberIndices.getConfAtom2Index(i));
                }

                @Override
                public double[] params(int i) {
                    return CudaConfEnergyCalculator.this.confSpace.ffparams(0, amberIndices.getParamsIndex(i));
                }
            }, new AtomPairWriter(){

                @Override
                public int size() {
                    return eef1Indices.size();
                }

                @Override
                public int atomi1(int i) {
                    return CudaConfEnergyCalculator.this.confSpace.getConfAtomIndex(posi1, eef1Indices.getConfAtom1Index(i));
                }

                @Override
                public int atomi2(int i) {
                    return CudaConfEnergyCalculator.this.confSpace.getConfAtomIndex(posi2, eef1Indices.getConfAtom2Index(i));
                }

                @Override
                public double[] params(int i) {
                    return CudaConfEnergyCalculator.this.confSpace.ffparams(1, eef1Indices.getParamsIndex(i));
                }
            }, buf);
        }

        class SParamsAmberEef1
        extends Structs.Struct {
            Structs.Bool distance_dependent_dielectric = Structs.bool();
            Structs.Pad pad = Structs.pad(15L);

            SParamsAmberEef1(AmberEef1 this$1) {
            }

            void init() {
                this.init(16, "distance_dependent_dielectric", "pad");
            }
        }

        class SAtomPairs
        extends Structs.Struct {
            final Structs.Int32 num_amber = Structs.int32();
            final Structs.Int32 num_eef1 = Structs.int32();
            final Structs.Pad pad = Structs.pad(8L);

            SAtomPairs(AmberEef1 this$1) {
            }

            void init() {
                this.init(16, "num_amber", "num_eef1", "pad");
            }
        }

        class SAtomPairAmberF32a
        extends Structs.Struct {
            final Structs.Int32 atomi1 = Structs.int32();
            final Structs.Int32 atomi2 = Structs.int32();

            SAtomPairAmberF32a(AmberEef1 this$1) {
            }

            void init() {
                this.init(8, "atomi1", "atomi2");
            }
        }

        class SAtomPairAmberF32b
        extends Structs.Struct {
            final Structs.Float32 esQ = Structs.float32();
            final Structs.Float32 vdwA = Structs.float32();
            final Structs.Float32 vdwB = Structs.float32();
            final Structs.Pad pad = Structs.pad(4L);

            SAtomPairAmberF32b(AmberEef1 this$1) {
            }

            void init() {
                this.init(16, "esQ", "vdwA", "vdwB", "pad");
            }

            void setParams(MemoryBuffer buf, double[] params) {
                this.esQ.set(buf, (float)params[0]);
                this.vdwA.set(buf, (float)params[1]);
                this.vdwB.set(buf, (float)params[2]);
            }
        }

        class SAtomPairAmberF64a
        extends Structs.Struct {
            final Structs.Int32 atomi1 = Structs.int32();
            final Structs.Int32 atomi2 = Structs.int32();
            final Structs.Float64 esQ = Structs.float64();

            SAtomPairAmberF64a(AmberEef1 this$1) {
            }

            void setParams(MemoryBuffer buf, double[] params) {
                this.esQ.set(buf, params[0]);
            }

            void init() {
                this.init(16, "atomi1", "atomi2", "esQ");
            }
        }

        class SAtomPairAmberF64b
        extends Structs.Struct {
            final Structs.Float64 vdwA = Structs.float64();
            final Structs.Float64 vdwB = Structs.float64();

            SAtomPairAmberF64b(AmberEef1 this$1) {
            }

            void init() {
                this.init(16, "vdwA", "vdwB");
            }

            void setParams(MemoryBuffer buf, double[] params) {
                this.vdwA.set(buf, params[1]);
                this.vdwB.set(buf, params[2]);
            }
        }

        class SAtomPairEef1F32a
        extends Structs.Struct {
            final Structs.Int32 atomi1 = Structs.int32();
            final Structs.Int32 atomi2 = Structs.int32();

            SAtomPairEef1F32a(AmberEef1 this$1) {
            }

            void init() {
                this.init(8, "atomi1", "atomi2");
            }
        }

        class SAtomPairEef1F32b
        extends Structs.Struct {
            final Structs.Float32 vdwRadius = Structs.float32();
            final Structs.Float32 oolambda = Structs.float32();
            final Structs.Float32 alpha = Structs.float32();
            final Structs.Pad pad = Structs.pad(4L);

            SAtomPairEef1F32b(AmberEef1 this$1) {
            }

            void init() {
                this.init(16, "vdwRadius", "oolambda", "alpha", "pad");
            }

            void setParams1(MemoryBuffer buf, double[] params) {
                this.vdwRadius.set(buf, (float)params[0]);
                this.oolambda.set(buf, (float)(1.0 / params[1]));
                this.alpha.set(buf, (float)params[4]);
            }

            void setParams2(MemoryBuffer buf, double[] params) {
                this.vdwRadius.set(buf, (float)params[2]);
                this.oolambda.set(buf, (float)(1.0 / params[3]));
                this.alpha.set(buf, (float)params[5]);
            }
        }

        class SAtomPairEef1F64a
        extends Structs.Struct {
            final Structs.Int32 atomi1 = Structs.int32();
            final Structs.Int32 atomi2 = Structs.int32();

            SAtomPairEef1F64a(AmberEef1 this$1) {
            }

            void init() {
                this.init(8, "atomi1", "atomi2");
            }
        }

        class SAtomPairEef1F64b
        extends Structs.Struct {
            final Structs.Float64 vdwRadius = Structs.float64();
            final Structs.Float64 oolambda = Structs.float64();

            SAtomPairEef1F64b(AmberEef1 this$1) {
            }

            void init() {
                this.init(16, "vdwRadius", "oolambda");
            }

            void setParams1(MemoryBuffer buf, double[] params) {
                this.vdwRadius.set(buf, params[0]);
                this.oolambda.set(buf, 1.0 / params[1]);
            }

            void setParams2(MemoryBuffer buf, double[] params) {
                this.vdwRadius.set(buf, params[2]);
                this.oolambda.set(buf, 1.0 / params[3]);
            }
        }

        class SAtomPairEef1F64c
        extends Structs.Struct {
            final Structs.Float64 alpha1 = Structs.float64();
            final Structs.Float64 alpha2 = Structs.float64();

            SAtomPairEef1F64c(AmberEef1 this$1) {
            }

            void init() {
                this.init(16, "alpha1", "alpha2");
            }

            void setParams(MemoryBuffer buf, double[] params) {
                this.alpha1.set(buf, params[4]);
                this.alpha2.set(buf, params[5]);
            }
        }
    }

    private static interface ForcefieldsImpl {
        public double calc(Stream var1, ByteBuffer var2, ByteBuffer var3, ByteBuffer var4, long var5);

        public double minimize(Stream var1, ByteBuffer var2, ByteBuffer var3, ByteBuffer var4);

        public void minimizeBatch(Stream var1, ByteBuffer var2, ByteBuffer var3);

        public void dumpJobs(File var1, ByteBuffer var2);

        public long paramsBytes();

        public void writeParams(MemoryBuffer var1);

        public long staticStaticBytes();

        public long staticPosBytes(int var1, int var2);

        public long posBytes(int var1, int var2);

        public long posPosBytes(int var1, int var2, int var3, int var4);

        public void writeStaticStatic(MemoryBuffer var1);

        public void writeStaticPos(int var1, int var2, MemoryBuffer var3);

        public void writePos(int var1, int var2, MemoryBuffer var3);

        public void writePosPos(int var1, int var2, int var3, int var4, MemoryBuffer var5);
    }

    public static class GpuStreams {
        public final GpuInfo gpuInfo;
        public final int numStreams;

        public GpuStreams(GpuInfo gpuInfo, int numStreams) {
            this.gpuInfo = gpuInfo;
            this.numStreams = numStreams;
        }
    }

    static class SConfSpaceSizes
    extends Structs.Struct {
        Structs.Int64 num_pos = Structs.int64();
        Structs.Int64 max_num_inters = Structs.int64();
        Structs.Int64 num_atoms = Structs.int64();
        Structs.Int64 max_num_dofs = Structs.int64();
        Structs.Int64 num_mol_motions = Structs.int64();

        SConfSpaceSizes() {
        }

        SConfSpaceSizes init() {
            this.init(40, "num_pos", "max_num_inters", "num_atoms", "max_num_dofs", "num_mol_motions");
            return this;
        }
    }

    private static class Stream
    implements AutoCloseable {
        public final int device;
        public final Pointer pConfSpace;
        public final Pointer stream;

        public Stream(int device, Pointer pConfSpace, long hostBytes, long deviceBytes) {
            this.device = device;
            this.pConfSpace = pConfSpace;
            this.stream = NativeLib.alloc_stream(device, hostBytes, deviceBytes);
        }

        @Override
        public void close() {
            NativeLib.free_stream(this.device, this.stream);
        }
    }

    public class CheckedOutStream
    implements AutoCloseable {
        public final Stream stream;

        private CheckedOutStream(Stream stream) {
            this.stream = stream;
        }

        @Override
        public void close() {
            if (this.stream != null) {
                CudaConfEnergyCalculator.this.streamQueue.add(this.stream);
            }
        }
    }

    private static interface AtomPairWriter {
        public int size();

        public int atomi1(int var1);

        public int atomi2(int var1);

        public double[] params(int var1);
    }
}

