/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy.compiled;

import edu.duke.cs.osprey.energy.compiled.EnergyCalculator;

public class EEF1EnergyCalculator
implements EnergyCalculator {
    public static final EnergyCalculator.Type type = EnergyCalculator.Type.EEF1;
    private static final double cutoff = 9.0;
    public final String id;
    public final int ffi;

    public EEF1EnergyCalculator(String id, int ffi) {
        this.id = id;
        this.ffi = ffi;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public EnergyCalculator.Type type() {
        return type;
    }

    @Override
    public int ffi() {
        return this.ffi;
    }

    @Override
    public double calcEnergy(double r, double r2, double[] params) {
        double vdwRadius1 = params[0];
        double lambda1 = params[1];
        double vdwRadius2 = params[2];
        double lambda2 = params[3];
        double alpha1 = params[4];
        double alpha2 = params[5];
        if (r <= 9.0) {
            double Xij = (r - vdwRadius1) / lambda1;
            double Xji = (r - vdwRadius2) / lambda2;
            return -(alpha1 * Math.exp(-Xij * Xij) + alpha2 * Math.exp(-Xji * Xji)) / r2;
        }
        return 0.0;
    }
}

