/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy.forcefield;

import edu.duke.cs.osprey.energy.EnergyFunction;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldEnergy;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldParams;
import edu.duke.cs.osprey.restypes.ResidueTemplate;
import edu.duke.cs.osprey.structure.Residue;

public class SingleResEnergy
implements EnergyFunction {
    Residue res;
    ResidueTemplate templ;
    ForcefieldParams ffParams;
    ForcefieldEnergy ffEnergy;

    public SingleResEnergy(Residue res, ForcefieldParams ffParams) {
        this.res = res;
        this.ffParams = ffParams;
        this.templ = res.template;
        this.initFFE();
    }

    @Override
    public double getEnergy() {
        if (this.res.template != this.templ) {
            this.initFFE();
        }
        if (!this.res.confProblems.isEmpty()) {
            return Double.POSITIVE_INFINITY;
        }
        return this.ffEnergy.calculateTotalEnergy();
    }

    void initFFE() {
        this.ffEnergy = new ForcefieldEnergy(true, this.res.atoms, this.res.atoms, this.ffParams);
        this.templ = this.res.template;
    }

    public Residue getRes() {
        return this.res;
    }

    public ForcefieldParams getFFParams() {
        return this.ffParams;
    }

    public ForcefieldEnergy getFFEnergy() {
        return this.ffEnergy;
    }
}

