/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy.forcefield;

import edu.duke.cs.osprey.energy.EnergyFunction;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldEnergy;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldParams;
import edu.duke.cs.osprey.restypes.ResidueTemplate;
import edu.duke.cs.osprey.structure.Atom;
import edu.duke.cs.osprey.structure.Residue;
import java.util.ArrayList;

public class SparseFFEnergy
implements EnergyFunction {
    Residue res1;
    Residue res2;
    ResidueTemplate templ1 = null;
    ResidueTemplate templ2 = null;
    ForcefieldParams ffParams;
    ForcefieldEnergy ffEnergy;

    public SparseFFEnergy(ArrayList<Atom[]> interactingAtomPairs, ForcefieldParams ffParams) {
        this.res1 = interactingAtomPairs.get((int)0)[0].res;
        this.res2 = interactingAtomPairs.get((int)0)[1].res;
        this.ffParams = ffParams;
        this.templ1 = this.res1.template;
        this.templ2 = this.res2.template;
        this.ffEnergy = new ForcefieldEnergy(interactingAtomPairs, ffParams);
    }

    @Override
    public double getEnergy() {
        if (this.res1.template != this.templ1 || this.res2.template != this.templ2) {
            throw new RuntimeException("ERROR: Cannot calculate a SparseFFEnergy on residues mutated since the SparseFFEnergy was initialized");
        }
        if (!this.res1.confProblems.isEmpty() || !this.res2.confProblems.isEmpty()) {
            return Double.POSITIVE_INFINITY;
        }
        return this.ffEnergy.calculateTotalEnergy();
    }
}

