/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.ewakstar;

import edu.duke.cs.osprey.ewakstar.EWAKStarPartitionFunction;
import edu.duke.cs.osprey.tools.MathTools;
import java.math.BigDecimal;
import java.util.function.Function;

public class EWAKStarScore {
    public final EWAKStarPartitionFunction.Result protein;
    public final EWAKStarPartitionFunction.Result ligand;
    public final EWAKStarPartitionFunction.Result complex;
    public final BigDecimal score;
    public final BigDecimal lowerBound;
    public final BigDecimal upperBound;

    public EWAKStarScore(BigDecimal score, BigDecimal lowerBound, BigDecimal upperBound) {
        this.protein = null;
        this.ligand = null;
        this.complex = null;
        this.score = score;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public EWAKStarScore(EWAKStarPartitionFunction.Result protein, EWAKStarPartitionFunction.Result ligand, EWAKStarPartitionFunction.Result complex) {
        BigDecimal x;
        this.protein = protein;
        this.ligand = ligand;
        this.complex = complex;
        this.score = !(protein.status != EWAKStarPartitionFunction.Status.ConfLimitReached && protein.status != EWAKStarPartitionFunction.Status.EpsilonReached && protein.status != EWAKStarPartitionFunction.Status.EnergyReached || ligand.status != EWAKStarPartitionFunction.Status.ConfLimitReached && ligand.status != EWAKStarPartitionFunction.Status.EpsilonReached && ligand.status != EWAKStarPartitionFunction.Status.EnergyReached || complex.status != EWAKStarPartitionFunction.Status.ConfLimitReached && complex.status != EWAKStarPartitionFunction.Status.EpsilonReached && complex.status != EWAKStarPartitionFunction.Status.EnergyReached) ? (MathTools.isNaN(x = MathTools.bigDivideDivide(complex.values.qstar, protein.values.qstar, ligand.values.qstar, EWAKStarPartitionFunction.decimalPrecision)) ? null : x) : null;
        this.lowerBound = MathTools.bigDivideDivide(complex.values.calcLowerBound(), protein.values.calcUpperBound(), ligand.values.calcUpperBound(), EWAKStarPartitionFunction.decimalPrecision);
        this.upperBound = MathTools.bigDivideDivide(complex.values.calcUpperBound(), protein.values.calcLowerBound(), ligand.values.calcLowerBound(), EWAKStarPartitionFunction.decimalPrecision);
    }

    public static boolean isLigandComplexUseful(EWAKStarPartitionFunction.Result protein) {
        return protein.status != EWAKStarPartitionFunction.Status.Unstable;
    }

    public static boolean isComplexUseful(EWAKStarPartitionFunction.Result protein, EWAKStarPartitionFunction.Result ligand) {
        return protein.status != EWAKStarPartitionFunction.Status.Unstable && ligand.status != EWAKStarPartitionFunction.Status.Unstable;
    }

    public String toString() {
        Function<String, String> trim = s -> {
            if (s.length() > 9) {
                return s.substring(0, 9);
            }
            return s;
        };
        return String.format("%-9s in [%-9s,%9s] (log10)", trim.apply(this.scoreLog10String()), trim.apply(this.lowerBoundLog10String()), trim.apply(this.upperBoundLog10String()));
    }

    public boolean equals(Object other) {
        return other instanceof EWAKStarScore && this.equals((EWAKStarScore)other);
    }

    public boolean equals(EWAKStarScore other) {
        return MathTools.isSameValue(this.score, other.score) && MathTools.isSameValue(this.lowerBound, other.lowerBound) && MathTools.isSameValue(this.upperBound, other.upperBound);
    }

    public boolean isSimilarTo(EWAKStarScore other, double relativeEpsilon) {
        return MathTools.isRelativelySame(this.score, other.score, EWAKStarPartitionFunction.decimalPrecision, relativeEpsilon) && MathTools.isRelativelySame(this.lowerBound, other.lowerBound, EWAKStarPartitionFunction.decimalPrecision, relativeEpsilon) && MathTools.isRelativelySame(this.upperBound, other.upperBound, EWAKStarPartitionFunction.decimalPrecision, relativeEpsilon);
    }

    public Double scoreLog10() {
        return EWAKStarScore.scoreToLog10(this.score);
    }

    public Double lowerBoundLog10() {
        return EWAKStarScore.scoreToLog10(this.lowerBound);
    }

    public Double upperBoundLog10() {
        return EWAKStarScore.scoreToLog10(this.upperBound);
    }

    public String scoreLog10String() {
        return EWAKStarScore.scoreToLog10String(this.score);
    }

    public String lowerBoundLog10String() {
        return EWAKStarScore.scoreToLog10String(this.lowerBound);
    }

    public String upperBoundLog10String() {
        return EWAKStarScore.scoreToLog10String(this.upperBound);
    }

    public static Double scoreToLog10(BigDecimal score) {
        if (score != null) {
            return Math.log10(score.doubleValue());
        }
        return null;
    }

    public static String scoreToString(BigDecimal score) {
        if (score != null) {
            return String.format("%e", score.doubleValue());
        }
        return "none";
    }

    public static String scoreToLog10String(BigDecimal score) {
        if (score != null) {
            return String.format("%f", EWAKStarScore.scoreToLog10(score));
        }
        return "none";
    }
}

