/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gmec;

import edu.duke.cs.osprey.Queue;
import edu.duke.cs.osprey.astar.ConfTree;
import edu.duke.cs.osprey.astar.GMECMutSpace;
import edu.duke.cs.osprey.astar.conf.ConfAStarTree;
import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.ematrix.epic.EPICSettings;
import edu.duke.cs.osprey.energy.ConfEnergyCalculator;
import edu.duke.cs.osprey.energy.EnergyCalculator;
import edu.duke.cs.osprey.gmec.ConfPrinter;
import edu.duke.cs.osprey.gmec.GMECFinder;
import edu.duke.cs.osprey.gmec.PrecomputedMatrices;
import edu.duke.cs.osprey.gmec.PruningSettings;
import edu.duke.cs.osprey.gmec.SimpleGMECFinder;
import edu.duke.cs.osprey.tupexp.LUTESettings;

public class DEEGMECFinder
extends SimpleGMECFinder {
    public EnergyMatrix emat;
    public SimpleConfSpace confSpace;
    public EnergyCalculator ecalc;
    public double I0 = 5.0;
    public double Ew = 0.0;
    public boolean doIMinDEE = true;
    String name;
    String GMECMutFile = null;
    public EPICSettings epicSettings = new EPICSettings();
    public LUTESettings luteSettings = new LUTESettings();
    public PruningSettings pruningSettings = new PruningSettings();
    private PrecomputedMatrices precompMat = null;

    private DEEGMECFinder(EnergyMatrix emat, SimpleConfSpace confSpace, EnergyCalculator ecalc, ConfEnergyCalculator confEcalc, GMECFinder.ConfPruner pruner, ConfPrinter logPrinter, ConfPrinter consolePrinter, boolean printIntermediateConfsToConsole, String name) {
        super(null, confEcalc, pruner, logPrinter, consolePrinter, printIntermediateConfsToConsole, true, null);
        this.emat = emat;
        this.confSpace = confSpace;
        this.ecalc = ecalc;
        this.name = name;
    }

    public ConfSearch.EnergiedConf calcGMEC() {
        return (ConfSearch.EnergiedConf)this.calcGMEC(this.I0).poll();
    }

    public Queue.FIFO<ConfSearch.EnergiedConf> calcGMEC(double interval) {
        System.out.println("Calculating GMEC with interval = " + interval);
        boolean printEPICEnergy = this.epicSettings.shouldWeUseEPIC();
        if (this.epicSettings.shouldWeUseEPIC()) {
            this.checkEPICThresh2(interval);
        }
        this.precompMat = new PrecomputedMatrices(this.Ew + interval, this.Ew, this.name, this.emat, this.confSpace, this.ecalc, this.confEcalc, this.epicSettings, this.luteSettings, this.pruningSettings);
        this.search = this.prepareConfSearch();
        Queue.FIFO<ConfSearch.EnergiedConf> goodConfs = super.find(this.Ew);
        if (printEPICEnergy) {
            System.out.println("GMEC EPIC energy: " + this.precompMat.epicMat.minimizeEnergy(((ConfSearch.EnergiedConf)goodConfs.peek()).getAssignments()));
        }
        if (this.doIMinDEE) {
            double lowestBound = this.lowestPairwiseBound();
            double firstGMECEnergy = ((ConfSearch.EnergiedConf)goodConfs.peek()).getEnergy();
            if (firstGMECEnergy > lowestBound + interval) {
                System.out.println("Pruning interval is too small. minGMEC could have been pruned.");
                System.out.println("Will estimate new interval based on conformations evaluated so far and restart");
                double nextInterval = firstGMECEnergy - lowestBound;
                double intervalPad = 0.001;
                return this.calcGMEC(nextInterval += intervalPad);
            }
        }
        return goodConfs;
    }

    private double lowestPairwiseBound() {
        ConfSearch lbSearch = this.needHigherOrderTerms() || this.epicSettings.shouldWeUseEPIC() || this.GMECMutFile != null ? ConfTree.makeFull(this.precompMat, this.parseGMECMutFile(), false, false, new EPICSettings(), this.confSpace.getNumPos()) : new ConfAStarTree.Builder(this.emat, new RCs(this.precompMat.pruneMat)).build();
        System.out.println("Computing lowest pairwise-minimized bound");
        ConfSearch.ScoredConf lbConf = lbSearch.nextConf();
        double bound = lbConf == null ? Double.POSITIVE_INFINITY : lbConf.getScore();
        System.out.println("Lowest bound: " + bound);
        return bound;
    }

    private ConfSearch prepareConfSearch() {
        if (this.needHigherOrderTerms() || this.epicSettings.shouldWeUseEPIC() || this.GMECMutFile != null) {
            return ConfTree.makeFull(this.precompMat, this.parseGMECMutFile(), this.luteSettings.shouldWeUseLUTE(), this.epicSettings.shouldWeUseEPIC(), this.epicSettings, this.confSpace.getNumPos());
        }
        if (this.luteSettings.shouldWeUseLUTE()) {
            return new ConfAStarTree.Builder(this.precompMat.luteMat, new RCs(this.precompMat.pruneMat)).build();
        }
        return new ConfAStarTree.Builder(this.emat, new RCs(this.precompMat.pruneMat)).build();
    }

    private boolean needHigherOrderTerms() {
        if (this.luteSettings.shouldWeUseLUTE()) {
            return this.precompMat.luteMat.hasHigherOrderTerms();
        }
        return this.emat.hasHigherOrderTerms();
    }

    private void checkEPICThresh2(double curInterval) {
        if (curInterval + this.Ew > this.epicSettings.EPICThresh2) {
            System.out.println("Raising EPICThresh2 to " + (curInterval + this.Ew) + " based on iMinDEE interval and energy window");
            this.epicSettings.EPICThresh2 = curInterval + this.Ew;
        }
    }

    public GMECMutSpace parseGMECMutFile() {
        if (this.GMECMutFile == null) {
            return null;
        }
        return new GMECMutSpace(this.GMECMutFile, this.confSpace);
    }

    public static class Builder
    extends SimpleGMECFinder.Builder {
        EnergyMatrix emat;
        SimpleConfSpace confSpace;
        EnergyCalculator ecalc;
        String name;

        public Builder(EnergyMatrix emat, SimpleConfSpace confSpace, EnergyCalculator ecalc, ConfEnergyCalculator confEcalc, String name) {
            super(null, confEcalc);
            this.emat = emat;
            this.confSpace = confSpace;
            this.ecalc = ecalc;
            this.name = name;
        }

        @Override
        public DEEGMECFinder build() {
            return new DEEGMECFinder(this.emat, this.confSpace, this.ecalc, this.confEcalc, this.pruner, this.logPrinter, this.consolePrinter, this.printIntermediateConfsToConsole, this.name);
        }
    }
}

