/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gpu.cuda;

import edu.duke.cs.osprey.gpu.cuda.Gpu;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jcuda.CudaException;
import jcuda.driver.CUdevice;
import jcuda.driver.JCudaDriver;

public class Gpus {
    public static boolean printGpuInfo = true;
    private static Gpus instance = null;
    private List<Gpu> gpus;

    public static Gpus get() {
        if (instance == null) {
            instance = new Gpus();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Gpus() {
        block11: {
            this.print("Discovering CUDA GPUs...");
            this.gpus = new ArrayList<Gpu>();
            try {
                JCudaDriver.setExceptionsEnabled((boolean)true);
                JCudaDriver.cuInit((int)0);
                int[] ints = new int[1];
                JCudaDriver.cuDeviceGetCount((int[])ints);
                int count = ints[0];
                for (int i = 0; i < count; ++i) {
                    CUdevice device = new CUdevice();
                    JCudaDriver.cuDeviceGet((CUdevice)device, (int)i);
                    Gpu gpu = new Gpu(device);
                    if (!gpu.supportsDoubles()) continue;
                    this.gpus.add(gpu);
                }
            }
            catch (UnsatisfiedLinkError ex) {
                StringWriter buf = new StringWriter();
                ex.printStackTrace(new PrintWriter(buf));
                this.print(buf.toString());
            }
            catch (CudaException ex) {
                if (ex.getMessage().equals("CUDA_ERROR_NO_DEVICE")) {
                    break block11;
                }
                throw ex;
            }
            finally {
                if (this.gpus.isEmpty()) {
                    this.print(" none found\n");
                } else {
                    this.print(" found " + this.gpus.size() + "\n");
                }
            }
        }
    }

    public List<Gpu> getGpus() {
        return Collections.unmodifiableList(this.gpus);
    }

    private void print(String msg) {
        if (printGpuInfo) {
            System.out.print(msg);
        }
    }
}

