/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gpu.opencl;

import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLProgram;
import edu.duke.cs.osprey.tools.FileTools;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Gpu {
    private static final boolean DumpCompilerLog = false;
    private CLDevice device;
    private Map<String, CLProgram> programs;

    public Gpu(CLDevice device) {
        this.device = device;
        this.programs = new HashMap<String, CLProgram>();
    }

    public CLDevice getDevice() {
        return this.device;
    }

    public boolean supportsDoubles() {
        Set extensions = this.device.getExtensions();
        return extensions.contains("cl_khr_fp64") || extensions.contains("cl_amd_fp64");
    }

    public String toString() {
        return this.device.getName();
    }

    public CLProgram getProgram(String filename) throws IOException {
        CLProgram program = this.programs.get(filename);
        if (program != null) {
            return program;
        }
        return this.compileProgram(filename);
    }

    public CLProgram compileProgram(String filename) throws IOException {
        CLProgram cLProgram;
        block8: {
            InputStream in = FileTools.openResource("/gpuKernels/opencl/" + filename, this.getClass());
            try {
                CLProgram program = this.device.getContext().createProgram(in).build();
                this.programs.put(filename, program);
                cLProgram = program;
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new IOException(String.format("error compiling gpu program file: %s", filename), ex);
                }
            }
            in.close();
        }
        return cLProgram;
    }
}

