/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gui.compiler;

import edu.duke.cs.osprey.gui.io.ConfLib;
import edu.duke.cs.osprey.gui.prep.DesignPosition;
import edu.duke.cs.osprey.molscope.molecule.Molecule;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\bH\u0086\u0002\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\bJ(\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\b2\b\u0010\u001c\u001a\u0004\u0018\u00010\tH\u0086\u0002\u00a2\u0006\u0002\u0010\u001dR&\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0012\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Ledu/duke/cs/osprey/gui/compiler/MolNetCharges;", "", "mol", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "(Ledu/duke/cs/osprey/molscope/molecule/Molecule;)V", "charges", "Ljava/util/IdentityHashMap;", "Ledu/duke/cs/osprey/gui/prep/DesignPosition;", "Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;", "", "getMol", "()Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "netCharge", "getNetCharge", "()Ljava/lang/Integer;", "setNetCharge", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "netChargeOrThrow", "getNetChargeOrThrow", "()I", "get", "pos", "frag", "(Ledu/duke/cs/osprey/gui/prep/DesignPosition;Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;)Ljava/lang/Integer;", "getOrThrow", "set", "", "charge", "(Ledu/duke/cs/osprey/gui/prep/DesignPosition;Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;Ljava/lang/Integer;)V", "osprey3"})
@SourceDebugExtension(value={"SMAP\nNetCharges.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetCharges.kt\nedu/duke/cs/osprey/gui/compiler/MolNetCharges\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,87:1\n361#2,7:88\n361#2,7:95\n*S KotlinDebug\n*F\n+ 1 NetCharges.kt\nedu/duke/cs/osprey/gui/compiler/MolNetCharges\n*L\n71#1:88,7\n78#1:95,7\n*E\n"})
public final class MolNetCharges {
    @NotNull
    private final Molecule mol;
    @Nullable
    private Integer netCharge;
    @NotNull
    private final IdentityHashMap<DesignPosition, IdentityHashMap<ConfLib.Fragment, Integer>> charges;

    public MolNetCharges(@NotNull Molecule mol) {
        Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
        this.mol = mol;
        this.charges = new IdentityHashMap();
    }

    @NotNull
    public final Molecule getMol() {
        return this.mol;
    }

    @Nullable
    public final Integer getNetCharge() {
        return this.netCharge;
    }

    public final void setNetCharge(@Nullable Integer n) {
        this.netCharge = n;
    }

    public final int getNetChargeOrThrow() {
        Integer n = this.netCharge;
        if (n == null) {
            throw new IllegalStateException("molecule " + this.mol + " needs a net charge");
        }
        return n;
    }

    @Nullable
    public final Integer get(@NotNull DesignPosition pos, @NotNull ConfLib.Fragment frag) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)frag, (String)"frag");
        Map $this$getOrPut$iv = this.charges;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(pos);
        if (value$iv == null) {
            boolean bl = false;
            IdentityHashMap answer$iv = new IdentityHashMap();
            $this$getOrPut$iv.put(pos, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Integer)((IdentityHashMap)object).get(frag);
    }

    public final int getOrThrow(@NotNull DesignPosition pos, @NotNull ConfLib.Fragment frag) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)frag, (String)"frag");
        Integer n = this.get(pos, frag);
        if (n == null) {
            throw new NoSuchElementException("molecule " + this.mol + " needs a net charge for fragment " + frag.getId() + " at design position " + pos.getName());
        }
        return n;
    }

    public final void set(@NotNull DesignPosition pos, @NotNull ConfLib.Fragment frag, @Nullable Integer charge) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)frag, (String)"frag");
        Map $this$getOrPut$iv = this.charges;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(pos);
        if (value$iv == null) {
            boolean bl = false;
            IdentityHashMap answer$iv = new IdentityHashMap();
            $this$getOrPut$iv.put(pos, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        IdentityHashMap it = (IdentityHashMap)object;
        boolean bl = false;
        if (charge != null) {
            ((Map)it).put(frag, charge);
        } else {
            it.remove(frag);
        }
    }
}

