/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gui.forcefield.amber;

import edu.duke.cs.osprey.molscope.molecule.Atom;
import edu.duke.cs.osprey.molscope.molecule.Molecule;
import edu.duke.cs.osprey.molscope.molecule.Polymer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0011J\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J\u000e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0019\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u0016"}, d2={"Ledu/duke/cs/osprey/gui/forcefield/amber/MoleculeMapper;", "", "src", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "dst", "(Ledu/duke/cs/osprey/molscope/molecule/Molecule;Ledu/duke/cs/osprey/molscope/molecule/Molecule;)V", "getDst", "()Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "dstResidues", "", "Ledu/duke/cs/osprey/molscope/molecule/Polymer$Residue;", "getDstResidues", "()Ljava/util/List;", "getSrc", "srcResidues", "getSrcResidues", "mapAtom", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "srcAtom", "mapAtomOrThrow", "mapResidue", "srcRes", "osprey3"})
@SourceDebugExtension(value={"SMAP\nMoleculeMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MoleculeMapper.kt\nedu/duke/cs/osprey/gui/forcefield/amber/MoleculeMapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,48:1\n1360#2:49\n1446#2,5:50\n1360#2:55\n1446#2,5:56\n1#3:61\n*S KotlinDebug\n*F\n+ 1 MoleculeMapper.kt\nedu/duke/cs/osprey/gui/forcefield/amber/MoleculeMapper\n*L\n15#1:49\n15#1:50,5\n16#1:55\n16#1:56,5\n*E\n"})
public final class MoleculeMapper {
    @NotNull
    private final Molecule src;
    @NotNull
    private final Molecule dst;
    @Nullable
    private final List<Polymer.Residue> srcResidues;
    @Nullable
    private final List<Polymer.Residue> dstResidues;

    public MoleculeMapper(@NotNull Molecule src, @NotNull Molecule dst) {
        List list;
        List list2;
        Iterable list$iv$iv;
        Polymer.Chain it;
        Iterable $this$flatMapTo$iv$iv;
        boolean $i$f$flatMapTo;
        Collection destination$iv$iv;
        Iterable $this$flatMap$iv;
        boolean $i$f$flatMap;
        MoleculeMapper moleculeMapper;
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        this.src = src;
        this.dst = dst;
        MoleculeMapper moleculeMapper2 = this;
        Molecule molecule = this.src;
        Object object = molecule instanceof Polymer ? (Polymer)molecule : null;
        if (object != null && (object = ((Polymer)object).getChains()) != null) {
            Iterable iterable = (Iterable)object;
            moleculeMapper = moleculeMapper2;
            $i$f$flatMap = false;
            void var6_7 = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (Polymer.Chain)element$iv$iv;
                boolean bl = false;
                list$iv$iv = it.getResidues();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list2 = (List)destination$iv$iv;
            moleculeMapper2 = moleculeMapper;
        } else {
            list2 = null;
        }
        moleculeMapper2.srcResidues = list2;
        MoleculeMapper moleculeMapper3 = this;
        molecule = this.dst;
        Object object2 = molecule instanceof Polymer ? (Polymer)molecule : null;
        if (object2 != null && (object2 = ((Polymer)object2).getChains()) != null) {
            $this$flatMap$iv = (Iterable)object2;
            moleculeMapper = moleculeMapper3;
            $i$f$flatMap = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (Polymer.Chain)element$iv$iv;
                boolean bl = false;
                list$iv$iv = it.getResidues();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
            moleculeMapper3 = moleculeMapper;
        } else {
            list = null;
        }
        moleculeMapper3.dstResidues = list;
    }

    @NotNull
    public final Molecule getSrc() {
        return this.src;
    }

    @NotNull
    public final Molecule getDst() {
        return this.dst;
    }

    @Nullable
    public final List<Polymer.Residue> getSrcResidues() {
        return this.srcResidues;
    }

    @Nullable
    public final List<Polymer.Residue> getDstResidues() {
        return this.dstResidues;
    }

    @NotNull
    public final Polymer.Residue mapResidue(@NotNull Polymer.Residue srcRes) {
        Intrinsics.checkNotNullParameter((Object)srcRes, (String)"srcRes");
        Intrinsics.checkNotNull(this.srcResidues);
        Intrinsics.checkNotNull(this.dstResidues);
        if (this.srcResidues.size() != this.dstResidues.size()) {
            throw new Error("Amber didn't preserve residue list");
        }
        return this.dstResidues.get(this.srcResidues.indexOf(srcRes));
    }

    @Nullable
    public final Atom mapAtom(@NotNull Atom srcAtom) {
        Atom atom;
        Intrinsics.checkNotNullParameter((Object)srcAtom, (String)"srcAtom");
        if (this.src instanceof Polymer) {
            Object v1;
            block5: {
                Polymer.Residue residue = ((Polymer)this.src).findResidue(srcAtom);
                if (residue == null) {
                    return null;
                }
                Polymer.Residue srcRes = residue;
                Polymer.Residue dstRes = this.mapResidue(srcRes);
                Iterable iterable = dstRes.getAtoms();
                for (Object t : iterable) {
                    Atom it = (Atom)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)srcAtom.getName())) continue;
                    v1 = t;
                    break block5;
                }
                v1 = null;
            }
            atom = v1;
        } else {
            Object v3;
            block6: {
                Iterable iterable = this.dst.getAtoms();
                for (Object t : iterable) {
                    Atom it = (Atom)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)srcAtom.getName())) continue;
                    v3 = t;
                    break block6;
                }
                v3 = null;
            }
            atom = v3;
        }
        return atom;
    }

    @NotNull
    public final Atom mapAtomOrThrow(@NotNull Atom srcAtom) {
        Intrinsics.checkNotNullParameter((Object)srcAtom, (String)"srcAtom");
        Atom atom = this.mapAtom(srcAtom);
        if (atom == null) {
            throw new NoSuchElementException("can't match atom " + srcAtom);
        }
        return atom;
    }
}

