/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gui.io;

import edu.duke.cs.osprey.gui.io.ConfLib;
import edu.duke.cs.osprey.gui.io.TomlKt;
import edu.duke.cs.osprey.gui.io.TomlParseException;
import edu.duke.cs.osprey.molscope.molecule.Atom;
import edu.duke.cs.osprey.molscope.molecule.Element;
import edu.duke.cs.osprey.molscope.tools.LangKt;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.tomlj.Toml;
import org.tomlj.TomlArray;
import org.tomlj.TomlParseResult;
import org.tomlj.TomlPosition;
import org.tomlj.TomlTable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u0000 #2\u00020\u0001:\n\u001d\u001e\u001f !\"#$%&BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0007J\u000e\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0003J\u0016\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003J\b\u0010\u001c\u001a\u00020\u0003H\u0016R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0011\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\f\u00a8\u0006'"}, d2={"Ledu/duke/cs/osprey/gui/io/ConfLib;", "", "id", "", "name", "fragments", "", "Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;", "description", "citation", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;Ljava/lang/String;)V", "getCitation", "()Ljava/lang/String;", "getDescription", "getFragments", "()Ljava/util/Map;", "getId", "getName", "runtimeId", "getRuntimeId", "confRuntimeId", "frag", "conf", "Ledu/duke/cs/osprey/gui/io/ConfLib$Conf;", "fragRuntimeId", "getFragmentOrThrow", "fragId", "invertChirality", "toString", "Anchor", "AnchorAtomPointer", "AnchorCoords", "AtomInfo", "AtomPointer", "Bond", "Companion", "Conf", "ContinuousMotion", "Fragment", "osprey3"})
@SourceDebugExtension(value={"SMAP\nConfLib.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfLib.kt\nedu/duke/cs/osprey/gui/io/ConfLib\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,934:1\n125#2:935\n152#2,2:936\n125#2:938\n152#2,2:939\n125#2:941\n152#2,3:942\n125#2:945\n152#2,3:946\n154#2:949\n154#2:950\n*S KotlinDebug\n*F\n+ 1 ConfLib.kt\nedu/duke/cs/osprey/gui/io/ConfLib\n*L\n62#1:935\n62#1:936,2\n63#1:938\n63#1:939,2\n64#1:941\n64#1:942,3\n68#1:945\n68#1:946,3\n63#1:949\n62#1:950\n*E\n"})
public final class ConfLib {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final Map<String, Fragment> fragments;
    @Nullable
    private final String description;
    @Nullable
    private final String citation;
    @NotNull
    private final String runtimeId;
    private static int nextId;

    public ConfLib(@NotNull String id, @NotNull String name, @NotNull Map<String, Fragment> fragments, @Nullable String description, @Nullable String citation) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(fragments, (String)"fragments");
        this.id = id;
        this.name = name;
        this.fragments = fragments;
        this.description = description;
        this.citation = citation;
        int n = nextId;
        nextId = n + 1;
        this.runtimeId = "library-" + n;
    }

    public /* synthetic */ ConfLib(String string, String string2, Map map, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string3 = null;
        }
        if ((n & 0x10) != 0) {
            string4 = null;
        }
        this(string, string2, map, string3, string4);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Map<String, Fragment> getFragments() {
        return this.fragments;
    }

    @Nullable
    public final String getDescription() {
        return this.description;
    }

    @Nullable
    public final String getCitation() {
        return this.citation;
    }

    @NotNull
    public final String getRuntimeId() {
        return this.runtimeId;
    }

    @NotNull
    public final String fragRuntimeId(@NotNull Fragment frag) {
        Intrinsics.checkNotNullParameter((Object)frag, (String)"frag");
        return this.runtimeId + "." + frag.getId();
    }

    @NotNull
    public final String confRuntimeId(@NotNull Fragment frag, @NotNull Conf conf) {
        Intrinsics.checkNotNullParameter((Object)frag, (String)"frag");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        return this.runtimeId + "." + frag.getId() + "." + conf.getId();
    }

    @NotNull
    public final Fragment getFragmentOrThrow(@NotNull String fragId) {
        Intrinsics.checkNotNullParameter((Object)fragId, (String)"fragId");
        Fragment fragment = this.fragments.get(fragId);
        if (fragment == null) {
            throw new NoSuchElementException("no fragment found with id " + fragId);
        }
        return fragment;
    }

    @NotNull
    public String toString() {
        return this.name + " (" + this.runtimeId + ")";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ConfLib invertChirality(@NotNull String id, @NotNull String name) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Map<String, Fragment> $this$map$iv = this.fragments;
        boolean $i$f$map = false;
        Map<String, Fragment> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv2;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String fragId = (String)entry.getKey();
            Fragment frag = (Fragment)entry.getValue();
            Map<String, Conf> $this$map$iv2 = frag.getConfs();
            boolean $i$f$map2 = false;
            Map<String, Conf> map2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
            boolean $i$f$mapTo2 = false;
            Iterator iterator3 = $this$mapTo$iv$iv2.entrySet().iterator();
            while (iterator3.hasNext()) {
                void $this$mapTo$iv$iv3;
                Collection collection2;
                void $this$mapTo$iv$iv4;
                Map.Entry item$iv$iv2;
                Map.Entry entry2 = item$iv$iv2 = iterator3.next();
                Collection collection3 = destination$iv$iv2;
                boolean bl2 = false;
                String confId = (String)entry2.getKey();
                Conf conf = (Conf)entry2.getValue();
                Map<AtomInfo, Vector3d> $this$map$iv3 = conf.getCoords();
                boolean $i$f$map3 = false;
                Map<AtomInfo, Vector3d> map3 = $this$map$iv3;
                Object destination$iv$iv3 = new ArrayList($this$map$iv3.size());
                boolean $i$f$mapTo3 = false;
                Iterator iterator4 = $this$mapTo$iv$iv4.entrySet().iterator();
                while (iterator4.hasNext()) {
                    Map.Entry item$iv$iv3;
                    Map.Entry entry3 = item$iv$iv3 = iterator4.next();
                    collection2 = destination$iv$iv3;
                    boolean bl3 = false;
                    AtomInfo atomInfo = (AtomInfo)entry3.getKey();
                    Vector3d vector = (Vector3d)entry3.getValue();
                    collection2.add(TuplesKt.to((Object)atomInfo, (Object)new Vector3d(vector.x, vector.y, -vector.z)));
                }
                Map invertedCoords = MapsKt.toMap((Iterable)((List)destination$iv$iv3));
                Map<Anchor, AnchorCoords> $this$map$iv4 = conf.getAnchorCoords();
                boolean $i$f$map4 = false;
                destination$iv$iv3 = $this$map$iv4;
                Collection destination$iv$iv4 = new ArrayList($this$map$iv4.size());
                boolean $i$f$mapTo4 = false;
                Iterator iterator5 = $this$mapTo$iv$iv3.entrySet().iterator();
                while (iterator5.hasNext()) {
                    Map.Entry item$iv$iv4;
                    Map.Entry entry4 = item$iv$iv4 = iterator5.next();
                    collection2 = destination$iv$iv4;
                    boolean bl4 = false;
                    Anchor anchor = (Anchor)entry4.getKey();
                    AnchorCoords anchorCoords = (AnchorCoords)entry4.getValue();
                    collection2.add(TuplesKt.to((Object)anchor, (Object)anchorCoords.invertChirality()));
                }
                Map invertedAnchorCoords = MapsKt.toMap((Iterable)((List)destination$iv$iv4));
                collection3.add(TuplesKt.to((Object)confId, (Object)new Conf(conf.getId(), conf.getName(), conf.getDescription(), invertedCoords, invertedAnchorCoords)));
            }
            Map invertedConfs = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
            Fragment dFrag = new Fragment(frag.getId(), frag.getName(), frag.getType(), frag.getAtoms(), frag.getBonds(), frag.getAnchors(), invertedConfs, frag.getMotions());
            collection.add(TuplesKt.to((Object)fragId, (Object)dFrag));
        }
        Map invertedFrags = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        return new ConfLib(id, name, invertedFrags, this.description, this.citation);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000f2\u00020\u0001:\u0003\u000f\u0010\u0011B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH&J&\u0010\f\u001a\u0004\u0018\u00010\u00002\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00000\bH&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\u0012\u0013\u00a8\u0006\u0014"}, d2={"Ledu/duke/cs/osprey/gui/io/ConfLib$Anchor;", "", "()V", "id", "", "getId", "()I", "findAtoms", "", "Ledu/duke/cs/osprey/gui/io/ConfLib$AtomInfo;", "frag", "Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;", "matchIn", "atoms", "anchors", "Companion", "Double", "Single", "Ledu/duke/cs/osprey/gui/io/ConfLib$Anchor$Double;", "Ledu/duke/cs/osprey/gui/io/ConfLib$Anchor$Single;", "osprey3"})
    public static abstract sealed class Anchor {
        @NotNull
        public static final Companion Companion = new Companion(null);

        private Anchor() {
        }

        public abstract int getId();

        @Nullable
        public abstract Anchor matchIn(@NotNull List<AtomInfo> var1, @NotNull List<? extends Anchor> var2);

        @NotNull
        public abstract List<AtomInfo> findAtoms(@NotNull Fragment var1);

        public /* synthetic */ Anchor(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005\u00a8\u0006\t"}, d2={"Ledu/duke/cs/osprey/gui/io/ConfLib$Anchor$Companion;", "", "()V", "findAtoms", "", "Ledu/duke/cs/osprey/gui/io/ConfLib$AtomInfo;", "frag", "Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;", "source", "osprey3"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<AtomInfo> findAtoms(@NotNull Fragment frag, @NotNull AtomInfo source) {
                Intrinsics.checkNotNullParameter((Object)frag, (String)"frag");
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                ArrayDeque<AtomInfo> toVisit = new ArrayDeque<AtomInfo>();
                Set<AtomInfo> visitScheduled = LangKt.identityHashSet();
                edu.duke.cs.osprey.gui.io.ConfLib$Anchor$Companion.findAtoms$scheduleVisit(toVisit, visitScheduled, source);
                ArrayList<AtomInfo> out = new ArrayList<AtomInfo>();
                while (toVisit.pollFirst() != null) {
                    AtomInfo atom;
                    out.add(atom);
                    for (AtomInfo bondedAtom : frag.bondedAtoms(atom)) {
                        if (visitScheduled.contains(bondedAtom)) continue;
                        edu.duke.cs.osprey.gui.io.ConfLib$Anchor$Companion.findAtoms$scheduleVisit(toVisit, visitScheduled, bondedAtom);
                    }
                }
                return out;
            }

            private static final void findAtoms$scheduleVisit(ArrayDeque<AtomInfo> toVisit, Set<AtomInfo> visitScheduled, AtomInfo atom) {
                toVisit.add(atom);
                visitScheduled.add(atom);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J3\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J+\u0010\u001a\u001a\t\u0018\u00010\u0000\u00a2\u0006\u0002\b\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u0016J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"Ledu/duke/cs/osprey/gui/io/ConfLib$Anchor$Double;", "Ledu/duke/cs/osprey/gui/io/ConfLib$Anchor;", "id", "", "bondsa", "", "Ledu/duke/cs/osprey/gui/io/ConfLib$AtomInfo;", "bondsb", "(ILjava/util/List;Ljava/util/List;)V", "getBondsa", "()Ljava/util/List;", "getBondsb", "getId", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "", "findAtoms", "frag", "Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;", "hashCode", "matchIn", "Lkotlin/internal/NoInfer;", "atoms", "anchors", "toString", "", "osprey3"})
        @SourceDebugExtension(value={"SMAP\nConfLib.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfLib.kt\nedu/duke/cs/osprey/gui/io/ConfLib$Anchor$Double\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,934:1\n800#2,11:935\n1726#2,3:946\n1726#2,3:949\n1360#2:952\n1446#2,2:953\n1360#2:955\n1446#2,5:956\n1448#2,3:961\n*S KotlinDebug\n*F\n+ 1 ConfLib.kt\nedu/duke/cs/osprey/gui/io/ConfLib$Anchor$Double\n*L\n145#1:935,11\n147#1:946,3\n148#1:949,3\n153#1:952\n153#1:953,2\n154#1:955\n154#1:956,5\n153#1:961,3\n*E\n"})
        public static final class Double
        extends Anchor {
            private final int id;
            @NotNull
            private final List<AtomInfo> bondsa;
            @NotNull
            private final List<AtomInfo> bondsb;

            public Double(int id, @NotNull List<AtomInfo> bondsa, @NotNull List<AtomInfo> bondsb) {
                Intrinsics.checkNotNullParameter(bondsa, (String)"bondsa");
                Intrinsics.checkNotNullParameter(bondsb, (String)"bondsb");
                super(null);
                this.id = id;
                this.bondsa = bondsa;
                this.bondsb = bondsb;
            }

            @Override
            public int getId() {
                return this.id;
            }

            @NotNull
            public final List<AtomInfo> getBondsa() {
                return this.bondsa;
            }

            @NotNull
            public final List<AtomInfo> getBondsb() {
                return this.bondsb;
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @Override
            @Nullable
            public Double matchIn(@NotNull List<AtomInfo> atoms, @NotNull List<? extends Anchor> anchors) {
                Object e;
                Object v0;
                boolean bl;
                void $this$filterIsInstanceTo$iv$iv;
                Intrinsics.checkNotNullParameter(atoms, (String)"atoms");
                Intrinsics.checkNotNullParameter(anchors, (String)"anchors");
                Iterable $this$filterIsInstance$iv = anchors;
                boolean $i$f$filterIsInstance = false;
                Object object = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof Double)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable iterable = (List)destination$iv$iv;
                object = iterable.iterator();
                do {
                    AtomInfo it;
                    boolean bl2;
                    boolean $i$f$all;
                    Iterable $this$all$iv;
                    Double it2;
                    block11: {
                        if (!object.hasNext()) {
                            v0 = null;
                            return v0;
                        }
                        e = object.next();
                        it2 = (Double)e;
                        boolean bl3 = false;
                        $this$all$iv = it2.bondsa;
                        $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl2 = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                it = (AtomInfo)element$iv;
                                boolean bl4 = false;
                                if (it.matchIn((List)atoms, (List)anchors) != null) continue;
                                bl2 = false;
                                break block11;
                            }
                            bl2 = true;
                        }
                    }
                    if (bl2) {
                        boolean bl5;
                        block12: {
                            $this$all$iv = it2.bondsb;
                            $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl5 = true;
                            } else {
                                for (Object element$iv : $this$all$iv) {
                                    it = (AtomInfo)element$iv;
                                    boolean bl6 = false;
                                    if (it.matchIn((List)atoms, (List)anchors) != null) continue;
                                    bl5 = false;
                                    break block12;
                                }
                                bl5 = true;
                            }
                        }
                        if (bl5) {
                            bl = true;
                            continue;
                        }
                    }
                    bl = false;
                } while (!bl);
                v0 = e;
                return v0;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @NotNull
            public List<AtomInfo> findAtoms(@NotNull Fragment frag) {
                void $this$flatMapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)frag, (String)"frag");
                Object[] objectArray = new List[]{this.bondsa, this.bondsb};
                Iterable $this$flatMap$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    void $this$flatMapTo$iv$iv2;
                    List bonds2 = (List)element$iv$iv;
                    boolean bl = false;
                    Iterable $this$flatMap$iv2 = bonds2;
                    boolean $i$f$flatMap2 = false;
                    Iterable iterable2 = $this$flatMap$iv2;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$flatMapTo2 = false;
                    for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                        AtomInfo it = (AtomInfo)element$iv$iv2;
                        boolean bl2 = false;
                        Iterable list$iv$iv = Companion.findAtoms(frag, it);
                        CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                    }
                    Iterable list$iv$iv = (List)destination$iv$iv2;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                return CollectionsKt.toList((Iterable)CollectionsKt.toCollection((Iterable)((List)destination$iv$iv), (Collection)LangKt.identityHashSet()));
            }

            public final int component1() {
                return this.id;
            }

            @NotNull
            public final List<AtomInfo> component2() {
                return this.bondsa;
            }

            @NotNull
            public final List<AtomInfo> component3() {
                return this.bondsb;
            }

            @NotNull
            public final Double copy(int id, @NotNull List<AtomInfo> bondsa, @NotNull List<AtomInfo> bondsb) {
                Intrinsics.checkNotNullParameter(bondsa, (String)"bondsa");
                Intrinsics.checkNotNullParameter(bondsb, (String)"bondsb");
                return new Double(id, bondsa, bondsb);
            }

            public static /* synthetic */ Double copy$default(Double double_, int n, List list, List list2, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = double_.id;
                }
                if ((n2 & 2) != 0) {
                    list = double_.bondsa;
                }
                if ((n2 & 4) != 0) {
                    list2 = double_.bondsb;
                }
                return double_.copy(n, list, list2);
            }

            @NotNull
            public String toString() {
                return "Double(id=" + this.id + ", bondsa=" + this.bondsa + ", bondsb=" + this.bondsb + ")";
            }

            public int hashCode() {
                int result = Integer.hashCode(this.id);
                result = result * 31 + ((Object)this.bondsa).hashCode();
                result = result * 31 + ((Object)this.bondsb).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Double)) {
                    return false;
                }
                Double double_ = (Double)other;
                if (this.id != double_.id) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.bondsa, double_.bondsa)) {
                    return false;
                }
                return Intrinsics.areEqual(this.bondsb, double_.bondsb);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J+\u0010\u0017\u001a\t\u0018\u00010\u0000\u00a2\u0006\u0002\b\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u0016J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Ledu/duke/cs/osprey/gui/io/ConfLib$Anchor$Single;", "Ledu/duke/cs/osprey/gui/io/ConfLib$Anchor;", "id", "", "bonds", "", "Ledu/duke/cs/osprey/gui/io/ConfLib$AtomInfo;", "(ILjava/util/List;)V", "getBonds", "()Ljava/util/List;", "getId", "()I", "component1", "component2", "copy", "equals", "", "other", "", "findAtoms", "frag", "Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;", "hashCode", "matchIn", "Lkotlin/internal/NoInfer;", "atoms", "anchors", "toString", "", "osprey3"})
        @SourceDebugExtension(value={"SMAP\nConfLib.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfLib.kt\nedu/duke/cs/osprey/gui/io/ConfLib$Anchor$Single\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,934:1\n800#2,11:935\n1726#2,3:947\n1360#2:950\n1446#2,5:951\n1#3:946\n*S KotlinDebug\n*F\n+ 1 ConfLib.kt\nedu/duke/cs/osprey/gui/io/ConfLib$Anchor$Single\n*L\n127#1:935,11\n128#1:947,3\n132#1:950\n132#1:951,5\n*E\n"})
        public static final class Single
        extends Anchor {
            private final int id;
            @NotNull
            private final List<AtomInfo> bonds;

            public Single(int id, @NotNull List<AtomInfo> bonds2) {
                Intrinsics.checkNotNullParameter(bonds2, (String)"bonds");
                super(null);
                this.id = id;
                this.bonds = bonds2;
            }

            @Override
            public int getId() {
                return this.id;
            }

            @NotNull
            public final List<AtomInfo> getBonds() {
                return this.bonds;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @Nullable
            public Single matchIn(@NotNull List<AtomInfo> atoms, @NotNull List<? extends Anchor> anchors) {
                Object v1;
                block6: {
                    void $this$filterIsInstanceTo$iv$iv;
                    Intrinsics.checkNotNullParameter(atoms, (String)"atoms");
                    Intrinsics.checkNotNullParameter(anchors, (String)"anchors");
                    Iterable $this$filterIsInstance$iv = anchors;
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof Single)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable iterable2 = (List)destination$iv$iv;
                    for (Object e : iterable2) {
                        boolean bl;
                        block5: {
                            Single it = (Single)e;
                            boolean bl2 = false;
                            Iterable $this$all$iv = it.bonds;
                            boolean $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl = true;
                            } else {
                                for (Object element$iv : $this$all$iv) {
                                    AtomInfo it2 = (AtomInfo)element$iv;
                                    boolean bl3 = false;
                                    if (it2.matchIn((List)atoms, (List)anchors) != null) continue;
                                    bl = false;
                                    break block5;
                                }
                                bl = true;
                            }
                        }
                        if (!bl) continue;
                        v1 = e;
                        break block6;
                    }
                    v1 = null;
                }
                return v1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @NotNull
            public List<AtomInfo> findAtoms(@NotNull Fragment frag) {
                void $this$flatMapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)frag, (String)"frag");
                Iterable $this$flatMap$iv = this.bonds;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    AtomInfo it = (AtomInfo)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = Companion.findAtoms(frag, it);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                return CollectionsKt.toList((Iterable)CollectionsKt.toCollection((Iterable)((List)destination$iv$iv), (Collection)LangKt.identityHashSet()));
            }

            public final int component1() {
                return this.id;
            }

            @NotNull
            public final List<AtomInfo> component2() {
                return this.bonds;
            }

            @NotNull
            public final Single copy(int id, @NotNull List<AtomInfo> bonds2) {
                Intrinsics.checkNotNullParameter(bonds2, (String)"bonds");
                return new Single(id, bonds2);
            }

            public static /* synthetic */ Single copy$default(Single single, int n, List list, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = single.id;
                }
                if ((n2 & 2) != 0) {
                    list = single.bonds;
                }
                return single.copy(n, list);
            }

            @NotNull
            public String toString() {
                return "Single(id=" + this.id + ", bonds=" + this.bonds + ")";
            }

            public int hashCode() {
                int result = Integer.hashCode(this.id);
                result = result * 31 + ((Object)this.bonds).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Single)) {
                    return false;
                }
                Single single = (Single)other;
                if (this.id != single.id) {
                    return false;
                }
                return Intrinsics.areEqual(this.bonds, single.bonds);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J&\u0010\u0013\u001a\u0004\u0018\u00010\u00002\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001e"}, d2={"Ledu/duke/cs/osprey/gui/io/ConfLib$AnchorAtomPointer;", "Ledu/duke/cs/osprey/gui/io/ConfLib$AtomPointer;", "anchor", "Ledu/duke/cs/osprey/gui/io/ConfLib$Anchor;", "index", "", "(Ledu/duke/cs/osprey/gui/io/ConfLib$Anchor;I)V", "getAnchor", "()Ledu/duke/cs/osprey/gui/io/ConfLib$Anchor;", "getIndex", "()I", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "matchIn", "atoms", "", "Ledu/duke/cs/osprey/gui/io/ConfLib$AtomInfo;", "anchors", "resolveCoords", "Lorg/joml/Vector3d;", "conf", "Ledu/duke/cs/osprey/gui/io/ConfLib$Conf;", "toString", "", "osprey3"})
    public static final class AnchorAtomPointer
    implements AtomPointer {
        @NotNull
        private final Anchor anchor;
        private final int index;

        public AnchorAtomPointer(@NotNull Anchor anchor, int index) {
            Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
            this.anchor = anchor;
            this.index = index;
        }

        @NotNull
        public final Anchor getAnchor() {
            return this.anchor;
        }

        public final int getIndex() {
            return this.index;
        }

        @Override
        @Nullable
        public AnchorAtomPointer matchIn(@NotNull List<AtomInfo> atoms, @NotNull List<? extends Anchor> anchors) {
            AnchorAtomPointer anchorAtomPointer;
            Intrinsics.checkNotNullParameter(atoms, (String)"atoms");
            Intrinsics.checkNotNullParameter(anchors, (String)"anchors");
            Anchor anchor = this.anchor.matchIn(atoms, anchors);
            if (anchor != null) {
                Anchor it = anchor;
                boolean bl = false;
                anchorAtomPointer = new AnchorAtomPointer(it, this.index);
            } else {
                anchorAtomPointer = null;
            }
            return anchorAtomPointer;
        }

        @Override
        @Nullable
        public Vector3d resolveCoords(@NotNull Conf conf) {
            Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
            AnchorCoords anchorCoords = conf.getAnchorCoords().get(this.anchor);
            return anchorCoords != null ? anchorCoords.getCoords(this.index) : null;
        }

        @NotNull
        public String toString() {
            return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + "[" + this.anchor.getId() + "," + this.index + "]";
        }

        @Override
        @NotNull
        public AtomPointer matchInOrThrow(@NotNull List<AtomInfo> atoms, @NotNull List<? extends Anchor> anchors) {
            return AtomPointer.DefaultImpls.matchInOrThrow(this, atoms, anchors);
        }

        @Override
        @NotNull
        public Vector3d resolveCoordsOrThrow(@NotNull Conf conf) {
            return AtomPointer.DefaultImpls.resolveCoordsOrThrow(this, conf);
        }

        @NotNull
        public final Anchor component1() {
            return this.anchor;
        }

        public final int component2() {
            return this.index;
        }

        @NotNull
        public final AnchorAtomPointer copy(@NotNull Anchor anchor, int index) {
            Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
            return new AnchorAtomPointer(anchor, index);
        }

        public static /* synthetic */ AnchorAtomPointer copy$default(AnchorAtomPointer anchorAtomPointer, Anchor anchor, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                anchor = anchorAtomPointer.anchor;
            }
            if ((n2 & 2) != 0) {
                n = anchorAtomPointer.index;
            }
            return anchorAtomPointer.copy(anchor, n);
        }

        public int hashCode() {
            int result = this.anchor.hashCode();
            result = result * 31 + Integer.hashCode(this.index);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AnchorAtomPointer)) {
                return false;
            }
            AnchorAtomPointer anchorAtomPointer = (AnchorAtomPointer)other;
            if (!Intrinsics.areEqual((Object)this.anchor, (Object)anchorAtomPointer.anchor)) {
                return false;
            }
            return this.index == anchorAtomPointer.index;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\b\tB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&J\b\u0010\u0007\u001a\u00020\u0000H&\u0082\u0001\u0002\n\u000b\u00a8\u0006\f"}, d2={"Ledu/duke/cs/osprey/gui/io/ConfLib$AnchorCoords;", "", "()V", "getCoords", "Lorg/joml/Vector3d;", "index", "", "invertChirality", "Double", "Single", "Ledu/duke/cs/osprey/gui/io/ConfLib$AnchorCoords$Double;", "Ledu/duke/cs/osprey/gui/io/ConfLib$AnchorCoords$Single;", "osprey3"})
    public static abstract sealed class AnchorCoords {
        private AnchorCoords() {
        }

        @Nullable
        public abstract Vector3d getCoords(int var1);

        @NotNull
        public abstract AnchorCoords invertChirality();

        public /* synthetic */ AnchorCoords(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\t\u0010\u0019\u001a\u00020\u0018H\u00d6\u0001J\b\u0010\u001a\u001a\u00020\u0001H\u0016J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u001d"}, d2={"Ledu/duke/cs/osprey/gui/io/ConfLib$AnchorCoords$Double;", "Ledu/duke/cs/osprey/gui/io/ConfLib$AnchorCoords;", "a", "Lorg/joml/Vector3d;", "b", "c", "d", "(Lorg/joml/Vector3d;Lorg/joml/Vector3d;Lorg/joml/Vector3d;Lorg/joml/Vector3d;)V", "getA", "()Lorg/joml/Vector3d;", "getB", "getC", "getD", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "getCoords", "index", "", "hashCode", "invertChirality", "toString", "", "osprey3"})
        public static final class Double
        extends AnchorCoords {
            @NotNull
            private final Vector3d a;
            @NotNull
            private final Vector3d b;
            @NotNull
            private final Vector3d c;
            @NotNull
            private final Vector3d d;

            public Double(@NotNull Vector3d a, @NotNull Vector3d b, @NotNull Vector3d c, @NotNull Vector3d d) {
                Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                Intrinsics.checkNotNullParameter((Object)d, (String)"d");
                super(null);
                this.a = a;
                this.b = b;
                this.c = c;
                this.d = d;
            }

            @NotNull
            public final Vector3d getA() {
                return this.a;
            }

            @NotNull
            public final Vector3d getB() {
                return this.b;
            }

            @NotNull
            public final Vector3d getC() {
                return this.c;
            }

            @NotNull
            public final Vector3d getD() {
                return this.d;
            }

            @Override
            @Nullable
            public Vector3d getCoords(int index) {
                return switch (index) {
                    case 0 -> this.a;
                    case 1 -> this.b;
                    case 2 -> this.c;
                    case 3 -> this.d;
                    default -> null;
                };
            }

            @Override
            @NotNull
            public AnchorCoords invertChirality() {
                return new Double(new Vector3d(this.a.x, this.a.y, -this.a.z), new Vector3d(this.b.x, this.b.y, -this.b.z), new Vector3d(this.c.x, this.c.y, -this.c.z), new Vector3d(this.d.x, this.d.y, -this.d.z));
            }

            @NotNull
            public final Vector3d component1() {
                return this.a;
            }

            @NotNull
            public final Vector3d component2() {
                return this.b;
            }

            @NotNull
            public final Vector3d component3() {
                return this.c;
            }

            @NotNull
            public final Vector3d component4() {
                return this.d;
            }

            @NotNull
            public final Double copy(@NotNull Vector3d a, @NotNull Vector3d b, @NotNull Vector3d c, @NotNull Vector3d d) {
                Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                Intrinsics.checkNotNullParameter((Object)d, (String)"d");
                return new Double(a, b, c, d);
            }

            public static /* synthetic */ Double copy$default(Double double_, Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, Vector3d vector3d4, int n, Object object) {
                if ((n & 1) != 0) {
                    vector3d = double_.a;
                }
                if ((n & 2) != 0) {
                    vector3d2 = double_.b;
                }
                if ((n & 4) != 0) {
                    vector3d3 = double_.c;
                }
                if ((n & 8) != 0) {
                    vector3d4 = double_.d;
                }
                return double_.copy(vector3d, vector3d2, vector3d3, vector3d4);
            }

            @NotNull
            public String toString() {
                return "Double(a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", d=" + this.d + ")";
            }

            public int hashCode() {
                int result = this.a.hashCode();
                result = result * 31 + this.b.hashCode();
                result = result * 31 + this.c.hashCode();
                result = result * 31 + this.d.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Double)) {
                    return false;
                }
                Double double_ = (Double)other;
                if (!Intrinsics.areEqual((Object)this.a, (Object)double_.a)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.b, (Object)double_.b)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.c, (Object)double_.c)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.d, (Object)double_.d);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\t\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001J\b\u0010\u0017\u001a\u00020\u0001H\u0016J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u001a"}, d2={"Ledu/duke/cs/osprey/gui/io/ConfLib$AnchorCoords$Single;", "Ledu/duke/cs/osprey/gui/io/ConfLib$AnchorCoords;", "a", "Lorg/joml/Vector3d;", "b", "c", "(Lorg/joml/Vector3d;Lorg/joml/Vector3d;Lorg/joml/Vector3d;)V", "getA", "()Lorg/joml/Vector3d;", "getB", "getC", "component1", "component2", "component3", "copy", "equals", "", "other", "", "getCoords", "index", "", "hashCode", "invertChirality", "toString", "", "osprey3"})
        public static final class Single
        extends AnchorCoords {
            @NotNull
            private final Vector3d a;
            @NotNull
            private final Vector3d b;
            @NotNull
            private final Vector3d c;

            public Single(@NotNull Vector3d a, @NotNull Vector3d b, @NotNull Vector3d c) {
                Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                super(null);
                this.a = a;
                this.b = b;
                this.c = c;
            }

            @NotNull
            public final Vector3d getA() {
                return this.a;
            }

            @NotNull
            public final Vector3d getB() {
                return this.b;
            }

            @NotNull
            public final Vector3d getC() {
                return this.c;
            }

            @Override
            @Nullable
            public Vector3d getCoords(int index) {
                return switch (index) {
                    case 0 -> this.a;
                    case 1 -> this.b;
                    case 2 -> this.c;
                    default -> null;
                };
            }

            @Override
            @NotNull
            public AnchorCoords invertChirality() {
                return new Single(new Vector3d(this.a.x, this.a.y, -this.a.z), new Vector3d(this.b.x, this.b.y, -this.b.z), new Vector3d(this.c.x, this.c.y, -this.c.z));
            }

            @NotNull
            public final Vector3d component1() {
                return this.a;
            }

            @NotNull
            public final Vector3d component2() {
                return this.b;
            }

            @NotNull
            public final Vector3d component3() {
                return this.c;
            }

            @NotNull
            public final Single copy(@NotNull Vector3d a, @NotNull Vector3d b, @NotNull Vector3d c) {
                Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                return new Single(a, b, c);
            }

            public static /* synthetic */ Single copy$default(Single single, Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, int n, Object object) {
                if ((n & 1) != 0) {
                    vector3d = single.a;
                }
                if ((n & 2) != 0) {
                    vector3d2 = single.b;
                }
                if ((n & 4) != 0) {
                    vector3d3 = single.c;
                }
                return single.copy(vector3d, vector3d2, vector3d3);
            }

            @NotNull
            public String toString() {
                return "Single(a=" + this.a + ", b=" + this.b + ", c=" + this.c + ")";
            }

            public int hashCode() {
                int result = this.a.hashCode();
                result = result * 31 + this.b.hashCode();
                result = result * 31 + this.c.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Single)) {
                    return false;
                }
                Single single = (Single)other;
                if (!Intrinsics.areEqual((Object)this.a, (Object)single.a)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.b, (Object)single.b)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.c, (Object)single.c);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J&\u0010\u0018\u001a\u0004\u0018\u00010\u00002\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00000\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001aH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\t\u0010!\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\""}, d2={"Ledu/duke/cs/osprey/gui/io/ConfLib$AtomInfo;", "Ledu/duke/cs/osprey/gui/io/ConfLib$AtomPointer;", "id", "", "name", "", "element", "Ledu/duke/cs/osprey/molscope/molecule/Element;", "(ILjava/lang/String;Ledu/duke/cs/osprey/molscope/molecule/Element;)V", "getElement", "()Ledu/duke/cs/osprey/molscope/molecule/Element;", "getId", "()I", "getName", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "matchIn", "atoms", "", "anchors", "Ledu/duke/cs/osprey/gui/io/ConfLib$Anchor;", "resolveCoords", "Lorg/joml/Vector3d;", "conf", "Ledu/duke/cs/osprey/gui/io/ConfLib$Conf;", "toString", "osprey3"})
    @SourceDebugExtension(value={"SMAP\nConfLib.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfLib.kt\nedu/duke/cs/osprey/gui/io/ConfLib$AtomInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,934:1\n1#2:935\n*E\n"})
    public static final class AtomInfo
    implements AtomPointer {
        private final int id;
        @NotNull
        private final String name;
        @NotNull
        private final Element element;

        public AtomInfo(int id, @NotNull String name, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)element), (String)"element");
            this.id = id;
            this.name = name;
            this.element = element;
        }

        public final int getId() {
            return this.id;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Element getElement() {
            return this.element;
        }

        @Override
        @Nullable
        public AtomInfo matchIn(@NotNull List<AtomInfo> atoms, @NotNull List<? extends Anchor> anchors) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter(atoms, (String)"atoms");
                Intrinsics.checkNotNullParameter(anchors, (String)"anchors");
                Iterable iterable = atoms;
                for (Object t : iterable) {
                    AtomInfo it = (AtomInfo)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.name, (Object)this.name)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @Override
        @Nullable
        public Vector3d resolveCoords(@NotNull Conf conf) {
            Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
            return conf.getCoords().get(this);
        }

        @Override
        @NotNull
        public AtomPointer matchInOrThrow(@NotNull List<AtomInfo> atoms, @NotNull List<? extends Anchor> anchors) {
            return AtomPointer.DefaultImpls.matchInOrThrow(this, atoms, anchors);
        }

        @Override
        @NotNull
        public Vector3d resolveCoordsOrThrow(@NotNull Conf conf) {
            return AtomPointer.DefaultImpls.resolveCoordsOrThrow(this, conf);
        }

        public final int component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final Element component3() {
            return this.element;
        }

        @NotNull
        public final AtomInfo copy(int id, @NotNull String name, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)element), (String)"element");
            return new AtomInfo(id, name, element);
        }

        public static /* synthetic */ AtomInfo copy$default(AtomInfo atomInfo, int n, String string, Element element, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = atomInfo.id;
            }
            if ((n2 & 2) != 0) {
                string = atomInfo.name;
            }
            if ((n2 & 4) != 0) {
                element = atomInfo.element;
            }
            return atomInfo.copy(n, string, element);
        }

        @NotNull
        public String toString() {
            return "AtomInfo(id=" + this.id + ", name=" + this.name + ", element=" + this.element + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.id);
            result = result * 31 + this.name.hashCode();
            result = result * 31 + this.element.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AtomInfo)) {
                return false;
            }
            AtomInfo atomInfo = (AtomInfo)other;
            if (this.id != atomInfo.id) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)atomInfo.name)) {
                return false;
            }
            return this.element == atomInfo.element;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u0000 \u000e2\u00020\u0001:\u0003\u000e\u000f\u0010J&\u0010\u0002\u001a\u0004\u0018\u00010\u00002\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004H&J$\u0010\b\u001a\u00020\u00002\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH&J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u0011"}, d2={"Ledu/duke/cs/osprey/gui/io/ConfLib$AtomPointer;", "", "matchIn", "atoms", "", "Ledu/duke/cs/osprey/gui/io/ConfLib$AtomInfo;", "anchors", "Ledu/duke/cs/osprey/gui/io/ConfLib$Anchor;", "matchInOrThrow", "resolveCoords", "Lorg/joml/Vector3d;", "conf", "Ledu/duke/cs/osprey/gui/io/ConfLib$Conf;", "resolveCoordsOrThrow", "Companion", "NoAtomException", "Resolver", "osprey3"})
    public static interface AtomPointer {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        @Nullable
        public AtomPointer matchIn(@NotNull List<AtomInfo> var1, @NotNull List<? extends Anchor> var2);

        @NotNull
        public AtomPointer matchInOrThrow(@NotNull List<AtomInfo> var1, @NotNull List<? extends Anchor> var2);

        @Nullable
        public Vector3d resolveCoords(@NotNull Conf var1);

        @NotNull
        public Vector3d resolveCoordsOrThrow(@NotNull Conf var1);

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ledu/duke/cs/osprey/gui/io/ConfLib$AtomPointer$Companion;", "", "()V", "osprey3"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            static {
                $$INSTANCE = new Companion();
            }
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            @NotNull
            public static AtomPointer matchInOrThrow(@NotNull AtomPointer $this, @NotNull List<AtomInfo> atoms, @NotNull List<? extends Anchor> anchors) {
                Intrinsics.checkNotNullParameter(atoms, (String)"atoms");
                Intrinsics.checkNotNullParameter(anchors, (String)"anchors");
                AtomPointer atomPointer = $this.matchIn(atoms, anchors);
                if (atomPointer == null) {
                    throw new NoSuchElementException("no match found for " + $this);
                }
                return atomPointer;
            }

            @NotNull
            public static Vector3d resolveCoordsOrThrow(@NotNull AtomPointer $this, @NotNull Conf conf) {
                Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
                Vector3d vector3d = $this.resolveCoords(conf);
                if (vector3d == null) {
                    throw new NoSuchElementException("no coords found for atom pointer " + $this);
                }
                return vector3d;
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ledu/duke/cs/osprey/gui/io/ConfLib$AtomPointer$NoAtomException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "p", "Ledu/duke/cs/osprey/gui/io/ConfLib$AtomPointer;", "(Ledu/duke/cs/osprey/gui/io/ConfLib$AtomPointer;)V", "getP", "()Ledu/duke/cs/osprey/gui/io/ConfLib$AtomPointer;", "osprey3"})
        public static final class NoAtomException
        extends RuntimeException {
            @NotNull
            private final AtomPointer p;

            public NoAtomException(@NotNull AtomPointer p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                super("can't find atom from pointer: " + p);
                this.p = p;
            }

            @NotNull
            public final AtomPointer getP() {
                return this.p;
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Ledu/duke/cs/osprey/gui/io/ConfLib$AtomPointer$Resolver;", "", "resolve", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "p", "Ledu/duke/cs/osprey/gui/io/ConfLib$AtomPointer;", "resolveOrThrow", "osprey3"})
        public static interface Resolver {
            @Nullable
            public Atom resolve(@NotNull AtomPointer var1);

            @NotNull
            public Atom resolveOrThrow(@NotNull AtomPointer var1);

            @Metadata(mv={1, 8, 0}, k=3, xi=48)
            public static final class DefaultImpls {
                @NotNull
                public static Atom resolveOrThrow(@NotNull Resolver $this, @NotNull AtomPointer p) {
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    Atom atom = $this.resolve(p);
                    if (atom == null) {
                        throw new NoAtomException(p);
                    }
                    return atom;
                }
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Ledu/duke/cs/osprey/gui/io/ConfLib$Bond;", "", "a", "Ledu/duke/cs/osprey/gui/io/ConfLib$AtomInfo;", "b", "(Ledu/duke/cs/osprey/gui/io/ConfLib$AtomInfo;Ledu/duke/cs/osprey/gui/io/ConfLib$AtomInfo;)V", "getA", "()Ledu/duke/cs/osprey/gui/io/ConfLib$AtomInfo;", "getB", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "osprey3"})
    public static final class Bond {
        @NotNull
        private final AtomInfo a;
        @NotNull
        private final AtomInfo b;

        public Bond(@NotNull AtomInfo a, @NotNull AtomInfo b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            this.a = a;
            this.b = b;
        }

        @NotNull
        public final AtomInfo getA() {
            return this.a;
        }

        @NotNull
        public final AtomInfo getB() {
            return this.b;
        }

        @NotNull
        public final AtomInfo component1() {
            return this.a;
        }

        @NotNull
        public final AtomInfo component2() {
            return this.b;
        }

        @NotNull
        public final Bond copy(@NotNull AtomInfo a, @NotNull AtomInfo b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return new Bond(a, b);
        }

        public static /* synthetic */ Bond copy$default(Bond bond, AtomInfo atomInfo, AtomInfo atomInfo2, int n, Object object) {
            if ((n & 1) != 0) {
                atomInfo = bond.a;
            }
            if ((n & 2) != 0) {
                atomInfo2 = bond.b;
            }
            return bond.copy(atomInfo, atomInfo2);
        }

        @NotNull
        public String toString() {
            return "Bond(a=" + this.a + ", b=" + this.b + ")";
        }

        public int hashCode() {
            int result = this.a.hashCode();
            result = result * 31 + this.b.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Bond)) {
                return false;
            }
            Bond bond = (Bond)other;
            if (!Intrinsics.areEqual((Object)this.a, (Object)bond.a)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.b, (Object)bond.b);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\u0007J\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ledu/duke/cs/osprey/gui/io/ConfLib$Companion;", "", "()V", "nextId", "", "fragmentsFrom", "", "", "Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;", "toml", "doc", "Lorg/tomlj/TomlTable;", "from", "Ledu/duke/cs/osprey/gui/io/ConfLib;", "osprey3"})
    @SourceDebugExtension(value={"SMAP\nConfLib.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfLib.kt\nedu/duke/cs/osprey/gui/io/ConfLib$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,934:1\n125#2:935\n152#2,3:936\n125#2:939\n152#2,3:940\n125#2:943\n152#2,3:944\n1549#3:947\n1620#3,3:948\n*S KotlinDebug\n*F\n+ 1 ConfLib.kt\nedu/duke/cs/osprey/gui/io/ConfLib$Companion\n*L\n665#1:935\n665#1:936,3\n667#1:939\n667#1:940,3\n669#1:943\n669#1:944,3\n531#1:947\n531#1:948,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ConfLib from(@NotNull String toml) {
            Intrinsics.checkNotNullParameter((Object)toml, (String)"toml");
            TomlParseResult doc = Toml.parse((String)toml);
            if (doc.hasErrors()) {
                List list = doc.errors();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"doc.errors()");
                throw new TomlParseException("TOML parsing failure:\n" + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, 2, null);
            }
            Intrinsics.checkNotNullExpressionValue((Object)doc, (String)"doc");
            return this.from((TomlTable)doc);
        }

        @NotNull
        public final ConfLib from(@NotNull TomlTable doc) {
            Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
            String libId = TomlKt.getStringOrThrow$default(doc, "id", null, 2, null);
            String libName = TomlKt.getStringOrThrow$default(doc, "name", null, 2, null);
            String libDesc = doc.getString("description");
            String citation = doc.getString("citation");
            Map<String, Fragment> frags = this.fragmentsFrom(doc);
            return new ConfLib(libId, libName, frags, libDesc, citation);
        }

        @NotNull
        public final Map<String, Fragment> fragmentsFrom(@NotNull String toml) {
            Intrinsics.checkNotNullParameter((Object)toml, (String)"toml");
            TomlParseResult doc = Toml.parse((String)toml);
            if (doc.hasErrors()) {
                List list = doc.errors();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"doc.errors()");
                throw new TomlParseException("TOML parsing failure:\n" + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, 2, null);
            }
            Intrinsics.checkNotNullExpressionValue((Object)doc, (String)"doc");
            return this.fragmentsFrom((TomlTable)doc);
        }

        @NotNull
        public final Map<String, Fragment> fragmentsFrom(@NotNull TomlTable doc) {
            Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
            HashMap frags = new HashMap();
            TomlTable tomlTable = doc.getTable("frag");
            if (tomlTable == null) {
                return frags;
            }
            TomlTable fragsTable = tomlTable;
            for (String fragId : fragsTable.keySet()) {
                Collection<ContinuousMotion> collection;
                Collection<Anchor> collection2;
                Collection<AtomInfo> collection3;
                Map $this$mapTo$iv$iv;
                Map $this$map$iv;
                Object motionTable;
                Object object;
                Intrinsics.checkNotNullExpressionValue((Object)fragId, (String)"fragId");
                TomlTable fragTable = TomlKt.getTableOrThrow$default(fragsTable, fragId, null, 2, null);
                TomlPosition fragPos = fragsTable.inputPositionOf(fragId);
                String string = fragTable.getString("name");
                if (string == null) {
                    string = fragId;
                }
                String fragName = string;
                String fragType = TomlKt.getStringOrThrow$default(fragTable, "type", null, 2, null);
                HashMap<Integer, AtomInfo> atoms = new HashMap<Integer, AtomInfo>();
                TomlArray atomsArray = TomlKt.getArrayOrThrow(fragTable, "atoms", fragPos);
                int n = atomsArray.size();
                for (int i = 0; i < n; ++i) {
                    TomlTable atomTable = atomsArray.getTable(i);
                    TomlPosition pos = atomsArray.inputPositionOf(i);
                    Intrinsics.checkNotNullExpressionValue((Object)atomTable, (String)"atomTable");
                    int id = TomlKt.getIntOrThrow(atomTable, "id", pos);
                    Integer n2 = id;
                    ((Map)atoms).put(n2, new AtomInfo(id, TomlKt.getStringOrThrow(atomTable, "name", pos), Element.Companion.get(TomlKt.getStringOrThrow(atomTable, "elem", pos))));
                }
                ArrayList<Bond> bonds2 = new ArrayList<Bond>();
                TomlArray bondsArray = TomlKt.getArrayOrThrow(fragTable, "bonds", fragPos);
                int pos = bondsArray.size();
                for (int i = 0; i < pos; ++i) {
                    TomlArray bondArray = bondsArray.getArray(i);
                    TomlPosition pos2 = bondsArray.inputPositionOf(i);
                    Intrinsics.checkNotNullExpressionValue((Object)bondArray, (String)"bondArray");
                    bonds2.add(new Bond(edu.duke.cs.osprey.gui.io.ConfLib$Companion.fragmentsFrom$getAtom(atoms, fragId, TomlKt.getInt(bondArray, 0), pos2), edu.duke.cs.osprey.gui.io.ConfLib$Companion.fragmentsFrom$getAtom(atoms, fragId, TomlKt.getInt(bondArray, 1), pos2)));
                }
                HashMap<Integer, Anchor> anchors = new HashMap<Integer, Anchor>();
                TomlArray anchorArray = TomlKt.getArrayOrThrow(fragTable, "anchors", fragPos);
                int pos2 = anchorArray.size();
                for (int i = 0; i < pos2; ++i) {
                    Anchor anchor;
                    String string2;
                    TomlTable anchorTable = anchorArray.getTable(i);
                    TomlPosition pos3 = anchorArray.inputPositionOf(i);
                    Intrinsics.checkNotNullExpressionValue((Object)anchorTable, (String)"anchorTable");
                    int id = TomlKt.getIntOrThrow(anchorTable, "id", pos3);
                    String string3 = anchorTable.getString("type");
                    if (string3 != null) {
                        String string4 = string3.toLowerCase(Locale.ROOT);
                        string2 = string4;
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    } else {
                        string2 = null;
                    }
                    String type = string2;
                    object = anchors;
                    Integer n3 = id;
                    Object object2 = type;
                    if (Intrinsics.areEqual((Object)object2, (Object)"single")) {
                        TomlArray tomlArray = TomlKt.getArrayOrThrow(anchorTable, "bonds", pos3);
                        Intrinsics.checkNotNullExpressionValue((Object)pos3, (String)"pos");
                        anchor = new Anchor.Single(id, edu.duke.cs.osprey.gui.io.ConfLib$Companion.fragmentsFrom$toBonds(tomlArray, atoms, fragId, pos3));
                    } else if (Intrinsics.areEqual((Object)object2, (Object)"double")) {
                        TomlArray tomlArray = TomlKt.getArrayOrThrow(anchorTable, "bondsa", pos3);
                        Intrinsics.checkNotNullExpressionValue((Object)pos3, (String)"pos");
                        anchor = new Anchor.Double(id, edu.duke.cs.osprey.gui.io.ConfLib$Companion.fragmentsFrom$toBonds(tomlArray, atoms, fragId, pos3), edu.duke.cs.osprey.gui.io.ConfLib$Companion.fragmentsFrom$toBonds(TomlKt.getArrayOrThrow(anchorTable, "bondsb", pos3), atoms, fragId, pos3));
                    } else {
                        throw new TomlParseException("unrecognized anchor type: " + type, pos3);
                    }
                    object2 = anchor;
                    object.put(n3, object2);
                }
                HashMap confs = new HashMap();
                TomlTable confsTable = TomlKt.getTableOrThrow(fragTable, "conf", fragPos);
                for (String confId : confsTable.keySet()) {
                    Intrinsics.checkNotNullExpressionValue((Object)confId, (String)"confId");
                    TomlTable confTable = TomlKt.getTableOrThrow$default(confsTable, confId, null, 2, null);
                    TomlPosition confPos = confsTable.inputPositionOf(confId);
                    String string5 = confTable.getString("name");
                    if (string5 == null) {
                        string5 = confId;
                    }
                    String name = string5;
                    String desc = confTable.getString("description");
                    IdentityHashMap coords = new IdentityHashMap();
                    IdentityHashMap anchorCoords = new IdentityHashMap();
                    TomlArray coordsArray = TomlKt.getArrayOrThrow(confTable, "coords", confPos);
                    int n4 = coordsArray.size();
                    for (int i = 0; i < n4; ++i) {
                        TomlTable coordTable = coordsArray.getTable(i);
                        TomlPosition pos4 = coordsArray.inputPositionOf(i);
                        Intrinsics.checkNotNullExpressionValue((Object)coordTable, (String)"coordTable");
                        AtomInfo atomInfo = edu.duke.cs.osprey.gui.io.ConfLib$Companion.fragmentsFrom$getAtom$default(atoms, fragId, TomlKt.getIntOrThrow(coordTable, "id", pos4), null, 8, null);
                        ((Map)coords).put(atomInfo, edu.duke.cs.osprey.gui.io.ConfLib$Companion.fragmentsFrom$toVector3d(TomlKt.getArrayOrThrow(coordTable, "xyz", pos4)));
                    }
                    TomlArray anchorCoordsArray = TomlKt.getArrayOrThrow(confTable, "anchorCoords", confPos);
                    int n5 = anchorCoordsArray.size();
                    for (int i2 = 0; i2 < n5; ++i2) {
                        AnchorCoords anchorCoords2;
                        TomlTable coordTable = anchorCoordsArray.getTable(i2);
                        TomlPosition pos5 = anchorCoordsArray.inputPositionOf(i2);
                        Intrinsics.checkNotNullExpressionValue((Object)coordTable, (String)"coordTable");
                        Anchor anchor = edu.duke.cs.osprey.gui.io.ConfLib$Companion.fragmentsFrom$getAnchor$default(anchors, fragId, TomlKt.getIntOrThrow(coordTable, "id", pos5), null, 8, null);
                        Map map = anchorCoords;
                        Object object3 = anchor;
                        if (object3 instanceof Anchor.Single) {
                            anchorCoords2 = new AnchorCoords.Single(edu.duke.cs.osprey.gui.io.ConfLib$Companion.fragmentsFrom$toVector3d(TomlKt.getArrayOrThrow(coordTable, "a", pos5)), edu.duke.cs.osprey.gui.io.ConfLib$Companion.fragmentsFrom$toVector3d(TomlKt.getArrayOrThrow(coordTable, "b", pos5)), edu.duke.cs.osprey.gui.io.ConfLib$Companion.fragmentsFrom$toVector3d(TomlKt.getArrayOrThrow(coordTable, "c", pos5)));
                        } else if (object3 instanceof Anchor.Double) {
                            anchorCoords2 = new AnchorCoords.Double(edu.duke.cs.osprey.gui.io.ConfLib$Companion.fragmentsFrom$toVector3d(TomlKt.getArrayOrThrow(coordTable, "a", pos5)), edu.duke.cs.osprey.gui.io.ConfLib$Companion.fragmentsFrom$toVector3d(TomlKt.getArrayOrThrow(coordTable, "b", pos5)), edu.duke.cs.osprey.gui.io.ConfLib$Companion.fragmentsFrom$toVector3d(TomlKt.getArrayOrThrow(coordTable, "c", pos5)), edu.duke.cs.osprey.gui.io.ConfLib$Companion.fragmentsFrom$toVector3d(TomlKt.getArrayOrThrow(coordTable, "d", pos5)));
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        object3 = anchorCoords2;
                        map.put(anchor, object3);
                    }
                    ((Map)confs).put(confId, new Conf(confId, name, desc, coords, anchorCoords));
                }
                HashMap motions = new HashMap();
                TomlArray motionsArray = TomlKt.getArrayOrThrow(fragTable, "motions", fragPos);
                int n6 = motionsArray.size();
                for (int i = 0; i < n6; ++i) {
                    motionTable = motionsArray.getTable(i);
                    TomlPosition pos6 = motionsArray.inputPositionOf(i);
                    Intrinsics.checkNotNullExpressionValue((Object)motionTable, (String)"motionTable");
                    int id = TomlKt.getIntOrThrow(motionTable, "id", pos6);
                    String type = TomlKt.getStringOrThrow(motionTable, "type", pos6);
                    if (!Intrinsics.areEqual((Object)type, (Object)"dihedral")) {
                        throw new TomlParseException("unrecognized degree of freedom type: " + type, pos6);
                    }
                    Integer i2 = id;
                    Map map = motions;
                    Object object4 = motionTable.get("a");
                    Intrinsics.checkNotNullExpressionValue((Object)pos6, (String)"pos");
                    map.put(i2, new ContinuousMotion.DihedralAngle(id, edu.duke.cs.osprey.gui.io.ConfLib$Companion.fragmentsFrom$makeAtomPointer(atoms, fragId, anchors, object4, pos6), edu.duke.cs.osprey.gui.io.ConfLib$Companion.fragmentsFrom$makeAtomPointer(atoms, fragId, anchors, motionTable.get("b"), pos6), edu.duke.cs.osprey.gui.io.ConfLib$Companion.fragmentsFrom$makeAtomPointer(atoms, fragId, anchors, motionTable.get("c"), pos6), edu.duke.cs.osprey.gui.io.ConfLib$Companion.fragmentsFrom$makeAtomPointer(atoms, fragId, anchors, motionTable.get("d"), pos6)));
                }
                Map map = frags;
                String string6 = fragId;
                motionTable = atoms;
                String string7 = fragType;
                String string8 = fragName;
                String string9 = fragId;
                boolean $i$f$map = false;
                void id = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry item$iv$iv;
                    Map.Entry entry = item$iv$iv = iterator2.next();
                    collection3 = destination$iv$iv;
                    boolean bl = false;
                    AtomInfo atom = (AtomInfo)entry.getValue();
                    collection3.add(atom);
                }
                collection3 = (List)destination$iv$iv;
                $this$map$iv = anchors;
                List list = bonds2;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList($this$map$iv.size());
                $i$f$mapTo = false;
                iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry item$iv$iv;
                    Map.Entry entry = item$iv$iv = iterator2.next();
                    collection2 = destination$iv$iv;
                    boolean bl = false;
                    Anchor anchor = (Anchor)entry.getValue();
                    collection2.add(anchor);
                }
                collection2 = (List)destination$iv$iv;
                $this$map$iv = motions;
                Map map2 = confs;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList($this$map$iv.size());
                $i$f$mapTo = false;
                iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry item$iv$iv;
                    Map.Entry entry = item$iv$iv = iterator2.next();
                    collection = destination$iv$iv;
                    boolean bl = false;
                    ContinuousMotion motion = (ContinuousMotion)entry.getValue();
                    collection.add(motion);
                }
                Collection<ContinuousMotion> collection4 = collection = (List)destination$iv$iv;
                Map map3 = map2;
                Collection<Anchor> collection5 = collection2;
                List list2 = list;
                Collection<AtomInfo> collection6 = collection3;
                String string10 = string7;
                String string11 = string8;
                String string12 = string9;
                object = new Fragment(string12, string11, string10, (List<AtomInfo>)collection6, list2, (List<? extends Anchor>)collection5, map3, (List<? extends ContinuousMotion>)collection4);
                map.put(string6, object);
            }
            return frags;
        }

        private static final AtomInfo fragmentsFrom$getAtom(HashMap<Integer, AtomInfo> atoms, String fragId, int id, TomlPosition pos) {
            AtomInfo atomInfo = atoms.get(id);
            if (atomInfo == null) {
                throw new TomlParseException("no atom with id " + id + " in fragment " + fragId, pos);
            }
            return atomInfo;
        }

        static /* synthetic */ AtomInfo fragmentsFrom$getAtom$default(HashMap hashMap, String string, int n, TomlPosition tomlPosition, int n2, Object object) {
            if ((n2 & 8) != 0) {
                tomlPosition = null;
            }
            return edu.duke.cs.osprey.gui.io.ConfLib$Companion.fragmentsFrom$getAtom(hashMap, string, n, tomlPosition);
        }

        /*
         * WARNING - void declaration
         */
        private static final List<AtomInfo> fragmentsFrom$toBonds(TomlArray $this$fragmentsFrom_u24toBonds, HashMap<Integer, AtomInfo> atoms, String fragId, TomlPosition pos) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = (Iterable)RangesKt.until((int)0, (int)$this$fragmentsFrom_u24toBonds.size());
            boolean $i$f$map = false;
            void var6_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void i;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(edu.duke.cs.osprey.gui.io.ConfLib$Companion.fragmentsFrom$getAtom(atoms, fragId, TomlKt.getInt($this$fragmentsFrom_u24toBonds, (int)i), pos));
            }
            return (List)destination$iv$iv;
        }

        private static final Anchor fragmentsFrom$getAnchor(HashMap<Integer, Anchor> anchors, String fragId, int id, TomlPosition pos) {
            Anchor anchor = anchors.get(id);
            if (anchor == null) {
                throw new TomlParseException("no anchor with id " + id + " in fragment " + fragId, pos);
            }
            return anchor;
        }

        static /* synthetic */ Anchor fragmentsFrom$getAnchor$default(HashMap hashMap, String string, int n, TomlPosition tomlPosition, int n2, Object object) {
            if ((n2 & 8) != 0) {
                tomlPosition = null;
            }
            return edu.duke.cs.osprey.gui.io.ConfLib$Companion.fragmentsFrom$getAnchor(hashMap, string, n, tomlPosition);
        }

        private static final Vector3d fragmentsFrom$toVector3d(TomlArray $this$fragmentsFrom_u24toVector3d) {
            return new Vector3d($this$fragmentsFrom_u24toVector3d.getDouble(0), $this$fragmentsFrom_u24toVector3d.getDouble(1), $this$fragmentsFrom_u24toVector3d.getDouble(2));
        }

        private static final AtomPointer fragmentsFrom$makeAtomPointer(HashMap<Integer, AtomInfo> atoms, String fragId, HashMap<Integer, Anchor> anchors, Object key, TomlPosition pos) {
            AtomPointer atomPointer;
            Object object = key;
            if (object instanceof Long) {
                atomPointer = edu.duke.cs.osprey.gui.io.ConfLib$Companion.fragmentsFrom$getAtom(atoms, fragId, (int)((Number)key).longValue(), pos);
            } else if (object instanceof TomlArray) {
                if (((TomlArray)key).size() != 2 || !((TomlArray)key).containsLongs()) {
                    throw new TomlParseException("atom pointer doesn't look like an anchor atom pointer: " + key, pos);
                }
                int anchorIndex = TomlKt.getInt((TomlArray)key, 0);
                int atomIndex = TomlKt.getInt((TomlArray)key, 1);
                atomPointer = new AnchorAtomPointer(edu.duke.cs.osprey.gui.io.ConfLib$Companion.fragmentsFrom$getAnchor$default(anchors, fragId, anchorIndex, null, 8, null), atomIndex - 1);
            } else {
                throw new TomlParseException("unrecognized atom pointer: " + key, pos);
            }
            return atomPointer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c6\u0003J\u0015\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0007H\u00c6\u0003JU\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0007H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001J\u0016\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006&"}, d2={"Ledu/duke/cs/osprey/gui/io/ConfLib$Conf;", "", "id", "", "name", "description", "coords", "", "Ledu/duke/cs/osprey/gui/io/ConfLib$AtomInfo;", "Lorg/joml/Vector3d;", "anchorCoords", "Ledu/duke/cs/osprey/gui/io/ConfLib$Anchor;", "Ledu/duke/cs/osprey/gui/io/ConfLib$AnchorCoords;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/util/Map;)V", "getAnchorCoords", "()Ljava/util/Map;", "getCoords", "getDescription", "()Ljava/lang/String;", "getId", "getName", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "uniqueId", "conflib", "Ledu/duke/cs/osprey/gui/io/ConfLib;", "frag", "Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;", "osprey3"})
    public static final class Conf {
        @NotNull
        private final String id;
        @NotNull
        private final String name;
        @Nullable
        private final String description;
        @NotNull
        private final Map<AtomInfo, Vector3d> coords;
        @NotNull
        private final Map<Anchor, AnchorCoords> anchorCoords;

        public Conf(@NotNull String id, @NotNull String name, @Nullable String description, @NotNull Map<AtomInfo, ? extends Vector3d> coords, @NotNull Map<Anchor, ? extends AnchorCoords> anchorCoords) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(coords, (String)"coords");
            Intrinsics.checkNotNullParameter(anchorCoords, (String)"anchorCoords");
            this.id = id;
            this.name = name;
            this.description = description;
            this.coords = coords;
            this.anchorCoords = anchorCoords;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final String getDescription() {
            return this.description;
        }

        @NotNull
        public final Map<AtomInfo, Vector3d> getCoords() {
            return this.coords;
        }

        @NotNull
        public final Map<Anchor, AnchorCoords> getAnchorCoords() {
            return this.anchorCoords;
        }

        @NotNull
        public final String uniqueId(@NotNull ConfLib conflib, @NotNull Fragment frag) {
            Intrinsics.checkNotNullParameter((Object)conflib, (String)"conflib");
            Intrinsics.checkNotNullParameter((Object)frag, (String)"frag");
            return conflib.getId() + "/" + frag.getId() + "/" + this.id;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @Nullable
        public final String component3() {
            return this.description;
        }

        @NotNull
        public final Map<AtomInfo, Vector3d> component4() {
            return this.coords;
        }

        @NotNull
        public final Map<Anchor, AnchorCoords> component5() {
            return this.anchorCoords;
        }

        @NotNull
        public final Conf copy(@NotNull String id, @NotNull String name, @Nullable String description, @NotNull Map<AtomInfo, ? extends Vector3d> coords, @NotNull Map<Anchor, ? extends AnchorCoords> anchorCoords) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(coords, (String)"coords");
            Intrinsics.checkNotNullParameter(anchorCoords, (String)"anchorCoords");
            return new Conf(id, name, description, coords, anchorCoords);
        }

        public static /* synthetic */ Conf copy$default(Conf conf, String string, String string2, String string3, Map map, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                string = conf.id;
            }
            if ((n & 2) != 0) {
                string2 = conf.name;
            }
            if ((n & 4) != 0) {
                string3 = conf.description;
            }
            if ((n & 8) != 0) {
                map = conf.coords;
            }
            if ((n & 0x10) != 0) {
                map2 = conf.anchorCoords;
            }
            return conf.copy(string, string2, string3, map, map2);
        }

        @NotNull
        public String toString() {
            return "Conf(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", coords=" + this.coords + ", anchorCoords=" + this.anchorCoords + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.name.hashCode();
            result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
            result = result * 31 + ((Object)this.coords).hashCode();
            result = result * 31 + ((Object)this.anchorCoords).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Conf)) {
                return false;
            }
            Conf conf = (Conf)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)conf.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)conf.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.description, (Object)conf.description)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.coords, conf.coords)) {
                return false;
            }
            return Intrinsics.areEqual(this.anchorCoords, conf.anchorCoords);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH&J,\u0010\f\u001a\u00020\u00002\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\u0003\u001a\u00020\u0004H&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0001\u0011\u00a8\u0006\u0012"}, d2={"Ledu/duke/cs/osprey/gui/io/ConfLib$ContinuousMotion;", "", "()V", "id", "", "getId", "()I", "affectedAtoms", "", "Ledu/duke/cs/osprey/gui/io/ConfLib$AtomInfo;", "frag", "Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;", "copyTo", "atoms", "anchors", "Ledu/duke/cs/osprey/gui/io/ConfLib$Anchor;", "DihedralAngle", "Ledu/duke/cs/osprey/gui/io/ConfLib$ContinuousMotion$DihedralAngle;", "osprey3"})
    public static abstract sealed class ContinuousMotion {
        private ContinuousMotion() {
        }

        public abstract int getId();

        @NotNull
        public abstract List<AtomInfo> affectedAtoms(@NotNull Fragment var1);

        @NotNull
        public abstract ContinuousMotion copyTo(@NotNull List<AtomInfo> var1, @NotNull List<? extends Anchor> var2, int var3);

        public /* synthetic */ ContinuousMotion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J;\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u0005H\u00c6\u0001J,\u0010\u001c\u001a\u00020\u00002\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u00d6\u0003J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001J\t\u0010%\u001a\u00020&H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006'"}, d2={"Ledu/duke/cs/osprey/gui/io/ConfLib$ContinuousMotion$DihedralAngle;", "Ledu/duke/cs/osprey/gui/io/ConfLib$ContinuousMotion;", "id", "", "a", "Ledu/duke/cs/osprey/gui/io/ConfLib$AtomPointer;", "b", "c", "d", "(ILedu/duke/cs/osprey/gui/io/ConfLib$AtomPointer;Ledu/duke/cs/osprey/gui/io/ConfLib$AtomPointer;Ledu/duke/cs/osprey/gui/io/ConfLib$AtomPointer;Ledu/duke/cs/osprey/gui/io/ConfLib$AtomPointer;)V", "getA", "()Ledu/duke/cs/osprey/gui/io/ConfLib$AtomPointer;", "getB", "getC", "getD", "getId", "()I", "affectedAtoms", "", "Ledu/duke/cs/osprey/gui/io/ConfLib$AtomInfo;", "frag", "Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;", "component1", "component2", "component3", "component4", "component5", "copy", "copyTo", "atoms", "anchors", "Ledu/duke/cs/osprey/gui/io/ConfLib$Anchor;", "equals", "", "other", "", "hashCode", "toString", "", "osprey3"})
        public static final class DihedralAngle
        extends ContinuousMotion {
            private final int id;
            @NotNull
            private final AtomPointer a;
            @NotNull
            private final AtomPointer b;
            @NotNull
            private final AtomPointer c;
            @NotNull
            private final AtomPointer d;

            public DihedralAngle(int id, @NotNull AtomPointer a, @NotNull AtomPointer b, @NotNull AtomPointer c, @NotNull AtomPointer d) {
                Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                Intrinsics.checkNotNullParameter((Object)d, (String)"d");
                super(null);
                this.id = id;
                this.a = a;
                this.b = b;
                this.c = c;
                this.d = d;
            }

            @Override
            public int getId() {
                return this.id;
            }

            @NotNull
            public final AtomPointer getA() {
                return this.a;
            }

            @NotNull
            public final AtomPointer getB() {
                return this.b;
            }

            @NotNull
            public final AtomPointer getC() {
                return this.c;
            }

            @NotNull
            public final AtomPointer getD() {
                return this.d;
            }

            @Override
            @NotNull
            public List<AtomInfo> affectedAtoms(@NotNull Fragment frag) {
                Intrinsics.checkNotNullParameter((Object)frag, (String)"frag");
                AtomPointer atomPointer = this.b;
                AtomInfo b = atomPointer instanceof AtomInfo ? (AtomInfo)atomPointer : null;
                AtomPointer atomPointer2 = this.c;
                AtomInfo atomInfo = atomPointer2 instanceof AtomInfo ? (AtomInfo)atomPointer2 : null;
                if (atomInfo == null) {
                    return frag.getAtoms();
                }
                AtomInfo c = atomInfo;
                return CollectionsKt.toList(frag.bfs(c, false, (Function2<? super AtomInfo, ? super AtomInfo, Boolean>)((Function2)new Function2<AtomInfo, AtomInfo, Boolean>(b){
                    final /* synthetic */ AtomInfo $b;
                    {
                        this.$b = $b;
                        super(2);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull AtomInfo atomInfo, @NotNull AtomInfo to) {
                        Intrinsics.checkNotNullParameter((Object)atomInfo, (String)"<anonymous parameter 0>");
                        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
                        return to != this.$b;
                    }
                })));
            }

            @Override
            @NotNull
            public DihedralAngle copyTo(@NotNull List<AtomInfo> atoms, @NotNull List<? extends Anchor> anchors, int id) {
                Intrinsics.checkNotNullParameter(atoms, (String)"atoms");
                Intrinsics.checkNotNullParameter(anchors, (String)"anchors");
                return new DihedralAngle(id, this.a.matchInOrThrow(atoms, anchors), this.b.matchInOrThrow(atoms, anchors), this.c.matchInOrThrow(atoms, anchors), this.d.matchInOrThrow(atoms, anchors));
            }

            public final int component1() {
                return this.id;
            }

            @NotNull
            public final AtomPointer component2() {
                return this.a;
            }

            @NotNull
            public final AtomPointer component3() {
                return this.b;
            }

            @NotNull
            public final AtomPointer component4() {
                return this.c;
            }

            @NotNull
            public final AtomPointer component5() {
                return this.d;
            }

            @NotNull
            public final DihedralAngle copy(int id, @NotNull AtomPointer a, @NotNull AtomPointer b, @NotNull AtomPointer c, @NotNull AtomPointer d) {
                Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                Intrinsics.checkNotNullParameter((Object)d, (String)"d");
                return new DihedralAngle(id, a, b, c, d);
            }

            public static /* synthetic */ DihedralAngle copy$default(DihedralAngle dihedralAngle, int n, AtomPointer atomPointer, AtomPointer atomPointer2, AtomPointer atomPointer3, AtomPointer atomPointer4, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = dihedralAngle.id;
                }
                if ((n2 & 2) != 0) {
                    atomPointer = dihedralAngle.a;
                }
                if ((n2 & 4) != 0) {
                    atomPointer2 = dihedralAngle.b;
                }
                if ((n2 & 8) != 0) {
                    atomPointer3 = dihedralAngle.c;
                }
                if ((n2 & 0x10) != 0) {
                    atomPointer4 = dihedralAngle.d;
                }
                return dihedralAngle.copy(n, atomPointer, atomPointer2, atomPointer3, atomPointer4);
            }

            @NotNull
            public String toString() {
                return "DihedralAngle(id=" + this.id + ", a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", d=" + this.d + ")";
            }

            public int hashCode() {
                int result = Integer.hashCode(this.id);
                result = result * 31 + this.a.hashCode();
                result = result * 31 + this.b.hashCode();
                result = result * 31 + this.c.hashCode();
                result = result * 31 + this.d.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof DihedralAngle)) {
                    return false;
                }
                DihedralAngle dihedralAngle = (DihedralAngle)other;
                if (this.id != dihedralAngle.id) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.a, (Object)dihedralAngle.a)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.b, (Object)dihedralAngle.b)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.c, (Object)dihedralAngle.c)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.d, (Object)dihedralAngle.d);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010#\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001Bi\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0007\u00a2\u0006\u0002\u0010\u0012JX\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0!2\u0006\u0010\"\u001a\u00020\b2\b\b\u0002\u0010#\u001a\u00020$28\b\u0002\u0010%\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b'\u0012\b\b\u0004\u0012\u0004\b\b((\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b'\u0012\b\b\u0004\u0012\u0004\b\b()\u0012\u0004\u0012\u00020$0&J\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010+\u001a\u00020\bJ\t\u0010,\u001a\u00020\u0003H\u00c6\u0003J\t\u0010-\u001a\u00020\u0003H\u00c6\u0003J\t\u0010.\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010/\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\u000f\u00100\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u00c6\u0003J\u000f\u00101\u001a\b\u0012\u0004\u0012\u00020\f0\u0007H\u00c6\u0003J\u0015\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\u000eH\u00c6\u0003J\u000f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00110\u0007H\u00c6\u0003J}\u00104\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\u000e2\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0007H\u00c6\u0001J\u0013\u00105\u001a\u00020$2\b\u00106\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\"\u00107\u001a\u0016\u0012\u0004\u0012\u00020\b 8*\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00070\u00072\u0006\u00109\u001a\u00020\fJ%\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0:2\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030;\"\u00020\u0003\u00a2\u0006\u0002\u0010<J\t\u0010=\u001a\u00020>H\u00d6\u0001J\t\u0010?\u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010@\u001a\u00020\u00032\u0006\u0010A\u001a\u00020BR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R \u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001c\u00a8\u0006C"}, d2={"Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;", "", "id", "", "name", "type", "atoms", "", "Ledu/duke/cs/osprey/gui/io/ConfLib$AtomInfo;", "bonds", "Ledu/duke/cs/osprey/gui/io/ConfLib$Bond;", "anchors", "Ledu/duke/cs/osprey/gui/io/ConfLib$Anchor;", "confs", "", "Ledu/duke/cs/osprey/gui/io/ConfLib$Conf;", "motions", "Ledu/duke/cs/osprey/gui/io/ConfLib$ContinuousMotion;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/Map;Ljava/util/List;)V", "getAnchors", "()Ljava/util/List;", "getAtoms", "atomsByAnchor", "Ljava/util/IdentityHashMap;", "getBonds", "getConfs", "()Ljava/util/Map;", "getId", "()Ljava/lang/String;", "getMotions", "getName", "getType", "bfs", "", "source", "visitSource", "", "shouldVisit", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "fromAtom", "toAtom", "bondedAtoms", "atom", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "getAtomsFor", "kotlin.jvm.PlatformType", "anchor", "", "", "([Ljava/lang/String;)Ljava/util/Set;", "hashCode", "", "toString", "uniqueId", "conflib", "Ledu/duke/cs/osprey/gui/io/ConfLib;", "osprey3"})
    @SourceDebugExtension(value={"SMAP\nConfLib.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfLib.kt\nedu/duke/cs/osprey/gui/io/ConfLib$Fragment\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,934:1\n1603#2,9:935\n1855#2:944\n1856#2:946\n1612#2:947\n1#3:945\n361#4,7:948\n11335#5:955\n11670#5,3:956\n*S KotlinDebug\n*F\n+ 1 ConfLib.kt\nedu/duke/cs/osprey/gui/io/ConfLib$Fragment\n*L\n373#1:935,9\n373#1:944\n373#1:946\n373#1:947\n373#1:945\n384#1:948,7\n441#1:955\n441#1:956,3\n*E\n"})
    public static final class Fragment {
        @NotNull
        private final String id;
        @NotNull
        private final String name;
        @NotNull
        private final String type;
        @NotNull
        private final List<AtomInfo> atoms;
        @NotNull
        private final List<Bond> bonds;
        @NotNull
        private final List<Anchor> anchors;
        @NotNull
        private final Map<String, Conf> confs;
        @NotNull
        private final List<ContinuousMotion> motions;
        @NotNull
        private final IdentityHashMap<Anchor, List<AtomInfo>> atomsByAnchor;

        public Fragment(@NotNull String id, @NotNull String name, @NotNull String type, @NotNull List<AtomInfo> atoms, @NotNull List<Bond> bonds2, @NotNull List<? extends Anchor> anchors, @NotNull Map<String, Conf> confs, @NotNull List<? extends ContinuousMotion> motions) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter(atoms, (String)"atoms");
            Intrinsics.checkNotNullParameter(bonds2, (String)"bonds");
            Intrinsics.checkNotNullParameter(anchors, (String)"anchors");
            Intrinsics.checkNotNullParameter(confs, (String)"confs");
            Intrinsics.checkNotNullParameter(motions, (String)"motions");
            this.id = id;
            this.name = name;
            this.type = type;
            this.atoms = atoms;
            this.bonds = bonds2;
            this.anchors = anchors;
            this.confs = confs;
            this.motions = motions;
            this.atomsByAnchor = new IdentityHashMap();
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final List<AtomInfo> getAtoms() {
            return this.atoms;
        }

        @NotNull
        public final List<Bond> getBonds() {
            return this.bonds;
        }

        @NotNull
        public final List<Anchor> getAnchors() {
            return this.anchors;
        }

        @NotNull
        public final Map<String, Conf> getConfs() {
            return this.confs;
        }

        @NotNull
        public final List<ContinuousMotion> getMotions() {
            return this.motions;
        }

        @NotNull
        public final String uniqueId(@NotNull ConfLib conflib) {
            Intrinsics.checkNotNullParameter((Object)conflib, (String)"conflib");
            return conflib.getId() + "/" + this.id;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<AtomInfo> bondedAtoms(@NotNull AtomInfo atom) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
            Iterable $this$mapNotNull$iv = this.bonds;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                AtomInfo it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Bond bond = (Bond)element$iv$iv;
                boolean bl2 = false;
                AtomInfo a = bond.component1();
                AtomInfo b = bond.component2();
                if ((atom == a ? b : (atom == b ? a : null)) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public final List<AtomInfo> getAtomsFor(@NotNull Anchor anchor) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
            Map $this$getOrPut$iv = this.atomsByAnchor;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(anchor);
            if (value$iv == null) {
                boolean bl = false;
                List<AtomInfo> answer$iv = anchor.findAtoms(this);
                $this$getOrPut$iv.put(anchor, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (List)object;
        }

        @NotNull
        public final Iterable<AtomInfo> bfs(@NotNull AtomInfo source, boolean visitSource, @NotNull Function2<? super AtomInfo, ? super AtomInfo, Boolean> shouldVisit) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter(shouldVisit, (String)"shouldVisit");
            return new Iterable<AtomInfo>(source, visitSource, this, shouldVisit){
                final /* synthetic */ AtomInfo $source;
                final /* synthetic */ boolean $visitSource;
                final /* synthetic */ Fragment this$0;
                final /* synthetic */ Function2<AtomInfo, AtomInfo, Boolean> $shouldVisit;
                {
                    this.$source = $source;
                    this.$visitSource = $visitSource;
                    this.this$0 = $receiver;
                    this.$shouldVisit = $shouldVisit;
                }

                @NotNull
                public bfs.iterator.1 iterator() {
                    return new Iterator<AtomInfo>(this.$source, this.$visitSource, this.this$0, this.$shouldVisit){
                        @NotNull
                        private final ArrayDeque<AtomInfo> toVisit;
                        @NotNull
                        private final Set<AtomInfo> visitScheduled;
                        final /* synthetic */ Fragment this$0;
                        final /* synthetic */ Function2<AtomInfo, AtomInfo, Boolean> $shouldVisit;
                        {
                            this.this$0 = $receiver;
                            this.$shouldVisit = $shouldVisit;
                            this.toVisit = new ArrayDeque<E>();
                            this.visitScheduled = LangKt.identityHashSet();
                            this.scheduleVisit($source);
                            if (!$visitSource) {
                                this.next();
                            }
                        }

                        @NotNull
                        public final ArrayDeque<AtomInfo> getToVisit() {
                            return this.toVisit;
                        }

                        @NotNull
                        public final Set<AtomInfo> getVisitScheduled() {
                            return this.visitScheduled;
                        }

                        public final void scheduleVisit(@NotNull AtomInfo atom) {
                            Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
                            this.toVisit.add(atom);
                            this.visitScheduled.add(atom);
                        }

                        public boolean hasNext() {
                            return !((Collection)this.toVisit).isEmpty();
                        }

                        @NotNull
                        public AtomInfo next() {
                            AtomInfo atomInfo = this.toVisit.pollFirst();
                            if (atomInfo == null) {
                                throw new NoSuchElementException("no more atoms to visit");
                            }
                            AtomInfo atom = atomInfo;
                            for (AtomInfo neighbor : this.this$0.bondedAtoms(atom)) {
                                if (this.visitScheduled.contains(neighbor) || !((Boolean)this.$shouldVisit.invoke((Object)atom, (Object)neighbor)).booleanValue()) continue;
                                this.scheduleVisit(neighbor);
                            }
                            return atom;
                        }

                        public void remove() {
                            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                        }
                    };
                }
            };
        }

        public static /* synthetic */ Iterable bfs$default(Fragment fragment, AtomInfo atomInfo, boolean bl, Function2 function2, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                function2 = bfs.1.INSTANCE;
            }
            return fragment.bfs(atomInfo, bl, (Function2<? super AtomInfo, ? super AtomInfo, Boolean>)function2);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<Conf> getConfs(String ... id) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            String[] $this$map$iv = id;
            boolean $i$f$map = false;
            String[] stringArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((Conf)MapsKt.getValue(this.confs, (Object)it));
            }
            return (Set)CollectionsKt.toCollection((Iterable)((List)destination$iv$iv), (Collection)LangKt.identityHashSet());
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final String component3() {
            return this.type;
        }

        @NotNull
        public final List<AtomInfo> component4() {
            return this.atoms;
        }

        @NotNull
        public final List<Bond> component5() {
            return this.bonds;
        }

        @NotNull
        public final List<Anchor> component6() {
            return this.anchors;
        }

        @NotNull
        public final Map<String, Conf> component7() {
            return this.confs;
        }

        @NotNull
        public final List<ContinuousMotion> component8() {
            return this.motions;
        }

        @NotNull
        public final Fragment copy(@NotNull String id, @NotNull String name, @NotNull String type, @NotNull List<AtomInfo> atoms, @NotNull List<Bond> bonds2, @NotNull List<? extends Anchor> anchors, @NotNull Map<String, Conf> confs, @NotNull List<? extends ContinuousMotion> motions) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter(atoms, (String)"atoms");
            Intrinsics.checkNotNullParameter(bonds2, (String)"bonds");
            Intrinsics.checkNotNullParameter(anchors, (String)"anchors");
            Intrinsics.checkNotNullParameter(confs, (String)"confs");
            Intrinsics.checkNotNullParameter(motions, (String)"motions");
            return new Fragment(id, name, type, atoms, bonds2, anchors, confs, motions);
        }

        public static /* synthetic */ Fragment copy$default(Fragment fragment, String string, String string2, String string3, List list, List list2, List list3, Map map, List list4, int n, Object object) {
            if ((n & 1) != 0) {
                string = fragment.id;
            }
            if ((n & 2) != 0) {
                string2 = fragment.name;
            }
            if ((n & 4) != 0) {
                string3 = fragment.type;
            }
            if ((n & 8) != 0) {
                list = fragment.atoms;
            }
            if ((n & 0x10) != 0) {
                list2 = fragment.bonds;
            }
            if ((n & 0x20) != 0) {
                list3 = fragment.anchors;
            }
            if ((n & 0x40) != 0) {
                map = fragment.confs;
            }
            if ((n & 0x80) != 0) {
                list4 = fragment.motions;
            }
            return fragment.copy(string, string2, string3, list, list2, list3, map, list4);
        }

        @NotNull
        public String toString() {
            return "Fragment(id=" + this.id + ", name=" + this.name + ", type=" + this.type + ", atoms=" + this.atoms + ", bonds=" + this.bonds + ", anchors=" + this.anchors + ", confs=" + this.confs + ", motions=" + this.motions + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.name.hashCode();
            result = result * 31 + this.type.hashCode();
            result = result * 31 + ((Object)this.atoms).hashCode();
            result = result * 31 + ((Object)this.bonds).hashCode();
            result = result * 31 + ((Object)this.anchors).hashCode();
            result = result * 31 + ((Object)this.confs).hashCode();
            result = result * 31 + ((Object)this.motions).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Fragment)) {
                return false;
            }
            Fragment fragment = (Fragment)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)fragment.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)fragment.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.type, (Object)fragment.type)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.atoms, fragment.atoms)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.bonds, fragment.bonds)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.anchors, fragment.anchors)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.confs, fragment.confs)) {
                return false;
            }
            return Intrinsics.areEqual(this.motions, fragment.motions);
        }
    }
}

