/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gui.io;

import cuchaz.kludge.tools.MathKt;
import edu.duke.cs.osprey.gui.prep.Proteins;
import edu.duke.cs.osprey.molscope.molecule.Element;
import edu.duke.cs.osprey.molscope.molecule.Molecule;
import edu.duke.cs.osprey.molscope.molecule.Polymer;
import edu.duke.cs.osprey.structure.Atom;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.PDBIO;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.structure.Residues;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.CharRange;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3dc;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0004\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0005\u001a\u00020\u0001*\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u001a(\u0010\b\u001a\u00020\u0006*\u00020\u00012\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\n\u001aY\u0010\r\u001a\u00020\u0004*\u00020\u00012\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0011\u001a\u00020\n2\b\b\u0002\u0010\u0012\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"fromPDB", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "Ledu/duke/cs/osprey/molscope/molecule/Molecule$Companion;", "pdb", "", "toMolecule", "Ledu/duke/cs/osprey/structure/Molecule;", "name", "toOspreyMol", "throwOnNonChainPolymerAtoms", "", "translateSSasCYX", "translateHIStoEDP", "toPDB", "comment", "energy", "", "includeTer", "includeSSBondConect", "(Ledu/duke/cs/osprey/molscope/molecule/Molecule;ZZLjava/lang/String;Ljava/lang/Double;ZZZ)Ljava/lang/String;", "osprey3"})
@SourceDebugExtension(value={"SMAP\nPDB.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PDB.kt\nedu/duke/cs/osprey/gui/io/PDBKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,295:1\n1#2:296\n1549#3:297\n1620#3,3:298\n1747#3,3:301\n1747#3,3:304\n*S KotlinDebug\n*F\n+ 1 PDB.kt\nedu/duke/cs/osprey/gui/io/PDBKt\n*L\n135#1:297\n135#1:298,3\n216#1:301,3\n217#1:304,3\n*E\n"})
public final class PDBKt {
    @NotNull
    public static final String toPDB(@NotNull edu.duke.cs.osprey.molscope.molecule.Molecule $this$toPDB, boolean throwOnNonChainPolymerAtoms, boolean translateSSasCYX, @Nullable String comment, @Nullable Double energy, boolean includeTer, boolean includeSSBondConect, boolean translateHIStoEDP) {
        Intrinsics.checkNotNullParameter((Object)$this$toPDB, (String)"<this>");
        String string = PDBIO.write(PDBKt.toOspreyMol($this$toPDB, throwOnNonChainPolymerAtoms, translateSSasCYX, translateHIStoEDP), comment, energy, includeTer, includeSSBondConect);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"write(\n\t\ttoOspreyMol(thr\u2026\n\t\tincludeSSBondConect\n\t)");
        return string;
    }

    public static /* synthetic */ String toPDB$default(edu.duke.cs.osprey.molscope.molecule.Molecule molecule, boolean bl, boolean bl2, String string, Double d, boolean bl3, boolean bl4, boolean bl5, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            d = null;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        if ((n & 0x20) != 0) {
            bl4 = false;
        }
        if ((n & 0x40) != 0) {
            bl5 = false;
        }
        return PDBKt.toPDB(molecule, bl, bl2, string, d, bl3, bl4, bl5);
    }

    @NotNull
    public static final edu.duke.cs.osprey.molscope.molecule.Molecule fromPDB(@NotNull Molecule.Companion $this$fromPDB, @NotNull String pdb) {
        Intrinsics.checkNotNullParameter((Object)$this$fromPDB, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pdb, (String)"pdb");
        Molecule molecule = PDBIO.read(pdb);
        Intrinsics.checkNotNullExpressionValue((Object)molecule, (String)"read(pdb)");
        return PDBKt.toMolecule(molecule, "PDB");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final edu.duke.cs.osprey.molscope.molecule.Molecule toMolecule(@NotNull Molecule $this$toMolecule, @Nullable String name) {
        Object bondedAtom;
        edu.duke.cs.osprey.molscope.molecule.Atom atom;
        edu.duke.cs.osprey.molscope.molecule.Molecule molecule;
        Intrinsics.checkNotNullParameter((Object)$this$toMolecule, (String)"<this>");
        Molecule omol = $this$toMolecule;
        if (omol.residues.size() > 1) {
            String string = name;
            if (string == null) {
                string = omol.name;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name ?: omol.name");
            molecule = new Polymer(string);
        } else {
            String string = name;
            if (string == null) {
                string = omol.name;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name ?: omol.name");
            Residues residues = omol.residues;
            Intrinsics.checkNotNullExpressionValue((Object)residues, (String)"omol.residues");
            Residue residue = (Residue)CollectionsKt.firstOrNull((List)residues);
            molecule = new edu.duke.cs.osprey.molscope.molecule.Molecule(string, residue != null ? residue.getType() : null, null, 4, null);
        }
        edu.duke.cs.osprey.molscope.molecule.Molecule mol = molecule;
        IdentityHashMap atomMap2 = new IdentityHashMap();
        for (Residue ores : omol.residues) {
            for (Atom oatom : ores.atoms) {
                Element element = Element.Companion.get(oatom.elementNumber);
                String string = oatom.name;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"oatom.name");
                atom = new edu.duke.cs.osprey.molscope.molecule.Atom(element, string, oatom.getCoords()[0], oatom.getCoords()[1], oatom.getCoords()[2]);
                ((Map)atomMap2).put(oatom, atom);
                mol.getAtoms().add(atom);
            }
        }
        for (Residue ores : omol.residues) {
            for (Atom oatom : ores.atoms) {
                Object v = atomMap2.get(oatom);
                Intrinsics.checkNotNull(v);
                atom = (edu.duke.cs.osprey.molscope.molecule.Atom)v;
                for (Atom bondedOatom : oatom.bonds) {
                    Object v2 = atomMap2.get(bondedOatom);
                    Intrinsics.checkNotNull(v2);
                    bondedAtom = (edu.duke.cs.osprey.molscope.molecule.Atom)v2;
                    mol.getBonds().add(atom, (edu.duke.cs.osprey.molscope.molecule.Atom)bondedAtom);
                }
            }
        }
        if (mol instanceof Polymer) {
            Lazy availableChainId2 = LazyKt.lazy((Function0)((Function0)new Function0<String>(omol){
                final /* synthetic */ Molecule $omol;
                {
                    this.$omol = $omol;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final String invoke() {
                    String string;
                    Object v1;
                    List chainIds;
                    block4: {
                        void $this$filterTo$iv$iv;
                        Iterable $this$mapTo$iv$iv;
                        Residues residues = this.$omol.residues;
                        Intrinsics.checkNotNullExpressionValue((Object)residues, (String)"omol.residues");
                        Iterable $this$map$iv = residues;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            Residue residue = (Residue)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(Character.valueOf(it.getChainId()));
                        }
                        Iterable $this$filter$iv = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                        boolean $i$f$filter = false;
                        $this$mapTo$iv$iv = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            char it = ((Character)element$iv$iv).charValue();
                            boolean bl = false;
                            if (!(!CharsKt.isWhitespace((char)it))) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        chainIds = (List)destination$iv$iv;
                        Iterable $this$firstOrNull$iv = (Iterable)new CharRange('A', 'Z');
                        boolean $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            char it = ((Character)element$iv).charValue();
                            boolean bl = false;
                            if (!(!chainIds.contains(Character.valueOf(it)))) continue;
                            v1 = element$iv;
                            break block4;
                        }
                        v1 = null;
                    }
                    Character c = v1;
                    if (c == null || (string = c.toString()) == null) {
                        throw new NoSuchElementException("can't find a unique chain ID, IDs already in use: " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)chainIds), (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
                    }
                    return string;
                }
            }));
            for (Residue res : omol.residues) {
                String string;
                Collection<edu.duke.cs.osprey.molscope.molecule.Atom> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Molecule $this$toMolecule_u24lambda_u242;
                Polymer.Chain chain;
                Object v9;
                Object object;
                String ochainId;
                block14: {
                    ochainId = PDBKt.toMolecule$translateChainId(res.getChainId(), (Lazy<String>)availableChainId2);
                    bondedAtom = ((Polymer)mol).getChains();
                    Iterator iterator2 = bondedAtom.iterator();
                    while (iterator2.hasNext()) {
                        object = iterator2.next();
                        Polymer.Chain it = (Polymer.Chain)object;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)ochainId)) continue;
                        v9 = object;
                        break block14;
                    }
                    v9 = null;
                }
                if ((chain = (Polymer.Chain)v9) == null) {
                    $this$toMolecule_u24lambda_u242 = $this$toMolecule;
                    boolean bl = false;
                    Object $this$toMolecule_u24lambda_u242_u24lambda_u241 = object = new Polymer.Chain(ochainId);
                    boolean bl2 = false;
                    ((Polymer)mol).getChains().add((Polymer.Chain)$this$toMolecule_u24lambda_u242_u24lambda_u241);
                    chain = object;
                }
                Polymer.Chain chain2 = chain;
                List<Polymer.Residue> list = chain2.getResidues();
                String string2 = res.fullName;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"res.fullName");
                Object object2 = string2;
                int bondedOatom = 5;
                String string3 = ((String)object2).substring(bondedOatom);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                String string4 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                Intrinsics.checkNotNullExpressionValue((Object)res.getType(), (String)"res.type");
                ArrayList<Atom> arrayList = res.atoms;
                Intrinsics.checkNotNullExpressionValue(arrayList, (String)"res.atoms");
                object2 = arrayList;
                String string5 = string4;
                List<Polymer.Residue> list2 = list;
                boolean $i$f$map = false;
                $this$toMolecule_u24lambda_u242 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Atom atom2 = (Atom)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    Object v = atomMap2.get(it);
                    Intrinsics.checkNotNull(v);
                    collection.add((edu.duke.cs.osprey.molscope.molecule.Atom)v);
                }
                Collection<edu.duke.cs.osprey.molscope.molecule.Atom> collection2 = collection = (List)destination$iv$iv;
                String string6 = string;
                String string7 = string5;
                list2.add(new Polymer.Residue(string7, string6, (List<edu.duke.cs.osprey.molscope.molecule.Atom>)collection2));
            }
        }
        return mol;
    }

    public static /* synthetic */ edu.duke.cs.osprey.molscope.molecule.Molecule toMolecule$default(Molecule molecule, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return PDBKt.toMolecule(molecule, string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final Molecule toOspreyMol(@NotNull edu.duke.cs.osprey.molscope.molecule.Molecule $this$toOspreyMol, boolean throwOnNonChainPolymerAtoms, boolean translateSSasCYX, boolean translateHIStoEDP) {
        Intrinsics.checkNotNullParameter((Object)$this$toOspreyMol, (String)"<this>");
        edu.duke.cs.osprey.molscope.molecule.Molecule mol = $this$toOspreyMol;
        Molecule omol = new Molecule();
        omol.name = mol.getName();
        IdentityHashMap<edu.duke.cs.osprey.molscope.molecule.Atom, Atom> atomMap2 = new IdentityHashMap<edu.duke.cs.osprey.molscope.molecule.Atom, Atom>();
        if (mol instanceof Polymer) {
            Set<edu.duke.cs.osprey.molscope.molecule.Atom> atomsCopied = edu.duke.cs.osprey.molscope.molecule.Atom.Companion.identitySet();
            for (Polymer.Chain chain : ((Polymer)mol).getChains()) {
                for (Polymer.Residue residue : chain.getResidues()) {
                    String string;
                    Object oatomCoords;
                    ArrayList<Atom> atoms = new ArrayList<Atom>();
                    ArrayList coords = new ArrayList();
                    for (edu.duke.cs.osprey.molscope.molecule.Atom atom : residue.getAtoms()) {
                        Pair<Atom, double[]> pair = PDBKt.toOspreyMol$toOsprey(atom, atomMap2);
                        Atom oatom = (Atom)pair.component1();
                        oatomCoords = (double[])pair.component2();
                        atoms.add(oatom);
                        coords.add(oatomCoords);
                    }
                    if (translateSSasCYX && Intrinsics.areEqual((Object)residue.getType(), (Object)"CYS") && Proteins.INSTANCE.isSSBonded(mol, residue)) {
                        string = "CYX";
                    } else if (translateHIStoEDP && Intrinsics.areEqual((Object)residue.getType(), (Object)"HIS")) {
                        boolean hasHd1;
                        boolean hasHe2;
                        block30: {
                            boolean bl;
                            block29: {
                                Iterable $this$any$iv = residue.getAtoms();
                                boolean $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl = false;
                                } else {
                                    oatomCoords = $this$any$iv.iterator();
                                    while (oatomCoords.hasNext()) {
                                        Object element$iv = oatomCoords.next();
                                        edu.duke.cs.osprey.molscope.molecule.Atom it = (edu.duke.cs.osprey.molscope.molecule.Atom)element$iv;
                                        boolean bl2 = false;
                                        String string2 = it.getName().toLowerCase(Locale.ROOT);
                                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                                        if (!Intrinsics.areEqual((Object)string2, (Object)"he2")) continue;
                                        bl = true;
                                        break block29;
                                    }
                                    bl = false;
                                }
                            }
                            hasHe2 = bl;
                            Iterable $this$any$iv = residue.getAtoms();
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                v3 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    edu.duke.cs.osprey.molscope.molecule.Atom it = (edu.duke.cs.osprey.molscope.molecule.Atom)element$iv;
                                    boolean bl3 = false;
                                    String string3 = it.getName().toLowerCase(Locale.ROOT);
                                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                                    if (!Intrinsics.areEqual((Object)string3, (Object)"hd1")) continue;
                                    v3 = true;
                                    break block30;
                                }
                                v3 = hasHd1 = false;
                            }
                        }
                        if (hasHe2 && hasHd1) {
                            string = "HIP";
                        } else if (hasHe2) {
                            string = "HIE";
                        } else {
                            if (!hasHd1) throw new IllegalArgumentException("Unable to determine Histidine protonation state, no HE2 or HD1");
                            string = "HID";
                        }
                    } else {
                        string = residue.getType();
                    }
                    String resType = string;
                    omol.residues.add(new Residue(atoms, coords, PDBKt.toOspreyMol$fullName(chain.getId(), residue.getId(), resType), omol));
                    atomsCopied.addAll((Collection<edu.duke.cs.osprey.molscope.molecule.Atom>)residue.getAtoms());
                }
            }
            int missingAtoms2 = $this$toOspreyMol.getAtoms().size() - atomsCopied.size();
            if (missingAtoms2 > 0) {
                StringBuilder msg = new StringBuilder();
                msg.append("Polymer has " + missingAtoms2 + " atoms that were not in chains");
                msg.append(", and not copied to the Osprey molecule.");
                Set<edu.duke.cs.osprey.molscope.molecule.Atom> chainAtoms = edu.duke.cs.osprey.molscope.molecule.Atom.Companion.identitySet();
                for (Polymer.Chain chain : ((Polymer)mol).getChains()) {
                    for (Polymer.Residue res : chain.getResidues()) {
                        chainAtoms.addAll((Collection<edu.duke.cs.osprey.molscope.molecule.Atom>)res.getAtoms());
                    }
                }
                for (edu.duke.cs.osprey.molscope.molecule.Atom atom : mol.getAtoms()) {
                    if (chainAtoms.contains(atom)) continue;
                    msg.append("\n\t" + atom + " @ " + MathKt.toString$default((Vector3dc)((Vector3dc)atom.getPos()), (Integer)6, null, (int)2, null));
                }
                if (throwOnNonChainPolymerAtoms) {
                    throw new IllegalArgumentException(msg.toString());
                }
                System.err.println("WARNING: " + (StringBuilder)msg);
            }
        } else {
            ArrayList<Atom> atoms = new ArrayList<Atom>();
            ArrayList<double[]> coords = new ArrayList<double[]>();
            for (edu.duke.cs.osprey.molscope.molecule.Atom atom : mol.getAtoms()) {
                Pair<Atom, double[]> pair = PDBKt.toOspreyMol$toOsprey(atom, atomMap2);
                Atom oatom = (Atom)pair.component1();
                double[] oatomCoords = (double[])pair.component2();
                atoms.add(oatom);
                coords.add(oatomCoords);
            }
            String string = mol.getType();
            if (string == null) {
                String string4 = PDBKt.toOspreyMol$first(mol.getName(), 3).toUpperCase(Locale.ROOT);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            }
            String resType = string;
            omol.residues.add(new Residue(atoms, coords, PDBKt.toOspreyMol$fullName("A", "1", resType), omol));
        }
        for (Map.Entry entry : ((Map)atomMap2).entrySet()) {
            edu.duke.cs.osprey.molscope.molecule.Atom atom = (edu.duke.cs.osprey.molscope.molecule.Atom)entry.getKey();
            Atom oatom = (Atom)entry.getValue();
            Molecule.Bonds bonds2 = mol.getBonds();
            Intrinsics.checkNotNullExpressionValue((Object)atom, (String)"atom");
            for (edu.duke.cs.osprey.molscope.molecule.Atom atom2 : bonds2.bondedAtoms(atom)) {
                Atom obonded;
                if (atomMap2.get(atom2) == null) {
                    throw new NoSuchElementException("bonded atom " + atom2 + " (bonded to " + atom + ") not in this molecule: " + mol);
                }
                if (oatom.bonds.contains(obonded)) continue;
                oatom.addBond(obonded);
            }
        }
        return omol;
    }

    public static /* synthetic */ Molecule toOspreyMol$default(edu.duke.cs.osprey.molscope.molecule.Molecule molecule, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            bl3 = false;
        }
        return PDBKt.toOspreyMol(molecule, bl, bl2, bl3);
    }

    private static final String toMolecule$translateChainId(char $this$toMolecule_u24translateChainId, Lazy<String> availableChainId2) {
        return CharsKt.isWhitespace((char)$this$toMolecule_u24translateChainId) ? (String)availableChainId2.getValue() : String.valueOf($this$toMolecule_u24translateChainId);
    }

    private static final Pair<Atom, double[]> toOspreyMol$toOsprey(edu.duke.cs.osprey.molscope.molecule.Atom $this$toOspreyMol_u24toOsprey, IdentityHashMap<edu.duke.cs.osprey.molscope.molecule.Atom, Atom> atomMap2) {
        Atom oatom = new Atom($this$toOspreyMol_u24toOsprey.getName(), $this$toOspreyMol_u24toOsprey.getElement().getSymbol());
        ((Map)atomMap2).put($this$toOspreyMol_u24toOsprey, oatom);
        double[] dArray = new double[]{$this$toOspreyMol_u24toOsprey.getPos().x, $this$toOspreyMol_u24toOsprey.getPos().y, $this$toOspreyMol_u24toOsprey.getPos().z};
        return TuplesKt.to((Object)oatom, (Object)dArray);
    }

    private static final String toOspreyMol$first(String $this$toOspreyMol_u24first, int len) {
        String string = $this$toOspreyMol_u24first.substring(0, Math.min(len, $this$toOspreyMol_u24first.length()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    private static final String toOspreyMol$fullName(String chainId, String resId, String resType) {
        String string = "%3s%2s%4s";
        Object[] objectArray = new Object[]{PDBKt.toOspreyMol$first(resType, 3), Character.valueOf(chainId.charAt(0)), PDBKt.toOspreyMol$first(resId, 4)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
        return string2;
    }
}

