/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gui.prep;

import ags.utils.dataStructures.trees.thirdGenKD.DistanceFunction;
import ags.utils.dataStructures.trees.thirdGenKD.KdTree;
import ags.utils.dataStructures.trees.thirdGenKD.NearestNeighborIterator;
import ags.utils.dataStructures.trees.thirdGenKD.SquareEuclideanDistanceFunction;
import cuchaz.kludge.tools.MathKt;
import edu.duke.cs.osprey.molscope.molecule.Atom;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3dc;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J \u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000f0\u000e0\r2\u0006\u0010\u0010\u001a\u00020\u0004J \u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000f0\u000e0\r2\u0006\u0010\u0011\u001a\u00020\u0012R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ledu/duke/cs/osprey/gui/prep/AtomTree;", "", "atoms", "", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "(Ljava/util/List;)V", "getAtoms", "()Ljava/util/List;", "distFunc", "Lags/utils/dataStructures/trees/thirdGenKD/SquareEuclideanDistanceFunction;", "tree", "Lags/utils/dataStructures/trees/thirdGenKD/KdTree;", "nearest", "", "Lkotlin/Pair;", "", "atom", "pos", "Lorg/joml/Vector3dc;", "osprey3"})
public final class AtomTree {
    @NotNull
    private final List<Atom> atoms;
    @NotNull
    private final KdTree<Atom> tree;
    @NotNull
    private final SquareEuclideanDistanceFunction distFunc;

    /*
     * WARNING - void declaration
     */
    public AtomTree(@NotNull List<Atom> atoms) {
        KdTree kdTree;
        Intrinsics.checkNotNullParameter(atoms, (String)"atoms");
        this.atoms = atoms;
        KdTree kdTree2 = kdTree = new KdTree(3);
        AtomTree atomTree = this;
        boolean bl = false;
        for (Atom atom : this.atoms) {
            void $this$tree_u24lambda_u240;
            double[] dArray = new double[]{atom.getPos().x, atom.getPos().y, atom.getPos().z};
            $this$tree_u24lambda_u240.addPoint(dArray, (Object)atom);
        }
        atomTree.tree = kdTree;
        this.distFunc = new SquareEuclideanDistanceFunction();
    }

    @NotNull
    public final List<Atom> getAtoms() {
        return this.atoms;
    }

    @NotNull
    public final Iterator<Pair<Atom, Double>> nearest(@NotNull Vector3dc pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return new Iterator<Pair<? extends Atom, ? extends Double>>(this, pos){
            private final NearestNeighborIterator<Atom> iter;
            {
                double[] dArray = new double[]{MathKt.getX((Vector3dc)$pos), MathKt.getY((Vector3dc)$pos), MathKt.getZ((Vector3dc)$pos)};
                this.iter = AtomTree.access$getTree$p($receiver).getNearestNeighborIterator(dArray, Integer.MAX_VALUE, (DistanceFunction)AtomTree.access$getDistFunc$p($receiver));
            }

            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @NotNull
            public Pair<Atom, Double> next() {
                Atom atom = (Atom)this.iter.next();
                double distSq = this.iter.distance();
                return TuplesKt.to((Object)atom, (Object)distSq);
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    @NotNull
    public final Iterator<Pair<Atom, Double>> nearest(@NotNull Atom atom) {
        Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
        return this.nearest((Vector3dc)atom.getPos());
    }

    public static final /* synthetic */ KdTree access$getTree$p(AtomTree $this) {
        return $this.tree;
    }

    public static final /* synthetic */ SquareEuclideanDistanceFunction access$getDistFunc$p(AtomTree $this) {
        return $this.distFunc;
    }
}

