/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar;

import edu.duke.cs.osprey.dof.deeper.DEEPerSettings;
import edu.duke.cs.osprey.multistatekstar.ResidueTermini;
import edu.duke.cs.osprey.tools.ObjectIO;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;

public class KSAllowedSeqs {
    private DEEPerSettings dset;
    private ArrayList<String[]> moveableStrandTermini;
    private ArrayList<String[]> freeBBZoneTermini;
    private ArrayList<String> flexRes;
    private ArrayList<ArrayList<String>> allowedAAs;
    private ArrayList<String> wt;
    public boolean addWT;
    private int dist;
    private boolean allowLessMut;
    private int strand;
    private ResidueTermini limits;
    private int maxSequences = (int)Math.pow(2.0, 28.0);
    private ArrayList<ArrayList<String>> allowedSeqs = null;
    private LinkedHashMap<ArrayList<String>, Integer> allowedSeq2Index = null;
    ArrayList<HashSet<ArrayList<String>>> allowedSubSeqs = null;

    public KSAllowedSeqs(int strand, ResidueTermini limits, DEEPerSettings dset, ArrayList<String[]> freeBBZoneTermini, ArrayList<String[]> moveableStrandTermini, ArrayList<String> flexRes, ArrayList<ArrayList<String>> allowedAAs, ArrayList<String> wt, boolean addWT, int dist, boolean allowLessMut) {
        this.strand = strand;
        this.limits = limits;
        this.dset = dset;
        this.freeBBZoneTermini = freeBBZoneTermini;
        this.moveableStrandTermini = moveableStrandTermini;
        this.flexRes = flexRes;
        this.allowedAAs = KSAllowedSeqs.addPosToAllowedAAs(allowedAAs, flexRes);
        this.wt = KSAllowedSeqs.addPosToSeq(wt, flexRes);
        this.addWT = addWT;
        this.dist = dist;
        this.allowLessMut = allowLessMut;
        this.allowedSeqs = this.generateSequences();
    }

    public KSAllowedSeqs(int strand, ResidueTermini limits, DEEPerSettings dset, ArrayList<String[]> freeBBZoneTermini, ArrayList<String[]> moveableStrandTermini, ArrayList<String> flexRes, KSAllowedSeqs in, ArrayList<ArrayList<String>> allowedAAs, int lb, int ub) {
        this.strand = strand;
        this.limits = limits;
        this.dset = dset;
        this.freeBBZoneTermini = freeBBZoneTermini;
        this.moveableStrandTermini = moveableStrandTermini;
        this.flexRes = flexRes;
        this.allowedAAs = allowedAAs;
        this.wt = new ArrayList<String>(in.wt.subList(lb, ub));
        this.addWT = in.addWT;
        this.dist = in.dist;
        this.allowedSeqs = new ArrayList();
        for (ArrayList<String> seq : in.allowedSeqs) {
            this.allowedSeqs.add(new ArrayList<String>(seq.subList(lb, ub)));
        }
    }

    public ResidueTermini getStrandLimits() {
        return this.limits;
    }

    public static ArrayList<ArrayList<String>> removePosFromAllowedAAs(ArrayList<ArrayList<String>> in) {
        ArrayList ans = (ArrayList)ObjectIO.deepCopy(in);
        for (ArrayList list : ans) {
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, ((String)list.get(i)).split("-")[0]);
            }
        }
        return ans;
    }

    public static ArrayList<ArrayList<String>> addPosToAllowedAAs(ArrayList<ArrayList<String>> in, ArrayList<String> flexRes) {
        if (in.size() > flexRes.size()) {
            throw new RuntimeException("ERROR: cannot assign positions to all AAs in list.");
        }
        ArrayList<ArrayList<String>> ans = new ArrayList<ArrayList<String>>();
        for (int i = 0; i < in.size(); ++i) {
            ans.add(KSAllowedSeqs.addSinglePosToSeq(in.get(i), flexRes.get(i)));
        }
        ans.trimToSize();
        return ans;
    }

    private static ArrayList<String> addSinglePosToSeq(ArrayList<String> in, String pos) {
        ArrayList<String> ans = new ArrayList<String>();
        for (int i = 0; i < in.size(); ++i) {
            ans.add(in.get(i) + "-" + pos);
        }
        ans.trimToSize();
        return ans;
    }

    public static ArrayList<String> addPosToSeq(ArrayList<String> in, ArrayList<String> flexRes) {
        if (in.size() > flexRes.size()) {
            throw new RuntimeException("ERROR: cannot assign positions to all AAs in list.");
        }
        ArrayList<String> ans = new ArrayList<String>();
        for (int i = 0; i < in.size(); ++i) {
            ans.add(in.get(i) + "-" + flexRes.get(i));
        }
        return ans;
    }

    public static ArrayList<String> getAAsFromSeq(ArrayList<String> seq) {
        ArrayList<String> ans = new ArrayList<String>();
        for (String res : seq) {
            ans.add(res.split("-")[0]);
        }
        ans.trimToSize();
        return ans;
    }

    public static ArrayList<String> getFlexResFromSeq(ArrayList<String> seq) {
        ArrayList<String> ans = new ArrayList<String>();
        for (String res : seq) {
            ans.add(res.split("-")[1]);
        }
        ans.trimToSize();
        return ans;
    }

    public ArrayList<Integer> getFlexResIndexesFromSeq(ArrayList<String> seq) {
        ArrayList<String> seqFlexRes = KSAllowedSeqs.getFlexResFromSeq(seq);
        ArrayList<Integer> ans = new ArrayList<Integer>();
        block0: for (String pos : seqFlexRes) {
            for (int j = 0; j < this.flexRes.size(); ++j) {
                if (!pos.equalsIgnoreCase(this.flexRes.get(j))) continue;
                ans.add(j);
                continue block0;
            }
        }
        ans.trimToSize();
        return ans;
    }

    public int getFlexPosIndex(String res) {
        String flexPos = res.split("-")[1];
        for (int index = 0; index < this.flexRes.size(); ++index) {
            if (!flexPos.equalsIgnoreCase(this.flexRes.get(index))) continue;
            return index;
        }
        return Integer.MIN_VALUE;
    }

    public boolean isAllowed(String res) {
        int pos = this.getFlexPosIndex(res);
        if (pos == Integer.MIN_VALUE) {
            return false;
        }
        return this.allowedAAs.get(pos).contains(res);
    }

    public boolean isAllowed(ArrayList<String> seq) {
        for (String res : seq) {
            if (this.isAllowed(res)) continue;
            return false;
        }
        return true;
    }

    public int getStrand() {
        return this.strand;
    }

    public int getDistFromWT(ArrayList<String> seq) {
        if (seq.size() > this.wt.size()) {
            throw new RuntimeException("ERROR: sequence length > wt sequence length");
        }
        int dist = 0;
        for (int i = 0; i < seq.size(); ++i) {
            if (seq.get(i).compareTo(this.wt.get(i)) == 0) continue;
            ++dist;
        }
        return dist;
    }

    public DEEPerSettings getDEEPerSettings() {
        return this.dset;
    }

    public ArrayList<String[]> getMoveableStrandTermini() {
        return this.moveableStrandTermini;
    }

    public ArrayList<String[]> getFreeBBZoneTermini() {
        return this.freeBBZoneTermini;
    }

    public ArrayList<String> getFlexRes() {
        return this.flexRes;
    }

    public int getSequenceLength() {
        return this.flexRes.size();
    }

    public ArrayList<ArrayList<String>> getAllowedAAs() {
        return this.allowedAAs;
    }

    public ArrayList<HashSet<ArrayList<String>>> getStrandSubSeqList() {
        if (this.allowedSubSeqs == null) {
            this.allowedSubSeqs = new ArrayList();
            for (int depth = 0; depth < this.getSequenceLength(); ++depth) {
                this.allowedSubSeqs.add(new HashSet());
            }
            for (ArrayList<String> seq : this.allowedSeqs) {
                for (int i = 1; i < this.getSequenceLength(); ++i) {
                    ArrayList<String> tmp = new ArrayList<String>(seq.subList(0, i));
                    if (this.allowedSubSeqs.get(i).contains(tmp)) continue;
                    this.allowedSubSeqs.get(i).add(tmp);
                }
            }
            HashSet<ArrayList<String>> fullyDefSeqs = new HashSet<ArrayList<String>>(this.getStrandSeqList());
            this.allowedSubSeqs.add(fullyDefSeqs);
        }
        return this.allowedSubSeqs;
    }

    public ArrayList<HashSet<ArrayList<String>>> getStrandSubSeqList2(KSAllowedSeqs p, KSAllowedSeqs l) {
        if (this.strand != 2) {
            throw new RuntimeException("ERROR: this version of the method should only be called for the COMPLEX strand");
        }
        if (this.allowedSubSeqs == null) {
            int depth;
            this.allowedSubSeqs = new ArrayList();
            for (depth = 0; depth <= this.getSequenceLength(); ++depth) {
                this.allowedSubSeqs.add(new HashSet());
            }
            for (depth = 1; depth <= Math.max(p.getStrandSubSeqsMaxDepth(), l.getStrandSubSeqsMaxDepth()); ++depth) {
                int depthP = Math.min(depth, p.getStrandSubSeqsMaxDepth());
                int depthL = Math.min(depth, l.getStrandSubSeqsMaxDepth());
                for (ArrayList<String> subSeqP : p.getStrandSubSeqsAtDepth(depthP)) {
                    for (ArrayList<String> subSeqL : l.getStrandSubSeqsAtDepth(depthL)) {
                        if (p.getDistFromWT(subSeqP) + l.getDistFromWT(subSeqL) > this.dist) continue;
                        ArrayList<String> tmpSubSeq = new ArrayList<String>();
                        tmpSubSeq.addAll(subSeqP);
                        tmpSubSeq.addAll(subSeqL);
                        if (tmpSubSeq.size() == this.getSequenceLength() && this.getDistFromWT(tmpSubSeq) != this.dist) continue;
                        tmpSubSeq.trimToSize();
                        if (this.allowedSubSeqs.get(tmpSubSeq.size()).contains(tmpSubSeq)) continue;
                        this.allowedSubSeqs.get(tmpSubSeq.size()).add(tmpSubSeq);
                    }
                }
            }
        }
        return this.allowedSubSeqs;
    }

    public HashSet<ArrayList<String>> getStrandSubSeqsAtDepth(int depth, KSAllowedSeqs p, KSAllowedSeqs l) {
        if (this.strand != 2) {
            throw new RuntimeException("ERROR: this version of the method should only be called for the COMPLEX strand");
        }
        if (this.allowedSubSeqs == null) {
            this.getStrandSubSeqList2(p, l);
        }
        if (depth < 0 || depth > this.allowedSubSeqs.size() - 1) {
            throw new RuntimeException("ERROR: the requested depth " + depth + " is not within the valid range [0," + (this.allowedSubSeqs.size() - 1) + "]");
        }
        return this.allowedSubSeqs.get(depth);
    }

    public HashSet<ArrayList<String>> getStrandSubSeqsAtDepth(int depth) {
        if (this.allowedSubSeqs == null) {
            if (this.strand == 2) {
                throw new RuntimeException("ERROR: sub-sequences of the COMPLEX strand cannot be initialized using this method");
            }
            this.getStrandSubSeqList();
        }
        if (depth < 0 || depth > this.allowedSubSeqs.size() - 1) {
            throw new RuntimeException("ERROR: the requested depth " + depth + " is not within the valid range [0," + (this.allowedSubSeqs.size() - 1) + "]");
        }
        return this.allowedSubSeqs.get(depth);
    }

    public static void deleteFromSet(ArrayList<String> item, HashSet<ArrayList<String>> set) {
        Iterator<ArrayList<String>> iterator2 = set.iterator();
        while (iterator2.hasNext()) {
            ArrayList<String> element = iterator2.next();
            if (!element.containsAll(item)) continue;
            iterator2.remove();
        }
    }

    public int getNumSubSeqs() {
        int ans = 0;
        for (int depth = 0; depth <= this.getStrandSubSeqsMaxDepth(); ++depth) {
            ans += this.getStrandSubSeqsAtDepth(depth).size();
        }
        return ans;
    }

    public int getStrandSubSeqsMaxDepth() {
        return this.getFlexRes().size();
    }

    public void truncateAllowedAAs() {
        ArrayList newAllowedAAs = new ArrayList();
        for (int i = 0; i < this.getSequenceLength(); ++i) {
            ArrayList<String> aasAtPos = new ArrayList<String>();
            for (ArrayList<String> al : this.getStrandSeqList()) {
                String aa = al.get(i);
                if (aasAtPos.contains(aa)) continue;
                aasAtPos.add(aa);
            }
            aasAtPos.trimToSize();
            newAllowedAAs.add(aasAtPos);
        }
        newAllowedAAs.trimToSize();
        this.allowedAAs = newAllowedAAs;
    }

    public int getNumSeqs() {
        return this.allowedSeqs.size();
    }

    public ArrayList<ArrayList<String>> getStrandSeqList() {
        return this.allowedSeqs;
    }

    public int getPosOfSeq(ArrayList<String> seq) {
        if (this.allowedSeq2Index == null) {
            this.allowedSeq2Index = new LinkedHashMap();
            for (int index = 0; index < this.allowedSeqs.size(); ++index) {
                this.allowedSeq2Index.put(this.allowedSeqs.get(index), index);
            }
        }
        return this.allowedSeq2Index.get(seq);
    }

    public ArrayList<String> getStrandSeqAtPos(int index) {
        if (index > -1 && index < this.allowedSeqs.size()) {
            return this.allowedSeqs.get(index);
        }
        return null;
    }

    public ArrayList<String> getStrandSubSeq(int index, int begin, int end) {
        if (begin < 0 || end > this.getSequenceLength()) {
            throw new RuntimeException("ERROR: begin and end indexes [" + begin + "," + end + "] are out of range. Valid range is [0," + this.getSequenceLength() + "].");
        }
        ArrayList<String> seq = this.getStrandSeqAtPos(index);
        if (seq == null) {
            return null;
        }
        ArrayList<String> ans = new ArrayList<String>();
        for (int i = begin; i < end; ++i) {
            ans.add(seq.get(i));
        }
        return ans;
    }

    public ArrayList<String> removeStrandSeq(int index) {
        if (index > -1 && index < this.allowedSeqs.size()) {
            return this.allowedSeqs.remove(index);
        }
        throw new RuntimeException("ERROR: index " + index + " is invalid. Valid range is [0," + (this.getSequenceLength() - 1) + "]");
    }

    private ArrayList<ArrayList<String>> generateSequences() {
        return this.generateAllSequencesWithDist(this.allowedAAs);
    }

    private ArrayList<ArrayList<String>> generateAllSequencesWithDist(ArrayList<ArrayList<String>> input) {
        ArrayList<String> buffer = new ArrayList<String>();
        for (int it = 0; it < input.size(); ++it) {
            buffer.add("");
        }
        buffer.trimToSize();
        LinkedHashSet<ArrayList<String>> output = new LinkedHashSet<ArrayList<String>>();
        this.generatePermutations(input, output, buffer, 0, 0);
        boolean wtIsPresent = output.remove(this.wt);
        ArrayList<ArrayList<String>> ans = new ArrayList<ArrayList<String>>(output);
        if (this.addWT || wtIsPresent) {
            ans.add(0, this.wt);
        }
        int size = this.dist == 0 ? ans.size() : ans.size() - 1;
        System.out.println("\nNumber of sequences with " + this.dist + " mutation(s) from wild type: " + size + "\n");
        ans.trimToSize();
        return ans;
    }

    private void generatePermutations(ArrayList<ArrayList<String>> input, LinkedHashSet<ArrayList<String>> output, ArrayList<String> current, int depth, int diff) {
        if (output.size() >= this.maxSequences) {
            throw new RuntimeException("ERROR: the number of requested sequence combinations exceeds " + this.maxSequences + ". Reduce the value of the NUMMUTATIONS parameter.");
        }
        if (diff == this.dist) {
            if (depth != input.size()) {
                while (depth < this.wt.size()) {
                    current.set(depth, this.wt.get(depth));
                    ++depth;
                }
            }
            if (!output.contains(current)) {
                ArrayList<String> ans = new ArrayList<String>(current);
                ans.trimToSize();
                output.add(ans);
            }
            return;
        }
        if (depth == input.size()) {
            if ((diff == this.dist || this.allowLessMut) && !output.contains(current)) {
                ArrayList<String> ans = new ArrayList<String>(current);
                ans.trimToSize();
                output.add(ans);
            }
            return;
        }
        for (int it = 0; it < input.get(depth).size(); ++it) {
            int tmpDiff;
            current.set(depth, input.get(depth).get(it));
            int n = tmpDiff = current.get(depth).equalsIgnoreCase(this.wt.get(depth)) ? diff : diff + 1;
            if (tmpDiff > this.dist) continue;
            this.generatePermutations(input, output, current, depth + 1, tmpDiff);
        }
    }

    protected boolean isSpecifiedDist(ArrayList<String> s1, ArrayList<String> s2) {
        if (s1.size() != s2.size()) {
            throw new RuntimeException("Error: input strings " + String.valueOf(s1) + " and " + String.valueOf(s2) + " are not the same length.");
        }
        int dist = 0;
        for (int it = 0; it < s1.size(); ++it) {
            if (!s1.get(it).equalsIgnoreCase(s2.get(it))) {
                ++dist;
            }
            if (dist <= this.dist) continue;
            return false;
        }
        return dist == this.dist;
    }

    public ArrayList<String> getWTSeq() {
        return this.wt;
    }

    public boolean containsWTSeq() {
        if (this.allowedSeqs == null || this.allowedSeqs.size() < 1) {
            return false;
        }
        return this.allowedSeqs.get(0).equals(this.getWTSeq());
    }
}

