/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar;

import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SearchProblem;
import edu.duke.cs.osprey.control.ParamSet;
import edu.duke.cs.osprey.dof.deeper.DEEPerSettings;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.ematrix.EnergyMatrixCalculator;
import edu.duke.cs.osprey.ematrix.epic.EPICSettings;
import edu.duke.cs.osprey.energy.MultiTermEnergyFunction;
import edu.duke.cs.osprey.kstar.emat.ReducedEnergyMatrix;
import edu.duke.cs.osprey.kstar.pruning.InvertedPruningMatrix;
import edu.duke.cs.osprey.kstar.pruning.ReducedPruningMatrix;
import edu.duke.cs.osprey.kstar.pruning.UnprunedPruningMatrix;
import edu.duke.cs.osprey.multistatekstar.ResidueTermini;
import edu.duke.cs.osprey.pruning.Pruner;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import edu.duke.cs.osprey.tupexp.LUTESettings;
import java.math.BigInteger;
import java.util.ArrayList;

public class KSSearchProblem
extends SearchProblem {
    private static final long serialVersionUID = -6946555904198558059L;
    public ReducedPruningMatrix reducedMat = null;
    public InvertedPruningMatrix inverseMat = null;
    public ArrayList<String> flexibleRes = null;
    public ArrayList<ArrayList<String>> allowedAAs = null;
    public ArrayList<ArrayList<String>> reducedAllowedAAs = null;
    public ArrayList<Integer> posNums = null;
    public ParamSet params = null;

    public KSSearchProblem(ParamSet params, String name, String PDBFile, ArrayList<String> flexibleRes, ArrayList<ArrayList<String>> allowedAAs, boolean addWT, boolean contSCFlex, boolean useEPIC, EPICSettings epicSettings, boolean useTupExp, LUTESettings luteSettings, DEEPerSettings dset, ArrayList<String[]> moveableStrands, ArrayList<String[]> freeBBZones, boolean useEllipses, boolean useERef, boolean addResEntropy, boolean addWTRots, ResidueTermini termini, boolean useVoxelG) {
        super(name, PDBFile, flexibleRes, allowedAAs, addWT, contSCFlex, useEPIC, epicSettings, useTupExp, luteSettings, dset, moveableStrands, freeBBZones, useEllipses, useERef, addResEntropy, addWTRots, termini, useVoxelG, new ArrayList<String>());
        this.params = params;
        this.allowedAAs = allowedAAs;
        this.reducedAllowedAAs = allowedAAs;
        this.posNums = this.getMaxPosNums();
    }

    public KSSearchProblem(SearchProblem sp1) {
        super(sp1);
    }

    public KSSearchProblem(KSSearchProblem other, String newSPName, ArrayList<ArrayList<String>> reducedAllowedAAs, ArrayList<String> newFlexibleRes, ArrayList<Integer> newPosNums) {
        super(other);
        this.name = newSPName;
        this.allowedAAs = other.allowedAAs;
        this.reducedAllowedAAs = reducedAllowedAAs;
        this.flexibleRes = newFlexibleRes;
        this.posNums = newPosNums;
        this.contSCFlex = other.contSCFlex;
        this.useERef = other.useERef;
        this.addResEntropy = other.addResEntropy;
        this.emat = other.emat;
        this.epicMat = other.epicMat;
        this.tupExpEMat = other.tupExpEMat;
        this.shellResidues = other.shellResidues;
        this.fullConfE = other.fullConfE;
        this.pruneMat = other.pruneMat;
        this.competitorPruneMat = other.competitorPruneMat;
        this.confSpace = other.confSpace;
    }

    public MatrixType getMatrixType() {
        if (this.useEPIC) {
            throw new UnsupportedOperationException("ERROR: EPIC is currently not supported in K*");
        }
        return MatrixType.EMAT;
    }

    public EnergyMatrix getEnergyMatrix() {
        return this.emat;
    }

    public String getMatrixFileName(MatrixType type) {
        return this.name + "." + type.name() + ".dat";
    }

    public String getEnergyMatrixFileName() {
        return this.name + ".EMAT.dat";
    }

    public ArrayList<Integer> getMaxPosNums() {
        ArrayList<Integer> ans = new ArrayList<Integer>(this.allowedAAs.size());
        for (int i = 0; i < this.allowedAAs.size(); ++i) {
            ans.add(i);
        }
        return ans;
    }

    public InvertedPruningMatrix getInvertedFromUnreducedPruningMatrix(KSSearchProblem sp) {
        ReducedPruningMatrix unreduced = new ReducedPruningMatrix(this);
        InvertedPruningMatrix ans = new InvertedPruningMatrix(sp, unreduced.getUpdatedPruningMatrix());
        if (!this.pruneMatIsValid(ans)) {
            throw new RuntimeException("ERROR: pruning did not reduce RCs to sequence space of allowedAAs");
        }
        BigInteger numConfs = this.numConfs(ans);
        return numConfs.compareTo(BigInteger.ZERO) == 0 ? null : ans;
    }

    public InvertedPruningMatrix getInvertedFromReducedPruningMatrix(KSSearchProblem sp) {
        InvertedPruningMatrix ans = new InvertedPruningMatrix(sp, sp.reducedMat.getUpdatedPruningMatrix());
        if (!this.pruneMatIsValid(ans)) {
            throw new RuntimeException("ERROR: pruning did not reduce RCs to sequence space of allowedAAs");
        }
        BigInteger numConfs = this.numConfs(ans);
        return numConfs.compareTo(BigInteger.ZERO) == 0 ? null : ans;
    }

    public UnprunedPruningMatrix getUnprunedPruningMatrix(KSSearchProblem sp, double pruningInterval) {
        UnprunedPruningMatrix ans = new UnprunedPruningMatrix(sp, sp.reducedMat.getUpdatedPruningMatrix(), pruningInterval);
        if (!this.pruneMatIsValid(ans)) {
            throw new RuntimeException("ERROR: pruning did not reduce RCs to sequence space of allowedAAs");
        }
        BigInteger numConfs = this.numConfs(ans);
        return numConfs.compareTo(BigInteger.ZERO) == 0 ? null : ans;
    }

    protected ReducedPruningMatrix getReducedPruningMatrix(SearchProblem sp) {
        int oldNumUpdates;
        ReducedPruningMatrix ans = new ReducedPruningMatrix(this);
        for (int pos : this.posNums) {
            for (int rc : sp.pruneMat.unprunedRCsAtPos(pos)) {
                String rcAAType = this.confSpace.posFlex.get((int)pos).RCs.get((int)rc).AAType;
                if (this.reducedAllowedAAs.get(this.posNums.indexOf(pos)).contains(rcAAType)) continue;
                ans.getUpdatedPruningMatrix().markAsPruned(new RCTuple(pos, rc));
            }
        }
        for (int pos = 0; pos < sp.pruneMat.getNumPos(); ++pos) {
            if (this.posNums.contains(pos)) continue;
            for (int rc : sp.pruneMat.unprunedRCsAtPos(pos)) {
                ans.getUpdatedPruningMatrix().markAsPruned(new RCTuple(pos, rc));
            }
        }
        int numUpdates = ans.countUpdates();
        double stericThresh = this.params == null ? 100.0 : this.params.getDouble("StericThresh");
        Pruner dee = new Pruner(sp, ans.getUpdatedPruningMatrix(), true, stericThresh, ans.getPruningInterval(), sp.useEPIC, sp.useTupExpForSearch);
        dee.setVerbose(false);
        do {
            oldNumUpdates = numUpdates;
            dee.prune("GOLDSTEIN");
            dee.prune("GOLDSTEIN PAIRS FULL");
        } while ((numUpdates = ans.countUpdates()) > oldNumUpdates && this.numConfs(ans).compareTo(BigInteger.valueOf(50000L)) > 0);
        if (!this.pruneMatIsValid(ans)) {
            throw new RuntimeException("ERROR: pruning did not reduce RCs to sequence space of allowedAAs");
        }
        BigInteger numConfs = this.numConfs(ans);
        return numConfs.compareTo(BigInteger.ZERO) == 0 ? null : ans;
    }

    public KSSearchProblem getReducedSearchProblem(String name, ArrayList<ArrayList<String>> allowedAAs, ArrayList<String> flexRes, ArrayList<Integer> posNums) {
        KSSearchProblem reducedSP = new KSSearchProblem(this, name, allowedAAs, flexRes, posNums);
        reducedSP.reducedMat = reducedSP.getReducedPruningMatrix(reducedSP);
        if (reducedSP.reducedMat != null) {
            reducedSP.inverseMat = reducedSP.getInvertedFromReducedPruningMatrix(reducedSP);
        }
        return reducedSP;
    }

    public ArrayList<String> getAAsAtPos(PruningMatrix pruneMat, int pos) {
        ArrayList<String> ans = new ArrayList<String>();
        ArrayList<Integer> rcsAtPos = pruneMat.unprunedRCsAtPos(pos);
        for (int RCNum : rcsAtPos) {
            int pos1 = this.posNums.get(pos);
            String AAType = this.confSpace.posFlex.get((int)pos1).RCs.get((int)RCNum).AAType;
            if (ans.contains(AAType)) continue;
            ans.add(AAType);
        }
        return ans;
    }

    public ArrayList<Integer> rcsAtPos(PruningMatrix pruneMat, int pos, String aaType, boolean pruned) {
        ArrayList<Integer> ans = new ArrayList<Integer>();
        ArrayList<Integer> rcsAtPos = pruned ? pruneMat.prunedRCsAtPos(pos) : pruneMat.unprunedRCsAtPos(pos);
        for (int RCNum : rcsAtPos) {
            int pos1 = this.posNums.get(pos);
            String AAType = this.confSpace.posFlex.get((int)pos1).RCs.get((int)RCNum).AAType;
            if (!AAType.equalsIgnoreCase(aaType)) continue;
            ans.add(RCNum);
        }
        return ans;
    }

    private ArrayList<ArrayList<String>> getAAsAtPos(PruningMatrix pruneMat) {
        ArrayList<ArrayList<String>> ans = new ArrayList<ArrayList<String>>();
        for (int pos = 0; pos < pruneMat.getNumPos(); ++pos) {
            ans.add(this.getAAsAtPos(pruneMat, pos));
        }
        return ans;
    }

    private boolean pruneMatIsValid(PruningMatrix pruneMat) {
        ArrayList<ArrayList<String>> pruneMatAAs = this.getAAsAtPos(pruneMat);
        if (pruneMatAAs.size() != this.reducedAllowedAAs.size()) {
            return false;
        }
        for (int pos = 0; pos < this.reducedAllowedAAs.size(); ++pos) {
            for (String aaAtPos : pruneMatAAs.get(pos)) {
                if (this.reducedAllowedAAs.get(pos).contains(aaAtPos)) continue;
                return false;
            }
        }
        return true;
    }

    public BigInteger numConfs(PruningMatrix pruneMat) {
        if (pruneMat == null) {
            return BigInteger.ZERO;
        }
        BigInteger ans = BigInteger.ONE;
        for (int pos = 0; pos < pruneMat.getNumPos(); ++pos) {
            long numRCs = pruneMat.unprunedRCsAtPos(pos).size();
            if (numRCs == 0L) {
                return BigInteger.ZERO;
            }
            ans = ans.multiply(BigInteger.valueOf(numRCs));
        }
        return ans;
    }

    public EnergyMatrix getReducedEnergyMatrix() {
        if (this.posNums.size() == this.confSpace.numPos) {
            return this.emat;
        }
        return new ReducedEnergyMatrix(this, this.emat);
    }

    public MultiTermEnergyFunction decompMinimizedEnergy(int[] conf) {
        MultiTermEnergyFunction mef = this.confSpace.getDecomposedMinimizedEnergy(conf, this.fullConfE, null);
        double E = mef.getPreCompE();
        E += this.emat.getConstTerm();
        if (this.useERef) {
            E -= this.emat.geteRefMat().confERef(conf);
        }
        if (this.addResEntropy) {
            E += this.confSpace.getConfResEntropy(conf);
        }
        mef.setPreCompE(E);
        return mef;
    }

    public void mergeResiduePositions(int ... posToCombine) {
        EnergyMatrixCalculator emc = new EnergyMatrixCalculator(this.confSpace, this.shellResidues, this.useEPIC, this.reducedMat, this.epicSettings, false, this.emat);
        emc.addEnergyTerms(false, posToCombine);
    }

    public double lowerBoundContribByRC(int pos, int[] conf, int numResInHot) {
        double bound = this.emat.rcContribAtPos(pos, conf, numResInHot);
        return bound;
    }

    public static enum MatrixType {
        EMAT,
        EPICMAT;

    }
}

