/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar;

import edu.duke.cs.osprey.confspace.Sequence;
import edu.duke.cs.osprey.kstar.KStarScore;
import edu.duke.cs.osprey.tools.Log;
import edu.duke.cs.osprey.tools.MathTools;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public interface KStarScoreWriter {
    public void writeHeader();

    public void writeScore(ScoreInfo var1);

    public static interface Formatter {
        default public String header() {
            return null;
        }

        public String format(ScoreInfo var1);

        public static class Log
        implements Formatter {
            private final long startNs = System.nanoTime();

            @Override
            public String header() {
                return String.join((CharSequence)"\t", "Seq ID", "Sequence", "K* Lower Bound", "K* Upper Bound", "K* Lower (log10)", "K* Upper (log10)", "Total # Confs.", "Complex Pfunc Lower", "Complex Pfunc Upper", "Complex Free Energy Lower", "Complex Free Energy Upper", "Complex Epsilon", "Complex # Confs.", "Protein Pfunc Lower", "Protein Pfunc Upper", "Protein Free Energy Lower", "Protein Free Energy Upper", "Protein Epsilon", "Protein # Confs.", "Ligand Pfund Lower", "Ligand Pfund Upper", "Ligand Free Energy Lower", "Ligand Free Energy Upper", "Ligand Epsilon", "Ligand # Confs.", "Time (sec)");
            }

            @Override
            public String format(ScoreInfo info2) {
                return String.join((CharSequence)"\t", Integer.toString(info2.sequenceNumber), info2.sequence.toString(Sequence.Renderer.AssignmentMutations, info2.sequence.calcCellSize() + 1), edu.duke.cs.osprey.tools.Log.formatBigEngineering(info2.kstarScore.lowerBound), edu.duke.cs.osprey.tools.Log.formatBigEngineering(info2.kstarScore.upperBound), Double.toString(MathTools.log10(info2.kstarScore.lowerBound)), Double.toString(MathTools.log10(info2.kstarScore.upperBound)), Integer.toString(info2.kstarScore.protein.numConfs + info2.kstarScore.ligand.numConfs + info2.kstarScore.complex.numConfs), edu.duke.cs.osprey.tools.Log.formatBigEngineering(info2.kstarScore.complex.values.calcLowerBound()), edu.duke.cs.osprey.tools.Log.formatBigEngineering(info2.kstarScore.complex.values.calcUpperBound()), Double.toString(info2.kstarScore.complex.values.calcFreeEnergyLowerBoundPrecise()), Double.toString(info2.kstarScore.complex.values.calcFreeEnergyUpperBoundPrecise()), Double.toString(info2.kstarScore.complex.values.getEffectiveEpsilon()), Integer.toString(info2.kstarScore.complex.numConfs), edu.duke.cs.osprey.tools.Log.formatBigEngineering(info2.kstarScore.protein.values.calcLowerBound()), edu.duke.cs.osprey.tools.Log.formatBigEngineering(info2.kstarScore.protein.values.calcUpperBound()), Double.toString(info2.kstarScore.protein.values.calcFreeEnergyLowerBoundPrecise()), Double.toString(info2.kstarScore.protein.values.calcFreeEnergyUpperBoundPrecise()), Double.toString(info2.kstarScore.protein.values.getEffectiveEpsilon()), Integer.toString(info2.kstarScore.protein.numConfs), edu.duke.cs.osprey.tools.Log.formatBigEngineering(info2.kstarScore.ligand.values.calcLowerBound()), edu.duke.cs.osprey.tools.Log.formatBigEngineering(info2.kstarScore.ligand.values.calcUpperBound()), Double.toString(info2.kstarScore.ligand.values.calcFreeEnergyLowerBoundPrecise()), Double.toString(info2.kstarScore.ligand.values.calcFreeEnergyUpperBoundPrecise()), Double.toString(info2.kstarScore.ligand.values.getEffectiveEpsilon()), Integer.toString(info2.kstarScore.ligand.numConfs), Long.toString((info2.timeNs - this.startNs) / 1000000000L));
            }
        }

        public static class SequenceKStarPfuncs
        implements Formatter {
            @Override
            public String format(ScoreInfo info2) {
                return String.format("sequence %4d/%4d   %s   K*(log10): %-34s   protein: %-18s, numConfs: %4d, delta: %01.3f   ligand: %-18s, numConfs: %4d, delta: %01.3f   complex: %-18s, numConfs: %4d, delta: %01.3f", info2.sequenceNumber + 1, info2.numSequences, info2.sequence.toString(Sequence.Renderer.AssignmentMutations, info2.sequence.calcCellSize() + 1), info2.kstarScore.toString(), info2.kstarScore.protein.toString(), info2.kstarScore.protein.numConfs, info2.kstarScore.protein.values.getEffectiveEpsilon(), info2.kstarScore.ligand.toString(), info2.kstarScore.ligand.numConfs, info2.kstarScore.ligand.values.getEffectiveEpsilon(), info2.kstarScore.complex.toString(), info2.kstarScore.complex.numConfs, info2.kstarScore.complex.values.getEffectiveEpsilon());
            }
        }
    }

    public static class ToConsole
    extends Formatted {
        public ToConsole(Formatter formatter) {
            super(formatter);
        }

        @Override
        protected void write(String line) {
            System.out.println(line);
        }
    }

    public static class ToFile
    extends Formatted {
        public final File file;
        private boolean started = false;

        public ToFile(File file, Formatter formatter) {
            super(formatter);
            this.file = file;
        }

        @Override
        protected void write(String line) {
            boolean append = true;
            if (!this.started) {
                this.started = true;
                append = false;
            }
            try (FileWriter out = new FileWriter(this.file, append);){
                out.write(line);
                out.write("\n");
            }
            catch (IOException ex) {
                System.err.println("writing to file failed: " + String.valueOf(this.file));
                ex.printStackTrace(System.err);
                System.err.println(line);
            }
        }
    }

    public static abstract class Formatted
    implements KStarScoreWriter {
        public final Formatter formatter;

        protected Formatted(Formatter formatter) {
            this.formatter = formatter;
        }

        @Override
        public void writeHeader() {
            String header = this.formatter.header();
            if (header != null) {
                this.write(header);
            }
        }

        @Override
        public void writeScore(ScoreInfo info2) {
            this.write(this.formatter.format(info2));
        }

        protected abstract void write(String var1);
    }

    public static class Nop
    implements KStarScoreWriter {
        @Override
        public void writeHeader() {
        }

        @Override
        public void writeScore(ScoreInfo info2) {
        }
    }

    public static class Writers
    extends ArrayList<KStarScoreWriter> {
        private static final long serialVersionUID = 1239885431627352405L;

        public void writeHeader() {
            for (KStarScoreWriter writer : this) {
                writer.writeHeader();
            }
        }

        public void writeScore(ScoreInfo info2) {
            for (KStarScoreWriter writer : this) {
                writer.writeScore(info2);
            }
        }
    }

    public static class ScoreInfo {
        public final int sequenceNumber;
        public final int numSequences;
        public final Sequence sequence;
        public final KStarScore kstarScore;
        public final long timeNs;

        public ScoreInfo(int sequenceNumber, int numSequences, Sequence sequence) {
            this(sequenceNumber, numSequences, sequence, null);
        }

        public ScoreInfo(int sequenceNumber, int numSequences, Sequence sequence, KStarScore kstarScore) {
            this.sequenceNumber = sequenceNumber;
            this.numSequences = numSequences;
            this.sequence = sequence;
            this.kstarScore = kstarScore;
            this.timeNs = System.nanoTime();
        }
    }
}

