/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar.pfunc.impl;

import edu.duke.cs.osprey.kstar.KSConf;
import edu.duke.cs.osprey.kstar.KSConfigFileParser;
import edu.duke.cs.osprey.kstar.KSSearchProblem;
import edu.duke.cs.osprey.kstar.pfunc.PFAbstract;
import edu.duke.cs.osprey.kstar.pfunc.impl.PFTraditional;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;

public class PFUB
extends PFTraditional
implements Serializable {
    protected BigInteger enumeratedConfs = BigInteger.ZERO;

    public PFUB() {
    }

    public PFUB(int strand, ArrayList<String> sequence, ArrayList<Integer> absolutePos, String checkPointPath, String reducedSPName, KSConfigFileParser cfp, KSSearchProblem panSP) {
        super(strand, sequence, absolutePos, checkPointPath, reducedSPName, cfp, panSP);
    }

    protected void updateQStarUB(KSConf conf) {
        this.qStar = this.qStar.add(this.getBoltzmannWeight(conf.getEnergyBound()));
        this.enumeratedConfs = this.enumeratedConfs.add(BigInteger.ONE);
    }

    @Override
    protected BigInteger getNumUnEnumerated() {
        return this.unPrunedConfs.subtract(this.enumeratedConfs);
    }

    @Override
    protected void updateQPrime() {
        this.qPrime = this.getBoltzmannWeight(this.Et).multiply(new BigDecimal(this.getNumUnEnumerated()));
    }

    @Override
    protected double computeEffectiveEpsilon() {
        BigDecimal dividend = this.qPrime.add(this.pStar);
        BigDecimal divisor = this.qStar.add(dividend);
        if (divisor.compareTo(BigDecimal.ZERO) == 0) {
            return -2.0;
        }
        if (this.qStar.add(this.qPrime).compareTo(BigDecimal.ZERO) == 0) {
            return -2.0;
        }
        double delta = this.qPrime.add(this.pStar).divide(this.qStar, 4).doubleValue();
        return delta;
    }

    @Override
    protected void accumulate(KSConf conf) {
        double d;
        this.updateQStarUB(conf);
        this.Et = conf.getEnergyBound();
        this.updateQPrime();
        this.effectiveEpsilon = this.computeEffectiveEpsilon();
        if (d < 0.0) {
            this.eAppx = PFAbstract.EApproxReached.NOT_POSSIBLE;
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (!PFAbstract.suppressOutput) {
            if (!this.printedHeader) {
                this.printHeader();
            }
            if (this.enumeratedConfs.longValue() % 512L == 0L) {
                System.out.println(this.numberFormat.format(this.Et) + "\t" + this.numberFormat.format(this.effectiveEpsilon) + "\t" + String.valueOf(this.enumeratedConfs) + "\t" + String.valueOf(this.getNumUnEnumerated()) + "\t" + (currentTime - this.startTime) / 1000L);
            }
        }
        PFAbstract.EApproxReached eApproxReached = this.eAppx = this.effectiveEpsilon <= targetEpsilon || this.maxKSConfsReached() ? PFAbstract.EApproxReached.TRUE : PFAbstract.EApproxReached.FALSE;
        if (this.eAppx == PFAbstract.EApproxReached.TRUE) {
            this.qStar = this.qStar.multiply(new BigDecimal(1.0 + this.effectiveEpsilon));
            if (!this.isFullyDefined()) {
                this.adjustQStar();
            }
        }
    }

    @Override
    protected void printHeader() {
        System.out.println("minELB\tdelta\t#enum\t#un-enum\ttime(sec)");
        this.printedHeader = true;
    }

    @Override
    public String getImpl() {
        return "UB";
    }
}

