/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar.pruning;

import edu.duke.cs.osprey.confspace.PositionConfSpace;
import edu.duke.cs.osprey.gmec.GMECFinder;
import edu.duke.cs.osprey.kstar.KSAbstract;
import edu.duke.cs.osprey.kstar.KSAllowedSeqs;
import edu.duke.cs.osprey.kstar.KSConfigFileParser;
import edu.duke.cs.osprey.kstar.KSSearchProblem;
import java.util.HashMap;

public class APrioriPruningProver {
    KSConfigFileParser cfp;
    HashMap<Integer, KSAllowedSeqs> strand2AllowedSeqs;
    KSAbstract ks;
    boolean contSCFlex;

    public APrioriPruningProver(KSAbstract ks, KSConfigFileParser cfp, HashMap<Integer, KSAllowedSeqs> strand2AllowedSeqs) {
        this.ks = ks;
        this.cfp = cfp;
        this.strand2AllowedSeqs = strand2AllowedSeqs;
        this.contSCFlex = cfp.params.getBool("doMinimize", true);
    }

    public double calcI0() {
        double I0 = 0.0;
        if (!this.contSCFlex) {
            return 0.0;
        }
        if (!this.cfp.params.getBool("iMinDEE")) {
            throw new RuntimeException("ERROR: Trying to calc I0 but not using iMinDEE");
        }
        System.out.println("Determining I0 to get provable K*");
        for (int strand : new int[]{0, 1, 2}) {
            KSSearchProblem strandSP = this.ks.createPanSeqSP(this.contSCFlex, strand);
            GMECFinder strandGF = new GMECFinder();
            strandGF.init(this.cfp, strandSP);
            double gmec = strandGF.calcGMECEnergy();
            double lowestBound = strandGF.getLowestBound();
            I0 = Math.max(I0, gmec - lowestBound);
        }
        double stabilityGap = this.cfp.params.getDouble("StabilityGap", 10.0);
        System.out.println("I0 to get provable K*: " + (I0 += stabilityGap));
        return I0;
    }

    public double calcEw() {
        double epsilon = this.cfp.params.getDouble("epsilon");
        if (epsilon <= 0.0 || epsilon >= 1.0) {
            throw new RuntimeException("ERROR: Can't calc Ew based on this epsilon: " + epsilon);
        }
        double Ew = -0.593050165 * Math.log(epsilon);
        KSSearchProblem complexSP = this.ks.createPanSeqSP(this.contSCFlex, 2);
        for (int pos = 0; pos < complexSP.confSpace.numPos; ++pos) {
            PositionConfSpace pcs = complexSP.confSpace.posFlex.get(pos);
            Ew += 0.593050165 * Math.log(pcs.maxNumRCsPerResType());
        }
        System.out.println("Ew to get provable K*: " + Ew);
        return Ew;
    }
}

