/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.lute;

import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.lute.LUTE;

public class LUTEState {
    public final RCTuple[] tuples;
    public final double[] tupleEnergies;
    public double tupleEnergyOffset;

    public LUTEState(int numTuples) {
        this.tuples = new RCTuple[numTuples];
        this.tupleEnergies = new double[numTuples];
        this.tupleEnergyOffset = 0.0;
    }

    public LUTEState(LUTE.LinearSystem system) {
        this(system.tuples.size());
        this.set(system);
    }

    public void set(LUTE.LinearSystem system) {
        this.tupleEnergyOffset = system.tupleEnergyOffset;
        for (int i = 0; i < this.tuples.length; ++i) {
            this.tuples[i] = system.tuples.get(i);
            this.tupleEnergies[i] = system.tupleEnergies[i];
        }
    }

    public boolean equals(Object other) {
        return other instanceof LUTEState && this.equals((LUTEState)other);
    }

    public boolean equals(LUTEState other) {
        if (this.tuples.length != other.tuples.length) {
            return false;
        }
        for (int i = 0; i < this.tuples.length; ++i) {
            if (!this.tuples[i].equals(other.tuples[i])) {
                return false;
            }
            if (this.tupleEnergies[i] == other.tupleEnergies[i]) continue;
            return false;
        }
        return this.tupleEnergyOffset == other.tupleEnergyOffset;
    }
}

