/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.markstar;

import edu.duke.cs.osprey.astar.conf.ConfIndex;
import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.astar.conf.scoring.AStarScorer;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;

public class UpperBoundScorer
implements AStarScorer {
    private EnergyMatrix emat;

    public UpperBoundScorer(EnergyMatrix emat) {
        this.emat = emat;
    }

    @Override
    public UpperBoundScorer make() {
        return new UpperBoundScorer(this.emat);
    }

    @Override
    public double calc(ConfIndex index, RCs rcs) {
        double uscore = 0.0;
        for (int i = 0; i < index.numUndefined; ++i) {
            int pos1 = index.undefinedPos[i];
            double pos1Score = Double.NEGATIVE_INFINITY;
            for (int rc1 : rcs.get(pos1)) {
                int pos2;
                int j;
                double rcContrib = this.emat.getOneBody(pos1, rc1);
                for (j = 0; j < index.numDefined; ++j) {
                    pos2 = index.definedPos[j];
                    int rc2 = index.definedRCs[j];
                    rcContrib += this.emat.getPairwise(pos1, rc1, pos2, rc2).doubleValue();
                }
                for (j = 0; j < index.numUndefined && (pos2 = index.undefinedPos[j]) < pos1; ++j) {
                    double maxEnergy = Double.NEGATIVE_INFINITY;
                    for (int rc2 : rcs.get(pos2)) {
                        double pairwiseEnergy = this.emat.getPairwise(pos1, rc1, pos2, rc2);
                        maxEnergy = Math.max(maxEnergy, pairwiseEnergy);
                    }
                    rcContrib += maxEnergy;
                }
                pos1Score = Math.max(pos1Score, rcContrib);
            }
            uscore += pos1Score;
        }
        return uscore;
    }
}

