/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.markstar.visualizer;

import edu.duke.cs.osprey.markstar.visualizer.KStarTreeNode;
import edu.duke.cs.osprey.tools.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javafx.application.Application;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextInputDialog;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.jetbrains.annotations.NotNull;

public class Visualizer
extends Application {
    private static final double SCALE_DELTA = 1.1;
    Stage primaryStage;
    BorderPane triroot;
    Pane ringNode;
    KStarTreeNode root;
    Group rootGroup;
    private double mouseDownX;
    private double mouseDownY;
    private double ringX;
    private double ringY;

    public void start(Stage primaryStage) {
        this.primaryStage = primaryStage;
        primaryStage.setTitle("MARK* Tree Analyzer (v0.2)");
        this.triroot = new BorderPane();
        this.triroot.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.color((double)1.0, (double)1.0, (double)1.0), CornerRadii.EMPTY, Insets.EMPTY)}));
        Scene test2 = new Scene((Parent)this.triroot, 300.0, 275.0);
        primaryStage.setScene(test2);
        MenuBar menuBar = this.getMenuBar(primaryStage);
        this.triroot.setTop((Node)menuBar);
        primaryStage.setScene(test2);
        primaryStage.show();
    }

    @NotNull
    private MenuBar getMenuBar(Stage primaryStage) {
        Menu file = new Menu("File");
        Menu options = new Menu("Options");
        Menu help = new Menu("Help");
        MenuItem loadTree = new MenuItem("Load tree!");
        loadTree.setOnAction(e -> {
            FileChooser fc = new FileChooser();
            File selectedFile = fc.showOpenDialog((Window)primaryStage);
            this.loadTreeFromFile(selectedFile);
        });
        MenuItem helpDevShortCut = new MenuItem("DevShortCut");
        helpDevShortCut.setOnAction(e -> this.devShortCut());
        help.getItems().add((Object)helpDevShortCut);
        MenuItem helpDevShortCut2 = new MenuItem("DevShortCut2");
        helpDevShortCut2.setOnAction(e -> this.devShortCut2());
        help.getItems().add((Object)helpDevShortCut2);
        MenuItem helpDevShortCut3 = new MenuItem("DevShortCut3");
        helpDevShortCut3.setOnAction(e -> this.devShortCut3());
        MenuItem setvisibleLevels = new MenuItem("Set visible levels");
        setvisibleLevels.setOnAction(e -> {
            TextInputDialog dialog = new TextInputDialog("1");
            dialog.setHeaderText("Input levels to show");
            Optional result = dialog.showAndWait();
            result.ifPresent(levelsString -> {
                int[] levels = Arrays.stream(levelsString.split(",")).mapToInt(Integer::parseInt).toArray();
                this.root.pieChart(levels);
            });
        });
        MenuItem colorByOccupancy = new MenuItem("Color by statistical weight");
        colorByOccupancy.setOnAction(e -> this.root.setColorStyle(KStarTreeNode.ColorStyle.occupancy));
        MenuItem colorByEnergy = new MenuItem("Color by energy");
        colorByEnergy.setOnAction(e -> this.root.setColorStyle(KStarTreeNode.ColorStyle.differenceFromEnergy));
        MenuItem colorByLogOccupancy = new MenuItem("Color by log statistical weight");
        colorByLogOccupancy.setOnAction(e -> this.root.setColorStyle(KStarTreeNode.ColorStyle.logOccupancy));
        MenuItem toggleCenter = new MenuItem("Show/Hide white center");
        toggleCenter.setOnAction(e -> this.root.toggleCenter());
        help.getItems().add((Object)helpDevShortCut3);
        file.getItems().add((Object)loadTree);
        options.getItems().addAll((Object[])new MenuItem[]{setvisibleLevels, toggleCenter, colorByEnergy, colorByOccupancy, colorByLogOccupancy});
        MenuBar menuBar = new MenuBar();
        menuBar.getMenus().addAll((Object[])new Menu[]{file, options, help});
        Button button = new Button();
        button.setText("Click me!");
        return menuBar;
    }

    private void devShortCut3() {
        this.loadTreeFromFile(new File("/tmp/0.389867ConfTreeBounds.txt"));
    }

    private void devShortCut2() {
        this.loadTreeFromFile(new File("Protein2XXMContinuousBounds.txt"));
    }

    private void devShortCut() {
        this.loadTreeFromFile(new File("Complex2XXMContinuousBounds.txt"));
    }

    private void loadTreeFromFile(File selectedFile) {
        this.ringNode = new Pane();
        System.out.println("Parsing " + String.valueOf(selectedFile));
        this.rootGroup = new Group();
        Group ringGroup = new Group();
        Group textGroup = new Group();
        Group g = this.rootGroup;
        Pane centerPane = new Pane();
        Log.log("reading tree file for calibration, pass 1 ...", new Object[0]);
        HashMap biggestZByLevel = new HashMap();
        AtomicLong numNodes = new AtomicLong(0L);
        try (BufferedReader fileStream = new BufferedReader(new FileReader(selectedFile));){
            fileStream.lines().forEach(line -> {
                Matcher m = KStarTreeNode.p.matcher((CharSequence)line);
                m.matches();
                int level = m.group(1).length() / 2;
                BigDecimal upperBound = new BigDecimal(m.group(6).split(",")[1]);
                biggestZByLevel.compute(level, (key, old) -> {
                    if (old == null || upperBound.compareTo((BigDecimal)old) > 0) {
                        return upperBound;
                    }
                    return old;
                });
                numNodes.incrementAndGet();
            });
        }
        catch (Exception ex) {
            throw new RuntimeException("can't read tree file", ex);
        }
        Log.log("finished parsing %d nodes", numNodes.get());
        Log.log("biggest Z upper bounds for each level:", new Object[0]);
        for (Map.Entry entry : biggestZByLevel.entrySet()) {
            int level = (Integer)entry.getKey();
            BigDecimal upperBound = (BigDecimal)entry.getValue();
            Log.log("\t%2d -> %e", level, upperBound);
        }
        double cutoffFactor = 0.01;
        Log.log("cutoff factor: %f", 0.01);
        BigDecimal bigScale = BigDecimal.valueOf(0.01);
        Map<Integer, BigDecimal> zCutoffsByLevel = biggestZByLevel.entrySet().stream().collect(Collectors.toMap(e -> (Integer)e.getKey(), e -> ((BigDecimal)e.getValue()).multiply(bigScale)));
        for (Map.Entry<Integer, BigDecimal> entry : zCutoffsByLevel.entrySet()) {
            int level = entry.getKey();
            BigDecimal upperBound = entry.getValue();
            Log.log("\t%2d: %e", level, upperBound);
        }
        Log.log("reading tree file for display, pass 2 ...", new Object[0]);
        this.root = KStarTreeNode.parseTree(selectedFile, true, zCutoffsByLevel);
        this.rootGroup.getChildren().addAll((Object[])new Node[]{ringGroup, textGroup});
        this.root.setGroup(ringGroup);
        this.root.preprocess();
        this.root.render(g);
        this.root.setTextRoot(textGroup);
        this.root.autoExpand(0.001);
        this.resize();
        this.root.showRoot();
        centerPane.getChildren().addAll((Object[])new Node[]{g});
        this.triroot.setCenter((Node)centerPane);
        centerPane.setOnScroll(event -> {
            if (event.getDeltaY() == 0.0) {
                return;
            }
            double scaleFactor = event.getDeltaY() > 0.0 ? 1.1 : 0.9090909090909091;
            double mouseX = event.getX();
            double mouseY = event.getY();
            Point2D mouseXY = new Point2D(mouseX, mouseY);
            Point2D mouseLocal = ringGroup.sceneToLocal(mouseXY);
            ringGroup.setScaleX(ringGroup.getScaleX() * scaleFactor);
            ringGroup.setScaleY(ringGroup.getScaleY() * scaleFactor);
            Point2D movedMouseScene = ringGroup.localToScene(mouseLocal);
            ringGroup.setTranslateX(ringGroup.getTranslateX() + mouseX - movedMouseScene.getX());
            ringGroup.setTranslateY(ringGroup.getTranslateY() + mouseY - movedMouseScene.getY());
        });
        centerPane.setOnMousePressed(event -> {
            this.mouseDownX = event.getX();
            this.mouseDownY = event.getY();
            Point2D mouseXY = new Point2D(this.mouseDownX, this.mouseDownY);
            Point2D mouseLocal = ringGroup.sceneToLocal(mouseXY);
            Point2D ringScene = ringGroup.localToScene(mouseXY);
            this.ringX = ringGroup.getTranslateX();
            this.ringY = ringGroup.getTranslateY();
        });
        centerPane.setOnMouseDragged(event -> {
            double x = event.getX();
            double y = event.getY();
            ringGroup.setTranslateX(this.ringX + (x - this.mouseDownX));
            ringGroup.setTranslateY(this.ringY + (y - this.mouseDownY));
        });
        this.triroot.setTop((Node)this.getMenuBar(this.primaryStage));
    }

    private void resize() {
        double width = this.triroot.getWidth() - this.triroot.getInsets().getLeft() - this.triroot.getInsets().getRight();
        double height = this.triroot.getHeight() - this.triroot.getInsets().getTop() - this.triroot.getInsets().getBottom();
        this.triroot.setMaxSize(width, height);
        this.triroot.setPrefSize(width, height);
        this.rootGroup.setTranslateX(width / 2.0);
        this.rootGroup.setTranslateY(height / 2.0);
    }

    public static void main(String[] args) {
        Visualizer.launch((String[])args);
    }
}

