/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.minimization;

import cern.colt.matrix.DoubleMatrix1D;
import edu.duke.cs.osprey.minimization.ObjectiveFunction;
import edu.duke.cs.osprey.tools.AutoCleanable;

public interface Minimizer
extends AutoCleanable {
    default public Result minimize() {
        return this.minimizeFromCenter();
    }

    public Result minimizeFromCenter();

    public Result minimizeFrom(DoubleMatrix1D var1);

    @Override
    default public void clean() {
        Tools.cleanIfNeeded(this);
    }

    public static class Result {
        public DoubleMatrix1D dofValues;
        public double energy;

        public Result(DoubleMatrix1D dofValues, double energy) {
            this.dofValues = dofValues;
            this.energy = energy;
        }
    }

    public static class Tools {
        public static void cleanIfNeeded(Minimizer minimizer) {
            if (minimizer != null && minimizer instanceof NeedsCleanup) {
                ((NeedsCleanup)minimizer).cleanWithoutCrashing();
            }
        }
    }

    public static interface Reusable
    extends Minimizer {
        public void init(ObjectiveFunction var1);
    }

    public static interface NeedsCleanup
    extends Minimizer,
    AutoCleanable {
    }
}

