/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.minimization;

import cern.colt.matrix.DoubleMatrix1D;
import edu.duke.cs.osprey.minimization.LineSearcher;
import edu.duke.cs.osprey.minimization.Minimizer;
import edu.duke.cs.osprey.minimization.ObjectiveFunction;
import edu.duke.cs.osprey.minimization.SurfingLineSearcher;
import edu.duke.cs.osprey.tools.Factory;
import java.util.ArrayList;
import java.util.List;

public class SimpleCCDMinimizer
implements Minimizer.NeedsCleanup,
Minimizer.Reusable {
    private static final double MaxIterations = 30.0;
    private static final double ConvergenceThreshold = 0.001;
    private Factory<LineSearcher, Void> lineSearcherFactory;
    private ObjectiveFunction f;
    private List<LineSearcher> lineSearchers;

    public SimpleCCDMinimizer() {
        this((Void context) -> new SurfingLineSearcher());
    }

    public SimpleCCDMinimizer(ObjectiveFunction f) {
        this();
        this.init(f);
    }

    public SimpleCCDMinimizer(Factory<LineSearcher, Void> lineSearcherFactory) {
        this.lineSearcherFactory = lineSearcherFactory;
        this.lineSearchers = new ArrayList<LineSearcher>();
    }

    @Override
    public void init(ObjectiveFunction f) {
        this.f = f;
        this.lineSearchers.clear();
        for (int d = 0; d < f.getNumDOFs(); ++d) {
            ObjectiveFunction.OneDof fd = new ObjectiveFunction.OneDof(f, d);
            if (fd.getXMin() < fd.getXMax()) {
                LineSearcher lineSearcher = this.lineSearcherFactory.make(null);
                lineSearcher.init(fd);
                this.lineSearchers.add(lineSearcher);
                continue;
            }
            this.lineSearchers.add(null);
        }
    }

    @Override
    public Minimizer.Result minimizeFromCenter() {
        return this.minimizeFrom(this.f.getDOFsCenter());
    }

    @Override
    public Minimizer.Result minimizeFrom(DoubleMatrix1D startx) {
        int n = this.f.getNumDOFs();
        DoubleMatrix1D herex = startx.copy();
        DoubleMatrix1D nextx = startx.copy();
        double herefx = this.f.getValue(herex);
        int iter = 0;
        while ((double)iter < 30.0) {
            for (int d = 0; d < n; ++d) {
                LineSearcher lineSearcher = this.lineSearchers.get(d);
                if (lineSearcher == null) continue;
                double xd = nextx.get(d);
                xd = lineSearcher.search(xd);
                nextx.set(d, xd);
            }
            double nextfx = this.f.getValue(nextx);
            double improvement = herefx - nextfx;
            if (!(improvement > 0.0)) break;
            herex.assign(nextx);
            herefx = nextfx;
            if (improvement < 0.001) break;
            ++iter;
        }
        this.f.setDOFs(herex);
        return new Minimizer.Result(herex, herefx);
    }

    @Override
    public void clean() {
        for (LineSearcher lineSearcher : this.lineSearchers) {
            if (!(lineSearcher instanceof LineSearcher.NeedsCleanup)) continue;
            ((LineSearcher.NeedsCleanup)lineSearcher).cleanup();
        }
    }
}

