/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.multistatekstar;

import java.math.BigDecimal;
import java.util.StringTokenizer;

public class LMB {
    BigDecimal[] coeffs;
    BigDecimal constTerm;
    boolean correctConstTerm;

    public LMB(String s, int numStates) {
        StringTokenizer st = new StringTokenizer(s);
        if (st.countTokens() != numStates + 1) {
            throw new RuntimeException("ERROR: there are " + numStates + " states but LinFunc specified with " + st.countTokens() + " coefficients: " + s);
        }
        this.coeffs = new BigDecimal[numStates];
        for (int state = 0; state < numStates; ++state) {
            this.coeffs[state] = new BigDecimal(st.nextToken());
        }
        String s1 = st.nextToken().replaceAll("\\s+", "").toLowerCase();
        if (s1.endsWith("xwt")) {
            this.constTerm = new BigDecimal(s1.split("x")[0]);
            this.correctConstTerm = true;
        } else {
            this.constTerm = new BigDecimal(s1);
            this.correctConstTerm = false;
        }
    }

    BigDecimal[] getCoeffs() {
        return this.coeffs;
    }

    boolean correctConstTerm() {
        return this.correctConstTerm;
    }

    void correctConstTerm(BigDecimal correction) {
        this.constTerm = this.constTerm.multiply(correction);
    }

    BigDecimal getConstTerm() {
        return this.constTerm;
    }

    BigDecimal eval(BigDecimal[] stateVals) {
        if (stateVals.length != this.coeffs.length) {
            throw new RuntimeException("ERROR: Wrong number of state values");
        }
        BigDecimal ans = BigDecimal.ZERO;
        for (int c = 0; c < this.coeffs.length; ++c) {
            if (this.coeffs[c].compareTo(BigDecimal.ZERO) == 0) continue;
            ans = ans.add(this.coeffs[c].multiply(stateVals[c]));
        }
        ans = ans.add(this.constTerm);
        return ans;
    }
}

