/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.parallelism;

import edu.duke.cs.osprey.Cleaner;
import edu.duke.cs.osprey.parallelism.ConcurrentTaskExecutor;
import edu.duke.cs.osprey.parallelism.TaskExecutor;
import edu.duke.cs.osprey.parallelism.Threads;
import java.util.concurrent.TimeUnit;

public class ThreadPoolTaskExecutor
extends ConcurrentTaskExecutor
implements Cleaner.GarbageDetectable {
    public int queueSize = 0;
    private Threads threads = null;

    public void start(int numThreads) {
        this.threads = new Threads(numThreads, this.queueSize);
        Cleaner.addCleaner(this, this.threads);
    }

    public void stop() {
        if (this.threads != null) {
            this.threads.clean();
            this.threads = null;
        }
    }

    public void stopAndWait(int timeoutMs) {
        if (this.threads != null) {
            this.threads.cleanAndWait(timeoutMs);
            this.threads = null;
        }
    }

    @Override
    public void clean() {
        this.stop();
    }

    @Override
    public int getParallelism() {
        return this.threads.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void submit(TaskExecutor.Task<T> task, TaskExecutor.TaskListener<T> listener) {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = this;
        synchronized (threadPoolTaskExecutor) {
            boolean wasAdded = false;
            while (!wasAdded) {
                this.checkException();
                wasAdded = this.threads.submit(400L, TimeUnit.MILLISECONDS, () -> {
                    try {
                        Object result = this.runTask(task);
                        this.threads.submitToListener(() -> this.taskSuccess(task, listener, result));
                    }
                    catch (Throwable t) {
                        this.taskFailure(task, listener, t);
                    }
                });
            }
            this.startedTask();
        }
    }
}

