/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.parallelism;

import edu.duke.cs.osprey.Cleaner;

public abstract class WorkThread
extends Thread
implements Cleaner.Cleanable {
    private volatile boolean isRunning;

    protected WorkThread(String name) {
        super(name);
        this.setDaemon(true);
        this.isRunning = false;
    }

    public boolean isRunning() {
        return this.isRunning();
    }

    public void askToStop() {
        this.isRunning = false;
    }

    public void askToStopAndWait() throws InterruptedException {
        this.askToStop();
        this.join();
    }

    @Override
    public void run() {
        this.isRunning = true;
        while (this.isRunning) {
            try {
                this.doWork();
            }
            catch (InterruptedException ex) {
                // empty catch block
                break;
            }
        }
        this.isRunning = false;
    }

    protected abstract void doWork() throws InterruptedException;

    @Override
    public void clean() {
        this.askToStop();
    }
}

