/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.paste;

import edu.duke.cs.osprey.confspace.Sequence;
import edu.duke.cs.osprey.paste.PasteScore;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public interface PasteScoreWriter {
    public void writeHeader();

    public void writeScore(ScoreInfo var1);

    public static interface Formatter {
        default public String header() {
            return null;
        }

        public String format(ScoreInfo var1);

        public static class Log
        implements Formatter {
            private final long startNs = System.nanoTime();

            @Override
            public String header() {
                return String.join((CharSequence)"\t", "Sequence", "PAStE Score (ddG)", "PAStE Lower Bound", "PAStE Upper Bound", "Variant Bounds", "WT Bounds", "Total # Confs.", "Protein Partition Function", "Protein Epsilon", "Protein # Confs.", "Time (sec)");
            }

            @Override
            public String format(ScoreInfo info2) {
                return String.join((CharSequence)"\t", info2.sequence.toString(Sequence.Renderer.AssignmentMutations, info2.sequence.calcCellSize() + 1), info2.pasteScore.toString(), info2.pasteScore.lowerBoundLog10String(), info2.pasteScore.upperBoundLog10String(), info2.pasteScore.protein.toString(), info2.pasteScore.wt.toString(), Integer.toString(info2.pasteScore.protein.numConfs), String.format("%e", info2.pasteScore.protein.values.qstar.doubleValue()), Double.toString(info2.pasteScore.protein.values.getEffectiveEpsilon()), Integer.toString(info2.pasteScore.protein.numConfs));
            }
        }

        public static class SequenceKStarPfuncs
        implements Formatter {
            @Override
            public String format(ScoreInfo info2) {
                return String.format("%s   PAStE ddG: %-34s   ", info2.sequence.toString(Sequence.Renderer.AssignmentMutations, info2.sequence.calcCellSize() + 1), info2.pasteScore.toString());
            }
        }
    }

    public static class ToConsole
    extends Formatted {
        public ToConsole(Formatter formatter) {
            super(formatter);
        }

        @Override
        protected void write(String line) {
            System.out.println(line);
        }
    }

    public static class ToFile
    extends Formatted {
        public final File file;
        private boolean started = false;

        public ToFile(File file, Formatter formatter) {
            super(formatter);
            this.file = file;
        }

        @Override
        protected void write(String line) {
            boolean append = true;
            if (!this.started) {
                this.started = true;
                append = false;
            }
            try (FileWriter out = new FileWriter(this.file, append);){
                out.write(line);
                out.write("\n");
            }
            catch (IOException ex) {
                System.err.println("writing to file failed: " + String.valueOf(this.file));
                ex.printStackTrace(System.err);
                System.err.println(line);
            }
        }
    }

    public static abstract class Formatted
    implements PasteScoreWriter {
        public final Formatter formatter;

        protected Formatted(Formatter formatter) {
            this.formatter = formatter;
        }

        @Override
        public void writeHeader() {
            String header = this.formatter.header();
            if (header != null) {
                this.write(header);
            }
        }

        @Override
        public void writeScore(ScoreInfo info2) {
            this.write(this.formatter.format(info2));
        }

        protected abstract void write(String var1);
    }

    public static class Nop
    implements PasteScoreWriter {
        @Override
        public void writeHeader() {
        }

        @Override
        public void writeScore(ScoreInfo info2) {
        }
    }

    public static class Writers
    extends ArrayList<PasteScoreWriter> {
        private static final long serialVersionUID = 1239885431627352405L;

        public void writeHeader() {
            for (PasteScoreWriter writer : this) {
                writer.writeHeader();
            }
        }

        public void writeScore(ScoreInfo info2) {
            for (PasteScoreWriter writer : this) {
                writer.writeScore(info2);
            }
        }
    }

    public static class ScoreInfo {
        public final int sequenceNumber;
        public final int numSequences;
        public final Sequence sequence;
        public final PasteScore pasteScore;
        public final long timeNs;

        public ScoreInfo(int sequenceNumber, int numSequences, Sequence sequence, PasteScore pasteScore) {
            this.sequenceNumber = sequenceNumber;
            this.numSequences = numSequences;
            this.sequence = sequence;
            this.pasteScore = pasteScore;
            this.timeNs = System.nanoTime();
        }
    }
}

