/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.plug;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.jet.math.Functions;
import com.joptimizer.functions.LinearMultivariateRealFunction;
import java.util.ArrayList;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.linear.LinearConstraint;
import org.apache.commons.math3.optim.linear.LinearConstraintSet;
import org.apache.commons.math3.optim.linear.LinearObjectiveFunction;
import org.apache.commons.math3.optim.linear.NoFeasibleSolutionException;
import org.apache.commons.math3.optim.linear.Relationship;
import org.apache.commons.math3.optim.linear.SimplexSolver;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;

public class LPChecks {
    public static boolean canAddConstr(LinearConstraint newConstr, ArrayList<LinearConstraint> oldConstr) {
        SimplexSolver ss = new SimplexSolver();
        LinearObjectiveFunction of = LPChecks.constrAsFunction(newConstr);
        PointValuePair ans = ss.optimize(new OptimizationData[]{of, new LinearConstraintSet(oldConstr), GoalType.MINIMIZE});
        return (Double)ans.getValue() < -1.0E-8;
    }

    public static LinearObjectiveFunction constrAsFunction(LinearConstraint newConstr) {
        if (newConstr.getRelationship() == Relationship.GEQ) {
            return new LinearObjectiveFunction(newConstr.getCoefficients().mapMultiply(-1.0), newConstr.getValue());
        }
        return new LinearObjectiveFunction(newConstr.getCoefficients(), -newConstr.getValue());
    }

    public static boolean isPointInPolytope(ArrayList<LinearConstraint> polytope, double[] point) {
        for (LinearConstraint c : polytope) {
            if (!(LPChecks.constrAsFunction(c).value(point) > 1.0E-8)) continue;
            return false;
        }
        return true;
    }

    public static boolean polytopeHasFeasiblePt(ArrayList<LinearConstraint> polytope) {
        if (polytope.isEmpty()) {
            return true;
        }
        try {
            LPChecks.getFeasiblePt(polytope);
        }
        catch (NoFeasibleSolutionException e) {
            return false;
        }
        return true;
    }

    public static double[] getFeasiblePt(ArrayList<LinearConstraint> polytope) {
        if (polytope.isEmpty()) {
            return new double[0];
        }
        SimplexSolver ss = new SimplexSolver();
        LinearObjectiveFunction of = LPChecks.constrAsFunction(polytope.get(0));
        PointValuePair ans = ss.optimize(new OptimizationData[]{of, new LinearConstraintSet(polytope), GoalType.MINIMIZE});
        return ans.getPoint();
    }

    public static LinearConstraint toLinearConstraint(LinearMultivariateRealFunction f) {
        return new LinearConstraint(f.getQ().toArray(), Relationship.LEQ, -f.getR());
    }

    public static LinearMultivariateRealFunction toLinearMultivariateRealFunction(LinearConstraint curConstr) {
        return LPChecks.toLinearMultivariateRealFunction(curConstr, 0.0);
    }

    public static LinearMultivariateRealFunction toLinearMultivariateRealFunction(LinearConstraint curConstr, double ineqTol) {
        if (curConstr.getRelationship() == Relationship.GEQ) {
            return new LinearMultivariateRealFunction(curConstr.getCoefficients().mapMultiply(-1.0).toArray(), curConstr.getValue() - ineqTol);
        }
        if (curConstr.getRelationship() == Relationship.LEQ) {
            return new LinearMultivariateRealFunction(curConstr.getCoefficients().toArray(), -curConstr.getValue() - ineqTol);
        }
        throw new RuntimeException("ERROR: Unsupported relationship type");
    }

    public static DoubleMatrix1D getInteriorPt(LinearMultivariateRealFunction[] polytope) {
        ArrayList<LinearConstraint> constr = new ArrayList<LinearConstraint>();
        for (LinearMultivariateRealFunction f : polytope) {
            constr.add(LPChecks.toLinearConstraint(f));
        }
        return LPChecks.getInteriorPt(constr);
    }

    public static DoubleMatrix1D getInteriorPt(ArrayList<LinearConstraint> polytope) {
        if (polytope.isEmpty()) {
            return DoubleFactory1D.dense.make(0);
        }
        ArrayList<DoubleMatrix1D> corners = new ArrayList<DoubleMatrix1D>();
        SimplexSolver ss = new SimplexSolver();
        LinearConstraintSet polytopeConstr = new LinearConstraintSet(polytope);
        for (LinearConstraint constr : polytope) {
            PointValuePair otherCorner;
            LinearObjectiveFunction func = LPChecks.constrAsFunction(constr);
            try {
                otherCorner = ss.optimize(new OptimizationData[]{func, polytopeConstr, GoalType.MINIMIZE});
            }
            catch (NoFeasibleSolutionException e) {
                return null;
            }
            corners.add(DoubleFactory1D.dense.make(otherCorner.getPoint()));
        }
        DoubleMatrix1D ans = DoubleFactory1D.dense.make(polytope.get(0).getCoefficients().getDimension());
        for (DoubleMatrix1D corner : corners) {
            ans.assign(corner, Functions.plus);
        }
        ans.assign(Functions.mult((double)(1.0 / (double)corners.size())));
        return ans;
    }
}

