/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.plug;

import java.util.HashMap;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.optim.linear.LinearConstraint;

public class VoxConstrCache {
    HashMap<Integer, Double> lb = new HashMap();
    HashMap<Integer, Double> ub = new HashMap();

    public boolean checkRedundancy(LinearConstraint constr) {
        int voxConstrDOFNum = VoxConstrCache.getVoxConstrDOFNum(constr.getCoefficients());
        if (voxConstrDOFNum == -1) {
            return false;
        }
        switch (constr.getRelationship()) {
            case GEQ: {
                return VoxConstrCache.checkRedundancy(voxConstrDOFNum, this.lb, constr.getValue());
            }
            case LEQ: {
                return VoxConstrCache.checkRedundancy(voxConstrDOFNum, this.ub, constr.getValue());
            }
        }
        throw new RuntimeException("ERROR: Unexpected relationship");
    }

    private static boolean checkRedundancy(int dofNum, HashMap<Integer, Double> curConstr, double val) {
        if (curConstr.containsKey(dofNum)) {
            if (Math.abs(val - curConstr.get(dofNum)) > 1.0E-10) {
                throw new RuntimeException("ERROR: Conflicting voxel constraints");
            }
            return true;
        }
        curConstr.put(dofNum, val);
        return false;
    }

    private static int getVoxConstrDOFNum(RealVector coeff) {
        int ans = -1;
        for (int dof = 0; dof < coeff.getDimension(); ++dof) {
            double val = coeff.getEntry(dof);
            if (!(Math.abs(val) > 1.0E-10)) continue;
            if (ans != -1) {
                return -1;
            }
            if (Math.abs(val - 1.0) > 1.0E-10) {
                return -1;
            }
            ans = dof;
        }
        return ans;
    }
}

