/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.restypes;

import edu.duke.cs.osprey.restypes.HardCodedResidueInfo;
import edu.duke.cs.osprey.restypes.ResidueTemplate;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.ObjectIO;
import edu.duke.cs.osprey.tools.Protractor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class DAminoAcidHandler {
    public static final LinkedHashMap<String, String> altProtStateDNames = new LinkedHashMap();
    public static final LinkedHashMap<String, String> altProtStateLNames = new LinkedHashMap();

    public static void tryRenamingAsD(Residue res) {
        String origName = res.fullName.substring(0, 3);
        if (DAminoAcidHandler.isStandardLAminoAcid(origName) && !origName.equalsIgnoreCase("GLY")) {
            double[][] coords = new double[][]{res.getCoordsByAtomName("CB"), res.getCoordsByAtomName("CA"), res.getCoordsByAtomName("N"), res.getCoordsByAtomName("HA")};
            for (int c = 0; c < 4; ++c) {
                if (coords[c] != null) continue;
                return;
            }
            double ang = Protractor.measureDihedral(coords);
            if (ang < 0.0) {
                res.fullName = DAminoAcidHandler.getDName(origName) + res.fullName.substring(3);
            }
        }
    }

    public static List<ResidueTemplate> makeDTemplates(List<ResidueTemplate> templates) {
        ArrayList<ResidueTemplate> dTemplates = new ArrayList<ResidueTemplate>();
        for (ResidueTemplate template : templates) {
            if (!DAminoAcidHandler.isStandardLAminoAcid(template.name)) continue;
            dTemplates.add(DAminoAcidHandler.makeDTemplate(template));
        }
        return dTemplates;
    }

    public static ResidueTemplate makeDTemplate(ResidueTemplate LTemplate) {
        ResidueTemplate DTemplate = (ResidueTemplate)ObjectIO.deepCopy(LTemplate);
        String DName = DAminoAcidHandler.getDName(LTemplate.name);
        if (DName == null) {
            throw new RuntimeException("ERROR: Trying to make a D version of  a template that isn't a standard L-amino acid: " + LTemplate.name);
        }
        DTemplate.name = DName;
        Residue DTemplRes = DTemplate.templateRes;
        DTemplRes.fullName = DName + DTemplRes.fullName.substring(3);
        if (DTemplRes.coords != null) {
            int c = 0;
            while (c < DTemplRes.coords.length) {
                int n = c++;
                DTemplRes.coords[n] = DTemplRes.coords[n] * -1.0;
            }
        }
        if (DTemplate.rotamericDihedrals != null) {
            double[][][][] dArray = DTemplate.rotamericDihedrals;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                double[][][] phiDih;
                double[][][] dArray2 = phiDih = dArray[i];
                int n2 = dArray2.length;
                for (int j = 0; j < n2; ++j) {
                    double[][] psiDih;
                    for (double[] rotDih : psiDih = dArray2[j]) {
                        int d = 0;
                        while (d < rotDih.length) {
                            int n3 = d++;
                            rotDih[n3] = rotDih[n3] * -1.0;
                        }
                    }
                }
            }
        }
        if (DTemplRes.pucker != null) {
            DTemplRes.pucker.setBasePucker(DTemplRes.pucker.getBasePucker().flip());
            DTemplRes.pucker.setCurPucker(DTemplRes.pucker.getCurPucker().flip());
        }
        return DTemplate;
    }

    static String getDName(String LName) {
        if (HardCodedResidueInfo.three2one.containsKey(LName)) {
            return "DX" + HardCodedResidueInfo.getOneLet(LName);
        }
        if (altProtStateDNames.containsKey(LName)) {
            return altProtStateDNames.get(LName);
        }
        throw new RuntimeException("ERROR: Can't make D form for residue type " + LName);
    }

    public static boolean isStandardLAminoAcid(String aa3Name) {
        return HardCodedResidueInfo.three2one.containsKey(aa3Name) || altProtStateDNames.containsKey(aa3Name);
    }

    public static boolean isDAminoAcidName(String AAname) {
        if (AAname.startsWith("DX") && HardCodedResidueInfo.one2three.containsKey(AAname.substring(2))) {
            return true;
        }
        return altProtStateLNames.containsKey(AAname);
    }

    public static String getLEquivalent(String AAname) {
        if (AAname.startsWith("DX")) {
            return HardCodedResidueInfo.one2three.get(AAname.substring(2));
        }
        return altProtStateLNames.get(AAname);
    }

    static {
        altProtStateDNames.put("HID", "DHD");
        altProtStateDNames.put("HIE", "DHE");
        altProtStateDNames.put("HIP", "DHP");
        altProtStateDNames.put("CYX", "DCX");
        altProtStateDNames.put("CYM", "DCM");
        altProtStateDNames.put("ASH", "DDH");
        altProtStateDNames.put("GLH", "DEH");
        altProtStateDNames.put("LYN", "DKN");
        for (String LName : altProtStateDNames.keySet()) {
            altProtStateLNames.put(altProtStateDNames.get(LName), LName);
        }
    }
}

